/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.code.RuntimeCodeCache;
import java.util.EnumSet;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.code.TargetDescription;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class SubstrateTargetDescription
extends TargetDescription {
    private final int deoptScratchSpace;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static boolean shouldInlineObjectsInImageCode() {
        return SubstrateOptions.SpawnIsolates.getValue();
    }

    public static boolean shouldInlineObjectsInRuntimeCode() {
        return SubstrateOptions.SpawnIsolates.getValue() != false && RuntimeCodeCache.Options.WriteableCodeCache.getValue() != false;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SubstrateTargetDescription(Architecture arch, boolean isMP, int stackAlignment, int implicitNullCheckLimit, int deoptScratchSpace) {
        super(arch, isMP, stackAlignment, implicitNullCheckLimit, SubstrateTargetDescription.shouldInlineObjectsInImageCode());
        this.deoptScratchSpace = deoptScratchSpace;
    }

    public static EnumSet<AMD64.Flag> allAMD64Flags() {
        return EnumSet.of(AMD64.Flag.UseCountLeadingZerosInstruction, AMD64.Flag.UseCountTrailingZerosInstruction);
    }

    public int getDeoptScratchSpace() {
        return this.deoptScratchSpace;
    }
}

