/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jni.hosted;

import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.hosted.phases.HostedGraphKit;
import com.oracle.svm.jni.JNIGeneratedMethodSupport;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.java.ExceptionObjectNode;

class JNIGraphKit
extends HostedGraphKit {
    JNIGraphKit(DebugContext debug, HostedProviders providers, ResolvedJavaMethod method) {
        super(debug, providers, method);
    }

    private InvokeWithExceptionNode createStaticInvoke(String name, ValueNode ... args) {
        return this.createInvokeWithExceptionAndUnwind(this.findMethod(JNIGeneratedMethodSupport.class, name, true), CallTargetNode.InvokeKind.Static, this.getFrameState(), this.bci(), this.bci(), args);
    }

    private InvokeWithExceptionNode createStaticInvokeRetainException(String name, ValueNode ... args) {
        ResolvedJavaMethod method = this.findMethod(JNIGeneratedMethodSupport.class, name, true);
        int invokeBci = this.bci();
        int exceptionEdgeBci = this.bci();
        InvokeWithExceptionNode invoke = this.startInvokeWithException(method, CallTargetNode.InvokeKind.Static, this.getFrameState(), invokeBci, exceptionEdgeBci, args);
        this.exceptionPart();
        ExceptionObjectNode exception = this.exceptionObject();
        this.setPendingException((ValueNode)exception);
        this.endInvokeWithException();
        return invoke;
    }

    public InvokeWithExceptionNode nativeCallAddress(ValueNode linkage) {
        ResolvedJavaMethod method = this.findMethod(JNIGeneratedMethodSupport.class, "nativeCallAddress", true);
        int invokeBci = this.bci();
        int exceptionEdgeBci = this.bci();
        return this.createInvokeWithExceptionAndUnwind(method, CallTargetNode.InvokeKind.Static, this.getFrameState(), invokeBci, exceptionEdgeBci, new ValueNode[]{linkage});
    }

    public InvokeWithExceptionNode nativeCallPrologue() {
        return this.createStaticInvoke("nativeCallPrologue", new ValueNode[0]);
    }

    public InvokeWithExceptionNode nativeCallEpilogue(ValueNode handleFrame) {
        return this.createStaticInvoke("nativeCallEpilogue", handleFrame);
    }

    public InvokeWithExceptionNode environment() {
        return this.createStaticInvoke("environment", new ValueNode[0]);
    }

    public InvokeWithExceptionNode boxObjectInLocalHandle(ValueNode obj) {
        return this.createStaticInvoke("boxObjectInLocalHandle", obj);
    }

    public InvokeWithExceptionNode unboxHandle(ValueNode handle) {
        return this.createStaticInvoke("unboxHandle", handle);
    }

    public InvokeWithExceptionNode getFieldOffsetFromId(ValueNode fieldId) {
        return this.createStaticInvoke("getFieldOffsetFromId", fieldId);
    }

    public InvokeWithExceptionNode getStaticPrimitiveFieldsArray() {
        return this.createStaticInvoke("getStaticPrimitiveFieldsArray", new ValueNode[0]);
    }

    public InvokeWithExceptionNode getStaticObjectFieldsArray() {
        return this.createStaticInvoke("getStaticObjectFieldsArray", new ValueNode[0]);
    }

    public InvokeWithExceptionNode setPendingException(ValueNode obj) {
        return this.createStaticInvoke("setPendingException", obj);
    }

    public InvokeWithExceptionNode getAndClearPendingException() {
        return this.createStaticInvoke("getAndClearPendingException", new ValueNode[0]);
    }

    public InvokeWithExceptionNode rethrowPendingException() {
        ResolvedJavaMethod method = this.findMethod(JNIGeneratedMethodSupport.class, "rethrowPendingException", true);
        int invokeBci = this.bci();
        int exceptionEdgeBci = this.bci();
        return this.createInvokeWithExceptionAndUnwind(method, CallTargetNode.InvokeKind.Static, this.getFrameState(), invokeBci, exceptionEdgeBci, new ValueNode[0]);
    }

    public InvokeWithExceptionNode pinArrayAndGetAddress(ValueNode array, ValueNode isCopy) {
        return this.createStaticInvoke("pinArrayAndGetAddress", array, isCopy);
    }

    public InvokeWithExceptionNode unpinArrayByAddress(ValueNode address) {
        return this.createStaticInvoke("unpinArrayByAddress", address);
    }

    public InvokeWithExceptionNode getPrimitiveArrayRegionRetainException(JavaKind elementKind, ValueNode array, ValueNode start, ValueNode count, ValueNode buffer) {
        assert (elementKind.isPrimitive());
        return this.createStaticInvokeRetainException("getPrimitiveArrayRegion", new ValueNode[]{this.createObject(elementKind), array, start, count, buffer});
    }

    public InvokeWithExceptionNode setPrimitiveArrayRegionRetainException(JavaKind elementKind, ValueNode array, ValueNode start, ValueNode count, ValueNode buffer) {
        assert (elementKind.isPrimitive());
        return this.createStaticInvokeRetainException("setPrimitiveArrayRegion", new ValueNode[]{this.createObject(elementKind), array, start, count, buffer});
    }
}

