/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.hosted.meta.HostedMethod;
import java.util.Collection;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.java.AbstractNewObjectNode;
import org.graalvm.compiler.options.Option;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.function.InvokeCFunctionPointer;

public final class UninterruptibleAnnotationChecker {
    private final Collection<HostedMethod> methodCollection;

    private UninterruptibleAnnotationChecker(Collection<HostedMethod> methodCollection) {
        this.methodCollection = methodCollection;
    }

    public static void check(DebugContext debug, Collection<HostedMethod> methodCollection) {
        UninterruptibleAnnotationChecker checker = new UninterruptibleAnnotationChecker(methodCollection);
        checker.checkUninterruptibleOverrides(debug);
        checker.checkUninterruptibleCallees(debug);
        checker.checkUninterruptibleCallers(debug);
        checker.checkUninterruptibleAllocations(debug);
    }

    private void checkUninterruptibleOverrides(DebugContext debug) {
        for (HostedMethod method : this.methodCollection) {
            try {
                DebugContext.Scope s = debug.scope((Object)"CheckUninterruptibleOverrides", (Object)method.compilationInfo.graph, (Object)method, (Object)this);
                Throwable throwable = null;
                try {
                    Uninterruptible methodAnnotation = method.getAnnotation(Uninterruptible.class);
                    if (methodAnnotation == null) continue;
                    for (HostedMethod impl : method.getImplementations()) {
                        Uninterruptible implAnnotation = impl.getAnnotation(Uninterruptible.class);
                        if (implAnnotation != null) {
                            if (methodAnnotation.callerMustBe() != implAnnotation.callerMustBe()) {
                                UninterruptibleAnnotationChecker.postUninterruptibleWarning("callerMustBe: " + method.format("%H.%n(%p)") + " != " + impl.format("%H.%n(%p)"));
                            }
                            if (methodAnnotation.calleeMustBe() == implAnnotation.calleeMustBe()) continue;
                            UninterruptibleAnnotationChecker.postUninterruptibleWarning("calleeMustBe: " + method.format("%H.%n(%p)") + " != " + impl.format("%H.%n(%p)"));
                            continue;
                        }
                        UninterruptibleAnnotationChecker.postUninterruptibleWarning("method " + method.format("%H.%n(%p)") + " is annotated but " + impl.format("%H.%n(%p) is not"));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (s == null) continue;
                    if (throwable != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    s.close();
                }
            }
            catch (Throwable t) {
                throw debug.handle(t);
            }
        }
    }

    private void checkUninterruptibleCallees(DebugContext debug) {
        if (Options.PrintUninterruptibleCalleeDOTGraph.getValue().booleanValue()) {
            System.out.println("/* DOT */ digraph uninterruptible {");
        }
        for (HostedMethod caller : this.methodCollection) {
            try {
                DebugContext.Scope s = debug.scope((Object)"CheckUninterruptibleCallees", (Object)caller.compilationInfo.graph, (Object)caller, (Object)this);
                Throwable throwable = null;
                try {
                    HostedMethod callee;
                    Uninterruptible callerAnnotation = caller.getAnnotation(Uninterruptible.class);
                    StructuredGraph graph = caller.compilationInfo.getGraph();
                    if (callerAnnotation == null) continue;
                    if (callerAnnotation.calleeMustBe()) {
                        if (graph == null) continue;
                        for (Invoke invoke : graph.getInvokes()) {
                            callee = (HostedMethod)invoke.callTarget().targetMethod();
                            if (Options.PrintUninterruptibleCalleeDOTGraph.getValue().booleanValue()) {
                                UninterruptibleAnnotationChecker.printDotGraphEdge(caller, callee);
                            }
                            if (UninterruptibleAnnotationChecker.isNotInterruptible(callee)) continue;
                            UninterruptibleAnnotationChecker.postUninterruptibleWarning("Unannotated callee: " + callee.format("%H.%n(%p)") + " called by annotated caller " + caller.format("%H.%n(%p)"));
                        }
                        continue;
                    }
                    if (graph == null) continue;
                    for (Invoke invoke : graph.getInvokes()) {
                        callee = (HostedMethod)invoke.callTarget().targetMethod();
                        if (!Options.PrintUninterruptibleCalleeDOTGraph.getValue().booleanValue()) continue;
                        UninterruptibleAnnotationChecker.printDotGraphEdge(caller, callee);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (s == null) continue;
                    if (throwable != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    s.close();
                }
            }
            catch (Throwable t) {
                throw debug.handle(t);
            }
        }
        if (Options.PrintUninterruptibleCalleeDOTGraph.getValue().booleanValue()) {
            System.out.println("/* DOT */ }");
        }
    }

    private void checkUninterruptibleCallers(DebugContext debug) {
        for (HostedMethod caller : this.methodCollection) {
            try {
                DebugContext.Scope s = debug.scope((Object)"CheckUninterruptibleCallers", (Object)caller.compilationInfo.graph, (Object)caller, (Object)this);
                Throwable throwable = null;
                try {
                    Uninterruptible callerAnnotation = caller.getAnnotation(Uninterruptible.class);
                    StructuredGraph graph = caller.compilationInfo.getGraph();
                    if (callerAnnotation != null || graph == null) continue;
                    for (Invoke invoke : graph.getInvokes()) {
                        HostedMethod callee = (HostedMethod)invoke.callTarget().targetMethod();
                        if (!UninterruptibleAnnotationChecker.isCallerMustBe(callee)) continue;
                        UninterruptibleAnnotationChecker.postUninterruptibleWarning("Unannotated caller: " + caller.format("%H.%n(%p)") + " calls annotated callee " + callee.format("%H.%n(%p)"));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (s == null) continue;
                    if (throwable != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    s.close();
                }
            }
            catch (Throwable t) {
                throw debug.handle(t);
            }
        }
    }

    private void checkUninterruptibleAllocations(DebugContext debug) {
        for (HostedMethod method : this.methodCollection) {
            try {
                DebugContext.Scope s = debug.scope((Object)"CheckUninterruptibleAllocations", (Object)method.compilationInfo.graph, (Object)method, (Object)this);
                Throwable throwable = null;
                try {
                    Uninterruptible methodAnnotation = method.getAnnotation(Uninterruptible.class);
                    StructuredGraph graph = method.compilationInfo.getGraph();
                    if (methodAnnotation == null || graph == null) continue;
                    for (Node node : graph.getNodes()) {
                        if (!(node instanceof AbstractNewObjectNode)) continue;
                        UninterruptibleAnnotationChecker.postUninterruptibleWarning("Annotated method: " + method.format("%H.%n(%p)") + " allocates.");
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (s == null) continue;
                    if (throwable != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    s.close();
                }
            }
            catch (Throwable t) {
                throw debug.handle(t);
            }
        }
    }

    private static void postUninterruptibleWarning(String warning) throws WarningException {
        String message = "@Uninterruptible warning: " + warning;
        if (Options.PrintUninterruptibleWarnings.getValue().booleanValue()) {
            System.err.println(message);
        }
        if (Options.UninterruptibleWarningsAreFatal.getValue().booleanValue()) {
            throw new WarningException(message);
        }
    }

    private static boolean isNotInterruptible(HostedMethod method) {
        return UninterruptibleAnnotationChecker.isUninterruptible(method) || UninterruptibleAnnotationChecker.isNoTransitionCFunction(method);
    }

    private static boolean isUninterruptible(HostedMethod method) {
        return method.getAnnotation(Uninterruptible.class) != null;
    }

    private static boolean isCallerMustBe(HostedMethod method) {
        Uninterruptible uninterruptibleAnnotation = method.getAnnotation(Uninterruptible.class);
        return uninterruptibleAnnotation != null && uninterruptibleAnnotation.callerMustBe();
    }

    private static boolean isCalleeMustBe(HostedMethod method) {
        Uninterruptible uninterruptibleAnnotation = method.getAnnotation(Uninterruptible.class);
        return uninterruptibleAnnotation != null && uninterruptibleAnnotation.calleeMustBe();
    }

    private static boolean isNoTransitionCFunction(HostedMethod method) {
        CFunction cfunctionAnnotation = method.getAnnotation(CFunction.class);
        InvokeCFunctionPointer invokeCFunctionPointerAnnotation = method.getAnnotation(InvokeCFunctionPointer.class);
        return cfunctionAnnotation != null && cfunctionAnnotation.transition() == CFunction.Transition.NO_TRANSITION || invokeCFunctionPointerAnnotation != null && invokeCFunctionPointerAnnotation.transition() == CFunction.Transition.NO_TRANSITION;
    }

    private static void printDotGraphEdge(HostedMethod caller, HostedMethod callee) {
        String callerColor = " [color=black]";
        String calleeColor = " [color=black]";
        if (UninterruptibleAnnotationChecker.isUninterruptible(caller)) {
            callerColor = " [color=blue]";
            if (!UninterruptibleAnnotationChecker.isCalleeMustBe(caller)) {
                callerColor = " [color=orange]";
            }
        }
        if (UninterruptibleAnnotationChecker.isUninterruptible(callee)) {
            calleeColor = " [color=blue]";
            if (!UninterruptibleAnnotationChecker.isCalleeMustBe(callee)) {
                calleeColor = " [color=purple]";
            }
        } else {
            calleeColor = " [color=red]";
        }
        if (UninterruptibleAnnotationChecker.isNoTransitionCFunction(callee)) {
            calleeColor = " [color=green]";
        }
        System.out.println("/* DOT */    " + caller.format("<%h.%n>") + callerColor);
        System.out.println("/* DOT */    " + callee.format("<%h.%n>") + calleeColor);
        System.out.println("/* DOT */    " + caller.format("<%h.%n>") + " -> " + callee.format("<%h.%n>") + calleeColor);
    }

    public static class WarningException
    extends Exception {
        private static final long serialVersionUID = -1407786075546990780L;

        public WarningException(String message) {
            super(message);
        }
    }

    public static class Options {
        @Option(help={"Print warnings for @Uninterruptible annotations."})
        public static final HostedOptionKey<Boolean> PrintUninterruptibleWarnings = new HostedOptionKey<Boolean>(true);
        @Option(help={"Warnings for @Uninterruptible annotations are fatal."})
        public static final HostedOptionKey<Boolean> UninterruptibleWarningsAreFatal = new HostedOptionKey<Boolean>(true);
        @Option(help={"Print (to stderr) a DOT graph of the @Uninterruptible annotations."})
        public static final HostedOptionKey<Boolean> PrintUninterruptibleCalleeDOTGraph = new HostedOptionKey<Boolean>(false);
    }
}

