/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.darwin;

import com.oracle.svm.core.posix.headers.darwin.CoreFoundation;
import org.graalvm.nativeimage.PinnedObject;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.impl.InternalPlatform;
import org.graalvm.word.PointerBase;
import org.graalvm.word.SignedWord;
import org.graalvm.word.WordFactory;

@Platforms(value={InternalPlatform.DARWIN_JNI_AND_SUBSTITUTIONS.class})
public final class DarwinCoreFoundationUtils {
    private DarwinCoreFoundationUtils() {
    }

    public static CoreFoundation.CFMutableStringRef toCFStringRef(String str) {
        CoreFoundation.CFMutableStringRef stringRef = CoreFoundation.CFStringCreateMutable(WordFactory.nullPointer(), (SignedWord)WordFactory.zero());
        if (stringRef.isNull()) {
            throw new OutOfMemoryError("native heap");
        }
        char[] charArray = str.toCharArray();
        try (PinnedObject pathPin = PinnedObject.create((Object)charArray);){
            PointerBase addressOfCharArray = pathPin.addressOfArrayElement(0);
            CoreFoundation.CFStringAppendCharacters(stringRef, addressOfCharArray, WordFactory.signed((int)charArray.length));
        }
        return stringRef;
    }

    public static String fromCFStringRef(CoreFoundation.CFStringRef cfstr) {
        int length = (int)CoreFoundation.CFStringGetLength(cfstr);
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            chars[i] = CoreFoundation.CFStringGetCharacterAtIndex(cfstr, i);
        }
        return String.valueOf(chars);
    }
}

