/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.heap.NativeImageInfo;
import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.hub.InteriorObjRefWalker;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.stack.StackFrameVisitor;
import com.oracle.svm.core.thread.JavaVMOperation;
import com.oracle.svm.core.thread.VMOperation;
import java.util.ArrayList;
import java.util.Arrays;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public class PathExhibitor {
    protected final ArrayList<PathElement> path = new ArrayList();
    protected static final FrameSlotVisitor frameSlotVisitor = new FrameSlotVisitor();
    protected static final FrameVisitor stackFrameVisitor = new FrameVisitor();
    protected static final BootImageHeapObjRefVisitor bootImageHeapObjRefVisitor = new BootImageHeapObjRefVisitor();
    protected static final HeapObjRefVisitor heapObjRefVisitor = new HeapObjRefVisitor();
    protected static final HeapObjectVisitor heapObjectVisitor = new HeapObjectVisitor();

    public static PathExhibitor factory() {
        return new PathExhibitor();
    }

    public boolean findPathToRoot(Object leaf) {
        block1: {
            PathElements singleElement = new PathElements(1);
            LeafElement currentElement = LeafElement.factory(leaf);
            Object currentObject = leaf;
            do {
                this.path.add(currentElement);
                singleElement.clear();
                this.findPathToObject(currentObject, singleElement);
                PathElement pathElement = currentElement = singleElement.isEmpty() ? null : singleElement.get(0);
                if (currentElement == null) break block1;
                currentObject = KnownIntrinsics.convertUnknownValue(((PathElement)currentElement).getObject(), Object.class);
                if (currentObject != null) continue;
                this.path.add(currentElement);
                break block1;
            } while (!this.checkForCycles(currentObject));
            CyclicElement cyclic = CyclicElement.factory(currentObject);
            this.path.add(cyclic);
        }
        return true;
    }

    public void toLog(Log log) {
        for (PathElement element : this.path) {
            log.newline();
            element.toLog(log);
        }
    }

    protected void findPathToObject(Object obj, PathElements result) {
        if (obj == null || !result.isSpaceAvailable()) {
            return;
        }
        this.findPathInHeap(obj, result);
        this.findPathInBootImageHeap(obj, result);
        this.findPathInStack(obj, result);
    }

    @NeverInline(value="Starting a stack walk in the caller frame")
    protected void findPathInStack(Object obj, PathElements result) {
        if (!result.isSpaceAvailable()) {
            return;
        }
        stackFrameVisitor.initialize(obj, result);
        Pointer sp = KnownIntrinsics.readCallerStackPointer();
        JavaStackWalker.walkCurrentThread(sp, stackFrameVisitor);
        stackFrameVisitor.reset();
    }

    protected void findPathInBootImageHeap(Object targetObject, PathElements result) {
        this.findPathInBootImageHeap(targetObject, NativeImageInfo.firstReadOnlyPrimitiveObject, NativeImageInfo.lastReadOnlyPrimitiveObject, result);
        this.findPathInBootImageHeap(targetObject, NativeImageInfo.firstReadOnlyReferenceObject, NativeImageInfo.lastReadOnlyReferenceObject, result);
        this.findPathInBootImageHeap(targetObject, NativeImageInfo.firstWritablePrimitiveObject, NativeImageInfo.lastWritablePrimitiveObject, result);
        this.findPathInBootImageHeap(targetObject, NativeImageInfo.firstWritableReferenceObject, NativeImageInfo.lastWritableReferenceObject, result);
    }

    protected void findPathInBootImageHeap(Object targetObject, Object firstObject, Object lastObject, PathElements result) {
        if (firstObject == null || lastObject == null || !result.isSpaceAvailable()) {
            return;
        }
        Word targetPointer = Word.objectToUntrackedPointer((Object)targetObject);
        Word firstPointer = Word.objectToUntrackedPointer((Object)firstObject);
        Word lastPointer = Word.objectToUntrackedPointer((Object)lastObject);
        Word current = firstPointer;
        while (current.belowOrEqual((UnsignedWord)lastPointer)) {
            Object bihObject = current.toObject();
            bootImageHeapObjRefVisitor.initialize((Pointer)current, (Pointer)targetPointer, result);
            if (!InteriorObjRefWalker.walkObject(bihObject, bootImageHeapObjRefVisitor)) break;
            current = LayoutEncoding.getObjectEnd(bihObject);
        }
    }

    protected void findPathInHeap(Object obj, PathElements result) {
        if (!result.isSpaceAvailable()) {
            return;
        }
        heapObjectVisitor.initialize(obj, result);
        HeapImpl.getHeapImpl().walkObjects(heapObjectVisitor);
    }

    protected boolean checkForCycles(Object currentObject) {
        boolean result = false;
        for (PathElement seen : this.path) {
            Object seenObject = seen.getObject();
            if (currentObject != seenObject) continue;
            result = true;
            break;
        }
        return result;
    }

    protected PathExhibitor() {
    }

    public static class PathElements {
        private PathElement[] elements;
        private int size;

        public PathElements(int maxSize) {
            this.elements = new PathElement[maxSize];
            this.size = 0;
        }

        public boolean isSpaceAvailable() {
            return this.size < this.elements.length;
        }

        public boolean isEmpty() {
            return this.size == 0;
        }

        public int size() {
            return this.size;
        }

        public PathElement get(int index) {
            return this.elements[index];
        }

        public void add(PathElement elem) {
            if (!PathElements.isInterfering(elem.getObject())) {
                this.elements[this.size++] = elem;
            }
        }

        public void clear() {
            Arrays.fill(this.elements, null);
            this.size = 0;
        }

        public void toLog(Log log) {
            for (int i = 0; i < this.size; ++i) {
                this.elements[i].toLog(log);
            }
        }

        private static boolean isInterfering(Object currentObject) {
            return currentObject instanceof PathElement || currentObject instanceof FindPathToObjectOperation;
        }
    }

    private static final class FindPathToObjectOperation
    extends JavaVMOperation {
        private final PathExhibitor exhibitor;
        private final Object object;
        private PathElements result;

        FindPathToObjectOperation(PathExhibitor exhibitor, Object object, PathElements result) {
            super("FindPathToObjectOperation", VMOperation.SystemEffect.SAFEPOINT);
            this.exhibitor = exhibitor;
            this.object = object;
            this.result = result;
        }

        @Override
        protected void operate() {
            this.exhibitor.findPathToObject(this.object, this.result);
        }
    }

    public static final class TestingBackDoor {
        private TestingBackDoor() {
        }

        public static PathElement findPathToObject(PathExhibitor exhibitor, Object obj) {
            PathElements result = new PathElements(1);
            TestingBackDoor.findPathToObject(exhibitor, obj, result);
            return result.isEmpty() ? null : result.get(0);
        }

        public static void findPathToObject(PathExhibitor exhibitor, Object obj, PathElements result) {
            FindPathToObjectOperation op = new FindPathToObjectOperation(exhibitor, obj, result);
            op.enqueue();
        }
    }

    public static class CyclicElement
    extends PathElement {
        protected final Object previous;

        public static CyclicElement factory(Object previous) {
            return new CyclicElement(previous);
        }

        @Override
        public Object getObject() {
            return null;
        }

        @Override
        public Log toLog(Log log) {
            log.string("[cyclic:");
            log.string("  previous: ").object(this.previous);
            log.string("]");
            return log;
        }

        protected CyclicElement(Object previous) {
            this.previous = previous;
        }
    }

    public static class BootImageHeapElement
    extends PathElement {
        protected final Object base;
        protected final UnsignedWord offset;
        protected final Pointer field;

        public static BootImageHeapElement factory(Object base, UnsignedWord offset, Pointer field) {
            return new BootImageHeapElement(base, offset, field);
        }

        @Override
        public Object getObject() {
            return null;
        }

        @Override
        public Log toLog(Log log) {
            log.string("[native image heap:");
            log.string("  object: ").object(this.base);
            log.string("  offset: ").unsigned((WordBase)this.offset);
            log.string("  field: ").hex((WordBase)this.field);
            log.string("]");
            return log;
        }

        protected BootImageHeapElement(Object base, UnsignedWord offset, Pointer field) {
            this.base = base;
            this.offset = offset;
            this.field = field;
        }
    }

    public static class StackElement
    extends PathElement {
        protected final Pointer stackSlot;
        protected final CodePointer ip;
        protected final CodePointer deoptSourcePC;
        protected final Pointer slotValue;

        public static StackElement factory(Pointer frameSlot, CodePointer ip, DeoptimizedFrame deoptFrame) {
            return new StackElement(frameSlot, ip, deoptFrame);
        }

        @Override
        public Object getObject() {
            return null;
        }

        @Override
        public Log toLog(Log log) {
            log.string("[stack:");
            log.string("  slot: ").hex((WordBase)this.stackSlot);
            log.string("  deoptSourcePC: ").hex((WordBase)this.deoptSourcePC);
            log.string("  ip: ").hex((WordBase)this.ip);
            log.string("  value: ").hex((WordBase)this.slotValue);
            log.string("]");
            return log;
        }

        protected StackElement(Pointer stackSlot, CodePointer ip, DeoptimizedFrame deoptFrame) {
            this.stackSlot = stackSlot;
            this.deoptSourcePC = deoptFrame != null ? deoptFrame.getSourcePC() : (CodePointer)WordFactory.nullPointer();
            this.ip = ip;
            this.slotValue = (Pointer)stackSlot.readWord(0);
        }
    }

    public static class HeapElement
    extends PathElement {
        protected final Object base;
        protected final UnsignedWord offset;

        public static HeapElement factory(Object base, UnsignedWord offset) {
            return new HeapElement(base, offset);
        }

        @Override
        public Object getObject() {
            return this.base;
        }

        @Override
        public Log toLog(Log log) {
            log.string("[heap:");
            log.string("  base: ").object(this.base);
            log.string("  offset: ").unsigned((WordBase)this.offset);
            Word objPointer = Word.objectToUntrackedPointer((Object)this.base);
            Pointer fieldObjRef = objPointer.add(this.offset);
            Pointer fieldPointer = (Pointer)fieldObjRef.readWord(0);
            log.string("  field: ").hex((WordBase)fieldPointer);
            log.string("]");
            return log;
        }

        protected HeapElement(Object base, UnsignedWord offset) {
            this.base = base;
            this.offset = offset;
        }
    }

    public static class LeafElement
    extends PathElement {
        protected final Object leaf;

        public static LeafElement factory(Object leaf) {
            return new LeafElement(leaf);
        }

        @Override
        public Object getObject() {
            return this.leaf;
        }

        @Override
        public Log toLog(Log log) {
            log.string("[leaf:");
            log.string("  ").object(this.leaf);
            log.string("]");
            return log;
        }

        protected LeafElement(Object leaf) {
            this.leaf = leaf;
        }
    }

    private static class HeapObjRefVisitor
    implements ObjectReferenceVisitor {
        protected Pointer containerPointer;
        protected Pointer targetPointer;
        private PathElements result;

        protected HeapObjRefVisitor() {
        }

        public void initialize(Pointer container, Pointer target, PathElements res) {
            this.containerPointer = container;
            this.targetPointer = target;
            this.result = res;
        }

        @Override
        public boolean visitObjectReference(Pointer objRef, boolean compressed) {
            if (objRef.isNull()) {
                return true;
            }
            Word referentPointer = ReferenceAccess.singleton().readObjectAsUntrackedPointer(objRef, compressed);
            if (referentPointer.equal((UnsignedWord)this.targetPointer)) {
                Pointer offset = objRef.subtract((UnsignedWord)this.containerPointer);
                Object containerObject = this.containerPointer.toObject();
                this.result.add(HeapElement.factory(containerObject, (UnsignedWord)offset));
                return this.result.isSpaceAvailable();
            }
            return true;
        }
    }

    private static class HeapObjectVisitor
    implements ObjectVisitor {
        protected Pointer targetPointer;
        private PathElements result;

        protected HeapObjectVisitor() {
        }

        public void initialize(Object targetObject, PathElements res) {
            this.targetPointer = Word.objectToUntrackedPointer((Object)targetObject);
            this.result = res;
        }

        @Override
        public boolean visitObject(Object containerObject) {
            Word containerPointer = Word.objectToUntrackedPointer((Object)containerObject);
            heapObjRefVisitor.initialize((Pointer)containerPointer, this.targetPointer, this.result);
            return InteriorObjRefWalker.walkObject(containerObject, heapObjRefVisitor);
        }
    }

    private static class BootImageHeapObjRefVisitor
    implements ObjectReferenceVisitor {
        protected Pointer targetPointer;
        protected Pointer containerPointer;
        private PathElements result;

        protected BootImageHeapObjRefVisitor() {
        }

        public void initialize(Pointer container, Pointer target, PathElements res) {
            this.containerPointer = container;
            this.targetPointer = target;
            this.result = res;
        }

        @Override
        public boolean visitObjectReference(Pointer objRef, boolean compressed) {
            if (objRef.isNull()) {
                return true;
            }
            Word referentPointer = ReferenceAccess.singleton().readObjectAsUntrackedPointer(objRef, compressed);
            if (referentPointer.equal((UnsignedWord)this.targetPointer)) {
                Object containerObject = this.containerPointer.toObject();
                Pointer offset = objRef.subtract((UnsignedWord)this.containerPointer);
                this.result.add(BootImageHeapElement.factory(containerObject, (UnsignedWord)offset, (Pointer)referentPointer));
                return this.result.isSpaceAvailable();
            }
            return true;
        }
    }

    private static class FrameSlotVisitor
    implements ObjectReferenceVisitor {
        protected CodePointer ip;
        protected DeoptimizedFrame deoptFrame;
        protected Pointer targetPointer;
        private PathElements result;

        protected FrameSlotVisitor() {
        }

        public void initialize(CodePointer ipArg, DeoptimizedFrame deoptFrameArg, Pointer targetArg, PathElements res) {
            this.ip = ipArg;
            this.deoptFrame = deoptFrameArg;
            this.targetPointer = targetArg;
            this.result = res;
        }

        @Override
        public boolean visitObjectReference(Pointer stackSlot, boolean compressed) {
            Log trace = Log.noopLog();
            if (stackSlot.isNull()) {
                return true;
            }
            Word referentPointer = ReferenceAccess.singleton().readObjectAsUntrackedPointer(stackSlot, compressed);
            trace.string("  referentPointer: ").hex((WordBase)referentPointer);
            if (referentPointer.equal((UnsignedWord)this.targetPointer)) {
                this.result.add(StackElement.factory(stackSlot, this.ip, this.deoptFrame));
                return this.result.isSpaceAvailable();
            }
            return true;
        }
    }

    public static class FrameVisitor
    implements StackFrameVisitor {
        protected Pointer targetPointer;
        private PathElements result;

        protected FrameVisitor() {
        }

        public void initialize(Object targetObject, PathElements res) {
            this.targetPointer = Word.objectToUntrackedPointer((Object)targetObject);
            this.result = res;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while verifying the heap.")
        public boolean visitFrame(Pointer sp, CodePointer ip, CodeInfo codeInfo, DeoptimizedFrame deoptimizedFrame) {
            frameSlotVisitor.initialize(ip, deoptimizedFrame, this.targetPointer, this.result);
            return CodeInfoTable.visitObjectReferences(sp, ip, codeInfo, deoptimizedFrame, frameSlotVisitor);
        }

        public void reset() {
            this.targetPointer = (Pointer)WordFactory.nullPointer();
        }
    }

    public static abstract class PathElement {
        public abstract Log toLog(Log var1);

        public abstract Object getObject();
    }
}

