/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.code.FrameInfoEncoder;
import com.oracle.svm.core.code.FrameInfoQueryResult;
import java.util.Objects;
import jdk.vm.ci.meta.JavaConstant;

class FrameInfoVerifier {
    FrameInfoVerifier() {
    }

    protected static void verifyFrames(FrameInfoEncoder.FrameData expectedData, FrameInfoQueryResult expectedTopFrame, FrameInfoQueryResult actualTopFrame) {
        FrameInfoQueryResult expectedFrame = expectedTopFrame;
        FrameInfoQueryResult actualFrame = actualTopFrame;
        while (expectedFrame != null) {
            assert (actualFrame != null);
            assert (expectedFrame.isDeoptEntry == actualFrame.isDeoptEntry);
            assert (expectedFrame.needLocalValues == actualFrame.needLocalValues);
            if (expectedFrame.needLocalValues) {
                assert (expectedFrame.encodedBci == actualFrame.encodedBci);
                assert (expectedFrame.deoptMethod == null && actualFrame.deoptMethod == null || expectedFrame.deoptMethod != null && expectedFrame.deoptMethod.equals(actualFrame.deoptMethod));
                assert (expectedFrame.deoptMethodOffset == actualFrame.deoptMethodOffset);
                assert (expectedFrame.numLocals == actualFrame.numLocals);
                assert (expectedFrame.numStack == actualFrame.numStack);
                assert (expectedFrame.numLocks == actualFrame.numLocks);
                FrameInfoVerifier.verifyValues(expectedFrame.valueInfos, actualFrame.valueInfos);
                assert (expectedFrame.virtualObjects == expectedTopFrame.virtualObjects);
                assert (actualFrame.virtualObjects == actualTopFrame.virtualObjects);
            }
            assert (Objects.equals(expectedFrame.sourceClass, actualFrame.sourceClass));
            assert (Objects.equals(expectedFrame.sourceMethodName, actualFrame.sourceMethodName));
            assert (expectedFrame.sourceLineNumber == actualFrame.sourceLineNumber);
            assert (expectedFrame.sourceClassIndex == actualFrame.sourceClassIndex);
            assert (expectedFrame.sourceMethodNameIndex == actualFrame.sourceMethodNameIndex);
            expectedFrame = expectedFrame.caller;
            actualFrame = actualFrame.caller;
        }
        assert (actualFrame == null);
        if (actualTopFrame.needLocalValues) {
            assert (expectedData.virtualObjects.length == actualTopFrame.virtualObjects.length);
            for (int i = 0; i < expectedData.virtualObjects.length; ++i) {
                FrameInfoVerifier.verifyValues(expectedData.virtualObjects[i], actualTopFrame.virtualObjects[i]);
            }
        }
    }

    private static void verifyValues(FrameInfoQueryResult.ValueInfo[] expectedValues, FrameInfoQueryResult.ValueInfo[] actualValues) {
        assert (expectedValues.length == actualValues.length);
        for (int i = 0; i < expectedValues.length; ++i) {
            FrameInfoQueryResult.ValueInfo expectedValue = expectedValues[i];
            FrameInfoQueryResult.ValueInfo actualValue = actualValues[i];
            assert (expectedValue.type == actualValue.type);
            assert (expectedValue.kind.equals((Object)actualValue.kind));
            assert (expectedValue.isCompressedReference == actualValue.isCompressedReference);
            assert (expectedValue.data == actualValue.data);
            FrameInfoVerifier.verifyConstant(expectedValue.value, actualValue.value);
            assert (Objects.equals(expectedValue.name, actualValue.name));
            assert (expectedValue.nameIndex == actualValue.nameIndex);
        }
    }

    protected static void verifyConstant(JavaConstant expectedConstant, JavaConstant actualConstant) {
        if (expectedConstant != null && expectedConstant.getJavaKind().isPrimitive() ? !$assertionsDisabled && FrameInfoEncoder.encodePrimitiveConstant(expectedConstant) != FrameInfoEncoder.encodePrimitiveConstant(actualConstant) : !$assertionsDisabled && !Objects.equals(expectedConstant, actualConstant)) {
            throw new AssertionError();
        }
    }
}

