/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.driver.metainf;

import com.oracle.svm.core.util.ClasspathUtils;
import com.oracle.svm.driver.metainf.MetaInfFileType;
import com.oracle.svm.driver.metainf.NativeImageMetaInfResourceProcessor;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class NativeImageMetaInfWalker {
    public static final String nativeImageMetaInf = "META-INF/native-image";
    public static final String nativeImagePropertiesFilename = "native-image.properties";

    public static void walkMetaInfForCPEntry(Path classpathEntry, NativeImageMetaInfResourceProcessor metaInfProcessor) throws MetaInfWalkException {
        block21: {
            try {
                if (Files.isDirectory(classpathEntry, new LinkOption[0])) {
                    Path nativeImageMetaInfBase = classpathEntry.resolve(Paths.get(nativeImageMetaInf, new String[0]));
                    NativeImageMetaInfWalker.processNativeImageMetaInf(classpathEntry, nativeImageMetaInfBase, metaInfProcessor);
                    break block21;
                }
                List<Object> jarFileMatches = Collections.emptyList();
                if (classpathEntry.endsWith("$JavaCla$$pathWildcard$ubstitute$")) {
                    try {
                        jarFileMatches = Files.list(classpathEntry.getParent()).filter(ClasspathUtils::isJar).collect(Collectors.toList());
                    }
                    catch (NoSuchFileException noSuchFileException) {}
                } else if (ClasspathUtils.isJar((Path)classpathEntry)) {
                    jarFileMatches = Collections.singletonList(classpathEntry);
                }
                for (Path path : jarFileMatches) {
                    FileSystem probeJarFS;
                    URI jarFileURI = URI.create("jar:" + path.toUri());
                    try {
                        probeJarFS = FileSystems.newFileSystem(jarFileURI, Collections.emptyMap());
                    }
                    catch (UnsupportedOperationException e) {
                        probeJarFS = null;
                        metaInfProcessor.showWarning(ClasspathUtils.classpathToString((Path)classpathEntry) + " does not describe valid jarfile" + (jarFileMatches.size() > 1 ? "s" : ""));
                    }
                    if (probeJarFS == null) continue;
                    FileSystem jarFS = probeJarFS;
                    Throwable throwable = null;
                    try {
                        Path nativeImageMetaInfBase = jarFS.getPath("/META-INF/native-image", new String[0]);
                        NativeImageMetaInfWalker.processNativeImageMetaInf(path, nativeImageMetaInfBase, metaInfProcessor);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (jarFS == null) continue;
                        if (throwable != null) {
                            try {
                                jarFS.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        jarFS.close();
                    }
                }
            }
            catch (IOException | FileSystemNotFoundException e) {
                throw new MetaInfWalkException("Invalid classpath entry " + ClasspathUtils.classpathToString((Path)classpathEntry), e);
            }
        }
    }

    private static void processNativeImageMetaInf(Path classpathEntry, Path nativeImageMetaInfBase, NativeImageMetaInfResourceProcessor metaInfProcessor) throws MetaInfWalkException {
        if (Files.isDirectory(nativeImageMetaInfBase, new LinkOption[0])) {
            for (MetaInfFileType fileType : MetaInfFileType.values()) {
                List nativeImageMetaInfFiles;
                try {
                    nativeImageMetaInfFiles = Files.walk(nativeImageMetaInfBase, new FileVisitOption[0]).filter(p -> p.endsWith(fileType.fileName)).collect(Collectors.toList());
                }
                catch (IOException e) {
                    throw new MetaInfWalkException("Processing " + nativeImageMetaInfBase.toUri() + " failed.", e);
                }
                for (Path nativeImageMetaInfFile : nativeImageMetaInfFiles) {
                    boolean excluded = metaInfProcessor.isExcluded(nativeImageMetaInfFile, classpathEntry);
                    if (excluded) continue;
                    Path resourceRoot = nativeImageMetaInfBase.getParent().getParent();
                    metaInfProcessor.showVerboseMessage("Apply " + nativeImageMetaInfFile.toUri());
                    try {
                        metaInfProcessor.processMetaInfResource(classpathEntry, resourceRoot, nativeImageMetaInfFile, fileType);
                    }
                    catch (Throwable err) {
                        throw new MetaInfWalkException("Processing " + nativeImageMetaInfFile.toUri() + " failed", err);
                    }
                }
            }
        }
    }

    public static class MetaInfWalkException
    extends Exception {
        private static final long serialVersionUID = 7185681203564964445L;
        public final Throwable cause;

        public MetaInfWalkException(String message, Throwable cause) {
            super(message);
            this.cause = cause;
        }
    }
}

