/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.driver;

import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.svm.core.FallbackExecutor;
import com.oracle.svm.core.OS;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.configure.ConfigurationFiles;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.ClasspathUtils;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.driver.APIOptionHandler;
import com.oracle.svm.driver.DefaultOptionHandler;
import com.oracle.svm.driver.MacroOption;
import com.oracle.svm.driver.MacroOptionHandler;
import com.oracle.svm.driver.NativeImageServer;
import com.oracle.svm.hosted.NativeImageSystemClassLoader;
import com.oracle.svm.util.ModuleSupport;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Scanner;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.ProcessProperties;

public class NativeImage {
    private static final String DEFAULT_GENERATOR_CLASS_NAME = "com.oracle.svm.hosted.NativeImageGeneratorRunner";
    private static final String DEFAULT_GENERATOR_9PLUS_SUFFIX = "$JDK9Plus";
    private static final String CUSTOM_SYSTEM_CLASS_LOADER = NativeImageSystemClassLoader.class.getCanonicalName();
    static final boolean IS_AOT = Boolean.getBoolean("com.oracle.graalvm.isaot");
    static final String platform = NativeImage.getPlatform();
    static final String graalvmVersion = System.getProperty("org.graalvm.version", "dev");
    static final String graalvmConfig = System.getProperty("org.graalvm.config", "CE");
    static final Map<String, String[]> graalCompilerFlags = NativeImage.getCompilerFlags();
    static Boolean useJVMCINativeLibrary = null;
    private static final String usageText = NativeImage.getResource("/Usage.txt");
    final DefaultOptionHandler defaultOptionHandler;
    final APIOptionHandler apiOptionHandler;
    public static final String oH = "-H:";
    static final String oR = "-R:";
    final String enablePrintFlags = SubstrateOptions.PrintFlags.getName();
    final String enablePrintFlagsWithExtraHelp = SubstrateOptions.PrintFlagsWithExtraHelp.getName();
    final String oHClass = NativeImage.oH(SubstrateOptions.Class);
    final String oHName = NativeImage.oH(SubstrateOptions.Name);
    final String oHPath = NativeImage.oH(SubstrateOptions.Path);
    final String enableSharedLibraryFlag = "-H:+" + SubstrateOptions.SharedLibrary.getName();
    final String oHCLibraryPath = NativeImage.oH(SubstrateOptions.CLibraryPath);
    final String oHOptimize = NativeImage.oH(SubstrateOptions.Optimize);
    final String oHFallbackThreshold = NativeImage.oH(SubstrateOptions.FallbackThreshold);
    final String oHFallbackExecutorJavaArg = NativeImage.oH(FallbackExecutor.Options.FallbackExecutorJavaArg);
    final String oRRuntimeJavaArg = NativeImage.oR(FallbackExecutor.Options.FallbackExecutorRuntimeJavaArg);
    final String oHTraceClassInitialization = NativeImage.oH(SubstrateOptions.TraceClassInitialization);
    final String oHTraceObjectInstantiation = NativeImage.oH(SubstrateOptions.TraceObjectInstantiation);
    final String oHTargetPlatform = NativeImage.oH(SubstrateOptions.TargetPlatform);
    final String oHSubstitutionFiles = NativeImage.oH(ConfigurationFiles.Options.SubstitutionFiles);
    final String oHReflectionConfigurationFiles = NativeImage.oH(ConfigurationFiles.Options.ReflectionConfigurationFiles);
    final String oHDynamicProxyConfigurationFiles = NativeImage.oH(ConfigurationFiles.Options.DynamicProxyConfigurationFiles);
    final String oHResourceConfigurationFiles = NativeImage.oH(ConfigurationFiles.Options.ResourceConfigurationFiles);
    final String oHJNIConfigurationFiles = NativeImage.oH(ConfigurationFiles.Options.JNIConfigurationFiles);
    final String oHSerializationConfigurationFiles = NativeImage.oH(ConfigurationFiles.Options.SerializationConfigurationFiles);
    final String oHSerializationDenyConfigurationFiles = NativeImage.oH(ConfigurationFiles.Options.SerializationDenyConfigurationFiles);
    final String oHInspectServerContentPath = NativeImage.oH(PointstoOptions.InspectServerContentPath);
    final String oHDeadlockWatchdogInterval = NativeImage.oH(SubstrateOptions.DeadlockWatchdogInterval);
    static final String oXmx = "-Xmx";
    static final String oXms = "-Xms";
    private static final String pKeyNativeImageArgs = "NativeImageArgs";
    private final ArrayList<String> imageBuilderArgs = new ArrayList();
    private final LinkedHashSet<Path> imageBuilderClasspath = new LinkedHashSet();
    private final LinkedHashSet<Path> imageBuilderBootClasspath = new LinkedHashSet();
    private final LinkedHashSet<String> imageIncludeBuiltinModules = new LinkedHashSet();
    private final ArrayList<String> imageBuilderJavaArgs = new ArrayList();
    private final LinkedHashSet<Path> imageClasspath = new LinkedHashSet();
    private final LinkedHashSet<Path> imageProvidedClasspath = new LinkedHashSet();
    private final ArrayList<String> customJavaArgs = new ArrayList();
    private final ArrayList<String> customImageBuilderArgs = new ArrayList();
    private final LinkedHashSet<Path> customImageClasspath = new LinkedHashSet();
    private final ArrayList<OptionHandler<? extends NativeImage>> optionHandlers = new ArrayList();
    protected final BuildConfiguration config;
    private final Map<String, String> userConfigProperties = new HashMap<String, String>();
    private final Map<String, String> propertyFileSubstitutionValues = new HashMap<String, String>();
    private boolean verbose = Boolean.valueOf(System.getenv("VERBOSE_GRAALVM_LAUNCHERS"));
    private boolean jarOptionMode = false;
    private boolean dryRun = false;
    private String printFlagsOptionQuery = null;
    private String printFlagsWithExtraHelpOptionQuery = null;
    final MacroOption.Registry optionRegistry;
    private LinkedHashSet<MacroOption.EnabledOption> enabledLanguages;
    private final List<ExcludeConfig> excludedConfigs = new ArrayList<ExcludeConfig>();
    public static final String nativeImagePropertiesFilename = "native-image.properties";
    public static final String nativeImageMetaInf = "META-INF/native-image";
    private String targetPlatform = null;
    private String targetOS = null;
    private String targetArch = null;
    private String mainClass;
    private String imageName;
    private String imagePath;
    private static final Function<BuildConfiguration, NativeImage> defaultNativeImageProvider = config -> IS_AOT ? NativeImageServer.create(config) : new NativeImage((BuildConfiguration)config);
    private static String deletedFileSuffix = ".deleted";

    private static String getPlatform() {
        return (OS.getCurrent().className + "-" + SubstrateUtil.getArchitectureName()).toLowerCase();
    }

    private static Map<String, String[]> getCompilerFlags() {
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        for (String versionTag : NativeImage.getResource(NativeImage.flagsFileName("versions")).split("\n")) {
            result.put(versionTag, NativeImage.getResource(NativeImage.flagsFileName(versionTag)).split("\n"));
        }
        return result;
    }

    private static String flagsFileName(String versionTag) {
        return "/graal-compiler-flags-" + versionTag + ".config";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String getResource(String resourceName) {
        try (InputStream input = NativeImage.class.getResourceAsStream(resourceName);){
            BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
            String resourceString = reader.lines().collect(Collectors.joining("\n"));
            String string = resourceString.replace("%pathsep%", File.pathSeparator);
            return string;
        }
        catch (IOException e) {
            VMError.shouldNotReachHere((Throwable)e);
            return null;
        }
    }

    private static <T> String oH(OptionKey<T> option) {
        return oH + option.getName() + "=";
    }

    private static <T> String oH(OptionKey<T> option, String origin) {
        VMError.guarantee((origin != null && !origin.contains("=") ? 1 : 0) != 0);
        return oH + option.getName() + "@" + origin + "=";
    }

    private static <T> String oR(OptionKey<T> option) {
        return oR + option.getName() + "=";
    }

    private ArrayList<String> createFallbackBuildArgs() {
        Path imagePathPath;
        ArrayList<String> buildArgs = new ArrayList<String>();
        Collection fallbackSystemProperties = this.customJavaArgs.stream().filter(s -> s.startsWith("-D")).collect(Collectors.toCollection(LinkedHashSet::new));
        for (Object property : fallbackSystemProperties) {
            buildArgs.add(NativeImage.oH(FallbackExecutor.Options.FallbackExecutorSystemProperty) + (String)property);
        }
        List runtimeJavaArgs = this.imageBuilderArgs.stream().filter(s -> s.startsWith(this.oRRuntimeJavaArg)).collect(Collectors.toList());
        for (Object runtimeJavaArg : runtimeJavaArgs) {
            buildArgs.add((String)runtimeJavaArg);
        }
        List fallbackExecutorJavaArgs = this.imageBuilderArgs.stream().filter(s -> s.startsWith(this.oHFallbackExecutorJavaArg)).collect(Collectors.toList());
        for (String fallbackExecutorJavaArg : fallbackExecutorJavaArgs) {
            buildArgs.add(fallbackExecutorJavaArg);
        }
        buildArgs.add("-H:+" + SubstrateOptions.ParseRuntimeOptions.getName());
        try {
            imagePathPath = this.canonicalize(Paths.get(this.imagePath, new String[0]));
        }
        catch (NativeImageError | InvalidPathException e) {
            throw NativeImage.showError("The given " + this.oHPath + this.imagePath + " argument does not specify a valid path", e);
        }
        boolean[] isPortable = new boolean[]{true};
        String classpathString = this.imageClasspath.stream().map(path -> {
            try {
                return imagePathPath.relativize((Path)path);
            }
            catch (IllegalArgumentException e) {
                isPortable[0] = false;
                return path;
            }
        }).map(ClasspathUtils::classpathToString).collect(Collectors.joining(File.pathSeparator));
        if (!isPortable[0]) {
            NativeImage.showWarning("The produced fallback image will not be portable, because not all classpath entries could be relativized (e.g., they are on another drive).");
        }
        buildArgs.add(this.oHPath + imagePathPath.toString());
        buildArgs.add(NativeImage.oH(FallbackExecutor.Options.FallbackExecutorClasspath) + classpathString);
        buildArgs.add(NativeImage.oH(FallbackExecutor.Options.FallbackExecutorMainClass) + this.mainClass);
        buildArgs.add("-H:-" + SubstrateOptions.DetectUserDirectoriesInImageHeap.getName());
        buildArgs.add(FallbackExecutor.class.getName());
        buildArgs.add(this.imageName);
        for (OptionHandler<? extends NativeImage> handler : this.optionHandlers) {
            handler.addFallbackBuildArgs(buildArgs);
        }
        return buildArgs;
    }

    protected NativeImage(BuildConfiguration config) {
        this.config = config;
        String configFileEnvVarKey = "NATIVE_IMAGE_CONFIG_FILE";
        String configFile = System.getenv(configFileEnvVarKey);
        if (configFile != null && !configFile.isEmpty()) {
            try {
                this.userConfigProperties.putAll(NativeImage.loadProperties(this.canonicalize(Paths.get(configFile, new String[0]))));
            }
            catch (NativeImageError | Exception e) {
                NativeImage.showError("Invalid environment variable " + configFileEnvVarKey, e);
            }
        }
        this.addPlainImageBuilderArg(this.oHPath + config.getWorkingDirectory());
        this.optionRegistry = new MacroOption.Registry();
        this.defaultOptionHandler = new DefaultOptionHandler(this);
        this.registerOptionHandler(this.defaultOptionHandler);
        this.apiOptionHandler = new APIOptionHandler(this);
        this.registerOptionHandler(this.apiOptionHandler);
        this.registerOptionHandler(new MacroOptionHandler(this));
    }

    void addMacroOptionRoot(Path configDir) {
        this.optionRegistry.addMacroOptionRoot(this.canonicalize(configDir));
    }

    protected void registerOptionHandler(OptionHandler<? extends NativeImage> handler) {
        this.optionHandlers.add(handler);
    }

    protected Map<String, String> getUserConfigProperties() {
        return this.userConfigProperties;
    }

    protected Path getUserConfigDir() {
        String envVarKey = "NATIVE_IMAGE_USER_HOME";
        String userHomeStr = System.getenv(envVarKey);
        if (userHomeStr == null || userHomeStr.isEmpty()) {
            return Paths.get(System.getProperty("user.home"), ".native-image");
        }
        return Paths.get(userHomeStr, new String[0]);
    }

    protected static void ensureDirectoryExists(Path dir) {
        if (Files.exists(dir, new LinkOption[0])) {
            if (!Files.isDirectory(dir, new LinkOption[0])) {
                throw NativeImage.showError("File " + dir + " is not a directory");
            }
        } else {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw NativeImage.showError("Could not create directory " + dir);
            }
        }
    }

    private void prepareImageBuildArgs() {
        this.config.getBuilderJavaArgs().forEach(xva$0 -> this.addImageBuilderJavaArgs((String)xva$0));
        this.addImageBuilderJavaArgs("-Xss10m");
        this.addImageBuilderJavaArgs(oXms + this.getXmsValue());
        this.addImageBuilderJavaArgs(oXmx + this.getXmxValue(1));
        this.addImageBuilderJavaArgs("-Duser.country=US", "-Duser.language=en");
        if (OS.getCurrent() != OS.WINDOWS || JavaVersionUtil.JAVA_SPEC > 8) {
            this.addImageBuilderJavaArgs("-Djava.awt.headless=true");
        }
        this.addImageBuilderJavaArgs("-Dorg.graalvm.version=" + graalvmVersion);
        this.addImageBuilderJavaArgs("-Dorg.graalvm.config=" + graalvmConfig);
        this.addImageBuilderJavaArgs("-Dcom.oracle.graalvm.isaot=true");
        this.addImageBuilderJavaArgs("-Djava.system.class.loader=" + CUSTOM_SYSTEM_CLASS_LOADER);
        if (OS.getCurrent() == OS.LINUX && JavaVersionUtil.JAVA_SPEC >= 11) {
            this.addImageBuilderJavaArgs("-Dawt.toolkit=sun.awt.X11.XToolkit");
            this.addImageBuilderJavaArgs("-Djava.awt.graphicsenv=sun.awt.X11GraphicsEnvironment");
            this.addImageBuilderJavaArgs("-Djava.awt.printerjob=sun.print.PSPrinterJob");
        }
        this.addImageBuilderJavaArgs("-Xshare:off");
        this.config.getBuilderClasspath().forEach(this::addImageBuilderClasspath);
        this.config.getImageProvidedClasspath().forEach(this::addImageProvidedClasspath);
        if (this.config.getBuilderInspectServerPath() != null) {
            this.addPlainImageBuilderArg(this.oHInspectServerContentPath + this.config.getBuilderInspectServerPath());
        }
        if (this.config.useJavaModules()) {
            String upgradeModulePath;
            String modulePath = this.config.getBuilderModulePath().stream().map(p -> this.canonicalize((Path)p).toString()).collect(Collectors.joining(File.pathSeparator));
            if (!modulePath.isEmpty()) {
                this.addImageBuilderJavaArgs(Arrays.asList("--module-path", modulePath));
            }
            if (!(upgradeModulePath = this.config.getBuilderUpgradeModulePath().stream().map(p -> this.canonicalize((Path)p).toString()).collect(Collectors.joining(File.pathSeparator))).isEmpty()) {
                this.addImageBuilderJavaArgs(Arrays.asList("--upgrade-module-path", upgradeModulePath));
            }
        } else {
            this.config.getBuilderJVMCIClasspath().forEach(this::addImageBuilderClasspath);
            if (!this.config.getBuilderJVMCIClasspathAppend().isEmpty()) {
                String builderJavaArg = this.config.getBuilderJVMCIClasspathAppend().stream().map(path -> this.canonicalize((Path)path).toString()).collect(Collectors.joining(File.pathSeparator, "-Djvmci.class.path.append=", ""));
                this.addImageBuilderJavaArgs(builderJavaArg);
            }
            this.config.getBuilderBootClasspath().forEach(this::addImageBuilderBootClasspath);
            this.config.getResourcesJar().ifPresent(this::addImageBuilderClasspath);
        }
        this.config.getImageClasspath().forEach(this::addCustomImageClasspath);
    }

    private void completeOptionArgs() {
        LinkedHashSet<MacroOption.EnabledOption> enabledOptions = this.optionRegistry.getEnabledOptions();
        if (!enabledOptions.isEmpty()) {
            this.addPlainImageBuilderArg(this.oHFallbackThreshold + 0);
        }
        this.enabledLanguages = this.optionRegistry.getEnabledOptions(MacroOption.MacroOptionKind.Language);
        if (this.enabledLanguages.size() > 1) {
            long baseMemRequirements = SubstrateOptionsParser.parseLong((String)"4g");
            long memRequirements = baseMemRequirements + (long)this.enabledLanguages.size() * SubstrateOptionsParser.parseLong((String)"1g");
            this.addImageBuilderJavaArgs(oXmx + memRequirements);
        }
        NativeImage.consolidateListArgs(this.imageBuilderJavaArgs, "-Dpolyglot.engine.PreinitializeContexts=", ",", Function.identity());
        NativeImage.consolidateListArgs(this.imageBuilderJavaArgs, "-Dpolyglot.image-build-time.PreinitializeContexts=", ",", Function.identity());
    }

    protected static boolean replaceArg(Collection<String> args, String argPrefix, String argSuffix) {
        boolean elementsRemoved = args.removeIf(arg -> arg.startsWith(argPrefix));
        args.add(argPrefix + argSuffix);
        return elementsRemoved;
    }

    private static <T> T consolidateArgs(Collection<String> args, String argPrefix, Function<String, T> fromSuffix, Function<T, String> toSuffix, Supplier<T> init, BiFunction<T, T, T> combiner) {
        Object consolidatedValue = null;
        boolean needsConsolidate = false;
        for (String arg : args) {
            if (!arg.startsWith(argPrefix)) continue;
            if (consolidatedValue == null) {
                consolidatedValue = init.get();
            } else {
                needsConsolidate = true;
            }
            consolidatedValue = combiner.apply(consolidatedValue, fromSuffix.apply(arg.substring(argPrefix.length())));
        }
        if (consolidatedValue != null && needsConsolidate) {
            NativeImage.replaceArg(args, argPrefix, toSuffix.apply(consolidatedValue));
        }
        return consolidatedValue;
    }

    private static LinkedHashSet<String> collectListArgs(Collection<String> args, String argPrefix, String delimiter) {
        LinkedHashSet<String> allEntries = new LinkedHashSet<String>();
        for (String arg : args) {
            String argEntriesRaw;
            if (!arg.startsWith(argPrefix) || (argEntriesRaw = arg.substring(argPrefix.length())).isEmpty()) continue;
            allEntries.addAll(Arrays.asList(argEntriesRaw.split(delimiter)));
        }
        return allEntries;
    }

    private static void consolidateListArgs(Collection<String> args, String argPrefix, String delimiter, Function<String, String> mapFunc) {
        LinkedHashSet<String> allEntries = NativeImage.collectListArgs(args, argPrefix, delimiter);
        if (!allEntries.isEmpty()) {
            NativeImage.replaceArg(args, argPrefix, allEntries.stream().map(mapFunc).collect(Collectors.joining(delimiter)));
        }
    }

    private void processClasspathNativeImageMetaInf(Path classpathEntry) {
        this.processClasspathNativeImageMetaInf(classpathEntry, this::processNativeImageMetaInf);
    }

    private void processClasspathNativeImageMetaInf(Path classpathEntry, NativeImageMetaInfResourceProcessor metaInfProcessor) {
        block21: {
            try {
                if (Files.isDirectory(classpathEntry, new LinkOption[0])) {
                    Path nativeImageMetaInfBase = classpathEntry.resolve(Paths.get(nativeImageMetaInf, new String[0]));
                    this.processNativeImageMetaInf(classpathEntry, nativeImageMetaInfBase, metaInfProcessor);
                    break block21;
                }
                List<Object> jarFileMatches = Collections.emptyList();
                if (classpathEntry.endsWith("$JavaCla$$pathWildcard$ubstitute$")) {
                    try {
                        jarFileMatches = Files.list(classpathEntry.getParent()).filter(ClasspathUtils::isJar).collect(Collectors.toList());
                    }
                    catch (NoSuchFileException noSuchFileException) {}
                } else if (ClasspathUtils.isJar((Path)classpathEntry)) {
                    jarFileMatches = Collections.singletonList(classpathEntry);
                }
                for (Path path : jarFileMatches) {
                    FileSystem probeJarFS;
                    block22: {
                        URI jarFileURI = URI.create("jar:" + path.toUri());
                        try {
                            probeJarFS = FileSystems.newFileSystem(jarFileURI, Collections.emptyMap());
                        }
                        catch (UnsupportedOperationException e) {
                            probeJarFS = null;
                            if (!this.isVerbose()) break block22;
                            NativeImage.showWarning(ClasspathUtils.classpathToString((Path)classpathEntry) + " does not describe valid jarfile" + (jarFileMatches.size() > 1 ? "s" : ""));
                        }
                    }
                    if (probeJarFS == null) continue;
                    FileSystem jarFS = probeJarFS;
                    Throwable throwable = null;
                    try {
                        Path nativeImageMetaInfBase = jarFS.getPath("/META-INF/native-image", new String[0]);
                        this.processNativeImageMetaInf(path, nativeImageMetaInfBase, metaInfProcessor);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (jarFS == null) continue;
                        if (throwable != null) {
                            try {
                                jarFS.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        jarFS.close();
                    }
                }
            }
            catch (IOException | FileSystemNotFoundException e) {
                throw NativeImage.showError("Invalid classpath entry " + ClasspathUtils.classpathToString((Path)classpathEntry), e);
            }
        }
    }

    private void processNativeImageMetaInf(Path classpathEntry, Path nativeImageMetaInfBase, NativeImageMetaInfResourceProcessor metaInfProcessor) throws IOException {
        if (Files.isDirectory(nativeImageMetaInfBase, new LinkOption[0])) {
            for (MetaInfFileType fileType : MetaInfFileType.values()) {
                List nativeImageMetaInfFiles = Files.walk(nativeImageMetaInfBase, new FileVisitOption[0]).filter(p -> p.endsWith(fileType.fileName)).collect(Collectors.toList());
                for (Path nativeImageMetaInfFile : nativeImageMetaInfFiles) {
                    boolean excluded = this.isExcluded(nativeImageMetaInfFile, classpathEntry);
                    if (excluded) continue;
                    Path resourceRoot = nativeImageMetaInfBase.getParent().getParent();
                    Function<String, String> resolver = str -> {
                        Path componentDirectory = resourceRoot.relativize(nativeImageMetaInfFile).getParent();
                        int nameCount = componentDirectory.getNameCount();
                        String optionArg = null;
                        if (nameCount > 2) {
                            String optionArgKey = componentDirectory.subpath(2, nameCount).toString();
                            optionArg = this.propertyFileSubstitutionValues.get(optionArgKey);
                        }
                        return NativeImage.resolvePropertyValue(str, optionArg, componentDirectory, this.config);
                    };
                    this.showVerboseMessage(this.isVerbose(), "Apply " + nativeImageMetaInfFile.toUri());
                    try {
                        metaInfProcessor.processMetaInfResource(classpathEntry, resourceRoot, nativeImageMetaInfFile, fileType, resolver);
                    }
                    catch (NativeImageError err) {
                        NativeImage.showError("Processing " + nativeImageMetaInfFile.toUri() + " failed", err);
                    }
                }
            }
        }
    }

    public void addExcludeConfig(Pattern jarPattern, Pattern resourcePattern) {
        this.excludedConfigs.add(new ExcludeConfig(jarPattern, resourcePattern));
    }

    private boolean isExcluded(Path resourcePath, Path classpathEntry) {
        return this.excludedConfigs.stream().filter(e -> e.jarPattern.matcher(classpathEntry.toString()).find()).anyMatch(e -> e.resourcePattern.matcher(resourcePath.toString()).find());
    }

    static String injectHostedOptionOrigin(String option, String origin) {
        if (origin != null && option.startsWith(oH)) {
            char boolPrefix;
            String optionOriginSeparator = "@";
            int eqIndex = option.indexOf(61);
            char c = boolPrefix = option.length() > oH.length() ? option.charAt(oH.length()) : (char)'\u0000';
            if (boolPrefix == '-' || boolPrefix == '+') {
                if (eqIndex != -1) {
                    NativeImage.showError("Invalid boolean native-image hosted-option " + option + " at " + origin);
                }
                return option + optionOriginSeparator + origin;
            }
            if (eqIndex == -1) {
                NativeImage.showError("Invalid native-image hosted-option " + option + " at " + origin);
            }
            String front = option.substring(0, eqIndex);
            String back = option.substring(eqIndex);
            return front + optionOriginSeparator + origin + back;
        }
        return option;
    }

    private void processNativeImageMetaInf(Path classpathEntry, Path resourceRoot, Path resourcePath, MetaInfFileType resourceType, Function<String, String> resolver) throws IOException {
        NativeImageArgsProcessor args = new NativeImageArgsProcessor(resourcePath.toUri().toString());
        if (resourceType == MetaInfFileType.Properties) {
            Map<String, String> properties = NativeImage.loadProperties(Files.newInputStream(resourcePath, new OpenOption[0]));
            String imageNameValue = properties.get("ImageName");
            if (imageNameValue != null) {
                this.addCustomImageBuilderArgs(NativeImage.injectHostedOptionOrigin(this.oHName + resolver.apply(imageNameValue), resourcePath.toUri().toString()));
            }
            NativeImage.forEachPropertyValue(properties.get("JavaArgs"), xva$0 -> this.addImageBuilderJavaArgs((String)xva$0), resolver);
            NativeImage.forEachPropertyValue(properties.get("Args"), args, resolver);
        } else {
            args.accept(NativeImage.oH(resourceType.optionKey) + resourceRoot.relativize(resourcePath));
        }
        args.apply(true);
    }

    static void processManifestMainAttributes(Path path, BiConsumer<Path, Attributes> manifestConsumer) {
        if (path.endsWith("$JavaCla$$pathWildcard$ubstitute$")) {
            if (!Files.isDirectory(path.getParent(), new LinkOption[0])) {
                throw NativeImage.showError("Cannot expand wildcard: '" + path + "' is not a directory");
            }
            try {
                Files.list(path.getParent()).filter(ClasspathUtils::isJar).forEach(p -> NativeImage.processJarManifestMainAttributes(p, manifestConsumer));
            }
            catch (IOException e) {
                throw NativeImage.showError("Error while expanding wildcard for '" + path + "'", e);
            }
        } else if (ClasspathUtils.isJar((Path)path)) {
            NativeImage.processJarManifestMainAttributes(path, manifestConsumer);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean processJarManifestMainAttributes(Path jarFilePath, BiConsumer<Path, Attributes> manifestConsumer) {
        try (JarFile jarFile = new JarFile(jarFilePath.toFile());){
            Manifest manifest = jarFile.getManifest();
            if (manifest == null) {
                boolean bl = false;
                return bl;
            }
            manifestConsumer.accept(jarFilePath, manifest.getMainAttributes());
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            throw NativeImage.showError("Invalid or corrupt jarfile " + jarFilePath, e);
        }
    }

    void handleMainClassAttribute(Path jarFilePath, Attributes mainAttributes) {
        String mainClassValue = mainAttributes.getValue("Main-Class");
        if (mainClassValue == null) {
            NativeImage.showError("No main manifest attribute, in " + jarFilePath);
        }
        String origin = "manifest from " + jarFilePath.toUri();
        this.addPlainImageBuilderArg(NativeImage.injectHostedOptionOrigin(this.oHClass + mainClassValue, origin));
        String jarFileName = jarFilePath.getFileName().toString();
        String jarSuffix = ".jar";
        String jarFileNameBase = jarFileName.endsWith(jarSuffix) ? jarFileName.substring(0, jarFileName.length() - jarSuffix.length()) : jarFileName;
        if (!jarFileNameBase.isEmpty()) {
            this.addPlainImageBuilderArg(NativeImage.injectHostedOptionOrigin(this.oHName + jarFileNameBase, origin));
        }
    }

    void handleClassPathAttribute(Path jarFilePath, Attributes mainAttributes) {
        String classPathValue = mainAttributes.getValue("Class-Path");
        if (classPathValue != null) {
            for (String cp : classPathValue.split(" +")) {
                Path manifestClassPath = ClasspathUtils.stringToClasspath((String)cp);
                if (!manifestClassPath.isAbsolute()) {
                    manifestClassPath = jarFilePath.getParent().resolve(manifestClassPath);
                }
                this.addImageClasspathEntry(this.imageClasspath, manifestClassPath, false);
            }
        }
    }

    private int completeImageBuild() {
        List<String> leftoverArgs = this.processNativeImageArgs();
        this.completeOptionArgs();
        this.addTargetArguments();
        String clibrariesPath = this.targetPlatform != null ? this.targetPlatform : platform;
        String clibrariesBuilderArg = this.config.getBuilderCLibrariesPaths().stream().map(path -> this.canonicalize(path.resolve(clibrariesPath)).toString()).collect(Collectors.joining(",", this.oHCLibraryPath, ""));
        this.addPlainImageBuilderArg(clibrariesBuilderArg);
        if (this.printFlagsOptionQuery != null) {
            this.addPlainImageBuilderArg(oH + this.enablePrintFlags + "=" + this.printFlagsOptionQuery);
            this.addPlainImageBuilderArg(oR + this.enablePrintFlags + "=" + this.printFlagsOptionQuery);
        } else if (this.printFlagsWithExtraHelpOptionQuery != null) {
            this.addPlainImageBuilderArg(oH + this.enablePrintFlagsWithExtraHelp + "=" + this.printFlagsWithExtraHelpOptionQuery);
            this.addPlainImageBuilderArg(oR + this.enablePrintFlagsWithExtraHelp + "=" + this.printFlagsWithExtraHelpOptionQuery);
        }
        if (this.shouldAddCWDToCP()) {
            this.addImageClasspath(Paths.get(".", new String[0]));
        }
        this.imageClasspath.addAll(this.customImageClasspath);
        Long xmxValue = NativeImage.consolidateArgs(this.imageBuilderJavaArgs, oXmx, SubstrateOptionsParser::parseLong, String::valueOf, () -> 0L, Math::max);
        Long xmsValue = NativeImage.consolidateArgs(this.imageBuilderJavaArgs, oXms, SubstrateOptionsParser::parseLong, String::valueOf, () -> SubstrateOptionsParser.parseLong((String)this.getXmsValue()), Math::max);
        if (Long.compareUnsigned(xmsValue, xmxValue) > 0) {
            NativeImage.replaceArg(this.imageBuilderJavaArgs, oXms, Long.toUnsignedString(xmxValue));
        }
        this.imageBuilderJavaArgs.add("-Djdk.internal.lambda.disableEagerInitialization=true");
        this.imageBuilderJavaArgs.add("-Djdk.internal.lambda.eagerlyInitialize=false");
        this.imageBuilderJavaArgs.add("-Djava.lang.invoke.InnerClassLambdaMetafactory.initializeLambdas=false");
        if (!this.imageIncludeBuiltinModules.isEmpty()) {
            this.imageBuilderJavaArgs.add("-Dsubstratevm.ImageIncludeBuiltinModules=" + String.join((CharSequence)",", this.imageIncludeBuiltinModules));
        }
        boolean afterOption = false;
        for (String arg2 : this.customJavaArgs) {
            if (arg2.startsWith("-")) {
                afterOption = true;
                continue;
            }
            if (!afterOption) {
                NativeImage.showError("Found invalid image builder Java VM argument: " + arg2);
                continue;
            }
            afterOption = false;
        }
        this.addImageBuilderJavaArgs(this.customJavaArgs.toArray(new String[0]));
        this.imageBuilderJavaArgs.addAll(this.getAgentArguments());
        this.mainClass = NativeImage.getHostedOptionFinalArgumentValue(this.imageBuilderArgs, this.oHClass);
        this.imagePath = NativeImage.getHostedOptionFinalArgumentValue(this.imageBuilderArgs, this.oHPath);
        boolean buildExecutable = this.imageBuilderArgs.stream().noneMatch(arg -> arg.contains(this.enableSharedLibraryFlag));
        boolean printFlags = this.imageBuilderArgs.stream().anyMatch(arg -> arg.contains(this.enablePrintFlags) || arg.contains(this.enablePrintFlagsWithExtraHelp));
        if (!printFlags) {
            ArrayList<String> extraImageArgs = new ArrayList<String>();
            ListIterator<String> leftoverArgsItr = leftoverArgs.listIterator();
            while (leftoverArgsItr.hasNext()) {
                String leftoverArg = leftoverArgsItr.next();
                if (leftoverArg.startsWith("-")) continue;
                leftoverArgsItr.remove();
                extraImageArgs.add(leftoverArg);
            }
            if (!this.jarOptionMode) {
                boolean explicitMainClass;
                boolean bl = explicitMainClass = NativeImage.getHostedOptionFinalArgumentValue(this.customImageBuilderArgs, this.oHClass) != null;
                if (extraImageArgs.isEmpty()) {
                    if (buildExecutable && (this.mainClass == null || this.mainClass.isEmpty())) {
                        NativeImage.showError("Please specify class containing the main entry point method. (see --help)");
                    }
                } else {
                    explicitMainClass = true;
                    this.mainClass = (String)extraImageArgs.remove(0);
                    this.imageBuilderArgs.add(NativeImage.oH(SubstrateOptions.Class, "explicit main-class") + this.mainClass);
                }
                if (extraImageArgs.isEmpty()) {
                    if (NativeImage.getHostedOptionFinalArgumentValue(this.customImageBuilderArgs, this.oHName) == null) {
                        if (explicitMainClass) {
                            this.imageBuilderArgs.add(NativeImage.oH(SubstrateOptions.Name, "main-class lower case as image name") + this.mainClass.toLowerCase());
                        } else if (NativeImage.getHostedOptionFinalArgumentValue(this.imageBuilderArgs, this.oHName) == null) {
                            throw NativeImage.showError("Missing image-name. Use " + this.oHName + "<imagename> to provide one.");
                        }
                    }
                } else {
                    this.imageBuilderArgs.add(NativeImage.oH(SubstrateOptions.Name, "explicit image name") + (String)extraImageArgs.remove(0));
                }
            } else if (!extraImageArgs.isEmpty()) {
                this.imageBuilderArgs.add(NativeImage.oH(SubstrateOptions.Name, "explicit image name") + (String)extraImageArgs.remove(0));
            }
            if (!extraImageArgs.isEmpty()) {
                String prefix = "Unknown argument" + (extraImageArgs.size() == 1 ? ": " : "s: ");
                NativeImage.showError(extraImageArgs.stream().collect(Collectors.joining(", ", prefix, "")));
            }
        }
        this.imageName = NativeImage.getHostedOptionFinalArgumentValue(this.imageBuilderArgs, this.oHName);
        if (!leftoverArgs.isEmpty()) {
            String prefix = "Unrecognized option" + (leftoverArgs.size() == 1 ? ": " : "s: ");
            NativeImage.showError(leftoverArgs.stream().collect(Collectors.joining(", ", prefix, "")));
        }
        LinkedHashSet<Path> finalImageClasspath = new LinkedHashSet<Path>(this.imageBuilderBootClasspath);
        finalImageClasspath.addAll(this.imageProvidedClasspath);
        finalImageClasspath.addAll(this.imageClasspath);
        if (!this.config.buildFallbackImage() && this.imageBuilderArgs.contains(this.oHFallbackThreshold + 10)) {
            return 2;
        }
        return this.buildImage(this.imageBuilderJavaArgs, this.imageBuilderBootClasspath, this.imageBuilderClasspath, this.imageBuilderArgs, finalImageClasspath);
    }

    private static String getLocationAgnosticArgPrefix(String argPrefix) {
        VMError.guarantee((argPrefix.startsWith(oH) && argPrefix.endsWith("=") ? 1 : 0) != 0, (String)"argPrefix has to be a hosted option that ends with \"=\"");
        return "^" + argPrefix.substring(0, argPrefix.length() - 1) + "(@[^=]*)?" + argPrefix.substring(argPrefix.length() - 1);
    }

    protected static String getHostedOptionFinalArgumentValue(List<String> args, String argPrefix) {
        String locationAgnosticArgPrefix = NativeImage.getLocationAgnosticArgPrefix(argPrefix);
        Pattern pattern = Pattern.compile(locationAgnosticArgPrefix);
        String lastArg = null;
        for (String arg : args) {
            Matcher matcher = pattern.matcher(arg);
            if (!matcher.find()) continue;
            lastArg = arg.substring(matcher.group().length());
        }
        return lastArg;
    }

    private boolean shouldAddCWDToCP() {
        if (this.config.buildFallbackImage() || this.printFlagsOptionQuery != null || this.printFlagsWithExtraHelpOptionQuery != null) {
            return false;
        }
        Optional<MacroOption.EnabledOption> explicitMacroOption = this.optionRegistry.getEnabledOptions(MacroOption.MacroOptionKind.Macro).stream().filter(MacroOption.EnabledOption::isEnabledFromCommandline).findAny();
        if (explicitMacroOption.isPresent()) {
            return false;
        }
        return this.customImageClasspath.isEmpty();
    }

    private static boolean isListArgumentSet(Collection<String> list, String argPrefix) {
        return list.stream().anyMatch(arg -> arg.startsWith(argPrefix) && !arg.equals(argPrefix));
    }

    private boolean isListArgumentSet(String argPrefix) {
        return NativeImage.isListArgumentSet(this.imageBuilderArgs, argPrefix);
    }

    private static String getListArgumentValue(Collection<String> list, String argPrefix) {
        VMError.guarantee((boolean)NativeImage.isListArgumentSet(list, argPrefix));
        return list.stream().filter(arg -> arg.startsWith(argPrefix)).map(arg -> arg.substring(argPrefix.length())).collect(Collectors.joining());
    }

    private String getListArgumentValue(String argPrefix) {
        return NativeImage.getListArgumentValue(this.imageBuilderArgs, argPrefix);
    }

    private List<String> getAgentArguments() {
        ArrayList<String> args = new ArrayList<String>();
        String agentOptions = "";
        boolean shouldTraceClassInitialization = this.isListArgumentSet(this.oHTraceClassInitialization);
        boolean shouldTraceObjectInstantiation = this.isListArgumentSet(this.oHTraceObjectInstantiation);
        if (shouldTraceClassInitialization) {
            String classesToTrace = this.getListArgumentValue(this.oHTraceClassInitialization);
            agentOptions = NativeImage.getAgentOptions(classesToTrace, "c");
        }
        if (shouldTraceObjectInstantiation) {
            String objectsToTrace = this.getListArgumentValue(this.oHTraceObjectInstantiation);
            if (!agentOptions.isEmpty()) {
                agentOptions = agentOptions + ",";
            }
            agentOptions = agentOptions + NativeImage.getAgentOptions(objectsToTrace, "o");
        }
        if (!agentOptions.isEmpty()) {
            args.add("-agentlib:native-image-diagnostics-agent=" + agentOptions);
        }
        args.add("-javaagent:" + this.config.getAgentJAR().toAbsolutePath().toString() + (agentOptions.isEmpty() ? "" : "=" + agentOptions));
        return args;
    }

    private static String getAgentOptions(String options, String optionName) {
        return Arrays.stream(options.split(",")).map(option -> optionName + "=" + option).collect(Collectors.joining(","));
    }

    private void addTargetArguments() {
        if (!this.isListArgumentSet(this.oHTargetPlatform)) {
            return;
        }
        this.targetPlatform = this.getListArgumentValue(this.oHTargetPlatform).toLowerCase();
        String[] parts = this.targetPlatform.split("-");
        if (parts.length != 2) {
            throw UserError.abort((String)"--target argument must be in format <OS>-<architecture>", (Object[])new Object[0]);
        }
        this.targetOS = parts[0];
        this.targetArch = parts[1];
        if (NativeImage.isListArgumentSet(this.customJavaArgs, "-Dsvm.platform")) {
            NativeImage.showWarning("Usage of -Dsvm.platform might conflict with --target parameter.");
        }
        if (this.targetOS != null) {
            this.customJavaArgs.add("-Dsvm.targetPlatformOS=" + this.targetOS);
        }
        if (this.targetArch != null) {
            this.customJavaArgs.add("-Dsvm.targetPlatformArch=" + this.targetArch);
        }
    }

    protected static List<String> createImageBuilderArgs(ArrayList<String> imageArgs, LinkedHashSet<Path> imagecp) {
        ArrayList<String> result = new ArrayList<String>();
        result.add("-imagecp");
        result.add(imagecp.stream().map(ClasspathUtils::classpathToString).collect(Collectors.joining(File.pathSeparator)));
        result.addAll(imageArgs);
        return result;
    }

    protected static String createImageBuilderArgumentFile(List<String> imageBuilderArguments) {
        try {
            final Path argsFile = Files.createTempFile("native-image", "args", new FileAttribute[0]);
            String joinedOptions = String.join((CharSequence)"\u0000", imageBuilderArguments);
            Files.write(argsFile, joinedOptions.getBytes(), new OpenOption[0]);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        Files.delete(argsFile);
                    }
                    catch (IOException e) {
                        System.err.println("Failed to delete temporary image builder arguments file: " + argsFile.toString());
                    }
                }
            });
            return "--image-args-file=" + argsFile.toString();
        }
        catch (IOException e) {
            throw NativeImage.showError(e.getMessage());
        }
    }

    protected int buildImage(List<String> javaArgs, LinkedHashSet<Path> bcp, LinkedHashSet<Path> cp, ArrayList<String> imageArgs, LinkedHashSet<Path> imagecp) {
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.canonicalize(this.config.getJavaExecutable()).toString());
        command.addAll(javaArgs);
        if (!bcp.isEmpty()) {
            command.add(bcp.stream().map(Path::toString).collect(Collectors.joining(File.pathSeparator, "-Xbootclasspath/a:", "")));
        }
        command.addAll(Arrays.asList("-cp", cp.stream().map(Path::toString).collect(Collectors.joining(File.pathSeparator))));
        command.add(this.config.getGeneratorMainClass());
        if (IS_AOT && OS.getCurrent().hasProcFS) {
            command.addAll(Arrays.asList("-watchpid", "" + ProcessProperties.getProcessID()));
        }
        List<String> finalImageBuilderArgs = NativeImage.createImageBuilderArgs(imageArgs, imagecp);
        List completeCommandList = Stream.concat(command.stream(), finalImageBuilderArgs.stream()).collect(Collectors.toList());
        command.add(NativeImage.createImageBuilderArgumentFile(finalImageBuilderArgs));
        this.showVerboseMessage(this.isVerbose() || this.dryRun, "Executing [");
        this.showVerboseMessage(this.isVerbose() || this.dryRun, SubstrateUtil.getShellCommandString(completeCommandList, (boolean)true));
        this.showVerboseMessage(this.isVerbose() || this.dryRun, "]");
        if (this.dryRun) {
            return 0;
        }
        int exitStatus = 1;
        try {
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            pb.command(command);
            Process p = pb.inheritIO().start();
            exitStatus = p.waitFor();
        }
        catch (IOException | InterruptedException e) {
            throw NativeImage.showError(e.getMessage());
        }
        return exitStatus;
    }

    public static void main(String[] args) {
        NativeImage.performBuild(new DefaultBuildConfiguration(Arrays.asList(args)), defaultNativeImageProvider);
    }

    public static void build(BuildConfiguration config) {
        NativeImage.build(config, defaultNativeImageProvider);
    }

    public static void agentBuild(Path javaHome, Path workDir, List<String> buildArgs) {
        NativeImage.performBuild(new DefaultBuildConfiguration(javaHome, workDir, buildArgs), NativeImage::new);
    }

    private static void performBuild(BuildConfiguration config, Function<BuildConfiguration, NativeImage> nativeImageProvider) {
        try {
            NativeImage.build(config, nativeImageProvider);
        }
        catch (NativeImageError e) {
            NativeImage.show(System.err::println, "Error: " + e.getMessage());
            for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                NativeImage.show(System.err::println, "Caused by: " + cause);
            }
            if (config.getBuildArgs().contains("--verbose")) {
                e.printStackTrace();
            }
            System.exit(e.exitCode);
        }
        System.exit(0);
    }

    protected static void build(BuildConfiguration config, Function<BuildConfiguration, NativeImage> nativeImageProvider) {
        NativeImage nativeImage = nativeImageProvider.apply(config);
        if (config.getBuildArgs().isEmpty()) {
            nativeImage.showMessage(usageText);
        } else {
            try {
                nativeImage.prepareImageBuildArgs();
            }
            catch (NativeImageError e) {
                if (nativeImage.isVerbose()) {
                    throw NativeImage.showError("Requirements for building native images are not fulfilled", e);
                }
                throw NativeImage.showError("Requirements for building native images are not fulfilled [cause: " + e.getMessage() + "]", null);
            }
            int buildStatus = nativeImage.completeImageBuild();
            if (buildStatus == 2) {
                NativeImage.build(FallbackBuildConfiguration.create(nativeImage), nativeImageProvider);
                NativeImage.showWarning("Image '" + nativeImage.imageName + "' is a fallback image that requires a JDK for execution (use --" + "no-fallback" + " to suppress fallback image generation and to print more detailed information why a fallback image was necessary).");
            } else if (buildStatus != 0) {
                throw NativeImage.showError("Image build request failed with exit status " + buildStatus, null, buildStatus);
            }
        }
    }

    Path canonicalize(Path path) {
        return this.canonicalize(path, true);
    }

    Path canonicalize(Path path, boolean strict) {
        Path absolutePath;
        Path path2 = absolutePath = path.isAbsolute() ? path : this.config.getWorkingDirectory().resolve(path);
        if (!strict) {
            return absolutePath;
        }
        boolean hasWildcard = absolutePath.endsWith("$JavaCla$$pathWildcard$ubstitute$");
        if (hasWildcard) {
            absolutePath = absolutePath.getParent();
        }
        try {
            Path realPath = absolutePath.toRealPath(LinkOption.NOFOLLOW_LINKS);
            if (!Files.isReadable(realPath)) {
                NativeImage.showError("Path entry " + ClasspathUtils.classpathToString((Path)path) + " is not readable");
            }
            if (hasWildcard) {
                if (!Files.isDirectory(realPath, new LinkOption[0])) {
                    NativeImage.showError("Path entry with wildcard " + ClasspathUtils.classpathToString((Path)path) + " is not a directory");
                }
                realPath = realPath.resolve("$JavaCla$$pathWildcard$ubstitute$");
            }
            return realPath;
        }
        catch (IOException e) {
            throw NativeImage.showError("Invalid Path entry " + ClasspathUtils.classpathToString((Path)path), e);
        }
    }

    void addImageBuilderClasspath(Path classpath) {
        this.imageBuilderClasspath.add(this.canonicalize(classpath));
    }

    void addImageBuilderBootClasspath(Path classpath) {
        this.imageBuilderBootClasspath.add(this.canonicalize(classpath));
    }

    public void addImageIncludeBuiltinModules(String moduleName) {
        this.imageIncludeBuiltinModules.add(moduleName);
    }

    void addImageBuilderJavaArgs(String ... javaArgs) {
        this.addImageBuilderJavaArgs(Arrays.asList(javaArgs));
    }

    void addImageBuilderJavaArgs(Collection<String> javaArgs) {
        this.imageBuilderJavaArgs.addAll(javaArgs);
    }

    void addPlainImageBuilderArg(String plainArg) {
        assert (plainArg.startsWith(oH) || plainArg.startsWith(oR));
        this.imageBuilderArgs.add(plainArg);
    }

    private void addImageProvidedClasspath(Path classpath) {
        VMError.guarantee((this.imageClasspath.isEmpty() && this.customImageClasspath.isEmpty() ? 1 : 0) != 0);
        Path classpathEntry = this.canonicalize(classpath);
        if (this.imageProvidedClasspath.add(classpathEntry)) {
            NativeImage.processManifestMainAttributes(classpathEntry, this::handleClassPathAttribute);
            this.processClasspathNativeImageMetaInf(classpathEntry);
        }
    }

    void addImageClasspath(Path classpath) {
        this.addImageClasspathEntry(this.imageClasspath, classpath, true);
    }

    void addCustomImageClasspath(String classpath) {
        this.addImageClasspathEntry(this.customImageClasspath, ClasspathUtils.stringToClasspath((String)classpath), false);
    }

    void addCustomImageClasspath(Path classpath) {
        this.addImageClasspathEntry(this.customImageClasspath, classpath, true);
    }

    private void addImageClasspathEntry(LinkedHashSet<Path> destination, Path classpath, boolean strict) {
        Path classpathEntry;
        try {
            classpathEntry = this.canonicalize(classpath);
        }
        catch (NativeImageError e) {
            if (strict) {
                throw e;
            }
            if (this.isVerbose()) {
                NativeImage.showWarning("Invalid classpath entry: " + classpath);
            }
            destination.add(this.canonicalize(classpath, false));
            return;
        }
        if (!this.imageClasspath.contains(classpathEntry) && !this.customImageClasspath.contains(classpathEntry)) {
            destination.add(classpathEntry);
            NativeImage.processManifestMainAttributes(classpathEntry, this::handleClassPathAttribute);
            this.processClasspathNativeImageMetaInf(classpathEntry);
        }
    }

    void addCustomJavaArgs(String javaArg) {
        this.customJavaArgs.add(javaArg);
    }

    void addCustomImageBuilderArgs(String plainArg) {
        this.addPlainImageBuilderArg(plainArg);
        this.customImageBuilderArgs.add(plainArg);
    }

    void setVerbose(boolean val) {
        this.verbose = val;
    }

    void setJarOptionMode(boolean val) {
        this.jarOptionMode = val;
    }

    boolean isVerbose() {
        return this.verbose;
    }

    boolean useDebugAttach() {
        return this.defaultOptionHandler.useDebugAttach;
    }

    protected void setDryRun(boolean val) {
        this.dryRun = val;
    }

    boolean isDryRun() {
        return this.dryRun;
    }

    public void setPrintFlagsOptionQuery(String val) {
        this.printFlagsOptionQuery = val;
    }

    public void setPrintFlagsWithExtraHelpOptionQuery(String val) {
        this.printFlagsWithExtraHelpOptionQuery = val;
    }

    void showVerboseMessage(boolean show, String message) {
        if (show) {
            NativeImage.show(System.out::println, message);
        }
    }

    void showMessage(String message) {
        NativeImage.show(System.out::println, message);
    }

    void showNewline() {
        System.out.println();
    }

    void showMessagePart(String message) {
        NativeImage.show(s -> {
            System.out.print((String)s);
            System.out.flush();
        }, message);
    }

    public static void showWarning(String message) {
        NativeImage.show(System.err::println, "Warning: " + message);
    }

    public static Error showError(String message) {
        throw new NativeImageError(message);
    }

    public static Error showError(String message, Throwable cause) {
        throw new NativeImageError(message, cause);
    }

    public static Error showError(String message, Throwable cause, int exitCode) {
        throw new NativeImageError(message, cause, exitCode);
    }

    private static void show(Consumer<String> printFunc, String message) {
        printFunc.accept(message);
    }

    static List<Path> getJars(Path dir, String ... jarBaseNames) {
        try {
            List<String> baseNameList = Arrays.asList(jarBaseNames);
            return Files.list(dir).filter(p -> {
                String jarFileName = p.getFileName().toString();
                String jarSuffix = ".jar";
                if (!jarFileName.toLowerCase().endsWith(jarSuffix)) {
                    return false;
                }
                if (baseNameList.isEmpty()) {
                    return true;
                }
                String jarBaseName = jarFileName.substring(0, jarFileName.length() - jarSuffix.length());
                return baseNameList.contains(jarBaseName);
            }).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw NativeImage.showError("Unable to use jar-files from directory " + dir, e);
        }
    }

    private List<String> processNativeImageArgs() {
        NativeImageArgsProcessor argsProcessor = new NativeImageArgsProcessor(null);
        String defaultNativeImageArgs = this.getUserConfigProperties().get(pKeyNativeImageArgs);
        if (defaultNativeImageArgs != null && !defaultNativeImageArgs.isEmpty()) {
            for (String defaultArg : defaultNativeImageArgs.split(" ")) {
                argsProcessor.accept(defaultArg);
            }
        }
        for (String arg : this.config.getBuildArgs()) {
            argsProcessor.accept(arg);
        }
        return argsProcessor.apply(false);
    }

    protected String getXmsValue() {
        return "1g";
    }

    private static long getPhysicalMemorySize() {
        OperatingSystemMXBean osMXBean = ManagementFactory.getOperatingSystemMXBean();
        long totalPhysicalMemorySize = ((com.sun.management.OperatingSystemMXBean)osMXBean).getTotalPhysicalMemorySize();
        return totalPhysicalMemorySize;
    }

    protected String getXmxValue(int maxInstances) {
        Long memMax = Long.divideUnsigned(Long.divideUnsigned(NativeImage.getPhysicalMemorySize(), 10L) * 8L, maxInstances);
        String maxXmx = "14g";
        if (Long.compareUnsigned(memMax, SubstrateOptionsParser.parseLong((String)maxXmx)) >= 0) {
            return maxXmx;
        }
        return Long.toUnsignedString(memMax);
    }

    static Map<String, String> loadProperties(Path propertiesPath) {
        if (Files.isReadable(propertiesPath)) {
            try {
                return NativeImage.loadProperties(Files.newInputStream(propertiesPath, new OpenOption[0]));
            }
            catch (IOException e) {
                throw NativeImage.showError("Could not read properties-file: " + propertiesPath, e);
            }
        }
        return Collections.emptyMap();
    }

    static Map<String, String> loadProperties(InputStream propertiesInputStream) {
        Properties properties = new Properties();
        try {
            InputStream input = propertiesInputStream;
            Object object = null;
            try {
                properties.load(input);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (input != null) {
                    if (object != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        input.close();
                    }
                }
            }
        }
        catch (IOException e) {
            NativeImage.showError("Could not read properties", e);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : properties.stringPropertyNames()) {
            map.put(key, properties.getProperty(key));
        }
        return Collections.unmodifiableMap(map);
    }

    static boolean forEachPropertyValue(String propertyValue, Consumer<String> target, Function<String, String> resolver) {
        return NativeImage.forEachPropertyValue(propertyValue, target, resolver, " ");
    }

    static boolean forEachPropertyValue(String propertyValue, Consumer<String> target, Function<String, String> resolver, String separatorRegex) {
        if (propertyValue != null) {
            for (String propertyValuePart : propertyValue.split(separatorRegex)) {
                target.accept(resolver.apply(propertyValuePart));
            }
            return true;
        }
        return false;
    }

    public void addOptionKeyValue(String key, String value) {
        this.propertyFileSubstitutionValues.put(key, value);
    }

    static String resolvePropertyValue(String val, String optionArg, Path componentDirectory, BuildConfiguration config) {
        String resultVal = val;
        if (optionArg != null) {
            resultVal = NativeImage.safeSubstitution(resultVal, "${*}", optionArg);
            for (String argNameValue : optionArg.split(",")) {
                String[] splitted = argNameValue.split(":");
                if (splitted.length != 2) continue;
                String argName = splitted[0];
                String argValue = splitted[1];
                if (argName.isEmpty()) continue;
                resultVal = NativeImage.safeSubstitution(resultVal, "${" + argName + "}", argValue);
            }
        }
        resultVal = NativeImage.safeSubstitution(resultVal, "${.}", componentDirectory.toString());
        resultVal = NativeImage.safeSubstitution(resultVal, "${java.home}", config.getJavaHome().toString());
        return resultVal;
    }

    private static String safeSubstitution(String source, CharSequence target, CharSequence replacement) {
        if (replacement == null && source.contains(target)) {
            throw NativeImage.showError("Unable to provide meaningful substitution for \"" + target + "\" in " + source);
        }
        return source.replace(target, replacement);
    }

    protected static boolean isDeletedPath(Path toDelete) {
        return toDelete.getFileName().toString().endsWith(deletedFileSuffix);
    }

    protected void deleteAllFiles(Path toDelete) {
        block3: {
            try {
                Path deletedPath = toDelete;
                if (!NativeImage.isDeletedPath(deletedPath)) {
                    deletedPath = toDelete.resolveSibling(toDelete.getFileName() + deletedFileSuffix);
                    Files.move(toDelete, deletedPath, new CopyOption[0]);
                }
                Files.walk(deletedPath, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
            catch (IOException e) {
                if (!this.isVerbose()) break block3;
                this.showMessage("Could not recursively delete path: " + toDelete);
                e.printStackTrace();
            }
        }
    }

    private static final class ExcludeConfig {
        final Pattern jarPattern;
        final Pattern resourcePattern;

        private ExcludeConfig(Pattern jarPattern, Pattern resourcePattern) {
            this.jarPattern = jarPattern;
            this.resourcePattern = resourcePattern;
        }
    }

    public static class JDK9Plus {
        private static final boolean IS_AOT = Boolean.getBoolean("com.oracle.graalvm.isaot");

        public static void main(String[] args) {
            if (!IS_AOT) {
                ModuleSupport.exportAndOpenAllPackagesToUnnamed((String)"jdk.internal.vm.compiler", (boolean)false);
                ModuleSupport.exportAndOpenAllPackagesToUnnamed((String)"jdk.internal.vm.compiler.management", (boolean)true);
                ModuleSupport.exportAndOpenAllPackagesToUnnamed((String)"com.oracle.graal.graal_enterprise", (boolean)true);
                ModuleSupport.exportAndOpenAllPackagesToUnnamed((String)"java.xml", (boolean)false);
                if (JavaVersionUtil.JAVA_SPEC >= 16) {
                    ModuleSupport.exportAndOpenPackageToUnnamed((String)"java.base", (String)"sun.reflect.annotation", (boolean)false);
                    ModuleSupport.exportAndOpenPackageToUnnamed((String)"java.base", (String)"sun.security.jca", (boolean)false);
                    ModuleSupport.exportAndOpenPackageToUnnamed((String)"jdk.jdeps", (String)"com.sun.tools.classfile", (boolean)false);
                }
            }
            NativeImage.main(args);
        }
    }

    public static final class NativeImageError
    extends Error {
        final int exitCode;

        private NativeImageError(String message) {
            this(message, (Throwable)null);
        }

        private NativeImageError(String message, Throwable cause) {
            this(message, cause, 1);
        }

        public NativeImageError(String message, Throwable cause, int exitCode) {
            super(message, cause);
            this.exitCode = exitCode;
        }
    }

    class NativeImageArgsProcessor
    implements Consumer<String> {
        private final ArgumentQueue args;

        NativeImageArgsProcessor(String argumentOrigin) {
            this.args = new ArgumentQueue(argumentOrigin);
        }

        @Override
        public void accept(String arg) {
            this.args.add(arg);
        }

        List<String> apply(boolean strict) {
            ArrayList<String> leftoverArgs = new ArrayList<String>();
            while (!this.args.isEmpty()) {
                boolean consumed = false;
                for (int index = NativeImage.this.optionHandlers.size() - 1; index >= 0; --index) {
                    OptionHandler handler = (OptionHandler)NativeImage.this.optionHandlers.get(index);
                    int numArgs = this.args.size();
                    if (!handler.consume(this.args)) continue;
                    assert (this.args.size() < numArgs) : "OptionHandler pretends to consume argument(s) but isn't: " + handler.getClass().getName();
                    consumed = true;
                    break;
                }
                if (consumed) continue;
                if (strict) {
                    NativeImage.showError("Property 'Args' contains invalid entry '" + this.args.peek() + "'");
                    continue;
                }
                leftoverArgs.add(this.args.poll());
            }
            return leftoverArgs;
        }
    }

    static interface NativeImageMetaInfResourceProcessor {
        public void processMetaInfResource(Path var1, Path var2, Path var3, MetaInfFileType var4, Function<String, String> var5) throws IOException;
    }

    static enum MetaInfFileType {
        Properties(null, "native-image.properties"),
        JniConfiguration((OptionKey<?>)ConfigurationFiles.Options.JNIConfigurationResources, "jni-config.json"),
        ReflectConfiguration((OptionKey<?>)ConfigurationFiles.Options.ReflectionConfigurationResources, "reflect-config.json"),
        ResourceConfiguration((OptionKey<?>)ConfigurationFiles.Options.ResourceConfigurationResources, "resource-config.json"),
        ProxyConfiguration((OptionKey<?>)ConfigurationFiles.Options.DynamicProxyConfigurationResources, "proxy-config.json"),
        SerializationConfiguration((OptionKey<?>)ConfigurationFiles.Options.SerializationConfigurationResources, "serialization-config.json"),
        SerializationDenyConfiguration((OptionKey<?>)ConfigurationFiles.Options.SerializationDenyConfigurationResources, "serialization-deny-config.json");

        final OptionKey<?> optionKey;
        final String fileName;

        private MetaInfFileType(OptionKey<?> optionKey, String fileName) {
            this.optionKey = optionKey;
            this.fileName = fileName;
        }
    }

    private static final class FallbackBuildConfiguration
    implements InvocationHandler {
        private final NativeImage original;
        private final List<String> buildArgs;

        private FallbackBuildConfiguration(NativeImage original) {
            this.original = original;
            this.buildArgs = original.createFallbackBuildArgs();
        }

        static BuildConfiguration create(NativeImage imageName) {
            FallbackBuildConfiguration handler = new FallbackBuildConfiguration(imageName);
            BuildConfiguration fallback = (BuildConfiguration)Proxy.newProxyInstance(BuildConfiguration.class.getClassLoader(), new Class[]{BuildConfiguration.class}, (InvocationHandler)handler);
            return fallback;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            switch (method.getName()) {
                case "getImageClasspath": {
                    return Collections.emptyList();
                }
                case "getBuildArgs": {
                    return this.buildArgs;
                }
                case "buildFallbackImage": {
                    return true;
                }
            }
            return method.invoke((Object)this.original.config, args);
        }
    }

    protected static class DefaultBuildConfiguration
    implements BuildConfiguration {
        protected final Path workDir;
        protected final Path rootDir;
        protected final List<String> args;

        protected DefaultBuildConfiguration(List<String> args) {
            this(null, null, args);
        }

        DefaultBuildConfiguration(Path rootDir, Path workDir, List<String> args) {
            this.args = args;
            Path path = this.workDir = workDir != null ? workDir : Paths.get(".", new String[0]).toAbsolutePath().normalize();
            if (rootDir != null) {
                this.rootDir = rootDir;
            } else if (IS_AOT) {
                Path executablePath = Paths.get(ProcessProperties.getExecutableName(), new String[0]);
                assert (executablePath != null);
                Path binDir = executablePath.getParent();
                Path rootDirCandidate = binDir.getParent();
                if (rootDirCandidate.endsWith(platform)) {
                    rootDirCandidate = rootDirCandidate.getParent();
                }
                if (rootDirCandidate.endsWith(Paths.get("lib", "svm"))) {
                    rootDirCandidate = rootDirCandidate.getParent().getParent();
                }
                this.rootDir = rootDirCandidate;
            } else {
                String rootDirProperty = "native-image.root";
                String rootDirString = System.getProperty(rootDirProperty);
                if (rootDirString == null) {
                    rootDirString = System.getProperty("java.home");
                }
                this.rootDir = Paths.get(rootDirString, new String[0]);
            }
        }

        @Override
        public Path getWorkingDirectory() {
            return this.workDir;
        }

        @Override
        public Path getJavaHome() {
            return this.useJavaModules() ? this.rootDir : this.rootDir.getParent();
        }

        @Override
        public Path getJavaExecutable() {
            Path binJava = Paths.get("bin", OS.getCurrent() == OS.WINDOWS ? "java.exe" : "java");
            if (Files.isExecutable(this.rootDir.resolve(binJava))) {
                return this.rootDir.resolve(binJava);
            }
            String javaHome = System.getenv("JAVA_HOME");
            if (javaHome == null) {
                throw NativeImage.showError("Environment variable JAVA_HOME is not set");
            }
            Path javaHomeDir = Paths.get(javaHome, new String[0]);
            if (!Files.isDirectory(javaHomeDir, new LinkOption[0])) {
                throw NativeImage.showError("Environment variable JAVA_HOME does not refer to a directory");
            }
            if (!Files.isExecutable(javaHomeDir.resolve(binJava))) {
                throw NativeImage.showError("Environment variable JAVA_HOME does not refer to a directory with a " + binJava + " executable");
            }
            return javaHomeDir.resolve(binJava);
        }

        @Override
        public List<Path> getBuilderClasspath() {
            ArrayList<Path> result = new ArrayList<Path>();
            if (this.useJavaModules()) {
                result.addAll(NativeImage.getJars(this.rootDir.resolve(Paths.get("lib", "jvmci")), "graal-sdk", "graal", "enterprise-graal"));
            }
            result.addAll(NativeImage.getJars(this.rootDir.resolve(Paths.get("lib", "svm", "builder")), new String[0]));
            return result;
        }

        @Override
        public List<Path> getBuilderCLibrariesPaths() {
            return Collections.singletonList(this.rootDir.resolve(Paths.get("lib", "svm", "clibraries")));
        }

        @Override
        public List<Path> getImageProvidedClasspath() {
            return NativeImage.getJars(this.rootDir.resolve(Paths.get("lib", "svm")), new String[0]);
        }

        @Override
        public Path getBuilderInspectServerPath() {
            Path inspectPath = this.rootDir.resolve(Paths.get("lib", "svm", "inspect"));
            if (Files.isDirectory(inspectPath, new LinkOption[0])) {
                return inspectPath;
            }
            return null;
        }

        @Override
        public List<Path> getBuilderJVMCIClasspath() {
            return NativeImage.getJars(this.rootDir.resolve(Paths.get("lib", "jvmci")), new String[0]);
        }

        @Override
        public List<Path> getBuilderJVMCIClasspathAppend() {
            return this.getBuilderJVMCIClasspath().stream().filter(f -> f.getFileName().toString().toLowerCase().endsWith("graal.jar")).collect(Collectors.toList());
        }

        @Override
        public List<Path> getBuilderBootClasspath() {
            return NativeImage.getJars(this.rootDir.resolve(Paths.get("lib", "boot")), new String[0]);
        }

        @Override
        public List<Path> getBuilderModulePath() {
            ArrayList<Path> result = new ArrayList<Path>();
            result.addAll(NativeImage.getJars(this.rootDir.resolve(Paths.get("lib", "jvmci")), "graal-sdk", "enterprise-graal"));
            result.addAll(NativeImage.getJars(this.rootDir.resolve(Paths.get("lib", "truffle")), "truffle-api"));
            return result;
        }

        @Override
        public List<Path> getBuilderUpgradeModulePath() {
            return NativeImage.getJars(this.rootDir.resolve(Paths.get("lib", "jvmci")), "graal", "graal-management");
        }

        @Override
        public List<Path> getImageClasspath() {
            return Collections.emptyList();
        }

        @Override
        public List<String> getBuildArgs() {
            if (this.args.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<String> buildArgs = new ArrayList<String>();
            buildArgs.addAll(Arrays.asList("--configurations-path", this.rootDir.toString()));
            buildArgs.addAll(Arrays.asList("--configurations-path", this.rootDir.resolve(Paths.get("lib", "svm")).toString()));
            buildArgs.addAll(this.args);
            return buildArgs;
        }

        @Override
        public Path getAgentJAR() {
            return this.rootDir.resolve(Paths.get("lib", "svm", "builder", "svm.jar"));
        }

        @Override
        public Optional<Path> getResourcesJar() {
            return Optional.of(this.rootDir.resolve(Paths.get("lib", "resources.jar")));
        }
    }

    public static interface BuildConfiguration {
        default public String getGeneratorMainClass() {
            String generatorClassName = NativeImage.DEFAULT_GENERATOR_CLASS_NAME;
            if (this.useJavaModules()) {
                generatorClassName = generatorClassName + NativeImage.DEFAULT_GENERATOR_9PLUS_SUFFIX;
            }
            return generatorClassName;
        }

        public Path getWorkingDirectory();

        default public Path getJavaHome() {
            throw VMError.unimplemented();
        }

        default public Path getJavaExecutable() {
            throw VMError.unimplemented();
        }

        default public boolean useJavaModules() {
            try {
                Class.forName("java.lang.Module");
            }
            catch (ClassNotFoundException e) {
                return false;
            }
            return true;
        }

        default public List<Path> getBuilderClasspath() {
            throw VMError.unimplemented();
        }

        default public List<Path> getBuilderCLibrariesPaths() {
            throw VMError.unimplemented();
        }

        default public Path getBuilderInspectServerPath() {
            throw VMError.unimplemented();
        }

        default public List<Path> getImageProvidedClasspath() {
            throw VMError.unimplemented();
        }

        default public List<Path> getBuilderJVMCIClasspath() {
            throw VMError.unimplemented();
        }

        default public List<Path> getBuilderJVMCIClasspathAppend() {
            throw VMError.unimplemented();
        }

        default public List<Path> getBuilderBootClasspath() {
            throw VMError.unimplemented();
        }

        default public List<String> getBuilderJavaArgs() {
            String javaVersion = String.valueOf(JavaVersionUtil.JAVA_SPEC);
            String[] flagsForVersion = graalCompilerFlags.get(javaVersion);
            if (flagsForVersion == null) {
                String suffix = "";
                if (System.getProperty("java.home").contains("-dev")) {
                    suffix = " Update SubstrateCompilerFlagsBuilder.compute_graal_compiler_flags_map() in mx_substratevm.py to add a configuration for a new Java version.";
                }
                NativeImage.showError(String.format("Image building not supported for Java version %s in %s with VM configuration \"%s\".%s", System.getProperty("java.version"), System.getProperty("java.home"), System.getProperty("java.vm.name"), suffix));
            }
            if (useJVMCINativeLibrary == null) {
                useJVMCINativeLibrary = false;
                ProcessBuilder pb = new ProcessBuilder(new String[0]);
                List<String> command = pb.command();
                command.add(this.getJavaExecutable().toString());
                command.add("-XX:+PrintFlagsFinal");
                command.add("-version");
                try {
                    Process process = pb.start();
                    try (Scanner inputScanner = new Scanner(process.getInputStream());){
                        while (inputScanner.hasNextLine()) {
                            String value;
                            String line = inputScanner.nextLine();
                            if (!line.contains("bool UseJVMCINativeLibrary") || !(value = SubstrateUtil.split((String)line, (String)"=")[1]).trim().startsWith("true")) continue;
                            useJVMCINativeLibrary = true;
                            break;
                        }
                    }
                    process.waitFor();
                    process.destroy();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ArrayList<String> builderJavaArgs = new ArrayList<String>();
            builderJavaArgs.addAll(Arrays.asList(flagsForVersion));
            if (useJVMCINativeLibrary.booleanValue()) {
                builderJavaArgs.add("-XX:+UseJVMCINativeLibrary");
            } else {
                builderJavaArgs.add("-XX:-UseJVMCICompiler");
            }
            return builderJavaArgs;
        }

        default public List<Path> getBuilderModulePath() {
            throw VMError.unimplemented();
        }

        default public List<Path> getBuilderUpgradeModulePath() {
            throw VMError.unimplemented();
        }

        default public List<Path> getImageClasspath() {
            throw VMError.unimplemented();
        }

        default public List<String> getBuildArgs() {
            throw VMError.unimplemented();
        }

        default public boolean buildFallbackImage() {
            return false;
        }

        default public Path getAgentJAR() {
            return null;
        }

        default public Optional<Path> getResourcesJar() {
            return Optional.empty();
        }
    }

    static abstract class OptionHandler<T extends NativeImage> {
        protected final T nativeImage;

        OptionHandler(T nativeImage) {
            this.nativeImage = nativeImage;
        }

        abstract boolean consume(ArgumentQueue var1);

        void addFallbackBuildArgs(List<String> buildArgs) {
        }
    }

    class ArgumentQueue {
        private final ArrayDeque<String> queue = new ArrayDeque();
        public final String argumentOrigin;

        ArgumentQueue(String argumentOrigin) {
            this.argumentOrigin = argumentOrigin;
        }

        public void add(String arg) {
            this.queue.add(arg);
        }

        public String poll() {
            return this.queue.poll();
        }

        public String peek() {
            return this.queue.peek();
        }

        public boolean isEmpty() {
            return this.queue.isEmpty();
        }

        public int size() {
            return this.queue.size();
        }
    }
}

