/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.driver;

import com.oracle.svm.driver.DefaultOptionHandler;
import com.oracle.svm.driver.MacroOption;
import com.oracle.svm.driver.NativeImage;
import com.oracle.svm.driver.NativeImageServer;
import java.util.List;
import java.util.Queue;

class ServerOptionHandler
extends NativeImage.OptionHandler<NativeImageServer> {
    private static final String helpTextServer = NativeImage.getResource("/HelpServer.txt");

    ServerOptionHandler(NativeImageServer nativeImage) {
        super(nativeImage);
    }

    @Override
    public boolean consume(Queue<String> args) {
        String headArg;
        switch (headArg = args.peek()) {
            case "--help-extra": {
                args.poll();
                ((NativeImageServer)this.nativeImage).showMessage(DefaultOptionHandler.helpExtraText);
                ((NativeImageServer)this.nativeImage).showMessage(helpTextServer);
                ((NativeImageServer)this.nativeImage).optionRegistry.showOptions(MacroOption.MacroOptionKind.Macro, true, ((NativeImageServer)this.nativeImage)::showMessage);
                ((NativeImageServer)this.nativeImage).showNewline();
                System.exit(0);
                return true;
            }
            case "--no-server": {
                args.poll();
                ((NativeImageServer)this.nativeImage).setUseServer(false);
                return true;
            }
            case "--verbose-server": {
                args.poll();
                ((NativeImageServer)this.nativeImage).setVerboseServer(true);
                return true;
            }
        }
        if (headArg.startsWith("--server-")) {
            String optionTail = args.poll().substring("--server-".length());
            boolean machineWide = false;
            String oList = "list";
            String oCleanup = "cleanup";
            String oShutdown = "shutdown";
            String oWipe = "wipe";
            String oSession = "session=";
            boolean serverCleanup = false;
            boolean serverShutdown = false;
            if (optionTail.startsWith(oList)) {
                optionTail = optionTail.substring(oList.length());
                boolean listDetails = false;
                machineWide = true;
                String oDetails = "-details";
                if (optionTail.startsWith(oDetails)) {
                    optionTail = optionTail.substring(oDetails.length());
                    listDetails = true;
                }
                if (optionTail.isEmpty()) {
                    ((NativeImageServer)this.nativeImage).listServers(machineWide, listDetails);
                    System.exit(0);
                }
            } else if (optionTail.startsWith(oCleanup)) {
                optionTail = optionTail.substring(oCleanup.length());
                serverCleanup = true;
                machineWide = true;
            } else if (optionTail.startsWith(oShutdown)) {
                optionTail = optionTail.substring(oShutdown.length());
                serverShutdown = true;
                String oAll = "-all";
                if (optionTail.startsWith(oAll)) {
                    optionTail = optionTail.substring(oAll.length());
                    machineWide = true;
                }
            } else if (optionTail.equals(oWipe)) {
                ((NativeImageServer)this.nativeImage).wipeMachineDir();
                System.exit(0);
            } else if (optionTail.startsWith(oSession)) {
                ((NativeImageServer)this.nativeImage).setSessionName(optionTail.substring(oSession.length()));
                return true;
            }
            if (optionTail.isEmpty() && (serverCleanup || serverShutdown)) {
                ((NativeImageServer)this.nativeImage).cleanupServers(serverShutdown, machineWide, false);
                System.exit(0);
            }
            NativeImage.showError("Invalid server option: " + headArg);
        }
        return false;
    }

    @Override
    void addFallbackBuildArgs(List<String> buildArgs) {
        if (!((NativeImageServer)this.nativeImage).useServer()) {
            buildArgs.add("--no-server");
        }
        if (((NativeImageServer)this.nativeImage).verboseServer()) {
            buildArgs.add("--verbose-server");
        }
    }
}

