/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.agent.predicatedconfig;

import com.oracle.svm.agent.predicatedconfig.ClassInfo;
import com.oracle.svm.configure.config.SignatureUtil;
import java.util.Objects;

public class MethodInfo {
    private final String name;
    private final String signature;
    private final ClassInfo declaringClass;

    MethodInfo(String name, String signature, ClassInfo declaringClass) {
        this.name = name;
        this.signature = signature;
        this.declaringClass = declaringClass;
    }

    public String getJavaMethodNameAndSignature() {
        String[] parameterTypes = SignatureUtil.toParameterTypes((String)this.signature);
        StringBuilder sb = new StringBuilder(this.name);
        sb.append(" (");
        boolean first = false;
        for (String parameterType : parameterTypes) {
            if (!first) {
                first = true;
            } else {
                sb.append(",");
            }
            sb.append(parameterType);
        }
        sb.append(")");
        return sb.toString();
    }

    public String getJavaDeclaringClassName() {
        return this.declaringClass.className;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodInfo that = (MethodInfo)o;
        return this.name.equals(that.name) && this.signature.equals(that.signature) && this.declaringClass.equals(that.declaringClass);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.signature, this.declaringClass);
    }
}

