/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.agent;

import com.oracle.svm.agent.BreakpointInterceptor;
import com.oracle.svm.agent.JniCallInterceptor;
import com.oracle.svm.agent.NativeImageAgentJNIHandleSet;
import com.oracle.svm.agent.ignoredconfig.AgentMetaInfProcessor;
import com.oracle.svm.agent.predicatedconfig.ConfigurationWithOriginsResultWriter;
import com.oracle.svm.agent.predicatedconfig.MethodInfoRecordKeeper;
import com.oracle.svm.agent.stackaccess.EagerlyLoadedJavaStackAccess;
import com.oracle.svm.agent.stackaccess.InterceptedState;
import com.oracle.svm.agent.stackaccess.OnDemandJavaStackAccess;
import com.oracle.svm.agent.tracing.ConfigurationResultWriter;
import com.oracle.svm.agent.tracing.TraceFileWriter;
import com.oracle.svm.agent.tracing.core.Tracer;
import com.oracle.svm.agent.tracing.core.TracingResultWriter;
import com.oracle.svm.configure.config.ConfigurationSet;
import com.oracle.svm.configure.config.PredefinedClassesConfiguration;
import com.oracle.svm.configure.filters.FilterConfigurationParser;
import com.oracle.svm.configure.filters.RuleNode;
import com.oracle.svm.configure.trace.AccessAdvisor;
import com.oracle.svm.configure.trace.TraceProcessor;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.driver.NativeImage;
import com.oracle.svm.driver.metainf.NativeImageMetaInfResourceProcessor;
import com.oracle.svm.driver.metainf.NativeImageMetaInfWalker;
import com.oracle.svm.jni.nativeapi.JNIEnvironment;
import com.oracle.svm.jni.nativeapi.JNIJavaVM;
import com.oracle.svm.jni.nativeapi.JNIObjectHandle;
import com.oracle.svm.jvmtiagentbase.JNIHandleSet;
import com.oracle.svm.jvmtiagentbase.JvmtiAgentBase;
import com.oracle.svm.jvmtiagentbase.Support;
import com.oracle.svm.jvmtiagentbase.jvmti.JvmtiEnv;
import com.oracle.svm.jvmtiagentbase.jvmti.JvmtiEventCallbacks;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.ProcessProperties;
import org.graalvm.nativeimage.hosted.Feature;

public final class NativeImageAgent
extends JvmtiAgentBase<NativeImageAgentJNIHandleSet> {
    private static final String AGENT_NAME = "native-image-agent";
    private static final TimeZone UTC_TIMEZONE = TimeZone.getTimeZone("UTC");
    private ScheduledThreadPoolExecutor periodicConfigWriterExecutor = null;
    private Tracer tracer;
    private TracingResultWriter tracingResultWriter;
    private Path configOutputDirPath;
    private static final Pattern propertyBlacklist = Pattern.compile("(java\\..*)|(sun\\..*)|(jvmci\\..*)");
    private static final Pattern propertyWhitelist = Pattern.compile("(java\\.library\\.path)|(java\\.io\\.tmpdir)");
    private static final int MAX_WARNINGS_FOR_WRITING_CONFIGS_FAILURES = 5;
    private static int currentFailuresWritingConfigs = 0;
    private static final int MAX_FAILURES_ATOMIC_MOVE = 20;
    private static int currentFailuresAtomicMove = 0;

    private static String getTokenValue(String token) {
        return token.substring(token.indexOf(61) + 1);
    }

    protected int getRequiredJvmtiVersion() {
        return 805372416;
    }

    protected JNIHandleSet constructJavaHandles(JNIEnvironment env) {
        return new NativeImageAgentJNIHandleSet(env);
    }

    protected int onLoadCallback(JNIJavaVM vm, JvmtiEnv jvmti, JvmtiEventCallbacks callbacks, String options) {
        Supplier<InterceptedState> interceptedStateSupplier;
        String[] tokens;
        String traceOutputFile = null;
        String configOutputDir = null;
        ConfigurationSet mergeConfigs = new ConfigurationSet();
        ConfigurationSet omittedConfigs = new ConfigurationSet();
        boolean builtinCallerFilter = true;
        boolean builtinHeuristicFilter = true;
        ArrayList<String> callerFilterFiles = new ArrayList<String>();
        ArrayList<String> accessFilterFiles = new ArrayList<String>();
        boolean experimentalClassLoaderSupport = true;
        boolean experimentalClassDefineSupport = false;
        boolean experimentalOmitClasspathConfig = false;
        boolean build = false;
        boolean configurationWithOrigins = false;
        int configWritePeriod = -1;
        int configWritePeriodInitialDelay = 1;
        boolean trackReflectionMetadata = true;
        for (String token : tokens = !options.isEmpty() ? options.split(",") : new String[]{}) {
            if (token.startsWith("trace-output=")) {
                if (traceOutputFile != null) {
                    return NativeImageAgent.usage(1, "cannot specify trace-output= more than once.");
                }
                traceOutputFile = NativeImageAgent.getTokenValue(token);
                continue;
            }
            if (token.startsWith("config-output-dir=") || token.startsWith("config-merge-dir=")) {
                if (configOutputDir != null) {
                    return NativeImageAgent.usage(1, "cannot specify more than one of config-output-dir= or config-merge-dir=.");
                }
                configOutputDir = NativeImageAgent.transformPath(NativeImageAgent.getTokenValue(token));
                if (!token.startsWith("config-merge-dir=")) continue;
                mergeConfigs.addDirectory(Paths.get(configOutputDir, new String[0]));
                continue;
            }
            if (token.startsWith("config-to-omit=")) {
                String omittedConfigDir = NativeImageAgent.getTokenValue(token);
                omittedConfigDir = NativeImageAgent.transformPath(omittedConfigDir);
                omittedConfigs.addDirectory(Paths.get(omittedConfigDir, new String[0]));
                continue;
            }
            if (token.equals("experimental-omit-config-from-classpath")) {
                experimentalOmitClasspathConfig = true;
                continue;
            }
            if (token.startsWith("experimental-omit-config-from-classpath=")) {
                experimentalOmitClasspathConfig = Boolean.parseBoolean(NativeImageAgent.getTokenValue(token));
                continue;
            }
            if (token.startsWith("restrict-all-dir") || token.equals("restrict") || token.startsWith("restrict=")) {
                NativeImageAgent.warn("restrict mode is no longer supported, ignoring option: " + token);
                continue;
            }
            if (token.equals("no-builtin-caller-filter")) {
                builtinCallerFilter = false;
                continue;
            }
            if (token.startsWith("builtin-caller-filter=")) {
                builtinCallerFilter = Boolean.parseBoolean(NativeImageAgent.getTokenValue(token));
                continue;
            }
            if (token.equals("no-builtin-heuristic-filter")) {
                builtinHeuristicFilter = false;
                continue;
            }
            if (token.startsWith("builtin-heuristic-filter=")) {
                builtinHeuristicFilter = Boolean.parseBoolean(NativeImageAgent.getTokenValue(token));
                continue;
            }
            if (token.equals("no-filter")) {
                builtinCallerFilter = false;
                builtinHeuristicFilter = false;
                continue;
            }
            if (token.startsWith("no-filter=")) {
                builtinHeuristicFilter = builtinCallerFilter = !Boolean.parseBoolean(NativeImageAgent.getTokenValue(token));
                continue;
            }
            if (token.startsWith("caller-filter-file=")) {
                callerFilterFiles.add(NativeImageAgent.getTokenValue(token));
                continue;
            }
            if (token.startsWith("access-filter-file=")) {
                accessFilterFiles.add(NativeImageAgent.getTokenValue(token));
                continue;
            }
            if (token.equals("experimental-class-loader-support")) {
                experimentalClassLoaderSupport = true;
                continue;
            }
            if (token.startsWith("experimental-class-loader-support=")) {
                experimentalClassLoaderSupport = Boolean.parseBoolean(NativeImageAgent.getTokenValue(token));
                continue;
            }
            if (token.equals("experimental-class-define-support")) {
                experimentalClassDefineSupport = true;
                continue;
            }
            if (token.startsWith("experimental-class-define-support=")) {
                experimentalClassDefineSupport = Boolean.parseBoolean(NativeImageAgent.getTokenValue(token));
                continue;
            }
            if (token.startsWith("config-write-period-secs=")) {
                configWritePeriod = NativeImageAgent.parseIntegerOrNegative(NativeImageAgent.getTokenValue(token));
                if (configWritePeriod > 0) continue;
                return NativeImageAgent.usage(1, "config-write-period-secs must be an integer greater than 0");
            }
            if (token.startsWith("config-write-initial-delay-secs=")) {
                configWritePeriodInitialDelay = NativeImageAgent.parseIntegerOrNegative(NativeImageAgent.getTokenValue(token));
                if (configWritePeriodInitialDelay >= 0) continue;
                return NativeImageAgent.usage(1, "config-write-initial-delay-secs must be an integer greater or equal to 0");
            }
            if (token.equals("build")) {
                build = true;
                continue;
            }
            if (token.startsWith("build=")) {
                build = Boolean.parseBoolean(NativeImageAgent.getTokenValue(token));
                continue;
            }
            if (token.equals("experimental-configuration-with-origins")) {
                configurationWithOrigins = true;
                continue;
            }
            if (token.equals("track-reflection-metadata")) {
                trackReflectionMetadata = true;
                continue;
            }
            if (token.startsWith("track-reflection-metadata=")) {
                trackReflectionMetadata = Boolean.parseBoolean(NativeImageAgent.getTokenValue(token));
                continue;
            }
            return NativeImageAgent.usage(1, "unknown option: '" + token + "'.");
        }
        if (traceOutputFile == null && configOutputDir == null && !build) {
            configOutputDir = NativeImageAgent.transformPath("native-image-agent_config-pid{pid}-{datetime}/");
            NativeImageAgent.inform("no output/build options provided, tracking dynamic accesses and writing configuration to directory: " + configOutputDir);
        }
        if (configurationWithOrigins && !mergeConfigs.isEmpty()) {
            configurationWithOrigins = false;
            NativeImageAgent.inform("using configuration with origins with configuration merging is currently unsupported. Disabling configuration with origins mode.");
        }
        if (configurationWithOrigins) {
            NativeImageAgent.warn("using experimental configuration with origins mode. Note that native-image cannot process these files, and this flag may change or be removed without a warning!");
        }
        RuleNode callerFilter = null;
        if (!builtinCallerFilter) {
            callerFilter = RuleNode.createRoot();
            callerFilter.addOrGetChildren("**", RuleNode.Inclusion.Include);
        }
        if (!callerFilterFiles.isEmpty()) {
            if (callerFilter == null) {
                callerFilter = AccessAdvisor.copyBuiltinCallerFilterTree();
            }
            if (!NativeImageAgent.parseFilterFiles(callerFilter, callerFilterFiles)) {
                return 1;
            }
        }
        RuleNode accessFilter = null;
        if (!accessFilterFiles.isEmpty() && !NativeImageAgent.parseFilterFiles(accessFilter = AccessAdvisor.copyBuiltinAccessFilterTree(), accessFilterFiles)) {
            return 1;
        }
        MethodInfoRecordKeeper recordKeeper = new MethodInfoRecordKeeper(configurationWithOrigins);
        Supplier<InterceptedState> supplier = interceptedStateSupplier = configurationWithOrigins ? EagerlyLoadedJavaStackAccess.stackAccessSupplier() : OnDemandJavaStackAccess.stackAccessSupplier();
        if (configOutputDir != null) {
            if (traceOutputFile != null) {
                return NativeImageAgent.usage(1, "can only once specify exactly one of trace-output=, config-output-dir= or config-merge-dir=.");
            }
            try {
                this.configOutputDirPath = Paths.get(configOutputDir, new String[0]);
                if (!Files.exists(this.configOutputDirPath, new LinkOption[0])) {
                    Files.createDirectories(this.configOutputDirPath, new FileAttribute[0]);
                }
                if (experimentalOmitClasspathConfig) {
                    NativeImageAgent.ignoreConfigFromClasspath(jvmti, omittedConfigs);
                }
                AccessAdvisor advisor = NativeImageAgent.createAccessAdvisor(builtinHeuristicFilter, callerFilter, accessFilter);
                TraceProcessor omittedConfigProcessor = null;
                Predicate<String> shouldExcludeClassesWithHash = null;
                if (!omittedConfigs.isEmpty()) {
                    Function<IOException, Exception> ignore = e -> {
                        NativeImageAgent.warn("Failed to load omitted config: " + e);
                        return null;
                    };
                    omittedConfigProcessor = new TraceProcessor(advisor, omittedConfigs.loadJniConfig(ignore), omittedConfigs.loadReflectConfig(ignore), omittedConfigs.loadProxyConfig(ignore), omittedConfigs.loadResourceConfig(ignore), omittedConfigs.loadSerializationConfig(ignore), omittedConfigs.loadPredefinedClassesConfig(null, null, ignore), null);
                    shouldExcludeClassesWithHash = arg_0 -> ((PredefinedClassesConfiguration)omittedConfigProcessor.getPredefinedClassesConfiguration()).containsClassWithHash(arg_0);
                }
                Path[] predefinedClassDestinationDirs = new Path[]{this.configOutputDirPath.resolve("agent-extracted-predefined-classes")};
                if (configurationWithOrigins) {
                    ConfigurationWithOriginsResultWriter writer = new ConfigurationWithOriginsResultWriter(advisor, recordKeeper);
                    this.tracer = writer;
                    this.tracingResultWriter = writer;
                }
                Function<IOException, Exception> handler = e -> {
                    if (e instanceof NoSuchFileException) {
                        NativeImageAgent.warn("file " + ((NoSuchFileException)e).getFile() + " for merging could not be found, skipping");
                        return null;
                    }
                    if (e instanceof FileNotFoundException) {
                        NativeImageAgent.warn("could not open configuration file: " + e);
                        return null;
                    }
                    return e;
                };
                TraceProcessor processor = new TraceProcessor(advisor, mergeConfigs.loadJniConfig(handler), mergeConfigs.loadReflectConfig(handler), mergeConfigs.loadProxyConfig(handler), mergeConfigs.loadResourceConfig(handler), mergeConfigs.loadSerializationConfig(handler), mergeConfigs.loadPredefinedClassesConfig(predefinedClassDestinationDirs, shouldExcludeClassesWithHash, handler), omittedConfigProcessor);
                ConfigurationResultWriter writer = new ConfigurationResultWriter(processor);
                this.tracer = writer;
                this.tracingResultWriter = writer;
            }
            catch (Throwable t) {
                return NativeImageAgent.error(2, t.toString());
            }
        } else if (traceOutputFile != null) {
            try {
                Path path = Paths.get(NativeImageAgent.transformPath(traceOutputFile), new String[0]);
                TraceFileWriter writer = new TraceFileWriter(path);
                this.tracer = writer;
                this.tracingResultWriter = writer;
            }
            catch (Throwable t) {
                return NativeImageAgent.error(2, t.toString());
            }
        }
        if (build) {
            int status = NativeImageAgent.buildImage(jvmti);
            if (status == 0) {
                System.exit(status);
            }
            return status;
        }
        try {
            BreakpointInterceptor.onLoad(jvmti, callbacks, this.tracer, this, interceptedStateSupplier, experimentalClassLoaderSupport, experimentalClassDefineSupport, trackReflectionMetadata);
        }
        catch (Throwable t) {
            return NativeImageAgent.error(3, t.toString());
        }
        try {
            JniCallInterceptor.onLoad(this.tracer, this, interceptedStateSupplier);
        }
        catch (Throwable t) {
            return NativeImageAgent.error(4, t.toString());
        }
        this.setupExecutorServiceForPeriodicConfigurationCapture(configWritePeriod, configWritePeriodInitialDelay);
        return 0;
    }

    private static void inform(String message) {
        System.err.println("native-image-agent: " + message);
    }

    private static void warn(String message) {
        NativeImageAgent.inform("Warning: " + message);
    }

    private static <T> T error(T result, String message) {
        NativeImageAgent.inform("Error: " + message);
        return result;
    }

    private static <T> T usage(T result, String message) {
        NativeImageAgent.inform(message);
        NativeImageAgent.inform("Example usage: -agentlib:native-image-agent=config-output-dir=/path/to/config-dir/");
        NativeImageAgent.inform("For details, please read BuildConfiguration.md or https://www.graalvm.org/reference-manual/native-image/BuildConfiguration/");
        return result;
    }

    private static AccessAdvisor createAccessAdvisor(boolean builtinHeuristicFilter, RuleNode callerFilter, RuleNode accessFilter) {
        AccessAdvisor advisor = new AccessAdvisor();
        advisor.setHeuristicsEnabled(builtinHeuristicFilter);
        if (callerFilter != null) {
            advisor.setCallerFilterTree(callerFilter);
        }
        if (accessFilter != null) {
            advisor.setAccessFilterTree(accessFilter);
        }
        return advisor;
    }

    private static int parseIntegerOrNegative(String number) {
        try {
            return Integer.parseInt(number);
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }

    private static boolean parseFilterFiles(RuleNode filter, List<String> filterFiles) {
        for (String path : filterFiles) {
            try {
                new FilterConfigurationParser(filter).parseAndRegister(Paths.get(path, new String[0]));
            }
            catch (Exception e) {
                return NativeImageAgent.error(false, "cannot parse filter file " + path + ": " + e);
            }
        }
        filter.removeRedundantNodes();
        return true;
    }

    private void setupExecutorServiceForPeriodicConfigurationCapture(int writePeriod, int initialDelay) {
        if (this.tracingResultWriter == null || this.configOutputDirPath == null || !this.tracingResultWriter.supportsPeriodicTraceWriting()) {
            return;
        }
        if (writePeriod == -1) {
            return;
        }
        this.periodicConfigWriterExecutor = new ScheduledThreadPoolExecutor(1, r -> {
            Thread workerThread = new Thread(r);
            workerThread.setDaemon(true);
            workerThread.setName("AgentConfigurationsPeriodicWriter");
            return workerThread;
        });
        this.periodicConfigWriterExecutor.setRemoveOnCancelPolicy(true);
        this.periodicConfigWriterExecutor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.periodicConfigWriterExecutor.scheduleAtFixedRate(this::writeConfigurationFiles, initialDelay, writePeriod, TimeUnit.SECONDS);
    }

    private static void ignoreConfigFromClasspath(JvmtiEnv jvmti, ConfigurationSet ignoredConfigSet) {
        String classpath = Support.getSystemProperty((JvmtiEnv)jvmti, (String)"java.class.path");
        String sep = Support.getSystemProperty((JvmtiEnv)jvmti, (String)"path.separator");
        if (sep == null) {
            if (Platform.includedIn(Platform.LINUX.class) || Platform.includedIn(Platform.DARWIN.class)) {
                sep = ":";
            } else if (Platform.includedIn(Platform.WINDOWS.class)) {
                sep = "[:;]";
            } else {
                NativeImageAgent.warn("Running on unknown platform. Not omitting existing config from classpath.");
                return;
            }
        }
        AgentMetaInfProcessor processor = new AgentMetaInfProcessor(ignoredConfigSet);
        for (String cpEntry : classpath.split(sep)) {
            try {
                NativeImageMetaInfWalker.walkMetaInfForCPEntry((Path)Paths.get(cpEntry, new String[0]), (NativeImageMetaInfResourceProcessor)processor);
            }
            catch (NativeImageMetaInfWalker.MetaInfWalkException e) {
                NativeImageAgent.warn("Failed to walk the classpath entry: " + cpEntry + " Reason: " + (Object)((Object)e));
            }
        }
    }

    private static int buildImage(JvmtiEnv jvmti) {
        String[] keys;
        System.out.println("Building native image ...");
        String classpath = Support.getSystemProperty((JvmtiEnv)jvmti, (String)"java.class.path");
        if (classpath == null) {
            return NativeImageAgent.usage(1, "Build mode could not determine classpath.");
        }
        String javaCommand = Support.getSystemProperty((JvmtiEnv)jvmti, (String)"sun.java.command");
        String mainClassMissing = "Build mode could not determine main class.";
        if (javaCommand == null) {
            return NativeImageAgent.usage(1, mainClassMissing);
        }
        String mainClass = SubstrateUtil.split((String)javaCommand, (String)" ")[0];
        if (mainClass.isEmpty()) {
            return NativeImageAgent.usage(1, mainClassMissing);
        }
        ArrayList<String> buildArgs = new ArrayList<String>();
        for (String key : keys = Support.getSystemProperties((JvmtiEnv)jvmti)) {
            boolean blacklisted;
            boolean whitelisted = propertyWhitelist.matcher(key).matches();
            boolean bl = blacklisted = !whitelisted && propertyBlacklist.matcher(key).matches();
            if (blacklisted) continue;
            buildArgs.add("-D" + key + "=" + Support.getSystemProperty((JvmtiEnv)jvmti, (String)key));
        }
        if (mainClass.toLowerCase().endsWith(".jar")) {
            buildArgs.add("-jar");
        } else {
            buildArgs.addAll(Arrays.asList("-cp", classpath));
        }
        buildArgs.add(mainClass);
        buildArgs.add("native-image-agent.build");
        Path javaHome = Paths.get(Support.getSystemProperty((JvmtiEnv)jvmti, (String)"java.home"), new String[0]);
        String userDirStr = Support.getSystemProperty((JvmtiEnv)jvmti, (String)"user.dir");
        NativeImage.agentBuild((Path)javaHome, userDirStr == null ? null : Paths.get(userDirStr, new String[0]), buildArgs);
        return 0;
    }

    private static String transformPath(String path) {
        String result = path;
        if (result.contains("{pid}")) {
            result = result.replace("{pid}", Long.toString(ProcessProperties.getProcessID()));
        }
        if (result.contains("{datetime}")) {
            SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
            fmt.setTimeZone(UTC_TIMEZONE);
            result = result.replace("{datetime}", fmt.format(new Date()));
        }
        return result;
    }

    protected void onVMInitCallback(JvmtiEnv jvmti, JNIEnvironment jni, JNIObjectHandle thread) {
        BreakpointInterceptor.onVMInit(jvmti, jni);
        if (this.tracer != null) {
            this.tracer.tracePhaseChange("live");
        }
    }

    protected void onVMStartCallback(JvmtiEnv jvmti, JNIEnvironment jni) {
        JniCallInterceptor.onVMStart(jvmti);
        if (this.tracer != null) {
            this.tracer.tracePhaseChange("start");
        }
    }

    protected void onVMDeathCallback(JvmtiEnv jvmti, JNIEnvironment jni) {
        if (this.tracer != null) {
            this.tracer.tracePhaseChange("dead");
        }
    }

    private void writeConfigurationFiles() {
        try {
            Path tempDirectory = this.configOutputDirPath.toFile().exists() ? Files.createTempDirectory(this.configOutputDirPath, "tempConfig-", new FileAttribute[0]) : Files.createTempDirectory("tempConfig-", new FileAttribute[0]);
            List<Path> writtenFilePaths = this.tracingResultWriter.writeToDirectory(tempDirectory);
            for (Path writtenFilePath : writtenFilePaths) {
                Path fileName = tempDirectory.relativize(writtenFilePath);
                Path target = this.configOutputDirPath.resolve(fileName);
                NativeImageAgent.tryAtomicMove(writtenFilePath, target);
            }
            NativeImageAgent.compulsoryDelete(tempDirectory);
        }
        catch (IOException e) {
            NativeImageAgent.warnUpToLimit(currentFailuresWritingConfigs++, 5, "Error when writing configuration files: " + e.toString());
        }
    }

    private static void compulsoryDelete(Path pathToDelete) {
        int maxRetries = 3;
        for (int retries = 0; pathToDelete.toFile().exists() && !pathToDelete.toFile().delete() && retries < 3; ++retries) {
        }
    }

    private static void warnUpToLimit(int currentCount, int limit, String message) {
        if (currentCount < limit) {
            NativeImageAgent.warn(message);
            return;
        }
        if (currentCount == limit) {
            NativeImageAgent.warn(message);
            NativeImageAgent.warn("The above warning will no longer be reported.");
        }
    }

    private static void tryAtomicMove(Path source, Path target) throws IOException {
        try {
            Files.move(source, target, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (AtomicMoveNotSupportedException e) {
            NativeImageAgent.warnUpToLimit(currentFailuresAtomicMove++, 20, String.format("Could not move temporary configuration profile from (%s) to (%s) atomically. This might result in inconsistencies.", source.toAbsolutePath(), target.toAbsolutePath()));
            Files.move(source, target, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    protected int onUnloadCallback(JNIJavaVM vm) {
        if (this.periodicConfigWriterExecutor != null) {
            this.periodicConfigWriterExecutor.shutdown();
            try {
                this.periodicConfigWriterExecutor.awaitTermination(300L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ex) {
                this.periodicConfigWriterExecutor.shutdownNow();
            }
        }
        if (this.tracer != null) {
            this.tracer.tracePhaseChange("unload");
        }
        if (this.tracingResultWriter != null) {
            this.tracingResultWriter.close();
            if (this.tracingResultWriter.supportsOnUnloadTraceWriting() && this.configOutputDirPath != null) {
                this.writeConfigurationFiles();
                this.configOutputDirPath = null;
            }
        }
        return 0;
    }

    private static void cleanupOnUnload(JNIJavaVM vm) {
        JniCallInterceptor.onUnload();
        BreakpointInterceptor.onUnload();
    }

    public static class RegistrationFeature
    implements Feature {
        public void afterRegistration(Feature.AfterRegistrationAccess access) {
            NativeImageAgent.registerAgent((JvmtiAgentBase)new NativeImageAgent());
        }
    }
}

