/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.trace;

import com.oracle.svm.configure.ConfigurationBase;
import com.oracle.svm.configure.config.PredefinedClassesConfiguration;
import com.oracle.svm.configure.config.ProxyConfiguration;
import com.oracle.svm.configure.config.ResourceConfiguration;
import com.oracle.svm.configure.config.SerializationConfiguration;
import com.oracle.svm.configure.config.TypeConfiguration;
import com.oracle.svm.configure.trace.AbstractProcessor;
import com.oracle.svm.configure.trace.AccessAdvisor;
import com.oracle.svm.configure.trace.ClassLoadingProcessor;
import com.oracle.svm.configure.trace.JniProcessor;
import com.oracle.svm.configure.trace.ReflectionProcessor;
import com.oracle.svm.configure.trace.SerializationProcessor;
import com.oracle.svm.core.configure.ConfigurationFile;
import com.oracle.svm.core.util.json.JSONParser;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Map;

public class TraceProcessor
extends AbstractProcessor {
    private final AccessAdvisor advisor;
    private final JniProcessor jniProcessor;
    private final ReflectionProcessor reflectionProcessor;
    private final SerializationProcessor serializationProcessor;
    private final ClassLoadingProcessor classLoadingProcessor;

    public TraceProcessor(AccessAdvisor accessAdvisor, TypeConfiguration jniConfiguration, TypeConfiguration reflectionConfiguration, ProxyConfiguration proxyConfiguration, ResourceConfiguration resourceConfiguration, SerializationConfiguration serializationConfiguration, PredefinedClassesConfiguration predefinedClassesConfiguration) {
        this.advisor = accessAdvisor;
        this.jniProcessor = new JniProcessor(this.advisor, jniConfiguration, reflectionConfiguration);
        this.reflectionProcessor = new ReflectionProcessor(this.advisor, reflectionConfiguration, proxyConfiguration, resourceConfiguration);
        this.serializationProcessor = new SerializationProcessor(this.advisor, serializationConfiguration);
        this.classLoadingProcessor = new ClassLoadingProcessor(predefinedClassesConfiguration);
    }

    public TypeConfiguration getJniConfiguration() {
        return this.jniProcessor.getConfiguration();
    }

    public TypeConfiguration getReflectionConfiguration() {
        return this.reflectionProcessor.getConfiguration();
    }

    public ProxyConfiguration getProxyConfiguration() {
        return this.reflectionProcessor.getProxyConfiguration();
    }

    public ResourceConfiguration getResourceConfiguration() {
        return this.reflectionProcessor.getResourceConfiguration();
    }

    public SerializationConfiguration getSerializationConfiguration() {
        return this.serializationProcessor.getSerializationConfiguration();
    }

    public PredefinedClassesConfiguration getPredefinedClassesConfiguration() {
        return this.classLoadingProcessor.getPredefinedClassesConfiguration();
    }

    public ConfigurationBase getConfiguration(ConfigurationFile configFile) {
        assert (configFile.canBeGeneratedByAgent());
        switch (configFile) {
            case DYNAMIC_PROXY: {
                return this.getProxyConfiguration();
            }
            case JNI: {
                return this.getJniConfiguration();
            }
            case REFLECTION: {
                return this.getReflectionConfiguration();
            }
            case RESOURCES: {
                return this.getResourceConfiguration();
            }
            case SERIALIZATION: {
                return this.getSerializationConfiguration();
            }
            case PREDEFINED_CLASSES_NAME: {
                return this.getPredefinedClassesConfiguration();
            }
        }
        assert (false);
        return null;
    }

    public void process(Reader reader) throws IOException {
        this.setInLivePhase(false);
        JSONParser parser = new JSONParser(reader);
        List trace = (List)parser.parse();
        this.processTrace(trace);
    }

    private void processTrace(List<Map<String, ?>> trace) {
        for (Map<String, ?> entry : trace) {
            this.processEntry(entry);
        }
    }

    @Override
    public void processEntry(Map<String, ?> entry) {
        try {
            String tracer;
            switch (tracer = (String)entry.get("tracer")) {
                case "meta": {
                    String event = (String)entry.get("event");
                    if (event.equals("phase_change")) {
                        this.setInLivePhase(entry.get("phase").equals("live"));
                        break;
                    }
                    if (event.equals("initialization")) break;
                    TraceProcessor.logWarning("Unknown meta event, ignoring: " + event);
                    break;
                }
                case "jni": {
                    this.jniProcessor.processEntry(entry);
                    break;
                }
                case "reflect": {
                    this.reflectionProcessor.processEntry(entry);
                    break;
                }
                case "serialization": {
                    this.serializationProcessor.processEntry(entry);
                    break;
                }
                case "classloading": {
                    this.classLoadingProcessor.processEntry(entry);
                    break;
                }
                default: {
                    TraceProcessor.logWarning("Unknown tracer, ignoring: " + tracer);
                }
            }
        }
        catch (Exception e) {
            StackTraceElement stackTraceElement = e.getStackTrace()[0];
            TraceProcessor.logWarning("Error processing trace entry: " + e.toString() + " (at " + stackTraceElement.getClassName() + ":" + stackTraceElement.getLineNumber() + ") : " + entry.toString());
        }
    }

    @Override
    void setInLivePhase(boolean live) {
        this.advisor.setInLivePhase(live);
        this.jniProcessor.setInLivePhase(live);
        this.reflectionProcessor.setInLivePhase(live);
        super.setInLivePhase(live);
    }
}

