/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.trace;

import com.oracle.svm.configure.config.PredefinedClassesConfiguration;
import com.oracle.svm.configure.trace.AbstractProcessor;
import java.util.List;
import java.util.Map;

public class ClassLoadingProcessor
extends AbstractProcessor {
    private final PredefinedClassesConfiguration configuration;

    public ClassLoadingProcessor(PredefinedClassesConfiguration configuration) {
        this.configuration = configuration;
    }

    public PredefinedClassesConfiguration getPredefinedClassesConfiguration() {
        return this.configuration;
    }

    @Override
    void processEntry(Map<String, ?> entry) {
        boolean invalidResult = Boolean.FALSE.equals(entry.get("result"));
        if (invalidResult) {
            return;
        }
        String function = (String)entry.get("function");
        List args = (List)entry.get("args");
        if ("onClassFileLoadHook".equals(function)) {
            ClassLoadingProcessor.expectSize(args, 2);
            String nameInfo = (String)args.get(0);
            byte[] classData = ClassLoadingProcessor.asBinary(args.get(1));
            this.configuration.add(nameInfo, classData);
        }
    }
}

