/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.config;

import com.oracle.svm.configure.ConfigurationBase;
import com.oracle.svm.configure.config.ConfigurationPredefinedClass;
import com.oracle.svm.configure.json.JsonWriter;
import com.oracle.svm.core.hub.PredefinedClassesSupport;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ConcurrentHashMap;

public class PredefinedClassesConfiguration
implements ConfigurationBase {
    private final Path[] classDestinationDirs;
    private final ConcurrentHashMap<String, ConfigurationPredefinedClass> classes = new ConcurrentHashMap();

    public PredefinedClassesConfiguration(Path[] classDestinationDirs) {
        this.classDestinationDirs = classDestinationDirs;
    }

    public void add(String nameInfo, byte[] classData) {
        this.ensureDestinationDirsExist();
        String hash = PredefinedClassesSupport.hash((byte[])classData, (int)0, (int)classData.length);
        if (this.classDestinationDirs != null) {
            for (Path dir : this.classDestinationDirs) {
                try {
                    Files.write(dir.resolve(PredefinedClassesConfiguration.getFileName(hash)), classData, new OpenOption[0]);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        ConfigurationPredefinedClass clazz = new ConfigurationPredefinedClass(nameInfo, hash);
        this.classes.put(hash, clazz);
    }

    public void add(String nameInfo, String hash, Path directory) {
        if (this.classDestinationDirs != null) {
            this.ensureDestinationDirsExist();
            for (Path dir : this.classDestinationDirs) {
                if (dir.equals(directory)) continue;
                try {
                    String fileName = PredefinedClassesConfiguration.getFileName(hash);
                    Files.copy(directory.resolve(fileName), dir.resolve(fileName), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        ConfigurationPredefinedClass clazz = new ConfigurationPredefinedClass(nameInfo, hash);
        this.classes.put(hash, clazz);
    }

    private void ensureDestinationDirsExist() {
        if (this.classDestinationDirs != null) {
            for (Path dir : this.classDestinationDirs) {
                if (Files.isDirectory(dir, new LinkOption[0])) continue;
                try {
                    Files.createDirectory(dir, new FileAttribute[0]);
                }
                catch (IOException e) {
                    if (Files.isDirectory(dir, new LinkOption[0])) continue;
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static String getFileName(String hash) {
        return hash + ".classdata";
    }

    @Override
    public void printJson(JsonWriter writer) throws IOException {
        writer.append('[').indent().newline();
        writer.append('{').indent().newline();
        writer.quote("type").append(':').quote("agent-extracted").append(',').newline();
        writer.quote("classes").append(":[").indent();
        String prefix = "";
        for (ConfigurationPredefinedClass value : this.classes.values()) {
            writer.append(prefix).newline();
            value.printJson(writer);
            prefix = ",";
        }
        writer.unindent().newline().append(']');
        writer.unindent().newline().append('}');
        writer.unindent().newline().append(']').newline();
    }

    @Override
    public boolean isEmpty() {
        return this.classes.isEmpty();
    }
}

