/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.agent.predicatedconfig;

import com.oracle.svm.agent.predicatedconfig.MethodInfo;
import com.oracle.svm.agent.predicatedconfig.MethodInfoRecordKeeper;
import com.oracle.svm.agent.tracing.ConfigurationResultWriter;
import com.oracle.svm.agent.tracing.core.Tracer;
import com.oracle.svm.agent.tracing.core.TracingResultWriter;
import com.oracle.svm.configure.config.PredefinedClassesConfiguration;
import com.oracle.svm.configure.config.ProxyConfiguration;
import com.oracle.svm.configure.config.ResourceConfiguration;
import com.oracle.svm.configure.config.SerializationConfiguration;
import com.oracle.svm.configure.config.TypeConfiguration;
import com.oracle.svm.configure.json.JsonWriter;
import com.oracle.svm.configure.trace.AccessAdvisor;
import com.oracle.svm.configure.trace.TraceProcessor;
import com.oracle.svm.core.configure.ConfigurationFile;
import com.oracle.svm.jni.nativeapi.JNIMethodId;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class ConfigurationWithOriginsResultWriter
extends Tracer
implements TracingResultWriter {
    private final AccessAdvisor advisor;
    private final MethodCallNode rootNode;
    private final MethodInfoRecordKeeper methodInfoRecordKeeper;
    public static final String CONFIG_WITH_ORIGINS_FILE_SUFFIX = "-origins.json";

    public ConfigurationWithOriginsResultWriter(AccessAdvisor advisor, MethodInfoRecordKeeper methodInfoRecordKeeper) {
        this.advisor = advisor;
        this.rootNode = MethodCallNode.createRoot();
        this.methodInfoRecordKeeper = methodInfoRecordKeeper;
    }

    @Override
    public void traceEntry(Map<String, Object> entry) {
        String tracer = (String)entry.get("tracer");
        if (tracer.equals("meta")) {
            String event = (String)entry.get("event");
            if (event.equals("phase_change")) {
                this.advisor.setInLivePhase(entry.get("phase").equals("live"));
            }
        } else {
            assert (entry.containsKey("stack_trace"));
            JNIMethodId[] rawStackTrace = (JNIMethodId[])entry.remove("stack_trace");
            Map<String, Object> transformedEntry = ConfigurationResultWriter.arraysToLists(entry);
            if (rawStackTrace == null) {
                this.rootNode.traceEntry(this::createNewTraceProcessor, transformedEntry);
            } else {
                MethodInfo[] stackTrace = this.methodInfoRecordKeeper.getStackTraceInfo(rawStackTrace);
                this.rootNode.dispatchTraceEntry(stackTrace, stackTrace.length - 1, transformedEntry, this::createNewTraceProcessor);
            }
        }
    }

    private TraceProcessor createNewTraceProcessor() {
        TypeConfiguration jniConfig = new TypeConfiguration();
        TypeConfiguration reflectConfig = new TypeConfiguration();
        ProxyConfiguration proxyConfig = new ProxyConfiguration();
        ResourceConfiguration resourceConfig = new ResourceConfiguration();
        SerializationConfiguration serializationConfiguration = new SerializationConfiguration();
        PredefinedClassesConfiguration predefinedClassesConfiguration = new PredefinedClassesConfiguration(new Path[0]);
        return new TraceProcessor(this.advisor, jniConfig, reflectConfig, proxyConfig, resourceConfig, serializationConfiguration, predefinedClassesConfiguration);
    }

    @Override
    public boolean supportsPeriodicTraceWriting() {
        return false;
    }

    @Override
    public boolean supportsOnUnloadTraceWriting() {
        return true;
    }

    @Override
    public List<Path> writeToDirectory(Path directoryPath) throws IOException {
        ArrayList<Path> writtenPaths = new ArrayList<Path>();
        for (ConfigurationFile configFile : ConfigurationFile.values()) {
            if (!configFile.canBeGeneratedByAgent()) continue;
            Path filePath = directoryPath.resolve(configFile.getFileName(CONFIG_WITH_ORIGINS_FILE_SUFFIX));
            try (JsonWriter writer = new JsonWriter(filePath, new OpenOption[0]);){
                this.rootNode.writeJson(writer, configFile);
            }
            writtenPaths.add(filePath);
        }
        return writtenPaths;
    }

    private static final class MethodCallNode {
        private final MethodInfo methodInfo;
        private final MethodCallNode parent;
        private final Map<MethodInfo, MethodCallNode> calledMethods;
        private TraceProcessor processor;

        private MethodCallNode(MethodInfo methodInfo, MethodCallNode parent) {
            this.methodInfo = methodInfo;
            this.parent = parent;
            this.calledMethods = new ConcurrentHashMap<MethodInfo, MethodCallNode>();
            this.processor = null;
        }

        public static MethodCallNode createRoot() {
            return new MethodCallNode(null, null);
        }

        public boolean isRoot() {
            return this.parent == null;
        }

        public boolean hasConfig(ConfigurationFile configFile) {
            return this.processor != null && !this.processor.getConfiguration(configFile).isEmpty();
        }

        public void dispatchTraceEntry(MethodInfo[] stackTrace, int stackTraceEntry, Map<String, Object> entry, Supplier<TraceProcessor> traceProcessorSupplier) {
            if (stackTraceEntry == -1) {
                this.traceEntry(traceProcessorSupplier, entry);
            } else {
                MethodInfo next = stackTrace[stackTraceEntry];
                this.calledMethods.computeIfAbsent(next, nextNodeInfo -> new MethodCallNode((MethodInfo)nextNodeInfo, this));
                MethodCallNode nextCall = this.calledMethods.get(next);
                nextCall.dispatchTraceEntry(stackTrace, stackTraceEntry - 1, entry, traceProcessorSupplier);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void traceEntry(Supplier<TraceProcessor> traceProcessorSupplier, Map<String, Object> entry) {
            if (this.processor == null) {
                MethodCallNode methodCallNode = this;
                synchronized (methodCallNode) {
                    if (this.processor == null) {
                        this.processor = traceProcessorSupplier.get();
                    }
                }
            }
            this.processor.processEntry(entry);
        }

        public void writeJson(JsonWriter writer, ConfigurationFile configFile) throws IOException {
            HashSet<MethodCallNode> includedNodes = new HashSet<MethodCallNode>();
            this.visitPostOrder(node -> {
                if (node.hasConfig(configFile)) {
                    includedNodes.add((MethodCallNode)node);
                }
                if (includedNodes.contains(node) && node.parent != null) {
                    includedNodes.add(node.parent);
                }
            });
            this.writeJson(writer, configFile, includedNodes);
        }

        private void writeJson(JsonWriter writer, ConfigurationFile configFile, Set<MethodCallNode> includedNodes) throws IOException {
            if (this.isRoot()) {
                writer.append("[").newline().append("{").indent().newline().quote("configuration-with-origins").append(": [");
                this.printChildMethodJson(writer, configFile, includedNodes);
                writer.newline().append("]").unindent().newline();
                if (this.hasConfig(configFile)) {
                    writer.quote("configuration-without-origins").append(": ");
                    this.writeConfigJson(writer, configFile);
                    writer.unindent().newline();
                }
                writer.append("}").newline().append("]").newline();
            } else {
                writer.append("{").indent().newline();
                writer.quote("method").append(": ").quote(this.methodInfo.getJavaDeclaringClassName() + "#" + this.methodInfo.getJavaMethodNameAndSignature()).append(",").newline();
                if (this.anyChildrenIncluded(includedNodes)) {
                    writer.quote("methods").append(": [");
                    this.printChildMethodJson(writer, configFile, includedNodes);
                    writer.newline().append("]");
                    if (this.hasConfig(configFile)) {
                        writer.append(",").newline();
                    }
                }
                if (this.hasConfig(configFile)) {
                    this.writeConfigJson(writer, configFile);
                }
                writer.unindent().newline();
                writer.append("}");
            }
        }

        private void printChildMethodJson(JsonWriter writer, ConfigurationFile configFile, Set<MethodCallNode> includedNodes) throws IOException {
            boolean first = true;
            for (MethodCallNode methodCallNode : this.calledMethods.values()) {
                if (!includedNodes.contains(methodCallNode)) continue;
                if (first) {
                    first = false;
                } else {
                    writer.append(",");
                }
                writer.newline();
                methodCallNode.writeJson(writer, configFile, includedNodes);
            }
        }

        private boolean anyChildrenIncluded(Set<MethodCallNode> includedNodes) {
            return this.calledMethods.values().stream().anyMatch(includedNodes::contains);
        }

        private void writeConfigJson(JsonWriter writer, ConfigurationFile configFile) throws IOException {
            writer.quote("config").append(": ");
            this.processor.getConfiguration(configFile).printJson(writer);
        }

        private void visitPostOrder(Consumer<MethodCallNode> methodCallNodeConsumer) {
            for (MethodCallNode node : this.calledMethods.values()) {
                node.visitPostOrder(methodCallNodeConsumer);
            }
            methodCallNodeConsumer.accept(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodCallNode that = (MethodCallNode)o;
            return this.methodInfo.equals(that.methodInfo) && Objects.equals(this.parent, that.parent) && this.calledMethods.equals(that.calledMethods) && Objects.equals(this.processor, that.processor);
        }

        public int hashCode() {
            return Objects.hash(this.methodInfo, this.parent, this.processor);
        }
    }
}

