/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.config;

import com.oracle.svm.configure.config.ConfigurationType;
import com.oracle.svm.configure.json.JsonPrintable;
import com.oracle.svm.configure.json.JsonWriter;
import com.oracle.svm.core.util.UserError;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jdk.vm.ci.meta.JavaKind;

public class TypeConfiguration
implements JsonPrintable {
    private final ConcurrentMap<String, ConfigurationType> types = new ConcurrentHashMap<String, ConfigurationType>();

    public ConfigurationType get(String qualifiedJavaName) {
        return (ConfigurationType)this.types.get(qualifiedJavaName);
    }

    public void add(ConfigurationType type) {
        ConfigurationType previous = this.types.putIfAbsent(type.getQualifiedJavaName(), type);
        UserError.guarantee((previous == null || previous == type ? 1 : 0) != 0, (String)"Cannot replace existing type %s with %s", (Object[])new Object[]{previous, type});
    }

    public ConfigurationType getOrCreateType(String qualifiedForNameString) {
        int n;
        assert (qualifiedForNameString.indexOf(47) == -1) : "Requires qualified Java name, not internal representation";
        assert (!qualifiedForNameString.endsWith("[]")) : "Requires Class.forName syntax, for example '[Ljava.lang.String;'";
        String s = qualifiedForNameString;
        for (n = 0; n < s.length() && s.charAt(n) == '['; ++n) {
        }
        if (n > 0) {
            StringBuilder sb = new StringBuilder(s.length() + n);
            if (s.charAt(n) == 'L' && s.charAt(s.length() - 1) == ';') {
                sb.append(s, n + 1, s.length() - 1);
            } else if (n == s.length() - 1) {
                sb.append(JavaKind.fromPrimitiveOrVoidTypeChar((char)s.charAt(n)).getJavaName());
            } else {
                throw new IllegalArgumentException();
            }
            for (int i = 0; i < n; ++i) {
                sb.append("[]");
            }
            s = sb.toString();
        }
        return this.types.computeIfAbsent(s, ConfigurationType::new);
    }

    @Override
    public void printJson(JsonWriter writer) throws IOException {
        writer.append('[');
        String prefix = "\n";
        ArrayList list = new ArrayList(this.types.values());
        list.sort(Comparator.comparing(ConfigurationType::getQualifiedJavaName));
        for (ConfigurationType value : list) {
            writer.append(prefix);
            value.printJson(writer);
            prefix = ",\n";
        }
        writer.newline().append(']').newline();
    }
}

