/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure;

import com.oracle.svm.configure.config.ConfigurationSet;
import com.oracle.svm.configure.filters.FilterConfigurationParser;
import com.oracle.svm.configure.filters.ModuleFilterTools;
import com.oracle.svm.configure.filters.RuleNode;
import com.oracle.svm.configure.json.JsonWriter;
import com.oracle.svm.configure.trace.AccessAdvisor;
import com.oracle.svm.configure.trace.TraceProcessor;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.util.VMError;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class ConfigurationTool {
    private static final String HELP_TEXT = ConfigurationTool.getResource("/Help.txt") + System.lineSeparator();

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                throw new UsageException("No arguments provided.");
            }
            Iterator<String> argsIter = Arrays.asList(args).iterator();
            String first = argsIter.next();
            if (first.equals("command-file")) {
                if (!(argsIter = ConfigurationTool.handleCommandFile(argsIter)).hasNext()) {
                    throw new UsageException("No arguments provided in the command file.");
                }
                first = argsIter.next();
            }
            switch (first) {
                case "generate": {
                    ConfigurationTool.generate(argsIter, false);
                    break;
                }
                case "process-trace": {
                    ConfigurationTool.generate(argsIter, true);
                    break;
                }
                case "generate-filters": {
                    ConfigurationTool.generateFilterRules(argsIter);
                    break;
                }
                case "help": 
                case "--help": {
                    System.out.println(HELP_TEXT);
                    break;
                }
                default: {
                    throw new UsageException("Unknown subcommand: " + first);
                }
            }
        }
        catch (UsageException e) {
            System.err.println(e.getMessage() + System.lineSeparator() + "Use 'native-image-configure help' for usage.");
            System.exit(2);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static Path requirePath(String current, String value) {
        if (value == null || value.trim().isEmpty()) {
            throw new UsageException("Argument must be provided for: " + current);
        }
        return Paths.get(value, new String[0]);
    }

    private static URI requirePathUri(String current, String value) {
        return ConfigurationTool.requirePath(current, value).toUri();
    }

    private static Iterator<String> handleCommandFile(Iterator<String> args) {
        if (!args.hasNext()) {
            throw new UsageException("Path to a command file must be provided.");
        }
        Path filePath = Paths.get(args.next(), new String[0]);
        if (args.hasNext()) {
            throw new UsageException("Too many arguments to command-file passed. Expected a single argument: <path to a command file>.");
        }
        try {
            List<String> lines = Files.readAllLines(filePath);
            return lines.iterator();
        }
        catch (IOException e) {
            throw new UsageException("Failed to read the command file at " + filePath + ". Check if the file exists, you have the required permissions and that the file is actually a text file.");
        }
    }

    private static void generate(Iterator<String> argsIter, boolean acceptTraceFileArgs) throws IOException {
        Throwable throwable;
        TraceProcessor p;
        ArrayList<URI> traceInputs = new ArrayList<URI>();
        boolean builtinCallerFilter = true;
        boolean builtinHeuristicFilter = true;
        ArrayList<Path> callerFilterFiles = new ArrayList<Path>();
        ConfigurationSet inputSet = new ConfigurationSet();
        ConfigurationSet outputSet = new ConfigurationSet();
        block99: while (argsIter.hasNext()) {
            String[] parts = argsIter.next().split("=", 2);
            String current = parts[0];
            String value = parts.length > 1 ? parts[1] : null;
            ConfigurationSet set = outputSet;
            switch (current) {
                case "--input-dir": {
                    inputSet.addDirectory(ConfigurationTool.requirePath(current, value));
                    continue block99;
                }
                case "--output-dir": {
                    Path directory = ConfigurationTool.requirePath(current, value);
                    if (!Files.exists(directory, new LinkOption[0])) {
                        Files.createDirectory(directory, new FileAttribute[0]);
                    } else if (!Files.isDirectory(directory, new LinkOption[0])) {
                        throw new NoSuchFileException(value);
                    }
                    outputSet.addDirectory(directory);
                    continue block99;
                }
                case "--reflect-input": {
                    set = inputSet;
                }
                case "--reflect-output": {
                    set.getReflectConfigPaths().add(ConfigurationTool.requirePathUri(current, value));
                    continue block99;
                }
                case "--jni-input": {
                    set = inputSet;
                }
                case "--jni-output": {
                    set.getJniConfigPaths().add(ConfigurationTool.requirePathUri(current, value));
                    continue block99;
                }
                case "--proxy-input": {
                    set = inputSet;
                }
                case "--proxy-output": {
                    set.getProxyConfigPaths().add(ConfigurationTool.requirePathUri(current, value));
                    continue block99;
                }
                case "--resource-input": {
                    set = inputSet;
                }
                case "--resource-output": {
                    set.getResourceConfigPaths().add(ConfigurationTool.requirePathUri(current, value));
                    continue block99;
                }
                case "--serialization-input": {
                    set = inputSet;
                }
                case "--serialization-output": {
                    set.getSerializationConfigPaths().add(ConfigurationTool.requirePathUri(current, value));
                    continue block99;
                }
                case "--trace-input": {
                    traceInputs.add(ConfigurationTool.requirePathUri(current, value));
                    continue block99;
                }
                case "--no-filter": {
                    builtinCallerFilter = false;
                    builtinHeuristicFilter = false;
                    continue block99;
                }
                case "--no-builtin-caller-filter": {
                    builtinCallerFilter = false;
                    continue block99;
                }
                case "--no-builtin-heuristic-filter": {
                    builtinHeuristicFilter = false;
                    continue block99;
                }
                case "--caller-filter-file": {
                    callerFilterFiles.add(ConfigurationTool.requirePath(current, value));
                    continue block99;
                }
                case "--": {
                    if (acceptTraceFileArgs) {
                        argsIter.forEachRemaining(arg -> traceInputs.add(Paths.get(arg, new String[0]).toUri()));
                        continue block99;
                    }
                    throw new UsageException("Unknown argument: " + (String)current);
                }
            }
            if (!acceptTraceFileArgs || current.startsWith("-")) {
                throw new UsageException("Unknown argument: " + (String)current);
            }
            traceInputs.add(Paths.get(current, new String[0]).toUri());
        }
        RuleNode callersFilter = null;
        if (!builtinCallerFilter) {
            callersFilter = RuleNode.createRoot();
            callersFilter.addOrGetChildren("**", RuleNode.Inclusion.Include);
        }
        if (!callerFilterFiles.isEmpty()) {
            if (callersFilter == null) {
                callersFilter = AccessAdvisor.copyBuiltinCallerFilterTree();
            }
            for (Path path : callerFilterFiles) {
                try {
                    FilterConfigurationParser parser = new FilterConfigurationParser(callersFilter);
                    parser.parseAndRegister(new FileReader(path.toFile()));
                }
                catch (Exception e) {
                    throw new UsageException("Cannot parse filter file " + path + ": " + e);
                }
            }
            callersFilter.removeRedundantNodes();
        }
        AccessAdvisor advisor = new AccessAdvisor();
        advisor.setHeuristicsEnabled(builtinHeuristicFilter);
        if (callersFilter != null) {
            advisor.setCallerFilterTree(callersFilter);
        }
        try {
            p = new TraceProcessor(advisor, inputSet.loadJniConfig(ConfigurationSet.FAIL_ON_EXCEPTION), inputSet.loadReflectConfig(ConfigurationSet.FAIL_ON_EXCEPTION), inputSet.loadProxyConfig(ConfigurationSet.FAIL_ON_EXCEPTION), inputSet.loadResourceConfig(ConfigurationSet.FAIL_ON_EXCEPTION), inputSet.loadSerializationConfig(ConfigurationSet.FAIL_ON_EXCEPTION));
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        if (traceInputs.isEmpty() && inputSet.isEmpty()) {
            throw new UsageException("No inputs specified.");
        }
        for (URI uri : traceInputs) {
            BufferedReader reader = Files.newBufferedReader(Paths.get(uri));
            throwable = null;
            try {
                p.process(reader);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader == null) continue;
                if (throwable != null) {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ((Reader)reader).close();
            }
        }
        if (outputSet.isEmpty()) {
            System.err.println("Warning: no outputs specified, validating inputs only.");
        }
        for (URI uri : outputSet.getReflectConfigPaths()) {
            JsonWriter writer = new JsonWriter(Paths.get(uri), new OpenOption[0]);
            throwable = null;
            try {
                p.getReflectionConfiguration().printJson(writer);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (writer == null) continue;
                if (throwable != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    continue;
                }
                writer.close();
            }
        }
        for (URI uri : outputSet.getJniConfigPaths()) {
            JsonWriter writer = new JsonWriter(Paths.get(uri), new OpenOption[0]);
            throwable = null;
            try {
                p.getJniConfiguration().printJson(writer);
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (writer == null) continue;
                if (throwable != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable7) {
                        throwable.addSuppressed(throwable7);
                    }
                    continue;
                }
                writer.close();
            }
        }
        for (URI uri : outputSet.getProxyConfigPaths()) {
            JsonWriter writer = new JsonWriter(Paths.get(uri), new OpenOption[0]);
            throwable = null;
            try {
                p.getProxyConfiguration().printJson(writer);
            }
            catch (Throwable throwable8) {
                throwable = throwable8;
                throw throwable8;
            }
            finally {
                if (writer == null) continue;
                if (throwable != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable9) {
                        throwable.addSuppressed(throwable9);
                    }
                    continue;
                }
                writer.close();
            }
        }
        for (URI uri : outputSet.getResourceConfigPaths()) {
            JsonWriter writer = new JsonWriter(Paths.get(uri), new OpenOption[0]);
            throwable = null;
            try {
                p.getResourceConfiguration().printJson(writer);
            }
            catch (Throwable throwable10) {
                throwable = throwable10;
                throw throwable10;
            }
            finally {
                if (writer == null) continue;
                if (throwable != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable11) {
                        throwable.addSuppressed(throwable11);
                    }
                    continue;
                }
                writer.close();
            }
        }
        for (URI uri : outputSet.getSerializationConfigPaths()) {
            JsonWriter writer = new JsonWriter(Paths.get(uri), new OpenOption[0]);
            throwable = null;
            try {
                p.getSerializationConfiguration().printJson(writer);
            }
            catch (Throwable throwable12) {
                throwable = throwable12;
                throw throwable12;
            }
            finally {
                if (writer == null) continue;
                if (throwable != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable13) {
                        throwable.addSuppressed(throwable13);
                    }
                    continue;
                }
                writer.close();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void generateFilterRules(Iterator<String> argsIter) throws IOException {
        outputPath = null;
        reduce = false;
        args = new ArrayList<String>();
        while (argsIter.hasNext()) {
            arg = argsIter.next();
            if (arg.startsWith("--reduce")) {
                parts = arg.split("=", 2);
                reduce = parts.length < 2 || Boolean.parseBoolean(parts[1]) != false;
                continue;
            }
            args.add(arg);
        }
        rootNode = null;
        block34: for (String arg : args) {
            parts = arg.split("=", 2);
            current = parts[0];
            value = parts.length > 1 ? parts[1] : null;
            var10_12 = current;
            var11_13 = -1;
            switch (var10_12.hashCode()) {
                case 140633151: {
                    if (!var10_12.equals("--include-packages-from-modules")) break;
                    var11_13 = 0;
                    break;
                }
                case -884171791: {
                    if (!var10_12.equals("--exclude-packages-from-modules")) break;
                    var11_13 = 1;
                    break;
                }
                case 85853782: {
                    if (!var10_12.equals("--exclude-unexported-packages-from-modules")) break;
                    var11_13 = 2;
                    break;
                }
                case -699561153: {
                    if (!var10_12.equals("--input-file")) break;
                    var11_13 = 3;
                    break;
                }
                case 324513064: {
                    if (!var10_12.equals("--output-file")) break;
                    var11_13 = 4;
                    break;
                }
                case -1508618655: {
                    if (!var10_12.equals("--include-classes")) break;
                    var11_13 = 5;
                    break;
                }
                case 290489747: {
                    if (!var10_12.equals("--exclude-classes")) break;
                    var11_13 = 6;
                }
            }
            switch (var11_13) {
                case 0: 
                case 1: 
                case 2: {
                    if (SubstrateUtil.HOSTED) {
                        if (rootNode != null) {
                            throw new UsageException(current + " must be specified before other rule-creating arguments");
                        }
                        moduleNames = value != null ? value.split(",") : new String[]{};
                        unexportedInclusion = exportedInclusion = current.startsWith("--include") != false ? RuleNode.Inclusion.Include : RuleNode.Inclusion.Exclude;
                        rootInclusion = exportedInclusion.invert();
                        if (current.equals("--exclude-unexported-packages-from-modules")) {
                            rootInclusion = RuleNode.Inclusion.Include;
                            exportedInclusion = RuleNode.Inclusion.Include;
                            unexportedInclusion = RuleNode.Inclusion.Exclude;
                        }
                        rootNode = ModuleFilterTools.generateFromModules(moduleNames, rootInclusion, exportedInclusion, unexportedInclusion, reduce);
                        break;
                    }
                    throw new UsageException(current + " is currently not supported in the native-image build of this tool.");
                }
                case 3: {
                    rootNode = ConfigurationTool.maybeCreateRootNode(rootNode);
                    reader = new FileReader(ConfigurationTool.requirePath(current, value).toFile());
                    var13_15 = null;
                    parser = new FilterConfigurationParser(rootNode);
                    parser.parseAndRegister(reader);
                    if (reader == null) continue block34;
                    if (var13_15 == null) ** GOTO lbl78
                    try {
                        reader.close();
                    }
                    catch (Throwable var14_17) {
                        var13_15.addSuppressed(var14_17);
                    }
                    break;
lbl78:
                    // 1 sources

                    reader.close();
                    break;
                    catch (Throwable var14_18) {
                        try {
                            var13_15 = var14_18;
                            throw var14_18;
                        }
                        catch (Throwable var16_20) {
                            if (reader != null) {
                                if (var13_15 != null) {
                                    try {
                                        reader.close();
                                    }
                                    catch (Throwable var17_21) {
                                        var13_15.addSuppressed(var17_21);
                                    }
                                } else {
                                    reader.close();
                                }
                            }
                            throw var16_20;
                        }
                    }
                }
                case 4: {
                    outputPath = ConfigurationTool.requirePath(current, value);
                    break;
                }
                case 5: {
                    rootNode = ConfigurationTool.addSingleRule(rootNode, current, value, RuleNode.Inclusion.Include);
                    break;
                }
                case 6: {
                    rootNode = ConfigurationTool.addSingleRule(rootNode, current, value, RuleNode.Inclusion.Exclude);
                    break;
                }
                default: {
                    throw new UsageException("Unknown argument: " + current);
                }
            }
        }
        rootNode = ConfigurationTool.maybeCreateRootNode(rootNode);
        rootNode.removeRedundantNodes();
        if (outputPath != null) {
            os = new FileOutputStream(outputPath.toFile());
            var6_6 = null;
            try {
                rootNode.printJsonTree(os);
            }
            catch (Throwable var7_9) {
                var6_6 = var7_9;
                throw var7_9;
            }
            finally {
                if (os != null) {
                    if (var6_6 != null) {
                        try {
                            os.close();
                        }
                        catch (Throwable var7_8) {
                            var6_6.addSuppressed(var7_8);
                        }
                    } else {
                        os.close();
                    }
                }
            }
        } else {
            rootNode.printJsonTree(System.out);
        }
    }

    private static RuleNode maybeCreateRootNode(RuleNode rootNode) {
        return rootNode != null ? rootNode : RuleNode.createRoot();
    }

    private static RuleNode addSingleRule(RuleNode rootNode, String argName, String qualifiedPkg, RuleNode.Inclusion inclusion) {
        RuleNode root = ConfigurationTool.maybeCreateRootNode(rootNode);
        if (qualifiedPkg == null || qualifiedPkg.isEmpty()) {
            throw new UsageException("Argument must be provided for: " + argName);
        }
        if (qualifiedPkg.indexOf(42) != -1 && !qualifiedPkg.endsWith(".**") && !qualifiedPkg.endsWith(".*")) {
            throw new UsageException("Rule may only contain '*' at the end, either as .* to include all classes in the package, or as .** to include all classes in the package and all of its subpackages");
        }
        root.addOrGetChildren(qualifiedPkg, inclusion);
        return root;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getResource(String resourceName) {
        try (InputStream input = ConfigurationTool.class.getResourceAsStream(resourceName);){
            BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
            String string = reader.lines().collect(Collectors.joining("\n"));
            return string;
        }
        catch (IOException e) {
            VMError.shouldNotReachHere((Throwable)e);
            return null;
        }
    }

    private static class UsageException
    extends RuntimeException {
        static final long serialVersionUID = 1L;

        UsageException(String message) {
            super(message);
        }
    }
}

