/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.agent;

import com.oracle.svm.jni.JNIObjectHandles;
import com.oracle.svm.jni.nativeapi.JNIEnvironment;
import com.oracle.svm.jni.nativeapi.JNIFieldId;
import com.oracle.svm.jni.nativeapi.JNIMethodId;
import com.oracle.svm.jni.nativeapi.JNIObjectHandle;
import com.oracle.svm.jvmtiagentbase.JNIHandleSet;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.WordFactory;

public class NativeImageAgentJNIHandleSet
extends JNIHandleSet {
    final JNIObjectHandle javaLangClass;
    final JNIMethodId javaLangClassForName3;
    final JNIMethodId javaUtilEnumerationNextElement;
    final JNIMethodId javaLangClassGetDeclaredMethod;
    final JNIMethodId javaLangClassGetDeclaredConstructor;
    final JNIMethodId javaLangClassGetDeclaredField;
    final JNIMethodId javaLangClassGetName;
    final JNIMethodId javaLangReflectMemberGetName;
    final JNIMethodId javaLangReflectMemberGetDeclaringClass;
    final JNIMethodId javaUtilEnumerationHasMoreElements;
    final JNIObjectHandle javaLangClassLoader;
    final JNIMethodId javaLangObjectGetClass;
    private JNIMethodId javaLangInvokeMethodTypeParameterArray = (JNIMethodId)WordFactory.nullPointer();
    private JNIMethodId javaLangInvokeMethodTypeReturnType = (JNIMethodId)WordFactory.nullPointer();
    final JNIObjectHandle javaLangIllegalAccessException;
    final JNIObjectHandle javaLangInvokeWrongMethodTypeException;
    final JNIObjectHandle javaLangIllegalArgumentException;
    private JNIMethodId javaUtilResourceBundleGetBundleImplSLCC;
    private JNIMethodId javaIoObjectStreamClassComputeDefaultSUID;
    private JNIMethodId javaIoObjectStreamClassForClass;
    private JNIMethodId javaIoObjectStreamClassGetClassDataLayout0;
    private JNIObjectHandle javaIOObjectStreamClassClassDataSlot;
    private JNIFieldId javaIOObjectStreamClassClassDataSlotDesc;
    private JNIFieldId javaIOObjectStreamClassClassDataSlotHasData;
    private boolean queriedJavaUtilResourceBundleGetBundleImplSLCC;

    NativeImageAgentJNIHandleSet(JNIEnvironment env) {
        super(env);
        this.javaLangClass = this.newClassGlobalRef(env, "java/lang/Class");
        this.javaLangClassForName3 = this.getMethodId(env, this.javaLangClass, "forName", "(Ljava/lang/String;ZLjava/lang/ClassLoader;)Ljava/lang/Class;", true);
        this.javaLangClassGetDeclaredMethod = this.getMethodId(env, this.javaLangClass, "getDeclaredMethod", "(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;", false);
        this.javaLangClassGetDeclaredConstructor = this.getMethodId(env, this.javaLangClass, "getDeclaredConstructor", "([Ljava/lang/Class;)Ljava/lang/reflect/Constructor;", false);
        this.javaLangClassGetDeclaredField = this.getMethodId(env, this.javaLangClass, "getDeclaredField", "(Ljava/lang/String;)Ljava/lang/reflect/Field;", false);
        this.javaLangClassGetName = this.getMethodId(env, this.javaLangClass, "getName", "()Ljava/lang/String;", false);
        JNIObjectHandle javaLangReflectMember = this.findClass(env, "java/lang/reflect/Member");
        this.javaLangReflectMemberGetName = this.getMethodId(env, javaLangReflectMember, "getName", "()Ljava/lang/String;", false);
        this.javaLangReflectMemberGetDeclaringClass = this.getMethodId(env, javaLangReflectMember, "getDeclaringClass", "()Ljava/lang/Class;", false);
        JNIObjectHandle javaUtilEnumeration = this.findClass(env, "java/util/Enumeration");
        this.javaUtilEnumerationHasMoreElements = this.getMethodId(env, javaUtilEnumeration, "hasMoreElements", "()Z", false);
        this.javaUtilEnumerationNextElement = this.getMethodId(env, javaUtilEnumeration, "nextElement", "()Ljava/lang/Object;", false);
        this.javaLangClassLoader = this.newClassGlobalRef(env, "java/lang/ClassLoader");
        JNIObjectHandle javaLangObject = this.findClass(env, "java/lang/Object");
        this.javaLangObjectGetClass = this.getMethodId(env, javaLangObject, "getClass", "()Ljava/lang/Class;", false);
        this.javaLangIllegalAccessException = this.newClassGlobalRef(env, "java/lang/IllegalAccessException");
        this.javaLangInvokeWrongMethodTypeException = this.newClassGlobalRef(env, "java/lang/invoke/WrongMethodTypeException");
        this.javaLangIllegalArgumentException = this.newClassGlobalRef(env, "java/lang/IllegalArgumentException");
    }

    JNIMethodId getJavaLangInvokeMethodTypeReturnType(JNIEnvironment env) {
        if (this.javaLangInvokeMethodTypeReturnType.isNull()) {
            JNIObjectHandle javaLangInvokeMethodType = this.newClassGlobalRef(env, "java/lang/invoke/MethodType");
            this.javaLangInvokeMethodTypeReturnType = this.getMethodId(env, javaLangInvokeMethodType, "returnType", "()Ljava/lang/Class;", false);
        }
        return this.javaLangInvokeMethodTypeReturnType;
    }

    JNIMethodId getJavaLangInvokeMethodTypeParameterArray(JNIEnvironment env) {
        if (this.javaLangInvokeMethodTypeParameterArray.isNull()) {
            JNIObjectHandle javaLangInvokeMethodType = this.newClassGlobalRef(env, "java/lang/invoke/MethodType");
            this.javaLangInvokeMethodTypeParameterArray = this.getMethodId(env, javaLangInvokeMethodType, "parameterArray", "()[Ljava/lang/Class;", false);
        }
        return this.javaLangInvokeMethodTypeParameterArray;
    }

    JNIMethodId tryGetJavaUtilResourceBundleGetBundleImplSLCC(JNIEnvironment env) {
        if (!this.queriedJavaUtilResourceBundleGetBundleImplSLCC) {
            JNIObjectHandle javaUtilResourceBundle = this.findClass(env, "java/util/ResourceBundle");
            this.javaUtilResourceBundleGetBundleImplSLCC = this.getMethodIdOptional(env, javaUtilResourceBundle, "getBundleImpl", "(Ljava/lang/String;Ljava/util/Locale;Ljava/lang/Class;Ljava/util/ResourceBundle$Control;)Ljava/util/ResourceBundle;", true);
            this.queriedJavaUtilResourceBundleGetBundleImplSLCC = true;
        }
        return this.javaUtilResourceBundleGetBundleImplSLCC;
    }

    JNIMethodId getJavaIoObjectStreamClassComputeDefaultSUID(JNIEnvironment env, JNIObjectHandle javaIoObjectStreamClass) {
        if (this.javaIoObjectStreamClassComputeDefaultSUID.equal((ComparableWord)JNIObjectHandles.nullHandle())) {
            this.javaIoObjectStreamClassComputeDefaultSUID = this.getMethodId(env, javaIoObjectStreamClass, "computeDefaultSUID", "(Ljava/lang/Class;)J", true);
        }
        return this.javaIoObjectStreamClassComputeDefaultSUID;
    }

    JNIMethodId getJavaIoObjectStreamClassForClass(JNIEnvironment env, JNIObjectHandle javaIoObjectStreamClass) {
        if (this.javaIoObjectStreamClassForClass.equal((ComparableWord)JNIObjectHandles.nullHandle())) {
            this.javaIoObjectStreamClassForClass = this.getMethodId(env, javaIoObjectStreamClass, "forClass", "()Ljava/lang/Class;", false);
        }
        return this.javaIoObjectStreamClassForClass;
    }

    JNIMethodId getJavaIoObjectStreamClassGetClassDataLayout0(JNIEnvironment env, JNIObjectHandle javaIoObjectStreamClass) {
        if (this.javaIoObjectStreamClassGetClassDataLayout0.equal((ComparableWord)JNIObjectHandles.nullHandle())) {
            this.javaIoObjectStreamClassGetClassDataLayout0 = this.getMethodId(env, javaIoObjectStreamClass, "getClassDataLayout0", "()[Ljava/io/ObjectStreamClass$ClassDataSlot;", false);
        }
        return this.javaIoObjectStreamClassGetClassDataLayout0;
    }

    JNIObjectHandle getJavaIOObjectStreamClassClassDataSlot(JNIEnvironment env) {
        if (this.javaIOObjectStreamClassClassDataSlot.equal((ComparableWord)JNIObjectHandles.nullHandle())) {
            this.javaIOObjectStreamClassClassDataSlot = this.newClassGlobalRef(env, "java/io/ObjectStreamClass$ClassDataSlot");
        }
        return this.javaIOObjectStreamClassClassDataSlot;
    }

    JNIFieldId getJavaIOObjectStreamClassClassDataSlotDesc(JNIEnvironment env) {
        if (this.javaIOObjectStreamClassClassDataSlotDesc.equal((ComparableWord)JNIObjectHandles.nullHandle())) {
            this.javaIOObjectStreamClassClassDataSlotDesc = this.getFieldId(env, this.getJavaIOObjectStreamClassClassDataSlot(env), "desc", "Ljava/io/ObjectStreamClass;", false);
        }
        return this.javaIOObjectStreamClassClassDataSlotDesc;
    }

    JNIFieldId getJavaIOObjectStreamClassClassDataSlotHasData(JNIEnvironment env) {
        if (this.javaIOObjectStreamClassClassDataSlotHasData.equal((ComparableWord)JNIObjectHandles.nullHandle())) {
            this.javaIOObjectStreamClassClassDataSlotHasData = this.getFieldId(env, this.getJavaIOObjectStreamClassClassDataSlot(env), "hasData", "Z", false);
        }
        return this.javaIOObjectStreamClassClassDataSlotHasData;
    }
}

