/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.config;

import com.oracle.svm.configure.config.ParserConfigurationAdapter;
import com.oracle.svm.configure.config.ProxyConfiguration;
import com.oracle.svm.configure.config.ResourceConfiguration;
import com.oracle.svm.configure.config.TypeConfiguration;
import com.oracle.svm.core.configure.ConfigurationParser;
import com.oracle.svm.core.configure.ProxyConfigurationParser;
import com.oracle.svm.core.configure.ReflectionConfigurationParser;
import com.oracle.svm.core.configure.ReflectionConfigurationParserDelegate;
import com.oracle.svm.core.configure.ResourceConfigurationParser;
import com.oracle.svm.core.configure.ResourcesRegistry;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Function;

public class ConfigurationSet {
    public static final Function<IOException, Exception> FAIL_ON_EXCEPTION = e -> e;
    private final Set<URI> jniConfigPaths = new LinkedHashSet<URI>();
    private final Set<URI> reflectConfigPaths = new LinkedHashSet<URI>();
    private final Set<URI> proxyConfigPaths = new LinkedHashSet<URI>();
    private final Set<URI> resourceConfigPaths = new LinkedHashSet<URI>();

    public void addDirectory(Path path) {
        this.jniConfigPaths.add(path.resolve("jni-config.json").toUri());
        this.reflectConfigPaths.add(path.resolve("reflect-config.json").toUri());
        this.proxyConfigPaths.add(path.resolve("proxy-config.json").toUri());
        this.resourceConfigPaths.add(path.resolve("resource-config.json").toUri());
    }

    public boolean isEmpty() {
        return this.jniConfigPaths.isEmpty() && this.reflectConfigPaths.isEmpty() && this.proxyConfigPaths.isEmpty() && this.resourceConfigPaths.isEmpty();
    }

    public Set<URI> getJniConfigPaths() {
        return this.jniConfigPaths;
    }

    public Set<URI> getReflectConfigPaths() {
        return this.reflectConfigPaths;
    }

    public Set<URI> getProxyConfigPaths() {
        return this.proxyConfigPaths;
    }

    public Set<URI> getResourceConfigPaths() {
        return this.resourceConfigPaths;
    }

    public TypeConfiguration loadJniConfig(Function<IOException, Exception> exceptionHandler) throws Exception {
        return ConfigurationSet.loadTypeConfig(this.jniConfigPaths, exceptionHandler);
    }

    public TypeConfiguration loadReflectConfig(Function<IOException, Exception> exceptionHandler) throws Exception {
        return ConfigurationSet.loadTypeConfig(this.reflectConfigPaths, exceptionHandler);
    }

    public ProxyConfiguration loadProxyConfig(Function<IOException, Exception> exceptionHandler) throws Exception {
        ProxyConfiguration proxyConfiguration = new ProxyConfiguration();
        ConfigurationSet.loadConfig(this.proxyConfigPaths, (ConfigurationParser)new ProxyConfigurationParser(types -> proxyConfiguration.add(Arrays.asList(types))), exceptionHandler);
        return proxyConfiguration;
    }

    public ResourceConfiguration loadResourceConfig(Function<IOException, Exception> exceptionHandler) throws Exception {
        ResourceConfiguration resourceConfiguration = new ResourceConfiguration();
        ConfigurationSet.loadConfig(this.resourceConfigPaths, (ConfigurationParser)new ResourceConfigurationParser((ResourcesRegistry)new ResourceConfiguration.ParserAdapter(resourceConfiguration)), exceptionHandler);
        return resourceConfiguration;
    }

    private static TypeConfiguration loadTypeConfig(Collection<URI> uris, Function<IOException, Exception> exceptionHandler) throws Exception {
        TypeConfiguration configuration = new TypeConfiguration();
        ConfigurationSet.loadConfig(uris, (ConfigurationParser)new ReflectionConfigurationParser((ReflectionConfigurationParserDelegate)new ParserConfigurationAdapter(configuration)), exceptionHandler);
        return configuration;
    }

    private static void loadConfig(Collection<URI> configPaths, ConfigurationParser reflectParser, Function<IOException, Exception> exceptionHandler) throws Exception {
        for (URI path : configPaths) {
            try {
                BufferedReader reader = Files.newBufferedReader(Paths.get(path));
                Throwable throwable = null;
                try {
                    reflectParser.parseAndRegister((Reader)reader);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((Reader)reader).close();
                }
            }
            catch (IOException ioe) {
                Exception e = ioe;
                if (exceptionHandler != null) {
                    e = exceptionHandler.apply(ioe);
                }
                if (e == null) continue;
                throw e;
            }
        }
    }
}

