/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.agent.restrict;

import com.oracle.svm.configure.trace.AccessAdvisor;
import com.oracle.svm.configure.trace.LazyValueUtils;
import com.oracle.svm.jni.nativeapi.JNIEnvironment;
import com.oracle.svm.jni.nativeapi.JNIObjectHandle;
import com.oracle.svm.jvmtiagentbase.Support;
import org.graalvm.compiler.phases.common.LazyValue;

class AbstractAccessVerifier {
    protected final AccessAdvisor accessAdvisor;

    AbstractAccessVerifier(AccessAdvisor advisor) {
        this.accessAdvisor = advisor;
    }

    protected boolean shouldApproveWithoutChecks(JNIEnvironment env, JNIObjectHandle queriedClass, JNIObjectHandle callerClass) {
        return this.shouldApproveWithoutChecks(AbstractAccessVerifier.lazyClassNameOrNull(env, queriedClass), AbstractAccessVerifier.lazyClassNameOrNull(env, callerClass));
    }

    protected boolean shouldApproveWithoutChecks(LazyValue<String> queriedClassName, LazyValue<String> callerClassName) {
        return this.accessAdvisor.shouldIgnore(queriedClassName, callerClassName);
    }

    protected static LazyValue<String> lazyClassNameOrNull(JNIEnvironment env, JNIObjectHandle clazz) {
        return LazyValueUtils.lazyGet(() -> Support.getClassNameOrNull((JNIEnvironment)env, (JNIObjectHandle)clazz));
    }
}

