/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.agent;

import com.oracle.svm.agent.NativeImageAgent;
import com.oracle.svm.agent.NativeImageAgentJNIHandleSet;
import com.oracle.svm.agent.TraceWriter;
import com.oracle.svm.agent.restrict.ProxyAccessVerifier;
import com.oracle.svm.agent.restrict.ReflectAccessVerifier;
import com.oracle.svm.agent.restrict.ResourceAccessVerifier;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.jni.JNIObjectHandles;
import com.oracle.svm.jni.nativeapi.JNIEnvironment;
import com.oracle.svm.jni.nativeapi.JNIMethodId;
import com.oracle.svm.jni.nativeapi.JNINativeMethod;
import com.oracle.svm.jni.nativeapi.JNIObjectHandle;
import com.oracle.svm.jni.nativeapi.JNIValue;
import com.oracle.svm.jvmtiagentbase.AgentIsolate;
import com.oracle.svm.jvmtiagentbase.ConstantPoolTool;
import com.oracle.svm.jvmtiagentbase.Support;
import com.oracle.svm.jvmtiagentbase.jvmti.JvmtiCapabilities;
import com.oracle.svm.jvmtiagentbase.jvmti.JvmtiEnv;
import com.oracle.svm.jvmtiagentbase.jvmti.JvmtiError;
import com.oracle.svm.jvmtiagentbase.jvmti.JvmtiEvent;
import com.oracle.svm.jvmtiagentbase.jvmti.JvmtiEventCallbacks;
import com.oracle.svm.jvmtiagentbase.jvmti.JvmtiEventMode;
import com.oracle.svm.jvmtiagentbase.jvmti.JvmtiFrameInfo;
import com.oracle.svm.jvmtiagentbase.jvmti.JvmtiLocationFormat;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import jdk.vm.ci.meta.MetaUtil;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.UnmanagedMemory;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CEntryPointLiteral;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.nativeimage.c.function.InvokeCFunctionPointer;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CCharPointerPointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

final class BreakpointInterceptor {
    private static TraceWriter traceWriter;
    private static ReflectAccessVerifier accessVerifier;
    private static ProxyAccessVerifier proxyVerifier;
    private static ResourceAccessVerifier resourceVerifier;
    private static NativeImageAgent agent;
    private static Map<Long, Breakpoint> installedBreakpoints;
    private static Map<Long, Long> boundNativeMethods;
    private static Map<Long, NativeBreakpoint> nativeBreakpoints;
    private static boolean experimentalClassLoaderSupport;
    private static boolean methodHandleSupport;
    private static ConcurrentMap<MethodLocation, Boolean> observedExplicitLoadClassCallSites;
    private static final ReentrantLock nativeBreakpointsInitLock;
    private static final ThreadLocal<Boolean> recursive;
    private static final CEntryPointLiteral<ObjectFieldOffsetFunctionPointer> nativeObjectFieldOffsetLiteral;
    private static final NativeBreakpointSpecification NATIVE_OBJECTFIELDOFFSET_BREAKPOINT_SPEC;
    private static final CEntryPointLiteral<CFunctionPointer> onBreakpointLiteral;
    private static final CEntryPointLiteral<CFunctionPointer> onNativeMethodBindLiteral;
    private static final CEntryPointLiteral<CFunctionPointer> onClassPrepareLiteral;
    private static final BreakpointSpecification[] BREAKPOINT_SPECIFICATIONS;
    private static final BreakpointSpecification CLASSLOADER_LOAD_CLASS_BREAKPOINT_SPECIFICATION;
    private static final NativeBreakpointSpecification[] NATIVE_BREAKPOINT_SPECIFICATIONS;

    private static void traceBreakpoint(JNIEnvironment env, JNIObjectHandle clazz, JNIObjectHandle declaringClass, JNIObjectHandle callerClass, String function, Object result, Object ... args) {
        if (traceWriter != null) {
            traceWriter.traceCall("reflect", function, Support.getClassNameOr((JNIEnvironment)env, (JNIObjectHandle)clazz, null, (String)TraceWriter.UNKNOWN_VALUE), Support.getClassNameOr((JNIEnvironment)env, (JNIObjectHandle)declaringClass, null, (String)TraceWriter.UNKNOWN_VALUE), Support.getClassNameOr((JNIEnvironment)env, (JNIObjectHandle)callerClass, null, (String)TraceWriter.UNKNOWN_VALUE), result, args);
            VMError.guarantee((!Support.testException((JNIEnvironment)env) ? 1 : 0) != 0);
        }
    }

    private static boolean forName(JNIEnvironment jni, Breakpoint bp) {
        JNIObjectHandle callerClass = Support.getDirectCallerClass();
        JNIObjectHandle name = Support.getObjectArgument((int)0);
        String className = Support.fromJniString((JNIEnvironment)jni, (JNIObjectHandle)name);
        boolean allowed = accessVerifier == null || accessVerifier.verifyForName(jni, callerClass, className);
        Object result = false;
        if (allowed) {
            boolean classLoaderValid = true;
            WordPointer classLoaderPtr = (WordPointer)StackValue.get(WordPointer.class);
            if (bp.method == ((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangClassForName3) {
                classLoaderValid = Support.jvmtiFunctions().GetLocalObject().invoke(Support.jvmtiEnv(), (JNIObjectHandle)JNIObjectHandles.nullHandle(), 0, 2, (PointerBase)classLoaderPtr) == JvmtiError.JVMTI_ERROR_NONE;
            } else {
                classLoaderPtr.write((WordBase)JNIObjectHandles.nullHandle());
                if (callerClass.notEqual((ComparableWord)JNIObjectHandles.nullHandle())) {
                    classLoaderValid = Support.jvmtiFunctions().GetClassLoader().invoke(Support.jvmtiEnv(), callerClass, (PointerBase)classLoaderPtr) == JvmtiError.JVMTI_ERROR_NONE;
                }
            }
            result = TraceWriter.UNKNOWN_VALUE;
            if (classLoaderValid) {
                int initialize = 0;
                result = JNIObjectHandles.nullHandle().notEqual((ComparableWord)Support.callStaticObjectMethodLIL((JNIEnvironment)jni, (JNIObjectHandle)bp.clazz, (JNIMethodId)((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangClassForName3, (JNIObjectHandle)name, (int)initialize, (JNIObjectHandle)((JNIObjectHandle)classLoaderPtr.read())));
                if (Support.clearException((JNIEnvironment)jni)) {
                    result = false;
                }
            }
        }
        BreakpointInterceptor.traceBreakpoint(jni, bp.clazz, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, ((BreakpointSpecification)bp.specification).methodName, result, className);
        if (!allowed) {
            try (CTypeConversion.CCharPointerHolder message = Support.toCString((String)("native-image-agent: configuration does not permit access to class: " + className));){
                Support.jniFunctions().getThrowNew().invoke(jni, ((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangClassNotFoundException, message.get());
            }
        }
        return allowed;
    }

    private static boolean getFields(JNIEnvironment jni, Breakpoint bp) {
        return BreakpointInterceptor.handleGetFields(jni, bp, false);
    }

    private static boolean getDeclaredFields(JNIEnvironment jni, Breakpoint bp) {
        return BreakpointInterceptor.handleGetFields(jni, bp, true);
    }

    private static boolean handleGetFields(JNIEnvironment jni, Breakpoint bp, boolean declaredOnly) {
        JNIObjectHandle callerClass = Support.getDirectCallerClass();
        JNIObjectHandle self = Support.getObjectArgument((int)0);
        JNIObjectHandle returnResult = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        if (accessVerifier != null) {
            returnResult = Support.callObjectMethod((JNIEnvironment)jni, (JNIObjectHandle)self, (JNIMethodId)bp.method);
            if (Support.clearException((JNIEnvironment)jni)) {
                returnResult = (JNIObjectHandle)JNIObjectHandles.nullHandle();
            }
            if (returnResult.notEqual((ComparableWord)JNIObjectHandles.nullHandle())) {
                returnResult = accessVerifier.filterGetFields(jni, self, returnResult, declaredOnly, callerClass);
            }
        }
        BreakpointInterceptor.traceBreakpoint(jni, self, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, ((BreakpointSpecification)bp.specification).methodName, null, new Object[0]);
        if (accessVerifier != null && returnResult.notEqual((ComparableWord)JNIObjectHandles.nullHandle())) {
            Support.jvmtiFunctions().ForceEarlyReturnObject().invoke(Support.jvmtiEnv(), (JNIObjectHandle)JNIObjectHandles.nullHandle(), returnResult);
        }
        return true;
    }

    private static boolean getMethods(JNIEnvironment jni, Breakpoint bp) {
        return BreakpointInterceptor.handleGetMethods(jni, bp, false, (Support.WordSupplier<JNIObjectHandle>)((Support.WordSupplier)() -> ((NativeImageAgentJNIHandleSet)agent.handles()).getJavaLangReflectMethod(jni)));
    }

    private static boolean getDeclaredMethods(JNIEnvironment jni, Breakpoint bp) {
        return BreakpointInterceptor.handleGetMethods(jni, bp, true, (Support.WordSupplier<JNIObjectHandle>)((Support.WordSupplier)() -> ((NativeImageAgentJNIHandleSet)agent.handles()).getJavaLangReflectMethod(jni)));
    }

    private static boolean getConstructors(JNIEnvironment jni, Breakpoint bp) {
        return BreakpointInterceptor.handleGetMethods(jni, bp, true, (Support.WordSupplier<JNIObjectHandle>)((Support.WordSupplier)() -> ((NativeImageAgentJNIHandleSet)agent.handles()).getJavaLangReflectConstructor(jni)));
    }

    private static boolean getDeclaredConstructors(JNIEnvironment jni, Breakpoint bp) {
        return BreakpointInterceptor.handleGetMethods(jni, bp, true, (Support.WordSupplier<JNIObjectHandle>)((Support.WordSupplier)() -> ((NativeImageAgentJNIHandleSet)agent.handles()).getJavaLangReflectConstructor(jni)));
    }

    private static boolean handleGetMethods(JNIEnvironment jni, Breakpoint bp, boolean declaredOnly, Support.WordSupplier<JNIObjectHandle> elementClass) {
        JNIObjectHandle callerClass = Support.getDirectCallerClass();
        JNIObjectHandle self = Support.getObjectArgument((int)0);
        JNIObjectHandle returnResult = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        if (accessVerifier != null) {
            returnResult = Support.callObjectMethod((JNIEnvironment)jni, (JNIObjectHandle)self, (JNIMethodId)bp.method);
            if (Support.clearException((JNIEnvironment)jni)) {
                returnResult = (JNIObjectHandle)JNIObjectHandles.nullHandle();
            }
            if (returnResult.notEqual((ComparableWord)JNIObjectHandles.nullHandle())) {
                returnResult = accessVerifier.filterGetMethods(jni, self, returnResult, elementClass, declaredOnly, callerClass);
            }
        }
        BreakpointInterceptor.traceBreakpoint(jni, self, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, ((BreakpointSpecification)bp.specification).methodName, null, new Object[0]);
        if (accessVerifier != null && returnResult.notEqual((ComparableWord)JNIObjectHandles.nullHandle())) {
            Support.jvmtiFunctions().ForceEarlyReturnObject().invoke(Support.jvmtiEnv(), (JNIObjectHandle)JNIObjectHandles.nullHandle(), returnResult);
        }
        return true;
    }

    private static boolean getField(JNIEnvironment jni, Breakpoint bp) {
        return BreakpointInterceptor.handleGetField(jni, bp, false);
    }

    private static boolean getDeclaredField(JNIEnvironment jni, Breakpoint bp) {
        return BreakpointInterceptor.handleGetField(jni, bp, true);
    }

    private static boolean handleGetField(JNIEnvironment jni, Breakpoint bp, boolean declaredOnly) {
        JNIObjectHandle callerClass = Support.getDirectCallerClass();
        JNIObjectHandle self = Support.getObjectArgument((int)0);
        JNIObjectHandle name = Support.getObjectArgument((int)1);
        JNIObjectHandle result = Support.callObjectMethodL((JNIEnvironment)jni, (JNIObjectHandle)self, (JNIMethodId)bp.method, (JNIObjectHandle)name);
        if (Support.clearException((JNIEnvironment)jni)) {
            result = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        }
        JNIObjectHandle declaring = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        if (!declaredOnly && result.notEqual((ComparableWord)JNIObjectHandles.nullHandle())) {
            declaring = Support.callObjectMethod((JNIEnvironment)jni, (JNIObjectHandle)result, (JNIMethodId)((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangReflectMemberGetDeclaringClass);
            if (Support.clearException((JNIEnvironment)jni)) {
                declaring = (JNIObjectHandle)JNIObjectHandles.nullHandle();
            }
        }
        boolean allowed = result.equal((ComparableWord)JNIObjectHandles.nullHandle()) || accessVerifier == null || accessVerifier.verifyGetField(jni, self, name, result, declaredOnly ? self : declaring, callerClass);
        BreakpointInterceptor.traceBreakpoint(jni, self, declaring, callerClass, ((BreakpointSpecification)bp.specification).methodName, allowed && result.notEqual((ComparableWord)JNIObjectHandles.nullHandle()), Support.fromJniString((JNIEnvironment)jni, (JNIObjectHandle)name));
        if (!allowed) {
            try (CTypeConversion.CCharPointerHolder message = Support.toCString((String)("native-image-agent: configuration does not permit access to field: " + Support.getClassNameOr((JNIEnvironment)jni, (JNIObjectHandle)self, (String)"(null)", (String)"(?)") + "." + Support.fromJniString((JNIEnvironment)jni, (JNIObjectHandle)name)));){
                Support.jniFunctions().getThrowNew().invoke(jni, ((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangNoSuchFieldException, message.get());
            }
        }
        return allowed;
    }

    @CEntryPoint
    @CEntryPointOptions(prologue=AgentIsolate.Prologue.class)
    static long nativeObjectFieldOffset(JNIEnvironment jni, JNIObjectHandle self, JNIObjectHandle field) {
        VMError.guarantee((BreakpointInterceptor.NATIVE_OBJECTFIELDOFFSET_BREAKPOINT_SPEC.installed != null && BreakpointInterceptor.NATIVE_OBJECTFIELDOFFSET_BREAKPOINT_SPEC.installed.replacedFunction.isNonNull() ? 1 : 0) != 0, (String)"incompletely installed");
        ObjectFieldOffsetFunctionPointer original = (ObjectFieldOffsetFunctionPointer)BreakpointInterceptor.NATIVE_OBJECTFIELDOFFSET_BREAKPOINT_SPEC.installed.replacedFunction;
        long result = original.invoke(jni, self, field);
        if (!Support.isInitialized()) {
            return result;
        }
        boolean validResult = !Support.clearException((JNIEnvironment)jni);
        JNIMethodId currentMethod = Support.getCallerMethod((int)0);
        JNIObjectHandle callerClass = Support.getDirectCallerClass();
        JNIObjectHandle name = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        JNIObjectHandle declaring = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        if (field.notEqual((ComparableWord)JNIObjectHandles.nullHandle())) {
            name = Support.callObjectMethod((JNIEnvironment)jni, (JNIObjectHandle)field, (JNIMethodId)((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangReflectMemberGetName);
            if (Support.clearException((JNIEnvironment)jni)) {
                name = (JNIObjectHandle)JNIObjectHandles.nullHandle();
            }
            declaring = Support.callObjectMethod((JNIEnvironment)jni, (JNIObjectHandle)field, (JNIMethodId)((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangReflectMemberGetDeclaringClass);
            if (Support.clearException((JNIEnvironment)jni)) {
                declaring = (JNIObjectHandle)JNIObjectHandles.nullHandle();
            }
        }
        if (!BreakpointInterceptor.verifyAndTraceObjectFieldOffset(jni, validResult, name, declaring, currentMethod, callerClass)) {
            return Long.MIN_VALUE;
        }
        if (!validResult) {
            return original.invoke(jni, self, field);
        }
        return result;
    }

    private static boolean objectFieldOffset(JNIEnvironment jni, Breakpoint bp) {
        JNIObjectHandle callerClass = Support.getDirectCallerClass();
        JNIObjectHandle self = Support.getObjectArgument((int)0);
        JNIObjectHandle field = Support.getObjectArgument((int)1);
        Support.callLongMethodL((JNIEnvironment)jni, (JNIObjectHandle)self, (JNIMethodId)bp.method, (JNIObjectHandle)field);
        boolean validResult = !Support.clearException((JNIEnvironment)jni);
        JNIObjectHandle name = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        JNIObjectHandle declaring = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        if (field.notEqual((ComparableWord)JNIObjectHandles.nullHandle())) {
            name = Support.callObjectMethod((JNIEnvironment)jni, (JNIObjectHandle)field, (JNIMethodId)((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangReflectMemberGetName);
            if (Support.clearException((JNIEnvironment)jni)) {
                name = (JNIObjectHandle)JNIObjectHandles.nullHandle();
            }
            declaring = Support.callObjectMethod((JNIEnvironment)jni, (JNIObjectHandle)field, (JNIMethodId)((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangReflectMemberGetDeclaringClass);
            if (Support.clearException((JNIEnvironment)jni)) {
                declaring = (JNIObjectHandle)JNIObjectHandles.nullHandle();
            }
        }
        return BreakpointInterceptor.verifyAndTraceObjectFieldOffset(jni, validResult, name, declaring, bp.method, callerClass);
    }

    private static boolean verifyAndTraceObjectFieldOffset(JNIEnvironment jni, boolean validResult, JNIObjectHandle name, JNIObjectHandle declaring, JNIMethodId currentMethod, JNIObjectHandle callerClass) {
        JNIObjectHandle clazz = Support.getMethodDeclaringClass((JNIMethodId)currentMethod);
        boolean allowed = !validResult || accessVerifier == null || accessVerifier.verifyObjectFieldOffset(jni, name, declaring, callerClass);
        BreakpointInterceptor.traceBreakpoint(jni, clazz, declaring, callerClass, "objectFieldOffset", allowed && validResult, Support.fromJniString((JNIEnvironment)jni, (JNIObjectHandle)name));
        if (!allowed) {
            try (CTypeConversion.CCharPointerHolder message = Support.toCString((String)("native-image-agent: configuration does not permit unsafe access to field: " + Support.getClassNameOr((JNIEnvironment)jni, (JNIObjectHandle)declaring, (String)"(null)", (String)"(?)") + "." + Support.fromJniString((JNIEnvironment)jni, (JNIObjectHandle)name)));){
                Support.jniFunctions().getThrowNew().invoke(jni, ((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangRuntimeException, message.get());
            }
            return false;
        }
        return true;
    }

    private static boolean objectFieldOffsetByName(JNIEnvironment jni, Breakpoint bp) {
        JNIObjectHandle callerClass = Support.getDirectCallerClass();
        JNIObjectHandle self = Support.getObjectArgument((int)0);
        JNIObjectHandle declaring = Support.getObjectArgument((int)1);
        JNIObjectHandle name = Support.getObjectArgument((int)2);
        Support.callLongMethodLL((JNIEnvironment)jni, (JNIObjectHandle)self, (JNIMethodId)bp.method, (JNIObjectHandle)declaring, (JNIObjectHandle)name);
        boolean validResult = !Support.clearException((JNIEnvironment)jni);
        return BreakpointInterceptor.verifyAndTraceObjectFieldOffset(jni, validResult, name, declaring, bp.method, callerClass);
    }

    private static boolean getConstructor(JNIEnvironment jni, Breakpoint bp) {
        JNIObjectHandle callerClass = Support.getDirectCallerClass();
        JNIObjectHandle self = Support.getObjectArgument((int)0);
        JNIObjectHandle paramTypesHandle = Support.getObjectArgument((int)1);
        JNIObjectHandle result = Support.callObjectMethodL((JNIEnvironment)jni, (JNIObjectHandle)self, (JNIMethodId)bp.method, (JNIObjectHandle)paramTypesHandle);
        if (Support.clearException((JNIEnvironment)jni)) {
            result = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        }
        Object paramTypes = BreakpointInterceptor.getClassArrayNames(jni, paramTypesHandle);
        Supplier<String> signature = () -> BreakpointInterceptor.asInternalSignature(paramTypes);
        boolean allowed = result.equal((ComparableWord)JNIObjectHandles.nullHandle()) || accessVerifier == null || accessVerifier.verifyGetConstructor(jni, self, signature, result, callerClass);
        BreakpointInterceptor.traceBreakpoint(jni, self, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, ((BreakpointSpecification)bp.specification).methodName, allowed && JNIObjectHandles.nullHandle().notEqual((ComparableWord)result), paramTypes);
        if (!allowed) {
            BreakpointInterceptor.throwNoSuchMethodException(jni, self, "<init>", signature.get());
        }
        return allowed;
    }

    private static boolean getMethod(JNIEnvironment jni, Breakpoint bp) {
        return BreakpointInterceptor.handleGetMethod(jni, bp, false);
    }

    private static boolean getDeclaredMethod(JNIEnvironment jni, Breakpoint bp) {
        return BreakpointInterceptor.handleGetMethod(jni, bp, true);
    }

    private static boolean handleGetMethod(JNIEnvironment jni, Breakpoint bp, boolean declaredOnly) {
        JNIObjectHandle callerClass = Support.getDirectCallerClass();
        JNIObjectHandle self = Support.getObjectArgument((int)0);
        JNIObjectHandle nameHandle = Support.getObjectArgument((int)1);
        JNIObjectHandle paramTypesHandle = Support.getObjectArgument((int)2);
        JNIObjectHandle result = Support.callObjectMethodLL((JNIEnvironment)jni, (JNIObjectHandle)self, (JNIMethodId)bp.method, (JNIObjectHandle)nameHandle, (JNIObjectHandle)paramTypesHandle);
        if (Support.clearException((JNIEnvironment)jni)) {
            result = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        }
        JNIObjectHandle declaring = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        if (!declaredOnly && result.notEqual((ComparableWord)JNIObjectHandles.nullHandle())) {
            declaring = Support.callObjectMethod((JNIEnvironment)jni, (JNIObjectHandle)result, (JNIMethodId)((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangReflectMemberGetDeclaringClass);
            if (Support.clearException((JNIEnvironment)jni)) {
                declaring = (JNIObjectHandle)JNIObjectHandles.nullHandle();
            }
        }
        String name = Support.fromJniString((JNIEnvironment)jni, (JNIObjectHandle)nameHandle);
        Object paramTypes = BreakpointInterceptor.getClassArrayNames(jni, paramTypesHandle);
        Supplier<String> signature = () -> BreakpointInterceptor.asInternalSignature(paramTypes);
        boolean allowed = result.equal((ComparableWord)JNIObjectHandles.nullHandle()) || accessVerifier == null || accessVerifier.verifyGetMethod(jni, self, name, signature, result, declaredOnly ? self : declaring, callerClass);
        BreakpointInterceptor.traceBreakpoint(jni, self, declaring, callerClass, ((BreakpointSpecification)bp.specification).methodName, allowed && result.notEqual((ComparableWord)JNIObjectHandles.nullHandle()), name, paramTypes);
        if (!allowed) {
            BreakpointInterceptor.throwNoSuchMethodException(jni, self, name, signature.get());
        }
        return allowed;
    }

    private static boolean getEnclosingMethod(JNIEnvironment jni, Breakpoint bp) {
        JNIObjectHandle callerClass = Support.getDirectCallerClass();
        JNIObjectHandle self = Support.getObjectArgument((int)0);
        String result = TraceWriter.EXPLICIT_NULL;
        JNIObjectHandle enclosing = Support.callObjectMethod((JNIEnvironment)jni, (JNIObjectHandle)self, (JNIMethodId)bp.method);
        JNIObjectHandle holder = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        String name = null;
        String signature = null;
        if (!Support.clearException((JNIEnvironment)jni) && enclosing.notEqual((ComparableWord)JNIObjectHandles.nullHandle())) {
            result = TraceWriter.UNKNOWN_VALUE;
            JNIMethodId enclosingID = Support.jniFunctions().getFromReflectedMethod().invoke(jni, enclosing);
            if (!Support.clearException((JNIEnvironment)jni) && enclosingID.isNonNull()) {
                WordPointer holderPtr = (WordPointer)StackValue.get(WordPointer.class);
                if (Support.jvmtiFunctions().GetMethodDeclaringClass().invoke(Support.jvmtiEnv(), enclosingID, holderPtr) == JvmtiError.JVMTI_ERROR_NONE) {
                    holder = (JNIObjectHandle)holderPtr.read();
                    String holderName = Support.getClassNameOrNull((JNIEnvironment)jni, (JNIObjectHandle)((JNIObjectHandle)holderPtr.read()));
                    if (holderName != null) {
                        CCharPointerPointer namePtr = (CCharPointerPointer)StackValue.get(CCharPointerPointer.class);
                        CCharPointerPointer signaturePtr = (CCharPointerPointer)StackValue.get(CCharPointerPointer.class);
                        if (Support.jvmtiFunctions().GetMethodName().invoke(Support.jvmtiEnv(), enclosingID, namePtr, signaturePtr, (CCharPointerPointer)WordFactory.nullPointer()) == JvmtiError.JVMTI_ERROR_NONE) {
                            name = Support.fromCString((CCharPointer)namePtr.read());
                            signature = Support.fromCString((CCharPointer)signaturePtr.read());
                            result = holderName + "." + name + signature;
                            Support.jvmtiFunctions().Deallocate().invoke(Support.jvmtiEnv(), (PointerBase)namePtr.read());
                            Support.jvmtiFunctions().Deallocate().invoke(Support.jvmtiEnv(), (PointerBase)signaturePtr.read());
                        }
                    }
                }
            }
        }
        boolean allowed = enclosing.equal((ComparableWord)JNIObjectHandles.nullHandle()) || accessVerifier == null || accessVerifier.verifyGetEnclosingMethod(jni, holder, name, signature, enclosing, callerClass);
        BreakpointInterceptor.traceBreakpoint(jni, (JNIObjectHandle)JNIObjectHandles.nullHandle(), (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, ((BreakpointSpecification)bp.specification).methodName, allowed && enclosing.notEqual((ComparableWord)JNIObjectHandles.nullHandle()) ? result : Boolean.valueOf(false), new Object[0]);
        if (!allowed) {
            Support.jvmtiFunctions().ForceEarlyReturnObject().invoke(Support.jvmtiEnv(), (JNIObjectHandle)JNIObjectHandles.nullHandle(), (JNIObjectHandle)JNIObjectHandles.nullHandle());
        }
        return allowed;
    }

    private static boolean newInstance(JNIEnvironment jni, Breakpoint bp) {
        JNIObjectHandle callerClass = Support.getDirectCallerClass();
        JNIMethodId result = (JNIMethodId)WordFactory.nullPointer();
        String name = "<init>";
        String signature = "()V";
        JNIObjectHandle self = Support.getObjectArgument((int)0);
        if (self.notEqual((ComparableWord)JNIObjectHandles.nullHandle())) {
            try (CTypeConversion.CCharPointerHolder ctorName = Support.toCString((String)name);
                 CTypeConversion.CCharPointerHolder ctorSignature = Support.toCString((String)signature);){
                result = Support.jniFunctions().getGetMethodID().invoke(jni, self, ctorName.get(), ctorSignature.get());
            }
            if (Support.clearException((JNIEnvironment)jni)) {
                result = (JNIMethodId)WordFactory.nullPointer();
            }
        }
        boolean allowed = result.equal((ComparableWord)JNIObjectHandles.nullHandle()) || accessVerifier == null || accessVerifier.verifyNewInstance(jni, self, name, signature, result, callerClass);
        BreakpointInterceptor.traceBreakpoint(jni, self, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, ((BreakpointSpecification)bp.specification).methodName, allowed && result.notEqual((ComparableWord)JNIObjectHandles.nullHandle()), new Object[0]);
        if (!allowed) {
            BreakpointInterceptor.throwNoSuchMethodException(jni, self, name, signature);
        }
        return allowed;
    }

    private static void throwNoSuchMethodException(JNIEnvironment jni, JNIObjectHandle clazz, String name, String signature) {
        try (CTypeConversion.CCharPointerHolder message = Support.toCString((String)("native-image-agent: configuration does not permit access to method: " + Support.getClassNameOr((JNIEnvironment)jni, (JNIObjectHandle)clazz, (String)"(null)", (String)"(?)") + "." + name + signature));){
            Support.jniFunctions().getThrowNew().invoke(jni, ((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangNoSuchMethodException, message.get());
        }
    }

    private static boolean newArrayInstance(JNIEnvironment jni, Breakpoint bp) {
        JNIObjectHandle componentClass = Support.getObjectArgument((int)0);
        CIntPointer lengthPtr = (CIntPointer)StackValue.get(CIntPointer.class);
        boolean lengthValid = Support.jvmtiFunctions().GetLocalInt().invoke(Support.jvmtiEnv(), (JNIObjectHandle)JNIObjectHandles.nullHandle(), 0, 1, (PointerBase)lengthPtr) == JvmtiError.JVMTI_ERROR_NONE;
        JNIValue args = (JNIValue)StackValue.get((int)2, JNIValue.class);
        args.addressOf(0).setObject(componentClass);
        args.addressOf(1).setInt(lengthPtr.read());
        return BreakpointInterceptor.newArrayInstance0(jni, bp, args, lengthValid);
    }

    private static boolean newArrayInstanceMulti(JNIEnvironment jni, Breakpoint bp) {
        JNIObjectHandle componentClass = Support.getObjectArgument((int)0);
        JNIObjectHandle dimensionsArray = Support.getObjectArgument((int)1);
        JNIValue args = (JNIValue)StackValue.get((int)2, JNIValue.class);
        args.addressOf(0).setObject(componentClass);
        args.addressOf(1).setObject(dimensionsArray);
        return BreakpointInterceptor.newArrayInstance0(jni, bp, args, dimensionsArray.notEqual((ComparableWord)JNIObjectHandles.nullHandle()));
    }

    private static boolean newArrayInstance0(JNIEnvironment jni, Breakpoint bp, JNIValue args, boolean argsValid) {
        JNIObjectHandle callerClass = Support.getDirectCallerClass();
        JNIObjectHandle result = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        JNIObjectHandle resultClass = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        JNIObjectHandle componentClass = args.addressOf(0).getObject();
        if (componentClass.notEqual((ComparableWord)JNIObjectHandles.nullHandle()) && argsValid) {
            result = Support.jniFunctions().getCallStaticObjectMethodA().invoke(jni, bp.clazz, bp.method, args);
            if (Support.clearException((JNIEnvironment)jni)) {
                result = (JNIObjectHandle)JNIObjectHandles.nullHandle();
            } else {
                resultClass = Support.jniFunctions().getGetObjectClass().invoke(jni, result);
                if (Support.clearException((JNIEnvironment)jni)) {
                    resultClass = (JNIObjectHandle)JNIObjectHandles.nullHandle();
                }
            }
        }
        boolean allowed = result.equal((ComparableWord)JNIObjectHandles.nullHandle()) || accessVerifier == null || accessVerifier.verifyNewArray(jni, resultClass, callerClass);
        String resultClassName = Support.getClassNameOr((JNIEnvironment)jni, (JNIObjectHandle)resultClass, null, (String)TraceWriter.UNKNOWN_VALUE);
        BreakpointInterceptor.traceBreakpoint(jni, bp.clazz, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, ((BreakpointSpecification)bp.specification).methodName, allowed && result.notEqual((ComparableWord)JNIObjectHandles.nullHandle()), resultClassName);
        if (allowed && result.notEqual((ComparableWord)JNIObjectHandles.nullHandle())) {
            Support.jvmtiFunctions().ForceEarlyReturnObject().invoke(Support.jvmtiEnv(), (JNIObjectHandle)JNIObjectHandles.nullHandle(), result);
        }
        if (!allowed) {
            try (CTypeConversion.CCharPointerHolder message = Support.toCString((String)("native-image-agent: configuration does not permit reflective array instantiation: " + Support.getClassNameOr((JNIEnvironment)jni, (JNIObjectHandle)resultClass, (String)"(?)", (String)"(?)")));){
                Support.jniFunctions().getThrowNew().invoke(jni, ((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangRuntimeException, message.get());
            }
        }
        return allowed;
    }

    private static boolean getResource(JNIEnvironment jni, Breakpoint bp) {
        return BreakpointInterceptor.handleGetResources(jni, bp, false);
    }

    private static boolean getResources(JNIEnvironment jni, Breakpoint bp) {
        return BreakpointInterceptor.handleGetResources(jni, bp, true);
    }

    private static boolean handleGetResources(JNIEnvironment jni, Breakpoint bp, boolean returnsEnumeration) {
        boolean allowed;
        JNIObjectHandle callerClass = Support.getDirectCallerClass();
        JNIObjectHandle self = Support.getObjectArgument((int)0);
        JNIObjectHandle name = Support.getObjectArgument((int)1);
        boolean result = false;
        boolean bl = allowed = resourceVerifier == null || resourceVerifier.verifyGetResources(jni, name, callerClass);
        if (allowed) {
            JNIObjectHandle returnValue = Support.callObjectMethodL((JNIEnvironment)jni, (JNIObjectHandle)self, (JNIMethodId)bp.method, (JNIObjectHandle)name);
            result = returnValue.notEqual((ComparableWord)JNIObjectHandles.nullHandle());
            if (Support.clearException((JNIEnvironment)jni)) {
                result = false;
            }
            if (result && returnsEnumeration) {
                result = BreakpointInterceptor.hasEnumerationElements(jni, returnValue);
            }
        }
        JNIObjectHandle selfClazz = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        if (self.notEqual((ComparableWord)JNIObjectHandles.nullHandle())) {
            selfClazz = Support.jniFunctions().getGetObjectClass().invoke(jni, self);
            if (Support.clearException((JNIEnvironment)jni)) {
                selfClazz = (JNIObjectHandle)JNIObjectHandles.nullHandle();
            }
        }
        BreakpointInterceptor.traceBreakpoint(jni, selfClazz, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, ((BreakpointSpecification)bp.specification).methodName, result, Support.fromJniString((JNIEnvironment)jni, (JNIObjectHandle)name));
        if (!allowed) {
            BreakpointInterceptor.forceGetResourceReturn(jni, returnsEnumeration);
        }
        return allowed;
    }

    private static boolean hasEnumerationElements(JNIEnvironment jni, JNIObjectHandle obj) {
        boolean hasElements = Support.callBooleanMethod((JNIEnvironment)jni, (JNIObjectHandle)obj, (JNIMethodId)((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaUtilEnumerationHasMoreElements);
        if (Support.clearException((JNIEnvironment)jni)) {
            hasElements = false;
        }
        return hasElements;
    }

    private static void forceGetResourceReturn(JNIEnvironment env, boolean returnsEnumeration) {
        JNIObjectHandle newResult = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        if (returnsEnumeration) {
            JNIObjectHandle javaUtilCollections = ((NativeImageAgentJNIHandleSet)agent.handles()).getJavaUtilCollections(env);
            JNIMethodId emptyEnumeration = ((NativeImageAgentJNIHandleSet)agent.handles()).getJavaUtilCollectionsEmptyEnumeration(env);
            if (javaUtilCollections.notEqual((ComparableWord)JNIObjectHandles.nullHandle()) && emptyEnumeration.isNonNull()) {
                newResult = Support.callObjectMethod((JNIEnvironment)env, (JNIObjectHandle)javaUtilCollections, (JNIMethodId)emptyEnumeration);
                if (Support.clearException((JNIEnvironment)env)) {
                    newResult = (JNIObjectHandle)JNIObjectHandles.nullHandle();
                }
            }
        }
        Support.jvmtiFunctions().ForceEarlyReturnObject().invoke(Support.jvmtiEnv(), (JNIObjectHandle)JNIObjectHandles.nullHandle(), newResult);
    }

    private static boolean getSystemResource(JNIEnvironment jni, Breakpoint bp) {
        return BreakpointInterceptor.handleGetSystemResources(jni, bp, false);
    }

    private static boolean getSystemResources(JNIEnvironment jni, Breakpoint bp) {
        return BreakpointInterceptor.handleGetSystemResources(jni, bp, true);
    }

    private static boolean handleGetSystemResources(JNIEnvironment jni, Breakpoint bp, boolean returnsEnumeration) {
        JNIObjectHandle callerClass = Support.getDirectCallerClass();
        JNIObjectHandle name = Support.getObjectArgument((int)0);
        boolean allowed = resourceVerifier == null || resourceVerifier.verifyGetSystemResources(jni, name, callerClass);
        boolean result = false;
        if (allowed) {
            JNIObjectHandle returnValue = Support.callStaticObjectMethodL((JNIEnvironment)jni, (JNIObjectHandle)bp.clazz, (JNIMethodId)bp.method, (JNIObjectHandle)name);
            result = returnValue.notEqual((ComparableWord)JNIObjectHandles.nullHandle());
            if (Support.clearException((JNIEnvironment)jni)) {
                result = false;
            }
            if (result && returnsEnumeration) {
                result = BreakpointInterceptor.hasEnumerationElements(jni, returnValue);
            }
        }
        BreakpointInterceptor.traceBreakpoint(jni, (JNIObjectHandle)JNIObjectHandles.nullHandle(), (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, ((BreakpointSpecification)bp.specification).methodName, result, Support.fromJniString((JNIEnvironment)jni, (JNIObjectHandle)name));
        if (!allowed) {
            BreakpointInterceptor.forceGetResourceReturn(jni, returnsEnumeration);
        }
        return allowed;
    }

    private static boolean newProxyInstance(JNIEnvironment jni, Breakpoint bp) {
        JNIObjectHandle callerClass = Support.getDirectCallerClass();
        JNIObjectHandle classLoader = Support.getObjectArgument((int)0);
        JNIObjectHandle ifaces = Support.getObjectArgument((int)1);
        Object ifaceNames = BreakpointInterceptor.getClassArrayNames(jni, ifaces);
        boolean allowed = proxyVerifier == null || proxyVerifier.verifyNewProxyInstance(jni, ifaceNames, callerClass);
        boolean result = false;
        if (allowed) {
            JNIObjectHandle invokeHandler = Support.getObjectArgument((int)2);
            result = JNIObjectHandles.nullHandle().notEqual((ComparableWord)Support.callStaticObjectMethodLLL((JNIEnvironment)jni, (JNIObjectHandle)bp.clazz, (JNIMethodId)bp.method, (JNIObjectHandle)classLoader, (JNIObjectHandle)ifaces, (JNIObjectHandle)invokeHandler));
            if (Support.clearException((JNIEnvironment)jni)) {
                result = false;
            }
        }
        BreakpointInterceptor.traceBreakpoint(jni, (JNIObjectHandle)JNIObjectHandles.nullHandle(), (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, ((BreakpointSpecification)bp.specification).methodName, result, TraceWriter.UNKNOWN_VALUE, ifaceNames, TraceWriter.UNKNOWN_VALUE);
        if (!allowed) {
            BreakpointInterceptor.throwDeniedProxyException(jni, ifaceNames);
        }
        return allowed;
    }

    private static boolean getProxyClass(JNIEnvironment jni, Breakpoint bp) {
        JNIObjectHandle callerClass = Support.getDirectCallerClass();
        JNIObjectHandle classLoader = Support.getObjectArgument((int)0);
        JNIObjectHandle ifaces = Support.getObjectArgument((int)1);
        Object ifaceNames = BreakpointInterceptor.getClassArrayNames(jni, ifaces);
        boolean allowed = proxyVerifier == null || proxyVerifier.verifyGetProxyClass(jni, ifaceNames, callerClass);
        boolean result = false;
        if (allowed) {
            result = JNIObjectHandles.nullHandle().notEqual((ComparableWord)Support.callStaticObjectMethodLL((JNIEnvironment)jni, (JNIObjectHandle)bp.clazz, (JNIMethodId)bp.method, (JNIObjectHandle)classLoader, (JNIObjectHandle)ifaces));
            if (Support.clearException((JNIEnvironment)jni)) {
                result = false;
            }
        }
        BreakpointInterceptor.traceBreakpoint(jni, (JNIObjectHandle)JNIObjectHandles.nullHandle(), (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, ((BreakpointSpecification)bp.specification).methodName, result, TraceWriter.UNKNOWN_VALUE, ifaceNames);
        if (!allowed) {
            BreakpointInterceptor.throwDeniedProxyException(jni, ifaceNames);
        }
        return allowed;
    }

    private static void throwDeniedProxyException(JNIEnvironment jni, Object ifaceNames) {
        String interfaceString = "(unknown)";
        if (ifaceNames instanceof Object[]) {
            interfaceString = Arrays.toString((Object[])ifaceNames);
        }
        try (CTypeConversion.CCharPointerHolder message = Support.toCString((String)("native-image-agent: configuration does not permit proxy class for interfaces: " + interfaceString));){
            Support.jniFunctions().getThrowNew().invoke(jni, ((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangSecurityException, message.get());
        }
    }

    private static Object getClassArrayNames(JNIEnvironment jni, JNIObjectHandle classArray) {
        String[] classNames = TraceWriter.EXPLICIT_NULL;
        if (classArray.notEqual((ComparableWord)JNIObjectHandles.nullHandle())) {
            classNames = TraceWriter.UNKNOWN_VALUE;
            int length = Support.jniFunctions().getGetArrayLength().invoke(jni, classArray);
            if (!Support.clearException((JNIEnvironment)jni) && length >= 0) {
                ArrayList<String> list = new ArrayList<String>();
                for (int i = 0; i < length; ++i) {
                    JNIObjectHandle clazz = Support.jniFunctions().getGetObjectArrayElement().invoke(jni, classArray, i);
                    if (!Support.clearException((JNIEnvironment)jni)) {
                        list.add(Support.getClassNameOr((JNIEnvironment)jni, (JNIObjectHandle)clazz, (String)TraceWriter.EXPLICIT_NULL, (String)TraceWriter.UNKNOWN_VALUE));
                        continue;
                    }
                    list.add(TraceWriter.UNKNOWN_VALUE);
                }
                classNames = list.toArray(new String[0]);
            }
        }
        return classNames;
    }

    private static boolean getBundleImplJDK8OrEarlier(JNIEnvironment jni, Breakpoint bp) {
        JNIObjectHandle callerClass = Support.getCallerClass((int)2);
        JNIObjectHandle baseName = Support.getObjectArgument((int)0);
        boolean allowed = resourceVerifier == null || resourceVerifier.verifyGetBundle(jni, baseName, callerClass);
        JNIObjectHandle result = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        if (allowed) {
            JNIObjectHandle locale = Support.getObjectArgument((int)1);
            JNIObjectHandle loader = Support.getObjectArgument((int)2);
            JNIObjectHandle control = Support.getObjectArgument((int)3);
            result = Support.callStaticObjectMethodLLLL((JNIEnvironment)jni, (JNIObjectHandle)bp.clazz, (JNIMethodId)bp.method, (JNIObjectHandle)baseName, (JNIObjectHandle)locale, (JNIObjectHandle)loader, (JNIObjectHandle)control);
            if (Support.clearException((JNIEnvironment)jni)) {
                result = (JNIObjectHandle)JNIObjectHandles.nullHandle();
            }
        }
        BreakpointInterceptor.traceBreakpoint(jni, (JNIObjectHandle)JNIObjectHandles.nullHandle(), (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, "getBundleImplJDK8OrEarlier", result.notEqual((ComparableWord)JNIObjectHandles.nullHandle()), Support.fromJniString((JNIEnvironment)jni, (JNIObjectHandle)baseName), TraceWriter.UNKNOWN_VALUE, TraceWriter.UNKNOWN_VALUE, TraceWriter.UNKNOWN_VALUE);
        return BreakpointInterceptor.endGetBundleImpl(jni, baseName, allowed);
    }

    private static boolean getBundleImplJDK11OrLater(JNIEnvironment jni, Breakpoint bp) {
        JNIMethodId intermediateMethod = Support.getCallerMethod((int)2);
        JNIMethodId callerMethod = intermediateMethod.equal((ComparableWord)((NativeImageAgentJNIHandleSet)agent.handles()).tryGetJavaUtilResourceBundleGetBundleImplSLCC(jni)) ? Support.getCallerMethod((int)4) : Support.getCallerMethod((int)3);
        JNIObjectHandle callerClass = Support.getMethodDeclaringClass((JNIMethodId)callerMethod);
        JNIObjectHandle baseName = Support.getObjectArgument((int)2);
        boolean allowed = resourceVerifier == null || resourceVerifier.verifyGetBundle(jni, baseName, callerClass);
        JNIObjectHandle result = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        if (allowed) {
            JNIObjectHandle callerModule = Support.getObjectArgument((int)0);
            JNIObjectHandle module = Support.getObjectArgument((int)1);
            JNIObjectHandle locale = Support.getObjectArgument((int)3);
            JNIObjectHandle control = Support.getObjectArgument((int)4);
            result = Support.callStaticObjectMethodLLLLL((JNIEnvironment)jni, (JNIObjectHandle)bp.clazz, (JNIMethodId)bp.method, (JNIObjectHandle)callerModule, (JNIObjectHandle)module, (JNIObjectHandle)baseName, (JNIObjectHandle)locale, (JNIObjectHandle)control);
            if (Support.clearException((JNIEnvironment)jni)) {
                result = (JNIObjectHandle)JNIObjectHandles.nullHandle();
            }
        }
        BreakpointInterceptor.traceBreakpoint(jni, (JNIObjectHandle)JNIObjectHandles.nullHandle(), (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, "getBundleImplJDK11OrLater", result.notEqual((ComparableWord)JNIObjectHandles.nullHandle()), TraceWriter.UNKNOWN_VALUE, TraceWriter.UNKNOWN_VALUE, Support.fromJniString((JNIEnvironment)jni, (JNIObjectHandle)baseName), TraceWriter.UNKNOWN_VALUE, TraceWriter.UNKNOWN_VALUE);
        return BreakpointInterceptor.endGetBundleImpl(jni, baseName, allowed);
    }

    private static boolean endGetBundleImpl(JNIEnvironment jni, JNIObjectHandle baseName, boolean allowed) {
        if (!allowed) {
            try (CTypeConversion.CCharPointerHolder message = Support.toCString((String)("native-image-agent: configuration does not permit access to resource bundle: " + Support.fromJniString((JNIEnvironment)jni, (JNIObjectHandle)baseName)));){
                JNIObjectHandle msg = Support.jniFunctions().getNewStringUTF().invoke(jni, message.get());
                JNIObjectHandle ex = Support.newObjectLLL((JNIEnvironment)jni, (JNIObjectHandle)((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaUtilMissingResourceException, (JNIMethodId)((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaUtilMissingResourceExceptionCtor3, (JNIObjectHandle)msg, (JNIObjectHandle)((JNIObjectHandle)JNIObjectHandles.nullHandle()), (JNIObjectHandle)((JNIObjectHandle)JNIObjectHandles.nullHandle()));
                Support.jniFunctions().getThrow().invoke(jni, ex);
            }
        }
        return allowed;
    }

    private static boolean loadClass(JNIEnvironment jni, Breakpoint bp) {
        assert (experimentalClassLoaderSupport);
        JNIObjectHandle callerClass = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        JvmtiFrameInfo frameInfo = (JvmtiFrameInfo)StackValue.get(JvmtiFrameInfo.class);
        CIntPointer frameCountPtr = (CIntPointer)StackValue.get(CIntPointer.class);
        if (Support.jvmtiFunctions().GetStackTrace().invoke(Support.jvmtiEnv(), (JNIObjectHandle)JNIObjectHandles.nullHandle(), 1, 1, (WordPointer)frameInfo, frameCountPtr) == JvmtiError.JVMTI_ERROR_NONE && frameCountPtr.read() == 1) {
            callerClass = Support.getMethodDeclaringClass((JNIMethodId)frameInfo.getMethod());
            if (callerClass.notEqual((ComparableWord)JNIObjectHandles.nullHandle()) && Support.jniFunctions().getIsAssignableFrom().invoke(jni, callerClass, ((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangClassLoader)) {
                return true;
            }
            MethodLocation location = new MethodLocation(frameInfo.getMethod(), NumUtil.safeToInt((long)frameInfo.getLocation()));
            if (!observedExplicitLoadClassCallSites.containsKey(location)) {
                if (!BreakpointInterceptor.isLoadClassInvocation(callerClass, location.method, location.bci, ((BreakpointSpecification)bp.specification).methodName, ((BreakpointSpecification)bp.specification).signature)) {
                    return true;
                }
                observedExplicitLoadClassCallSites.put(location, Boolean.TRUE);
            }
        }
        JNIObjectHandle self = Support.getObjectArgument((int)0);
        JNIObjectHandle name = Support.getObjectArgument((int)1);
        String className = Support.fromJniString((JNIEnvironment)jni, (JNIObjectHandle)name);
        boolean allowed = accessVerifier == null || accessVerifier.verifyLoadClass(jni, callerClass, className);
        Boolean result = false;
        if (allowed) {
            result = JNIObjectHandles.nullHandle().notEqual((ComparableWord)Support.callObjectMethodL((JNIEnvironment)jni, (JNIObjectHandle)self, (JNIMethodId)bp.method, (JNIObjectHandle)name));
            if (Support.clearException((JNIEnvironment)jni)) {
                result = false;
            }
        }
        BreakpointInterceptor.traceBreakpoint(jni, bp.clazz, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, ((BreakpointSpecification)bp.specification).methodName, result, className);
        if (!allowed) {
            try (CTypeConversion.CCharPointerHolder message = Support.toCString((String)("native-image-agent: configuration does not permit access to class: " + className));){
                Support.jniFunctions().getThrowNew().invoke(jni, ((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangClassNotFoundException, message.get());
            }
        }
        return allowed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isLoadClassInvocation(JNIObjectHandle clazz, JNIMethodId method, int bci, String methodName, String signature) {
        int cpi;
        CIntPointer lengthPtr = (CIntPointer)StackValue.get(CIntPointer.class);
        CCharPointerPointer bytecodesPtr = (CCharPointerPointer)StackValue.get(CCharPointerPointer.class);
        if (Support.jvmtiFunctions().GetBytecodes().invoke(Support.jvmtiEnv(), method, lengthPtr, bytecodesPtr) != JvmtiError.JVMTI_ERROR_NONE) {
            return false;
        }
        CCharPointer bytecodes = bytecodesPtr.read();
        try {
            if (bci + 2 >= lengthPtr.read()) {
                boolean bl = false;
                return bl;
            }
            int instruction = Byte.toUnsignedInt(bytecodes.read(bci));
            if (instruction != 182) {
                boolean bl = false;
                return bl;
            }
            int indexbyte1 = Byte.toUnsignedInt(bytecodes.read(bci + 1));
            int indexbyte2 = Byte.toUnsignedInt(bytecodes.read(bci + 2));
            cpi = indexbyte1 << 8 | indexbyte2;
        }
        finally {
            Support.jvmtiFunctions().Deallocate().invoke(Support.jvmtiEnv(), (PointerBase)bytecodes);
        }
        CIntPointer constantPoolCountPtr = (CIntPointer)StackValue.get(CIntPointer.class);
        CIntPointer constantPoolByteCountPtr = (CIntPointer)StackValue.get(CIntPointer.class);
        CCharPointerPointer constantPoolBytesPtr = (CCharPointerPointer)StackValue.get(CCharPointerPointer.class);
        if (Support.jvmtiFunctions().GetConstantPool().invoke(Support.jvmtiEnv(), clazz, constantPoolCountPtr, constantPoolByteCountPtr, constantPoolBytesPtr) != JvmtiError.JVMTI_ERROR_NONE) {
            return false;
        }
        CCharPointer constantPool = constantPoolBytesPtr.read();
        try {
            ByteBuffer buffer = CTypeConversion.asByteBuffer((PointerBase)constantPool, (int)constantPoolByteCountPtr.read());
            buffer.order(ByteOrder.BIG_ENDIAN);
            try {
                ConstantPoolTool.MethodReference ref = new ConstantPoolTool(buffer).readMethodReference(cpi);
                boolean bl = methodName.contentEquals(ref.name) && signature.contentEquals(ref.descriptor);
                return bl;
            }
            catch (ConstantPoolTool.ConstantPoolException e) {
                boolean bl = false;
                Support.jvmtiFunctions().Deallocate().invoke(Support.jvmtiEnv(), (PointerBase)constantPool);
                return bl;
            }
        }
        finally {
            Support.jvmtiFunctions().Deallocate().invoke(Support.jvmtiEnv(), (PointerBase)constantPool);
        }
    }

    private static String asInternalSignature(Object paramTypesArray) {
        if (paramTypesArray instanceof Object[]) {
            StringBuilder sb = new StringBuilder("(");
            for (Object paramType : (Object[])paramTypesArray) {
                sb.append(MetaUtil.toInternalName((String)paramType.toString()));
            }
            return sb.append(')').toString();
        }
        return null;
    }

    private static boolean resolveMemberName(JNIEnvironment jni, Breakpoint bp) {
        Object[] args;
        String function;
        if (!methodHandleSupport) {
            return false;
        }
        JNIObjectHandle factory = Support.getObjectArgument((int)0);
        byte refKind = Support.getByteArgument((int)1);
        JNIObjectHandle unresolvedName = Support.getObjectArgument((int)2);
        JNIObjectHandle lookupClass = Support.getObjectArgument((int)3);
        boolean speculativeResolve = Support.getBooleanArgument((int)4);
        JNIObjectHandle resolvedName = Support.callObjectMethodBLLZ((JNIEnvironment)jni, (JNIObjectHandle)factory, (JNIMethodId)bp.method, (byte)refKind, (JNIObjectHandle)unresolvedName, (JNIObjectHandle)lookupClass, (boolean)speculativeResolve);
        if (Support.clearException((JNIEnvironment)jni)) {
            resolvedName = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        }
        if (resolvedName.equal((ComparableWord)JNIObjectHandles.nullHandle())) {
            return false;
        }
        boolean isMethod = Support.callBooleanMethod((JNIEnvironment)jni, (JNIObjectHandle)resolvedName, (JNIMethodId)((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangInvokeMemberNameIsMethod);
        if (Support.clearException((JNIEnvironment)jni)) {
            isMethod = false;
        }
        boolean isConstructor = Support.callBooleanMethod((JNIEnvironment)jni, (JNIObjectHandle)resolvedName, (JNIMethodId)((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangInvokeMemberNameIsConstructor);
        if (Support.clearException((JNIEnvironment)jni)) {
            isConstructor = false;
        }
        boolean isField = Support.callBooleanMethod((JNIEnvironment)jni, (JNIObjectHandle)resolvedName, (JNIMethodId)((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangInvokeMemberNameIsField);
        if (Support.clearException((JNIEnvironment)jni)) {
            isField = false;
        }
        JNIObjectHandle declaringClass = Support.callObjectMethod((JNIEnvironment)jni, (JNIObjectHandle)resolvedName, (JNIMethodId)((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangInvokeMemberNameGetDeclaringClass);
        if (Support.clearException((JNIEnvironment)jni)) {
            declaringClass = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        }
        JNIObjectHandle declaringClassNameHandle = Support.callObjectMethod((JNIEnvironment)jni, (JNIObjectHandle)declaringClass, (JNIMethodId)((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangClassGetName);
        if (Support.clearException((JNIEnvironment)jni)) {
            declaringClassNameHandle = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        }
        JNIObjectHandle nameHandle = Support.callObjectMethod((JNIEnvironment)jni, (JNIObjectHandle)resolvedName, (JNIMethodId)((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangInvokeMemberNameGetName);
        if (Support.clearException((JNIEnvironment)jni)) {
            nameHandle = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        }
        JNIObjectHandle paramTypesHandle = Support.callObjectMethod((JNIEnvironment)jni, (JNIObjectHandle)resolvedName, (JNIMethodId)((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangInvokeMemberNameGetParameterTypes);
        if (Support.clearException((JNIEnvironment)jni)) {
            paramTypesHandle = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        }
        JNIObjectHandle result = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        String declaringClassName = Support.fromJniString((JNIEnvironment)jni, (JNIObjectHandle)declaringClassNameHandle);
        String name = Support.fromJniString((JNIEnvironment)jni, (JNIObjectHandle)nameHandle);
        Object paramTypes = BreakpointInterceptor.getClassArrayNames(jni, paramTypesHandle);
        Supplier<String> signature = () -> BreakpointInterceptor.asInternalSignature(paramTypes);
        if (isMethod) {
            result = Support.callObjectMethodLL((JNIEnvironment)jni, (JNIObjectHandle)declaringClass, (JNIMethodId)((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangClassGetDeclaredMethod, (JNIObjectHandle)nameHandle, (JNIObjectHandle)paramTypesHandle);
            function = "getDeclaredMethod";
            args = new Object[]{name, paramTypes};
        } else if (isConstructor) {
            result = Support.callObjectMethodL((JNIEnvironment)jni, (JNIObjectHandle)declaringClass, (JNIMethodId)((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangClassGetDeclaredConstructor, (JNIObjectHandle)paramTypesHandle);
            function = "getDeclaredConstructor";
            args = new Object[]{paramTypes};
        } else if (isField) {
            result = Support.callObjectMethodL((JNIEnvironment)jni, (JNIObjectHandle)declaringClass, (JNIMethodId)((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangClassGetDeclaredField, (JNIObjectHandle)nameHandle);
            function = "getDeclaredField";
            args = new Object[]{name};
        } else {
            function = null;
            args = new Object[]{};
        }
        if (function != null && Support.clearException((JNIEnvironment)jni)) {
            result = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        }
        JNIObjectHandle resultDeclaringClass = Support.callObjectMethod((JNIEnvironment)jni, (JNIObjectHandle)result, (JNIMethodId)((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangReflectMemberGetDeclaringClass);
        if (Support.clearException((JNIEnvironment)jni)) {
            resultDeclaringClass = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        }
        boolean ignore = declaringClassName == null || name == null || declaringClassName.startsWith("java.lang.invoke") || declaringClassName.contains("$$Lambda$") || name.contains("$anonfun$") || name.startsWith("lambda$");
        boolean allowed = !ignore && (result.equal((ComparableWord)JNIObjectHandles.nullHandle()) || accessVerifier == null || accessVerifier.verifyGetMethod(jni, declaringClass, name, signature, result, declaringClass, lookupClass));
        BreakpointInterceptor.traceBreakpoint(jni, declaringClass, resultDeclaringClass, lookupClass, function, allowed && result.notEqual((ComparableWord)JNIObjectHandles.nullHandle()), args);
        if (!ignore && !allowed) {
            BreakpointInterceptor.throwNoSuchMethodException(jni, declaringClass, name, signature.get());
        }
        return allowed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CEntryPoint
    @CEntryPointOptions(prologue=AgentIsolate.Prologue.class)
    private static void onBreakpoint(JvmtiEnv jvmti, JNIEnvironment jni, JNIObjectHandle thread, JNIMethodId method, long location) {
        if (recursive.get().booleanValue()) {
            return;
        }
        recursive.set(true);
        try {
            Breakpoint bp = installedBreakpoints.get(method.rawValue());
            if (((BreakpointSpecification)bp.specification).handler.dispatch(jni, bp)) {
                VMError.guarantee((!Support.testException((JNIEnvironment)jni) ? 1 : 0) != 0);
            }
        }
        catch (Throwable t) {
            VMError.shouldNotReachHere((Throwable)t);
        }
        finally {
            recursive.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CEntryPoint
    @CEntryPointOptions(prologue=AgentIsolate.Prologue.class)
    private static void onNativeMethodBind(JvmtiEnv jvmti, JNIEnvironment jni, JNIObjectHandle thread, JNIMethodId method, CodePointer address, WordPointer newAddressPtr) {
        if (recursive.get().booleanValue()) {
            return;
        }
        nativeBreakpointsInitLock.lock();
        try {
            if (nativeBreakpoints != null) {
                NativeBreakpoint bp = nativeBreakpoints.get(method.rawValue());
                if (bp != null) {
                    BreakpointInterceptor.bindNativeBreakpoint(jni, bp, address, newAddressPtr);
                }
            } else {
                boundNativeMethods.put(method.rawValue(), address.rawValue());
            }
        }
        finally {
            nativeBreakpointsInitLock.unlock();
        }
    }

    @CEntryPoint
    @CEntryPointOptions(prologue=AgentIsolate.Prologue.class)
    private static void onClassPrepare(JvmtiEnv jvmti, JNIEnvironment jni, JNIObjectHandle thread, JNIObjectHandle clazz) {
        assert (experimentalClassLoaderSupport);
        BreakpointInterceptor.installBreakpointIfClassLoader(jni, clazz, installedBreakpoints);
    }

    private static void installBreakpointIfClassLoader(JNIEnvironment jni, JNIObjectHandle clazz, Map<Long, Breakpoint> breakpoints) {
        String className;
        if (Support.jniFunctions().getIsAssignableFrom().invoke(jni, clazz, ((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangClassLoader) && (className = Support.getClassNameOrNull((JNIEnvironment)jni, (JNIObjectHandle)clazz)) != null) {
            BreakpointSpecification proto = CLASSLOADER_LOAD_CLASS_BREAKPOINT_SPECIFICATION;
            JNIMethodId method = BreakpointInterceptor.resolveBreakpointMethod(jni, clazz, proto.methodName, proto.signature, true);
            if (method.isNonNull() && Support.jvmtiFunctions().SetBreakpoint().invoke(Support.jvmtiEnv(), method, 0L) == JvmtiError.JVMTI_ERROR_NONE) {
                BreakpointSpecification spec = new BreakpointSpecification(className, proto.methodName, proto.signature, proto.handler, proto.optional);
                JNIObjectHandle gclazz = ((NativeImageAgentJNIHandleSet)agent.handles()).newTrackedGlobalRef(jni, clazz);
                breakpoints.put(method.rawValue(), new Breakpoint(spec, gclazz, method));
            }
        }
    }

    public static void onLoad(JvmtiEnv jvmti, JvmtiEventCallbacks callbacks, TraceWriter writer, ReflectAccessVerifier verifier, ProxyAccessVerifier prverifier, ResourceAccessVerifier resverifier, NativeImageAgent nativeImageTracingAgent, boolean exptlClassLoaderSupport, boolean supportMethodHandles) {
        traceWriter = writer;
        accessVerifier = verifier;
        proxyVerifier = prverifier;
        resourceVerifier = resverifier;
        agent = nativeImageTracingAgent;
        experimentalClassLoaderSupport = exptlClassLoaderSupport;
        methodHandleSupport = supportMethodHandles;
        JvmtiCapabilities capabilities = (JvmtiCapabilities)UnmanagedMemory.calloc((int)SizeOf.get(JvmtiCapabilities.class));
        Support.check((JvmtiError)jvmti.getFunctions().GetCapabilities().invoke(jvmti, capabilities));
        capabilities.setCanGenerateBreakpointEvents(1);
        capabilities.setCanAccessLocalVariables(1);
        capabilities.setCanForceEarlyReturn(1);
        capabilities.setCanGenerateNativeMethodBindEvents(1);
        if (exptlClassLoaderSupport) {
            capabilities.setCanGetBytecodes(1);
            capabilities.setCanGetConstantPool(1);
            CIntPointer formatPtr = (CIntPointer)StackValue.get(CIntPointer.class);
            VMError.guarantee((jvmti.getFunctions().GetJLocationFormat().invoke(jvmti, formatPtr) == JvmtiError.JVMTI_ERROR_NONE && formatPtr.read() == JvmtiLocationFormat.JVMTI_JLOCATION_JVMBCI.getCValue() ? 1 : 0) != 0, (String)"Expecting BCI locations");
        }
        Support.check((JvmtiError)jvmti.getFunctions().AddCapabilities().invoke(jvmti, capabilities));
        UnmanagedMemory.free((PointerBase)capabilities);
        callbacks.setBreakpoint(onBreakpointLiteral.getFunctionPointer());
        callbacks.setNativeMethodBind(onNativeMethodBindLiteral.getFunctionPointer());
        if (exptlClassLoaderSupport) {
            callbacks.setClassPrepare(onClassPrepareLiteral.getFunctionPointer());
        }
        boundNativeMethods = new HashMap<Long, Long>();
        Support.check((JvmtiError)jvmti.getFunctions().SetEventNotificationMode().invoke(jvmti, JvmtiEventMode.JVMTI_ENABLE, JvmtiEvent.JVMTI_EVENT_NATIVE_METHOD_BIND, (JNIObjectHandle)JNIObjectHandles.nullHandle()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onVMInit(JvmtiEnv jvmti, JNIEnvironment jni) {
        JNIObjectHandle clazz;
        ConcurrentHashMap<Long, Breakpoint> breakpoints;
        if (experimentalClassLoaderSupport) {
            breakpoints = new ConcurrentHashMap(BREAKPOINT_SPECIFICATIONS.length);
            observedExplicitLoadClassCallSites = new ConcurrentHashMap<MethodLocation, Boolean>();
            CIntPointer classCountPtr = (CIntPointer)StackValue.get(CIntPointer.class);
            WordPointer classesPtr = (WordPointer)StackValue.get(WordPointer.class);
            Support.check((JvmtiError)Support.jvmtiFunctions().GetLoadedClasses().invoke(jvmti, classCountPtr, classesPtr));
            WordPointer classesArray = (WordPointer)classesPtr.read();
            for (int i = 0; i < classCountPtr.read(); ++i) {
                JNIObjectHandle clazz2 = (JNIObjectHandle)classesArray.read(i);
                BreakpointInterceptor.installBreakpointIfClassLoader(jni, clazz2, breakpoints);
            }
            Support.check((JvmtiError)Support.jvmtiFunctions().Deallocate().invoke(jvmti, (PointerBase)classesArray));
        } else {
            breakpoints = new HashMap(BREAKPOINT_SPECIFICATIONS.length);
        }
        JNIObjectHandle lastClass = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        String lastClassName = null;
        for (BreakpointSpecification breakpointSpecification : BREAKPOINT_SPECIFICATIONS) {
            Breakpoint bp;
            clazz = (JNIObjectHandle)JNIObjectHandles.nullHandle();
            if (lastClassName != null && lastClassName.equals(breakpointSpecification.className)) {
                clazz = lastClass;
            }
            if ((bp = BreakpointInterceptor.installBreakpoint(jni, breakpointSpecification, breakpoints, clazz)) == null) continue;
            lastClass = bp.clazz;
            lastClassName = breakpointSpecification.className;
        }
        installedBreakpoints = breakpoints;
        nativeBreakpointsInitLock.lock();
        try {
            nativeBreakpoints = new HashMap<Long, NativeBreakpoint>(NATIVE_BREAKPOINT_SPECIFICATIONS.length);
            for (AbstractBreakpointSpecification abstractBreakpointSpecification : NATIVE_BREAKPOINT_SPECIFICATIONS) {
                if (lastClassName != null && lastClassName.equals(((NativeBreakpointSpecification)abstractBreakpointSpecification).className)) {
                    clazz = lastClass;
                } else {
                    lastClass = clazz = BreakpointInterceptor.resolveBreakpointClass(jni, ((NativeBreakpointSpecification)abstractBreakpointSpecification).className, ((NativeBreakpointSpecification)abstractBreakpointSpecification).optional);
                    lastClassName = ((NativeBreakpointSpecification)abstractBreakpointSpecification).className;
                }
                JNIMethodId method = BreakpointInterceptor.resolveBreakpointMethod(jni, clazz, ((NativeBreakpointSpecification)abstractBreakpointSpecification).methodName, ((NativeBreakpointSpecification)abstractBreakpointSpecification).signature, ((NativeBreakpointSpecification)abstractBreakpointSpecification).optional);
                if (!method.isNonNull()) continue;
                NativeBreakpoint bp = new NativeBreakpoint((NativeBreakpointSpecification)abstractBreakpointSpecification, clazz, method);
                nativeBreakpoints.put(method.rawValue(), bp);
                Long original = boundNativeMethods.get(method.rawValue());
                if (original == null) continue;
                BreakpointInterceptor.bindNativeBreakpoint(jni, bp, (CodePointer)WordFactory.pointer((long)original), (WordPointer)WordFactory.nullPointer());
            }
            boundNativeMethods = null;
        }
        finally {
            nativeBreakpointsInitLock.unlock();
        }
        Support.check((JvmtiError)jvmti.getFunctions().SetEventNotificationMode().invoke(jvmti, JvmtiEventMode.JVMTI_ENABLE, JvmtiEvent.JVMTI_EVENT_BREAKPOINT, (JNIObjectHandle)JNIObjectHandles.nullHandle()));
        if (experimentalClassLoaderSupport) {
            Support.check((JvmtiError)jvmti.getFunctions().SetEventNotificationMode().invoke(jvmti, JvmtiEventMode.JVMTI_ENABLE, JvmtiEvent.JVMTI_EVENT_CLASS_PREPARE, (JNIObjectHandle)JNIObjectHandles.nullHandle()));
        }
    }

    private static Breakpoint installBreakpoint(JNIEnvironment jni, BreakpointSpecification br, Map<Long, Breakpoint> map, JNIObjectHandle knownClass) {
        JNIObjectHandle clazz = knownClass;
        if (clazz.equal((ComparableWord)JNIObjectHandles.nullHandle()) && (clazz = BreakpointInterceptor.resolveBreakpointClass(jni, br.className, br.optional)).equal((ComparableWord)JNIObjectHandles.nullHandle())) {
            VMError.guarantee((boolean)br.optional);
            return null;
        }
        JNIMethodId method = BreakpointInterceptor.resolveBreakpointMethod(jni, clazz, br.methodName, br.signature, br.optional);
        JvmtiError result = Support.jvmtiFunctions().SetBreakpoint().invoke(Support.jvmtiEnv(), method, 0L);
        if (result != JvmtiError.JVMTI_ERROR_NONE) {
            VMError.guarantee((boolean)br.optional, (String)"Setting breakpoint failed");
            return null;
        }
        Breakpoint bp = new Breakpoint(br, clazz, method);
        VMError.guarantee((map.put(method.rawValue(), bp) == null ? 1 : 0) != 0, (String)("Duplicate breakpoint: " + bp));
        return bp;
    }

    private static JNIObjectHandle resolveBreakpointClass(JNIEnvironment jni, String className, boolean optional) {
        JNIObjectHandle clazz;
        try (CTypeConversion.CCharPointerHolder cname = Support.toCString((String)className);){
            clazz = Support.jniFunctions().getFindClass().invoke(jni, cname.get());
            if (optional && (Support.clearException((JNIEnvironment)jni) || clazz.equal((ComparableWord)JNIObjectHandles.nullHandle()))) {
                JNIObjectHandle jNIObjectHandle = (JNIObjectHandle)JNIObjectHandles.nullHandle();
                return jNIObjectHandle;
            }
            Support.checkNoException((JNIEnvironment)jni);
        }
        clazz = ((NativeImageAgentJNIHandleSet)agent.handles()).newTrackedGlobalRef(jni, clazz);
        Support.checkNoException((JNIEnvironment)jni);
        return clazz;
    }

    private static JNIMethodId resolveBreakpointMethod(JNIEnvironment jni, JNIObjectHandle clazz, String methodName, String signature, boolean optional) {
        JNIMethodId method;
        VMError.guarantee((boolean)clazz.notEqual((ComparableWord)JNIObjectHandles.nullHandle()));
        try (CTypeConversion.CCharPointerHolder cname = Support.toCString((String)methodName);
             CTypeConversion.CCharPointerHolder csignature = Support.toCString((String)signature);){
            method = Support.jniFunctions().getGetMethodID().invoke(jni, clazz, cname.get(), csignature.get());
            if (method.isNull()) {
                Support.clearException((JNIEnvironment)jni);
                method = Support.jniFunctions().getGetStaticMethodID().invoke(jni, clazz, cname.get(), csignature.get());
            }
        }
        if (optional && (Support.clearException((JNIEnvironment)jni) || method.isNull())) {
            return (JNIMethodId)WordFactory.nullPointer();
        }
        VMError.guarantee((!Support.testException((JNIEnvironment)jni) && method.isNonNull() ? 1 : 0) != 0);
        return method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void bindNativeBreakpoint(JNIEnvironment jni, NativeBreakpoint bp, CodePointer originalAddress, WordPointer newAddressPtr) {
        assert (!recursive.get().booleanValue());
        bp.replacedFunction = originalAddress;
        CFunctionPointer breakpointMethod = ((NativeBreakpointSpecification)bp.specification).handlerLiteral.getFunctionPointer();
        if (newAddressPtr.isNonNull()) {
            newAddressPtr.write((WordBase)breakpointMethod);
        } else {
            recursive.set(true);
            try (CTypeConversion.CCharPointerHolder cname = Support.toCString((String)((NativeBreakpointSpecification)bp.specification).methodName);
                 CTypeConversion.CCharPointerHolder csignature = Support.toCString((String)((NativeBreakpointSpecification)bp.specification).signature);){
                JNINativeMethod nativeMethod = (JNINativeMethod)StackValue.get(JNINativeMethod.class);
                nativeMethod.setName(cname.get());
                nativeMethod.setSignature(csignature.get());
                nativeMethod.setFnPtr(breakpointMethod);
                Support.checkJni((int)jni.getFunctions().getRegisterNatives().invoke(jni, bp.clazz, nativeMethod, 1));
            }
            finally {
                recursive.set(false);
            }
        }
    }

    public static void onUnload() {
        installedBreakpoints = null;
        nativeBreakpoints = null;
        observedExplicitLoadClassCallSites = null;
        accessVerifier = null;
        proxyVerifier = null;
        resourceVerifier = null;
        traceWriter = null;
    }

    private static BreakpointSpecification brk(String className, String methodName, String signature, BreakpointHandler handler) {
        return new BreakpointSpecification(className, methodName, signature, handler, false);
    }

    private static BreakpointSpecification optionalBrk(String className, String methodName, String signature, BreakpointHandler handler) {
        return new BreakpointSpecification(className, methodName, signature, handler, true);
    }

    private BreakpointInterceptor() {
    }

    static {
        experimentalClassLoaderSupport = false;
        methodHandleSupport = false;
        nativeBreakpointsInitLock = new ReentrantLock();
        recursive = ThreadLocal.withInitial(() -> Boolean.FALSE);
        nativeObjectFieldOffsetLiteral = CEntryPointLiteral.create(BreakpointInterceptor.class, (String)"nativeObjectFieldOffset", (Class[])new Class[]{JNIEnvironment.class, JNIObjectHandle.class, JNIObjectHandle.class});
        NATIVE_OBJECTFIELDOFFSET_BREAKPOINT_SPEC = new NativeBreakpointSpecification("sun/misc/Unsafe", "objectFieldOffset", "(Ljava/lang/reflect/Field;)J", nativeObjectFieldOffsetLiteral);
        onBreakpointLiteral = CEntryPointLiteral.create(BreakpointInterceptor.class, (String)"onBreakpoint", (Class[])new Class[]{JvmtiEnv.class, JNIEnvironment.class, JNIObjectHandle.class, JNIMethodId.class, Long.TYPE});
        onNativeMethodBindLiteral = CEntryPointLiteral.create(BreakpointInterceptor.class, (String)"onNativeMethodBind", (Class[])new Class[]{JvmtiEnv.class, JNIEnvironment.class, JNIObjectHandle.class, JNIMethodId.class, CodePointer.class, WordPointer.class});
        onClassPrepareLiteral = CEntryPointLiteral.create(BreakpointInterceptor.class, (String)"onClassPrepare", (Class[])new Class[]{JvmtiEnv.class, JNIEnvironment.class, JNIObjectHandle.class, JNIObjectHandle.class});
        BREAKPOINT_SPECIFICATIONS = new BreakpointSpecification[]{BreakpointInterceptor.brk("java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;", BreakpointInterceptor::forName), BreakpointInterceptor.brk("java/lang/Class", "forName", "(Ljava/lang/String;ZLjava/lang/ClassLoader;)Ljava/lang/Class;", BreakpointInterceptor::forName), BreakpointInterceptor.brk("java/lang/Class", "getFields", "()[Ljava/lang/reflect/Field;", BreakpointInterceptor::getFields), BreakpointInterceptor.brk("java/lang/Class", "getMethods", "()[Ljava/lang/reflect/Method;", BreakpointInterceptor::getMethods), BreakpointInterceptor.brk("java/lang/Class", "getConstructors", "()[Ljava/lang/reflect/Constructor;", BreakpointInterceptor::getConstructors), BreakpointInterceptor.brk("java/lang/Class", "getDeclaredFields", "()[Ljava/lang/reflect/Field;", BreakpointInterceptor::getDeclaredFields), BreakpointInterceptor.brk("java/lang/Class", "getDeclaredMethods", "()[Ljava/lang/reflect/Method;", BreakpointInterceptor::getDeclaredMethods), BreakpointInterceptor.brk("java/lang/Class", "getDeclaredConstructors", "()[Ljava/lang/reflect/Constructor;", BreakpointInterceptor::getDeclaredConstructors), BreakpointInterceptor.brk("java/lang/Class", "getField", "(Ljava/lang/String;)Ljava/lang/reflect/Field;", BreakpointInterceptor::getField), BreakpointInterceptor.brk("java/lang/Class", "getDeclaredField", "(Ljava/lang/String;)Ljava/lang/reflect/Field;", BreakpointInterceptor::getDeclaredField), BreakpointInterceptor.brk("java/lang/Class", "getMethod", "(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;", BreakpointInterceptor::getMethod), BreakpointInterceptor.brk("java/lang/Class", "getConstructor", "([Ljava/lang/Class;)Ljava/lang/reflect/Constructor;", BreakpointInterceptor::getConstructor), BreakpointInterceptor.brk("java/lang/Class", "getDeclaredMethod", "(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;", BreakpointInterceptor::getDeclaredMethod), BreakpointInterceptor.brk("java/lang/Class", "getDeclaredConstructor", "([Ljava/lang/Class;)Ljava/lang/reflect/Constructor;", BreakpointInterceptor::getConstructor), BreakpointInterceptor.brk("java/lang/Class", "getEnclosingMethod", "()Ljava/lang/reflect/Method;", BreakpointInterceptor::getEnclosingMethod), BreakpointInterceptor.brk("java/lang/Class", "getEnclosingConstructor", "()Ljava/lang/reflect/Constructor;", BreakpointInterceptor::getEnclosingMethod), BreakpointInterceptor.brk("java/lang/Class", "newInstance", "()Ljava/lang/Object;", BreakpointInterceptor::newInstance), BreakpointInterceptor.brk("java/lang/reflect/Array", "newInstance", "(Ljava/lang/Class;I)Ljava/lang/Object;", BreakpointInterceptor::newArrayInstance), BreakpointInterceptor.brk("java/lang/reflect/Array", "newInstance", "(Ljava/lang/Class;[I)Ljava/lang/Object;", BreakpointInterceptor::newArrayInstanceMulti), BreakpointInterceptor.brk("java/lang/ClassLoader", "getResource", "(Ljava/lang/String;)Ljava/net/URL;", BreakpointInterceptor::getResource), BreakpointInterceptor.brk("java/lang/ClassLoader", "getResources", "(Ljava/lang/String;)Ljava/util/Enumeration;", BreakpointInterceptor::getResources), BreakpointInterceptor.brk("java/lang/ClassLoader", "getSystemResource", "(Ljava/lang/String;)Ljava/net/URL;", BreakpointInterceptor::getSystemResource), BreakpointInterceptor.brk("java/lang/ClassLoader", "getSystemResources", "(Ljava/lang/String;)Ljava/util/Enumeration;", BreakpointInterceptor::getSystemResources), BreakpointInterceptor.brk("java/lang/reflect/Proxy", "getProxyClass", "(Ljava/lang/ClassLoader;[Ljava/lang/Class;)Ljava/lang/Class;", BreakpointInterceptor::getProxyClass), BreakpointInterceptor.brk("java/lang/reflect/Proxy", "newProxyInstance", "(Ljava/lang/ClassLoader;[Ljava/lang/Class;Ljava/lang/reflect/InvocationHandler;)Ljava/lang/Object;", BreakpointInterceptor::newProxyInstance), BreakpointInterceptor.optionalBrk("java/util/ResourceBundle", "getBundleImpl", "(Ljava/lang/String;Ljava/util/Locale;Ljava/lang/ClassLoader;Ljava/util/ResourceBundle$Control;)Ljava/util/ResourceBundle;", BreakpointInterceptor::getBundleImplJDK8OrEarlier), BreakpointInterceptor.optionalBrk("java/util/ResourceBundle", "getBundleImpl", "(Ljava/lang/Module;Ljava/lang/Module;Ljava/lang/String;Ljava/util/Locale;Ljava/util/ResourceBundle$Control;)Ljava/util/ResourceBundle;", BreakpointInterceptor::getBundleImplJDK11OrLater), BreakpointInterceptor.optionalBrk("sun/misc/Unsafe", "objectFieldOffset", "(Ljava/lang/reflect/Field;)J", BreakpointInterceptor::objectFieldOffset), BreakpointInterceptor.optionalBrk("jdk/internal/misc/Unsafe", "objectFieldOffset", "(Ljava/lang/reflect/Field;)J", BreakpointInterceptor::objectFieldOffset), BreakpointInterceptor.optionalBrk("jdk/internal/misc/Unsafe", "objectFieldOffset", "(Ljava/lang/Class;Ljava/lang/String;)J", BreakpointInterceptor::objectFieldOffsetByName), BreakpointInterceptor.optionalBrk("java/lang/invoke/MemberName$Factory", "resolve", "(BLjava/lang/invoke/MemberName;Ljava/lang/Class;Z)Ljava/lang/invoke/MemberName;", BreakpointInterceptor::resolveMemberName)};
        CLASSLOADER_LOAD_CLASS_BREAKPOINT_SPECIFICATION = BreakpointInterceptor.optionalBrk("java/lang/ClassLoader", "loadClass", "(Ljava/lang/String;)Ljava/lang/Class;", BreakpointInterceptor::loadClass);
        NATIVE_BREAKPOINT_SPECIFICATIONS = new NativeBreakpointSpecification[]{NATIVE_OBJECTFIELDOFFSET_BREAKPOINT_SPEC};
    }

    private static final class MethodLocation {
        final JNIMethodId method;
        final int bci;

        MethodLocation(JNIMethodId method, int bci) {
            this.method = method;
            this.bci = bci;
        }

        public boolean equals(Object obj) {
            if (obj != this && obj instanceof MethodLocation) {
                MethodLocation other = (MethodLocation)obj;
                return this.method.equal((ComparableWord)other.method) && this.bci == other.bci;
            }
            return obj == this;
        }

        public int hashCode() {
            return 31 * Long.hashCode(this.method.rawValue()) + this.bci;
        }
    }

    private static final class NativeBreakpoint
    extends AbstractBreakpoint<NativeBreakpointSpecification> {
        CodePointer replacedFunction;

        NativeBreakpoint(NativeBreakpointSpecification specification, JNIObjectHandle clazz, JNIMethodId method) {
            super(specification, clazz, method);
            assert (specification.installed == null) : "must be installed exactly once";
            specification.installed = this;
        }
    }

    private static final class Breakpoint
    extends AbstractBreakpoint<BreakpointSpecification> {
        Breakpoint(BreakpointSpecification specification, JNIObjectHandle clazz, JNIMethodId method) {
            super(specification, clazz, method);
        }
    }

    private static abstract class AbstractBreakpoint<T extends AbstractBreakpointSpecification> {
        final T specification;
        final JNIObjectHandle clazz;
        final JNIMethodId method;

        AbstractBreakpoint(T specification, JNIObjectHandle clazz, JNIMethodId method) {
            this.specification = specification;
            this.clazz = clazz;
            this.method = method;
        }

        public String toString() {
            return ((AbstractBreakpointSpecification)this.specification).toString();
        }
    }

    private static class NativeBreakpointSpecification
    extends AbstractBreakpointSpecification {
        final CEntryPointLiteral<?> handlerLiteral;
        NativeBreakpoint installed;

        NativeBreakpointSpecification(String className, String methodName, String signature, CEntryPointLiteral<?> handlerLiteral) {
            super(className, methodName, signature, true);
            this.handlerLiteral = handlerLiteral;
        }
    }

    private static class BreakpointSpecification
    extends AbstractBreakpointSpecification {
        final BreakpointHandler handler;

        BreakpointSpecification(String className, String methodName, String signature, BreakpointHandler handler, boolean optional) {
            super(className, methodName, signature, optional);
            this.handler = handler;
        }
    }

    private static abstract class AbstractBreakpointSpecification {
        final String className;
        final String methodName;
        final String signature;
        final boolean optional;

        AbstractBreakpointSpecification(String className, String methodName, String signature, boolean optional) {
            this.className = className;
            this.methodName = methodName;
            this.signature = signature;
            this.optional = optional;
        }

        public String toString() {
            return this.className + ":" + this.methodName + this.signature + (this.optional ? " (optional)" : "");
        }
    }

    private static interface BreakpointHandler {
        public boolean dispatch(JNIEnvironment var1, Breakpoint var2);
    }

    private static interface ObjectFieldOffsetFunctionPointer
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public long invoke(JNIEnvironment var1, JNIObjectHandle var2, JNIObjectHandle var3);
    }
}

