/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.config;

import com.oracle.svm.configure.config.ConfigurationMemberKind;

final class FieldInfo {
    private static final FieldInfo[] WITHOUT_UNSAFE_ACCESS_CACHE;
    private final ConfigurationMemberKind kind;
    private final boolean finalButWritable;
    private final boolean allowUnsafeAccess;

    static FieldInfo get(ConfigurationMemberKind kind, boolean finalButWritable, boolean allowUnsafeAccess) {
        if (finalButWritable || allowUnsafeAccess) {
            return new FieldInfo(kind, finalButWritable, allowUnsafeAccess);
        }
        return WITHOUT_UNSAFE_ACCESS_CACHE[kind.ordinal()];
    }

    private FieldInfo(ConfigurationMemberKind kind, boolean finalButWritable, boolean allowUnsafeAccess) {
        this.kind = kind;
        this.finalButWritable = finalButWritable;
        this.allowUnsafeAccess = allowUnsafeAccess;
    }

    public ConfigurationMemberKind getKind() {
        return this.kind;
    }

    public boolean isFinalButWritable() {
        return this.finalButWritable;
    }

    public boolean isUnsafeAccessible() {
        return this.allowUnsafeAccess;
    }

    public boolean equals(Object obj) {
        if (obj != this && obj instanceof FieldInfo) {
            FieldInfo other = (FieldInfo)obj;
            return this.kind.equals((Object)other.kind) && this.finalButWritable == other.finalButWritable && this.allowUnsafeAccess == other.allowUnsafeAccess;
        }
        return obj == this;
    }

    public int hashCode() {
        return (Boolean.hashCode(this.allowUnsafeAccess) * 31 + Boolean.hashCode(this.finalButWritable)) * 31 + this.kind.hashCode();
    }

    static {
        ConfigurationMemberKind[] values = ConfigurationMemberKind.values();
        WITHOUT_UNSAFE_ACCESS_CACHE = new FieldInfo[values.length];
        for (ConfigurationMemberKind value : values) {
            FieldInfo.WITHOUT_UNSAFE_ACCESS_CACHE[value.ordinal()] = new FieldInfo(value, false, false);
        }
    }
}

