/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.agent.restrict;

import com.oracle.svm.agent.restrict.AbstractAccessVerifier;
import com.oracle.svm.configure.config.ProxyConfiguration;
import com.oracle.svm.configure.trace.AccessAdvisor;
import com.oracle.svm.configure.trace.LazyValueUtils;
import com.oracle.svm.jni.nativeapi.JNIEnvironment;
import com.oracle.svm.jni.nativeapi.JNIObjectHandle;
import java.util.Arrays;

public class ProxyAccessVerifier
extends AbstractAccessVerifier {
    private final ProxyConfiguration configuration;

    public ProxyAccessVerifier(ProxyConfiguration configuration, AccessAdvisor advisor) {
        super(advisor);
        this.configuration = configuration;
    }

    public boolean verifyNewProxyInstance(JNIEnvironment env, Object interfaceNames, JNIObjectHandle callerClass) {
        return this.verifyProxyAccess(env, interfaceNames, callerClass);
    }

    public boolean verifyGetProxyClass(JNIEnvironment env, Object interfaceNames, JNIObjectHandle callerClass) {
        return this.verifyProxyAccess(env, interfaceNames, callerClass);
    }

    private boolean verifyProxyAccess(JNIEnvironment env, Object interfaceNames, JNIObjectHandle callerClass) {
        if (this.shouldApproveWithoutChecks(LazyValueUtils.lazyNull(), ProxyAccessVerifier.lazyClassNameOrNull(env, callerClass))) {
            return true;
        }
        return interfaceNames instanceof String[] && this.configuration.contains(Arrays.asList((String[])interfaceNames));
    }
}

