/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.agent;

import com.oracle.svm.agent.BreakpointInterceptor;
import com.oracle.svm.agent.JniCallInterceptor;
import com.oracle.svm.agent.NativeImageAgentJNIHandleSet;
import com.oracle.svm.agent.TraceFileWriter;
import com.oracle.svm.agent.TraceProcessorWriterAdapter;
import com.oracle.svm.agent.TraceWriter;
import com.oracle.svm.agent.restrict.AbstractAccessVerifier;
import com.oracle.svm.agent.restrict.JniAccessVerifier;
import com.oracle.svm.agent.restrict.ProxyAccessVerifier;
import com.oracle.svm.agent.restrict.ReflectAccessVerifier;
import com.oracle.svm.agent.restrict.ResourceAccessVerifier;
import com.oracle.svm.agent.restrict.TypeAccessChecker;
import com.oracle.svm.configure.config.ConfigurationSet;
import com.oracle.svm.configure.filters.FilterConfigurationParser;
import com.oracle.svm.configure.filters.RuleNode;
import com.oracle.svm.configure.json.JsonPrintable;
import com.oracle.svm.configure.json.JsonWriter;
import com.oracle.svm.configure.trace.AccessAdvisor;
import com.oracle.svm.configure.trace.TraceProcessor;
import com.oracle.svm.core.FallbackExecutor;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.configure.ConfigurationFiles;
import com.oracle.svm.driver.NativeImage;
import com.oracle.svm.jni.nativeapi.JNIEnvironment;
import com.oracle.svm.jni.nativeapi.JNIJavaVM;
import com.oracle.svm.jni.nativeapi.JNIObjectHandle;
import com.oracle.svm.jvmtiagentbase.JNIHandleSet;
import com.oracle.svm.jvmtiagentbase.JvmtiAgentBase;
import com.oracle.svm.jvmtiagentbase.Support;
import com.oracle.svm.jvmtiagentbase.jvmti.JvmtiEnv;
import com.oracle.svm.jvmtiagentbase.jvmti.JvmtiEventCallbacks;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.nativeimage.ProcessProperties;
import org.graalvm.nativeimage.hosted.Feature;

public final class NativeImageAgent
extends JvmtiAgentBase<NativeImageAgentJNIHandleSet> {
    private static final String AGENT_NAME = "native-image-agent";
    public static final String MESSAGE_PREFIX = "native-image-agent: ";
    private static final TimeZone UTC_TIMEZONE = TimeZone.getTimeZone("UTC");
    private static final String oHJNIConfigurationResources = NativeImageAgent.oH(ConfigurationFiles.Options.JNIConfigurationResources);
    private static final String oHReflectionConfigurationResources = NativeImageAgent.oH(ConfigurationFiles.Options.ReflectionConfigurationResources);
    private static final String oHDynamicProxyConfigurationResources = NativeImageAgent.oH(ConfigurationFiles.Options.DynamicProxyConfigurationResources);
    private static final String oHResourceConfigurationResources = NativeImageAgent.oH(ConfigurationFiles.Options.ResourceConfigurationResources);
    private static final String oHConfigurationResourceRoots = NativeImageAgent.oH(ConfigurationFiles.Options.ConfigurationResourceRoots);
    private ScheduledThreadPoolExecutor periodicConfigWriterExecutor = null;
    private TraceWriter traceWriter;
    private Path configOutputDirPath;
    private AccessAdvisor accessAdvisor;
    private static final Pattern propertyBlacklist = Pattern.compile("(java\\..*)|(sun\\..*)|(jvmci\\..*)");
    private static final Pattern propertyWhitelist = Pattern.compile("(java\\.library\\.path)|(java\\.io\\.tmpdir)");
    private static final int MAX_WARNINGS_FOR_WRITING_CONFIGS_FAILURES = 5;
    private static int currentFailuresWritingConfigs = 0;
    private static final int MAX_FAILURES_ATOMIC_MOVE = 20;
    private static int currentFailuresAtomicMove = 0;

    private static <T> String oH(OptionKey<T> option) {
        return "-H:" + option.getName();
    }

    private static String getTokenValue(String token) {
        return token.substring(token.indexOf(61) + 1);
    }

    protected int getRequiredJvmtiVersion() {
        return 805372416;
    }

    protected JNIHandleSet constructJavaHandles(JNIEnvironment env) {
        return new NativeImageAgentJNIHandleSet(env);
    }

    protected int onLoadCallback(JNIJavaVM vm, JvmtiEnv jvmti, JvmtiEventCallbacks callbacks, String options) {
        AbstractAccessVerifier verifier;
        String traceOutputFile = null;
        String configOutputDir = null;
        ConfigurationSet restrictConfigs = new ConfigurationSet();
        ConfigurationSet mergeConfigs = new ConfigurationSet();
        boolean restrict = false;
        boolean builtinCallerFilter = true;
        boolean builtinHeuristicFilter = true;
        ArrayList<String> callerFilterFiles = new ArrayList<String>();
        ArrayList<String> accessFilterFiles = new ArrayList<String>();
        boolean experimentalClassLoaderSupport = true;
        boolean build = false;
        int configWritePeriod = -1;
        int configWritePeriodInitialDelay = 1;
        if (options.length() == 0) {
            System.err.println("native-image-agent: invalid option string. Please read CONFIGURE.md.");
            return 1;
        }
        for (String token : options.split(",")) {
            if (token.startsWith("trace-output=")) {
                if (traceOutputFile != null) {
                    System.err.println("native-image-agent: cannot specify trace-output= more than once.");
                    return 1;
                }
                traceOutputFile = NativeImageAgent.getTokenValue(token);
                continue;
            }
            if (token.startsWith("config-output-dir=") || token.startsWith("config-merge-dir=")) {
                if (configOutputDir != null) {
                    System.err.println("native-image-agent: cannot specify more than one of config-output-dir= or config-merge-dir=.");
                    return 1;
                }
                configOutputDir = NativeImageAgent.transformPath(NativeImageAgent.getTokenValue(token));
                if (!token.startsWith("config-merge-dir=")) continue;
                mergeConfigs.addDirectory(Paths.get(configOutputDir, new String[0]));
                continue;
            }
            if (token.startsWith("restrict-all-dir")) {
                restrictConfigs.addDirectory(Paths.get(NativeImageAgent.getTokenValue(token), new String[0]));
                continue;
            }
            if (token.equals("restrict")) {
                restrict = true;
                continue;
            }
            if (token.startsWith("restrict=")) {
                restrict = Boolean.parseBoolean(NativeImageAgent.getTokenValue(token));
                continue;
            }
            if (token.equals("no-builtin-caller-filter")) {
                builtinCallerFilter = false;
                continue;
            }
            if (token.startsWith("builtin-caller-filter=")) {
                builtinCallerFilter = Boolean.parseBoolean(NativeImageAgent.getTokenValue(token));
                continue;
            }
            if (token.equals("no-builtin-heuristic-filter")) {
                builtinHeuristicFilter = false;
                continue;
            }
            if (token.startsWith("builtin-heuristic-filter=")) {
                builtinHeuristicFilter = Boolean.parseBoolean(NativeImageAgent.getTokenValue(token));
                continue;
            }
            if (token.equals("no-filter")) {
                builtinCallerFilter = false;
                builtinHeuristicFilter = false;
                continue;
            }
            if (token.startsWith("no-filter=")) {
                builtinHeuristicFilter = builtinCallerFilter = !Boolean.parseBoolean(NativeImageAgent.getTokenValue(token));
                continue;
            }
            if (token.startsWith("caller-filter-file=")) {
                callerFilterFiles.add(NativeImageAgent.getTokenValue(token));
                continue;
            }
            if (token.startsWith("access-filter-file=")) {
                accessFilterFiles.add(NativeImageAgent.getTokenValue(token));
                continue;
            }
            if (token.equals("experimental-class-loader-support")) {
                experimentalClassLoaderSupport = true;
                continue;
            }
            if (token.startsWith("experimental-class-loader-support=")) {
                experimentalClassLoaderSupport = Boolean.parseBoolean(NativeImageAgent.getTokenValue(token));
                continue;
            }
            if (token.startsWith("config-write-period-secs=")) {
                configWritePeriod = NativeImageAgent.parseIntegerOrNegative(NativeImageAgent.getTokenValue(token));
                if (configWritePeriod > 0) continue;
                System.err.println("native-image-agent: config-write-period-secs can only be an integer greater than 0");
                return 1;
            }
            if (token.startsWith("config-write-initial-delay-secs=")) {
                configWritePeriodInitialDelay = NativeImageAgent.parseIntegerOrNegative(NativeImageAgent.getTokenValue(token));
                if (configWritePeriodInitialDelay >= 0) continue;
                System.err.println("native-image-agent: config-write-initial-delay-secs can only be an integer greater or equal to 0");
                return 1;
            }
            if (token.equals("build")) {
                build = true;
                continue;
            }
            if (token.startsWith("build=")) {
                build = Boolean.parseBoolean(NativeImageAgent.getTokenValue(token));
                continue;
            }
            System.err.println("native-image-agent: unsupported option: '" + token + "'. Please read CONFIGURE.md.");
            return 1;
        }
        if (traceOutputFile == null && configOutputDir == null && !restrict && restrictConfigs.isEmpty() && !build) {
            configOutputDir = NativeImageAgent.transformPath("native-image-agent_config-pid{pid}-{datetime}/");
            System.err.println("native-image-agent: no output/restrict/build options provided, tracking dynamic accesses and writing configuration to directory: " + configOutputDir);
        }
        RuleNode callerFilter = null;
        if (!builtinCallerFilter) {
            callerFilter = RuleNode.createRoot();
            callerFilter.addOrGetChildren("**", RuleNode.Inclusion.Include);
        }
        if (!callerFilterFiles.isEmpty()) {
            if (callerFilter == null) {
                callerFilter = AccessAdvisor.copyBuiltinCallerFilterTree();
            }
            if (!NativeImageAgent.parseFilterFiles(callerFilter, callerFilterFiles)) {
                return 1;
            }
        }
        RuleNode accessFilter = null;
        if (!accessFilterFiles.isEmpty() && !NativeImageAgent.parseFilterFiles(accessFilter = AccessAdvisor.copyBuiltinAccessFilterTree(), accessFilterFiles)) {
            return 1;
        }
        if (configOutputDir != null) {
            if (traceOutputFile != null) {
                System.err.println("native-image-agent: can only once specify exactly one of trace-output=, config-output-dir= or config-merge-dir=.");
                return 1;
            }
            try {
                this.configOutputDirPath = Paths.get(configOutputDir, new String[0]);
                if (!Files.isDirectory(this.configOutputDirPath, new LinkOption[0])) {
                    Files.createDirectory(this.configOutputDirPath, new FileAttribute[0]);
                }
                Function<IOException, Exception> handler = e -> {
                    if (e instanceof NoSuchFileException) {
                        System.err.println("native-image-agent: warning: file " + ((NoSuchFileException)e).getFile() + " for merging could not be found, skipping");
                        return null;
                    }
                    return e;
                };
                AccessAdvisor advisor = NativeImageAgent.createAccessAdvisor(builtinHeuristicFilter, callerFilter, accessFilter);
                TraceProcessor processor = new TraceProcessor(advisor, mergeConfigs.loadJniConfig(handler), mergeConfigs.loadReflectConfig(handler), mergeConfigs.loadProxyConfig(handler), mergeConfigs.loadResourceConfig(handler));
                this.traceWriter = new TraceProcessorWriterAdapter(processor);
            }
            catch (Throwable t) {
                System.err.println(MESSAGE_PREFIX + t);
                return 2;
            }
        }
        if (traceOutputFile != null) {
            try {
                Path path = Paths.get(NativeImageAgent.transformPath(traceOutputFile), new String[0]);
                this.traceWriter = new TraceFileWriter(path);
            }
            catch (Throwable t) {
                System.err.println(MESSAGE_PREFIX + t);
                return 2;
            }
        }
        if (build) {
            int status = NativeImageAgent.buildImage(jvmti);
            System.exit(status);
        }
        HashMap<URI, FileSystem> temporaryFileSystems = new HashMap<URI, FileSystem>();
        if (restrict && !NativeImageAgent.addRestrictConfigs(jvmti, restrictConfigs, temporaryFileSystems)) {
            return 2;
        }
        this.accessAdvisor = NativeImageAgent.createAccessAdvisor(builtinHeuristicFilter, callerFilter, accessFilter);
        TypeAccessChecker reflectAccessChecker = null;
        try {
            verifier = null;
            if (!restrictConfigs.getReflectConfigPaths().isEmpty()) {
                reflectAccessChecker = new TypeAccessChecker(restrictConfigs.loadReflectConfig(ConfigurationSet.FAIL_ON_EXCEPTION));
                verifier = new ReflectAccessVerifier(reflectAccessChecker, this.accessAdvisor, this);
            }
            ProxyAccessVerifier proxyVerifier = null;
            if (!restrictConfigs.getProxyConfigPaths().isEmpty()) {
                proxyVerifier = new ProxyAccessVerifier(restrictConfigs.loadProxyConfig(ConfigurationSet.FAIL_ON_EXCEPTION), this.accessAdvisor);
            }
            ResourceAccessVerifier resourceVerifier = null;
            if (!restrictConfigs.getResourceConfigPaths().isEmpty()) {
                resourceVerifier = new ResourceAccessVerifier(restrictConfigs.loadResourceConfig(ConfigurationSet.FAIL_ON_EXCEPTION), this.accessAdvisor);
            }
            BreakpointInterceptor.onLoad(jvmti, callbacks, this.traceWriter, verifier, proxyVerifier, resourceVerifier, this, experimentalClassLoaderSupport);
        }
        catch (Throwable t) {
            System.err.println(MESSAGE_PREFIX + t);
            return 3;
        }
        try {
            verifier = null;
            if (!restrictConfigs.getJniConfigPaths().isEmpty()) {
                TypeAccessChecker accessChecker = new TypeAccessChecker(restrictConfigs.loadJniConfig(ConfigurationSet.FAIL_ON_EXCEPTION));
                verifier = new JniAccessVerifier(accessChecker, reflectAccessChecker, this.accessAdvisor, this);
            }
            JniCallInterceptor.onLoad(this.traceWriter, (JniAccessVerifier)verifier, this);
        }
        catch (Throwable t) {
            System.err.println(MESSAGE_PREFIX + t);
            return 4;
        }
        for (FileSystem fileSystem : temporaryFileSystems.values()) {
            try {
                fileSystem.close();
            }
            catch (IOException e2) {
                System.err.println("native-image-agent: restrict mode could not close jar filesystem " + fileSystem);
                e2.printStackTrace();
            }
        }
        this.setupExecutorServiceForPeriodicConfigurationCapture(configWritePeriod, configWritePeriodInitialDelay);
        return 0;
    }

    private static AccessAdvisor createAccessAdvisor(boolean builtinHeuristicFilter, RuleNode callerFilter, RuleNode accessFilter) {
        AccessAdvisor advisor = new AccessAdvisor();
        advisor.setHeuristicsEnabled(builtinHeuristicFilter);
        if (callerFilter != null) {
            advisor.setCallerFilterTree(callerFilter);
        }
        if (accessFilter != null) {
            advisor.setAccessFilterTree(accessFilter);
        }
        return advisor;
    }

    private static int parseIntegerOrNegative(String number) {
        try {
            return Integer.parseInt(number);
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }

    private static boolean parseFilterFiles(RuleNode filter, List<String> filterFiles) {
        for (String path : filterFiles) {
            try {
                FileReader reader = new FileReader(path);
                Throwable throwable = null;
                try {
                    new FilterConfigurationParser(filter).parseAndRegister(reader);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((Reader)reader).close();
                }
            }
            catch (Exception e) {
                System.err.println("native-image-agent: cannot parse filter file " + path + ": " + e);
                return false;
            }
        }
        filter.removeRedundantNodes();
        return true;
    }

    private void setupExecutorServiceForPeriodicConfigurationCapture(int writePeriod, int initialDelay) {
        if (this.traceWriter == null || this.configOutputDirPath == null) {
            return;
        }
        if (writePeriod == -1) {
            return;
        }
        this.periodicConfigWriterExecutor = new ScheduledThreadPoolExecutor(1, r -> {
            Thread workerThread = new Thread(r);
            workerThread.setDaemon(true);
            workerThread.setName("AgentConfigurationsPeriodicWriter");
            return workerThread;
        });
        this.periodicConfigWriterExecutor.setRemoveOnCancelPolicy(true);
        this.periodicConfigWriterExecutor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.periodicConfigWriterExecutor.scheduleAtFixedRate(this::writeConfigurationFiles, initialDelay, writePeriod, TimeUnit.SECONDS);
    }

    private static boolean addRestrictConfigs(JvmtiEnv jvmti, ConfigurationSet restrictConfigs, Map<URI, FileSystem> temporaryFileSystems) {
        Path workDir = Paths.get(".", new String[0]).toAbsolutePath().normalize();
        AddURI addURI = (target, classpathEntry, resourceLocation) -> {
            boolean added = false;
            if (Files.isDirectory(classpathEntry, new LinkOption[0])) {
                Path resourcePath = classpathEntry.resolve(Paths.get(resourceLocation, new String[0]));
                if (Files.isReadable(resourcePath)) {
                    added = target.add(resourcePath.toUri());
                }
            } else {
                URI jarFileURI = URI.create("jar:" + classpathEntry.toUri());
                try {
                    FileSystem prevJarFS = (FileSystem)temporaryFileSystems.get(jarFileURI);
                    FileSystem jarFS = prevJarFS == null ? FileSystems.newFileSystem(jarFileURI, Collections.emptyMap()) : prevJarFS;
                    Path resourcePath = jarFS.getPath("/" + resourceLocation, new String[0]);
                    if (Files.isReadable(resourcePath)) {
                        added = target.add(resourcePath.toUri());
                    }
                    if (prevJarFS == null) {
                        if (added) {
                            temporaryFileSystems.put(jarFileURI, jarFS);
                        } else {
                            jarFS.close();
                        }
                    }
                }
                catch (IOException e) {
                    System.err.println("native-image-agent: restrict mode could not access " + classpathEntry + " as a jar file");
                }
            }
            if (added) {
                System.err.println("native-image-agent: restrict mode added " + resourceLocation + " from " + workDir.relativize(classpathEntry));
            }
        };
        String classpath = Support.getSystemProperty((JvmtiEnv)jvmti, (String)"java.class.path");
        if (classpath == null) {
            System.err.println("native-image-agent: restrict mode could not determine classpath");
            return false;
        }
        try {
            Map extractionResults = NativeImage.extractEmbeddedImageArgs((Path)workDir, (String[])SubstrateUtil.split((String)classpath, (String)File.pathSeparator));
            extractionResults.forEach((cpEntry, imageArgs) -> {
                for (String imageArg : imageArgs) {
                    String[] optionParts = SubstrateUtil.split((String)imageArg, (String)"=");
                    String argName = optionParts[0];
                    if (oHJNIConfigurationResources.equals(argName)) {
                        addURI.add(restrictConfigs.getJniConfigPaths(), (Path)cpEntry, optionParts[1]);
                        continue;
                    }
                    if (oHReflectionConfigurationResources.equals(argName)) {
                        addURI.add(restrictConfigs.getReflectConfigPaths(), (Path)cpEntry, optionParts[1]);
                        continue;
                    }
                    if (oHDynamicProxyConfigurationResources.equals(argName)) {
                        addURI.add(restrictConfigs.getProxyConfigPaths(), (Path)cpEntry, optionParts[1]);
                        continue;
                    }
                    if (oHResourceConfigurationResources.equals(argName)) {
                        addURI.add(restrictConfigs.getResourceConfigPaths(), (Path)cpEntry, optionParts[1]);
                        continue;
                    }
                    if (!oHConfigurationResourceRoots.equals(argName)) continue;
                    String resourceLocation = optionParts[1];
                    addURI.add(restrictConfigs.getJniConfigPaths(), (Path)cpEntry, resourceLocation + "/" + "jni-config.json");
                    addURI.add(restrictConfigs.getReflectConfigPaths(), (Path)cpEntry, resourceLocation + "/" + "reflect-config.json");
                    addURI.add(restrictConfigs.getProxyConfigPaths(), (Path)cpEntry, resourceLocation + "/" + "proxy-config.json");
                    addURI.add(restrictConfigs.getResourceConfigPaths(), (Path)cpEntry, resourceLocation + "/" + "resource-config.json");
                }
            });
        }
        catch (NativeImage.NativeImageError err) {
            System.err.println("native-image-agent: restrict mode could not extract restrict configuration from classpath");
            err.printStackTrace();
            return false;
        }
        return true;
    }

    private static int buildImage(JvmtiEnv jvmti) {
        String[] keys;
        System.out.println("Building native image ...");
        String classpath = Support.getSystemProperty((JvmtiEnv)jvmti, (String)"java.class.path");
        if (classpath == null) {
            System.err.println("native-image-agent: build mode could not determine classpath");
            return 1;
        }
        String javaCommand = Support.getSystemProperty((JvmtiEnv)jvmti, (String)"sun.java.command");
        String mainClassMissing = "native-image-agent: build mode could not determine main class";
        if (javaCommand == null) {
            System.err.println(mainClassMissing);
            return 1;
        }
        String mainClass = SubstrateUtil.split((String)javaCommand, (String)" ")[0];
        if (mainClass.isEmpty()) {
            System.err.println(mainClassMissing);
            return 1;
        }
        ArrayList<String> buildArgs = new ArrayList<String>();
        for (String key : keys = Support.getSystemProperties((JvmtiEnv)jvmti)) {
            boolean blacklisted;
            boolean whitelisted = propertyWhitelist.matcher(key).matches();
            boolean bl = blacklisted = !whitelisted && propertyBlacklist.matcher(key).matches();
            if (blacklisted) continue;
            buildArgs.add("-D" + key + "=" + Support.getSystemProperty((JvmtiEnv)jvmti, (String)key));
        }
        if (mainClass.toLowerCase().endsWith(".jar")) {
            buildArgs.add("-jar");
        } else {
            buildArgs.addAll(Arrays.asList("-cp", classpath));
        }
        buildArgs.add(mainClass);
        String enableAgentRestrictArg = "-agentlib:native-image-agent=restrict";
        buildArgs.add(NativeImageAgent.oH(FallbackExecutor.Options.FallbackExecutorJavaArg) + "=" + enableAgentRestrictArg);
        buildArgs.add("native-image-agent.build");
        Path javaHome = Paths.get(Support.getSystemProperty((JvmtiEnv)jvmti, (String)"java.home"), new String[0]);
        String userDirStr = Support.getSystemProperty((JvmtiEnv)jvmti, (String)"user.dir");
        NativeImage.agentBuild((Path)javaHome, userDirStr == null ? null : Paths.get(userDirStr, new String[0]), buildArgs);
        return 0;
    }

    private static String transformPath(String path) {
        String result = path;
        if (result.contains("{pid}")) {
            result = result.replace("{pid}", Long.toString(ProcessProperties.getProcessID()));
        }
        if (result.contains("{datetime}")) {
            SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
            fmt.setTimeZone(UTC_TIMEZONE);
            result = result.replace("{datetime}", fmt.format(new Date()));
        }
        return result;
    }

    protected void onVMInitCallback(JvmtiEnv jvmti, JNIEnvironment jni, JNIObjectHandle thread) {
        this.accessAdvisor.setInLivePhase(true);
        BreakpointInterceptor.onVMInit(jvmti, jni);
        if (this.traceWriter != null) {
            this.traceWriter.tracePhaseChange("live");
        }
    }

    protected void onVMStartCallback(JvmtiEnv jvmti, JNIEnvironment jni) {
        JniCallInterceptor.onVMStart(jvmti);
        if (this.traceWriter != null) {
            this.traceWriter.tracePhaseChange("start");
        }
    }

    protected void onVMDeathCallback(JvmtiEnv jvmti, JNIEnvironment jni) {
        this.accessAdvisor.setInLivePhase(false);
        if (this.traceWriter != null) {
            this.traceWriter.tracePhaseChange("dead");
        }
    }

    private void writeConfigurationFiles() {
        try {
            Path tempDirectory = this.configOutputDirPath.toFile().exists() ? Files.createTempDirectory(this.configOutputDirPath, "tempConfig-", new FileAttribute[0]) : Files.createTempDirectory("tempConfig-", new FileAttribute[0]);
            TraceProcessor p = ((TraceProcessorWriterAdapter)this.traceWriter).getProcessor();
            HashMap<String, JsonPrintable> allConfigFiles = new HashMap<String, JsonPrintable>(4);
            allConfigFiles.put("reflect-config.json", p.getReflectionConfiguration());
            allConfigFiles.put("jni-config.json", p.getJniConfiguration());
            allConfigFiles.put("proxy-config.json", p.getProxyConfiguration());
            allConfigFiles.put("resource-config.json", p.getResourceConfiguration());
            for (Map.Entry configFile : allConfigFiles.entrySet()) {
                Path tempPath = tempDirectory.resolve((String)configFile.getKey());
                JsonWriter writer = new JsonWriter(tempPath, new OpenOption[0]);
                Throwable throwable = null;
                try {
                    ((JsonPrintable)configFile.getValue()).printJson(writer);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (writer == null) continue;
                    if (throwable != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    writer.close();
                }
            }
            for (Map.Entry configFile : allConfigFiles.entrySet()) {
                Path source = tempDirectory.resolve((String)configFile.getKey());
                Path target = this.configOutputDirPath.resolve((String)configFile.getKey());
                NativeImageAgent.tryAtomicMove(source, target);
            }
            NativeImageAgent.compulsoryDelete(tempDirectory);
        }
        catch (IOException e) {
            NativeImageAgent.printUpToLimit(currentFailuresWritingConfigs++, 5, "native-image-agent: error when writing configuration files: " + e.toString());
        }
    }

    private static void compulsoryDelete(Path pathToDelete) {
        int maxRetries = 3;
        for (int retries = 0; pathToDelete.toFile().exists() && !pathToDelete.toFile().delete() && retries < 3; ++retries) {
        }
    }

    private static void printUpToLimit(int currentCount, int limit, String message) {
        if (currentCount < limit) {
            System.err.println(message);
            return;
        }
        if (currentCount == limit) {
            System.err.println(message);
            System.err.println("native-image-agent: WARNING: The above failure will be silenced, and will no longer be reported");
        }
    }

    private static void tryAtomicMove(Path source, Path target) throws IOException {
        try {
            Files.move(source, target, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (AtomicMoveNotSupportedException e) {
            NativeImageAgent.printUpToLimit(currentFailuresAtomicMove++, 20, String.format("native-image-agent: : Could not move temporary configuration profile from (%s) to (%s) atomically. This might result in inconsistencies.", source.toAbsolutePath(), target.toAbsolutePath()));
            Files.move(source, target, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    protected int onUnloadCallback(JNIJavaVM vm) {
        if (this.periodicConfigWriterExecutor != null) {
            this.periodicConfigWriterExecutor.shutdown();
            try {
                this.periodicConfigWriterExecutor.awaitTermination(300L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ex) {
                this.periodicConfigWriterExecutor.shutdownNow();
            }
        }
        if (this.traceWriter != null) {
            this.traceWriter.tracePhaseChange("unload");
            this.traceWriter.close();
            if (this.configOutputDirPath != null) {
                this.writeConfigurationFiles();
                this.configOutputDirPath = null;
            }
            this.traceWriter = null;
        }
        return 0;
    }

    private static void cleanupOnUnload(JNIJavaVM vm) {
        JniCallInterceptor.onUnload();
        BreakpointInterceptor.onUnload();
    }

    public static class RegistrationFeature
    implements Feature {
        public void afterRegistration(Feature.AfterRegistrationAccess access) {
            NativeImageAgent.registerAgent((JvmtiAgentBase)new NativeImageAgent());
        }
    }

    static interface AddURI {
        public void add(Set<URI> var1, Path var2, String var3);
    }
}

