/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.agent.restrict;

import com.oracle.svm.agent.Support;
import com.oracle.svm.agent.jvmti.JvmtiError;
import com.oracle.svm.agent.restrict.AbstractAccessVerifier;
import com.oracle.svm.agent.restrict.TypeAccessChecker;
import com.oracle.svm.configure.trace.AccessAdvisor;
import com.oracle.svm.core.util.WordPredicate;
import com.oracle.svm.jni.JNIObjectHandles;
import com.oracle.svm.jni.nativeapi.JNIEnvironment;
import com.oracle.svm.jni.nativeapi.JNIFieldId;
import com.oracle.svm.jni.nativeapi.JNIMethodId;
import com.oracle.svm.jni.nativeapi.JNIObjectHandle;
import java.util.function.Supplier;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CCharPointerPointer;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public class ReflectAccessVerifier
extends AbstractAccessVerifier {
    private final TypeAccessChecker typeAccessChecker;

    public ReflectAccessVerifier(TypeAccessChecker typeAccessChecker, AccessAdvisor advisor) {
        super(advisor);
        this.typeAccessChecker = typeAccessChecker;
    }

    public boolean verifyForName(JNIEnvironment env, JNIObjectHandle callerClass, String className) {
        return this.verifyLoadClass(env, callerClass, className);
    }

    public boolean verifyLoadClass(JNIEnvironment env, JNIObjectHandle callerClass, String className) {
        if (this.shouldApproveWithoutChecks(env, callerClass)) {
            return true;
        }
        return className == null || this.typeAccessChecker.getConfiguration().get(className) != null;
    }

    public boolean verifyGetField(JNIEnvironment env, JNIObjectHandle clazz, JNIObjectHandle name, JNIObjectHandle result, JNIObjectHandle declaring, JNIObjectHandle callerClass) {
        if (this.shouldApproveWithoutChecks(env, callerClass)) {
            return true;
        }
        JNIFieldId field = Support.jniFunctions().getFromReflectedField().invoke(env, result);
        return field.isNull() || this.typeAccessChecker.isFieldAccessible(env, clazz, () -> Support.fromJniString(env, name), field, declaring);
    }

    public boolean verifyObjectFieldOffset(JNIEnvironment env, JNIObjectHandle name, JNIObjectHandle declaring, JNIObjectHandle callerClass) {
        if (this.shouldApproveWithoutChecks(env, callerClass)) {
            return true;
        }
        return this.typeAccessChecker.isFieldUnsafeAccessible(() -> Support.fromJniString(env, name), declaring);
    }

    public boolean verifyGetMethod(JNIEnvironment env, JNIObjectHandle clazz, String name, Supplier<String> signature, JNIObjectHandle result, JNIObjectHandle declaring, JNIObjectHandle callerClass) {
        if (this.shouldApproveWithoutChecks(env, callerClass)) {
            return true;
        }
        JNIMethodId method = Support.jniFunctions().getFromReflectedMethod().invoke(env, result);
        return this.verifyGetMethod0(env, clazz, name, signature, method, declaring);
    }

    public boolean verifyGetConstructor(JNIEnvironment env, JNIObjectHandle clazz, Supplier<String> signature, JNIObjectHandle result, JNIObjectHandle callerClass) {
        return this.verifyGetMethod(env, clazz, "<init>", signature, result, clazz, callerClass);
    }

    public boolean verifyNewInstance(JNIEnvironment env, JNIObjectHandle clazz, String name, String signature, JNIMethodId result, JNIObjectHandle callerClass) {
        if (this.shouldApproveWithoutChecks(env, callerClass)) {
            return true;
        }
        return this.verifyGetMethod0(env, clazz, name, () -> signature, result, clazz);
    }

    public boolean verifyNewArray(JNIEnvironment env, JNIObjectHandle arrayClass, JNIObjectHandle callerClass) {
        if (this.shouldApproveWithoutChecks(env, callerClass)) {
            return true;
        }
        return this.typeAccessChecker.getType(arrayClass) != null;
    }

    public boolean verifyGetEnclosingMethod(JNIEnvironment env, JNIObjectHandle clazz, String name, String signature, JNIObjectHandle result, JNIObjectHandle callerClass) {
        if (this.shouldApproveWithoutChecks(env, callerClass)) {
            return true;
        }
        JNIMethodId method = Support.jniFunctions().getFromReflectedMethod().invoke(env, result);
        return method.isNull() || this.typeAccessChecker.isMethodAccessible(env, clazz, name, () -> signature, method, clazz);
    }

    private boolean verifyGetMethod0(JNIEnvironment env, JNIObjectHandle clazz, String name, Supplier<String> signature, JNIMethodId method, JNIObjectHandle declaring) {
        return method.isNull() || this.typeAccessChecker.isMethodAccessible(env, clazz, name, signature, method, declaring);
    }

    public JNIObjectHandle filterGetFields(JNIEnvironment env, JNIObjectHandle clazz, JNIObjectHandle array, boolean declaredOnly, JNIObjectHandle callerClass) {
        if (this.shouldApproveWithoutChecks(env, callerClass)) {
            return array;
        }
        WordPredicate predicate = f -> this.shouldRetainField(env, clazz, (JNIObjectHandle)f, declaredOnly);
        return ReflectAccessVerifier.filterArray(env, array, () -> Support.handles().getJavaLangReflectField(env), (WordPredicate<JNIObjectHandle>)predicate);
    }

    public JNIObjectHandle filterGetMethods(JNIEnvironment env, JNIObjectHandle clazz, JNIObjectHandle array, Support.WordSupplier<JNIObjectHandle> elementClass, boolean declaredOnly, JNIObjectHandle callerClass) {
        if (this.shouldApproveWithoutChecks(env, callerClass)) {
            return array;
        }
        WordPredicate predicate = m -> this.shouldRetainMethod(env, clazz, (JNIObjectHandle)m, declaredOnly);
        return ReflectAccessVerifier.filterArray(env, array, elementClass, (WordPredicate<JNIObjectHandle>)predicate);
    }

    private boolean shouldRetainMethod(JNIEnvironment env, JNIObjectHandle clazz, JNIObjectHandle methodObj, boolean declaredOnly) {
        JNIMethodId method = Support.jniFunctions().getFromReflectedMethod().invoke(env, methodObj);
        if (method.isNonNull() && !Support.clearException(env)) {
            JNIObjectHandle declaring = (JNIObjectHandle)JNIObjectHandles.nullHandle();
            if (declaredOnly) {
                declaring = clazz;
            } else {
                WordPointer declaringPtr = (WordPointer)StackValue.get(WordPointer.class);
                if (Support.jvmtiFunctions().GetMethodDeclaringClass().invoke(Support.jvmtiEnv(), method, declaringPtr) == JvmtiError.JVMTI_ERROR_NONE) {
                    declaring = (JNIObjectHandle)declaringPtr.read();
                }
            }
            if (declaring.notEqual((ComparableWord)JNIObjectHandles.nullHandle())) {
                CCharPointerPointer namePtr = (CCharPointerPointer)StackValue.get(CCharPointerPointer.class);
                CCharPointerPointer signaturePtr = (CCharPointerPointer)StackValue.get(CCharPointerPointer.class);
                if (Support.jvmtiFunctions().GetMethodName().invoke(Support.jvmtiEnv(), method, namePtr, signaturePtr, (CCharPointerPointer)WordFactory.nullPointer()) == JvmtiError.JVMTI_ERROR_NONE) {
                    boolean accessible = this.typeAccessChecker.isMethodAccessible(env, clazz, Support.fromCString(namePtr.read()), () -> Support.fromCString(signaturePtr.read()), method, declaring);
                    Support.jvmtiFunctions().Deallocate().invoke(Support.jvmtiEnv(), (PointerBase)namePtr.read());
                    Support.jvmtiFunctions().Deallocate().invoke(Support.jvmtiEnv(), (PointerBase)signaturePtr.read());
                    if (accessible) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static JNIObjectHandle filterArray(JNIEnvironment env, JNIObjectHandle array, Support.WordSupplier<JNIObjectHandle> elementClass, WordPredicate<JNIObjectHandle> shouldRetain) {
        JNIObjectHandle result = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        int length = Support.jniFunctions().getGetArrayLength().invoke(env, array);
        if (length > 0 && !Support.clearException(env)) {
            int i;
            JNIObjectHandle[] newArrayContents = new JNIObjectHandle[length];
            int newLength = 0;
            for (i = 0; i < length; ++i) {
                JNIObjectHandle element = Support.jniFunctions().getGetObjectArrayElement().invoke(env, array, i);
                if (Support.clearException(env) || !shouldRetain.test((WordBase)element)) continue;
                newArrayContents[newLength] = element;
                ++newLength;
            }
            if (newLength == length) {
                result = array;
            } else {
                result = Support.jniFunctions().getNewObjectArray().invoke(env, newLength, elementClass.get(), (JNIObjectHandle)JNIObjectHandles.nullHandle());
                if (result.notEqual((ComparableWord)JNIObjectHandles.nullHandle()) && !Support.clearException(env)) {
                    for (i = 0; i < newLength; ++i) {
                        Support.jniFunctions().getSetObjectArrayElement().invoke(env, result, i, newArrayContents[i]);
                        if (!Support.clearException(env)) continue;
                        result = (JNIObjectHandle)JNIObjectHandles.nullHandle();
                        break;
                    }
                }
            }
        }
        return result;
    }

    private boolean shouldRetainField(JNIEnvironment env, JNIObjectHandle clazz, JNIObjectHandle fieldObj, boolean declaredOnly) {
        JNIFieldId field = Support.jniFunctions().getFromReflectedField().invoke(env, fieldObj);
        if (field.isNonNull() && !Support.clearException(env)) {
            Supplier<String> nameSupplier;
            JNIObjectHandle declaring = (JNIObjectHandle)JNIObjectHandles.nullHandle();
            if (declaredOnly) {
                declaring = clazz;
            } else {
                WordPointer declaringPtr = (WordPointer)StackValue.get(WordPointer.class);
                if (Support.jvmtiFunctions().GetFieldDeclaringClass().invoke(Support.jvmtiEnv(), clazz, field, declaringPtr) == JvmtiError.JVMTI_ERROR_NONE) {
                    declaring = (JNIObjectHandle)declaringPtr.read();
                }
            }
            if (declaring.notEqual((ComparableWord)JNIObjectHandles.nullHandle()) && this.typeAccessChecker.isFieldAccessible(env, clazz, nameSupplier = () -> Support.getFieldName(clazz, field), field, declaring)) {
                return true;
            }
        }
        return false;
    }
}

