/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.agent;

import com.oracle.svm.agent.jvmti.JvmtiEnv;
import com.oracle.svm.agent.jvmti.JvmtiError;
import com.oracle.svm.agent.jvmti.JvmtiFrameInfo;
import com.oracle.svm.agent.jvmti.JvmtiInterface;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.jni.JNIObjectHandles;
import com.oracle.svm.jni.nativeapi.JNIEnvironment;
import com.oracle.svm.jni.nativeapi.JNIErrors;
import com.oracle.svm.jni.nativeapi.JNIFieldId;
import com.oracle.svm.jni.nativeapi.JNIFunctionPointerTypes;
import com.oracle.svm.jni.nativeapi.JNIMethodId;
import com.oracle.svm.jni.nativeapi.JNINativeInterface;
import com.oracle.svm.jni.nativeapi.JNIObjectHandle;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.concurrent.locks.ReentrantLock;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CCharPointerPointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class Support {
    private static JvmtiEnv jvmtiEnv;
    private static JNINativeInterface jniFunctions;
    private static JavaHandles handles;

    public static boolean isInitialized() {
        boolean initialized = jvmtiEnv.isNonNull();
        assert (initialized == jniFunctions.isNonNull() && initialized == (handles != null));
        return initialized;
    }

    public static void initialize(JvmtiEnv jvmti, JNIEnvironment localJni) {
        VMError.guarantee((!Support.isInitialized() ? 1 : 0) != 0);
        WordPointer functionsPtr = (WordPointer)StackValue.get(WordPointer.class);
        Support.check(jvmti.getFunctions().GetJNIFunctionTable().invoke(jvmti, functionsPtr));
        VMError.guarantee((functionsPtr.read() != WordFactory.nullPointer() ? 1 : 0) != 0, (String)"Functions table must be initialized exactly once");
        jvmtiEnv = jvmti;
        jniFunctions = (JNINativeInterface)functionsPtr.read();
        handles = new JavaHandles(localJni);
    }

    public static void destroy(JNIEnvironment env) {
        Support.jvmtiFunctions().Deallocate().invoke(Support.jvmtiEnv(), (PointerBase)jniFunctions);
        Support.handles().destroy(env);
        handles = null;
        jniFunctions = (JNINativeInterface)WordFactory.nullPointer();
        jvmtiEnv = (JvmtiEnv)WordFactory.nullPointer();
    }

    static String getSystemProperty(JvmtiEnv jvmti, String propertyName) {
        try (CTypeConversion.CCharPointerHolder propertyKey = Support.toCString(propertyName);){
            String propertyValue = null;
            CCharPointerPointer propertyValuePtr = (CCharPointerPointer)StackValue.get(CCharPointerPointer.class);
            if (jvmti.getFunctions().GetSystemProperty().invoke(jvmti, propertyKey.get(), propertyValuePtr) == JvmtiError.JVMTI_ERROR_NONE) {
                propertyValue = Support.fromCString(propertyValuePtr.read());
                Support.check(jvmti.getFunctions().Deallocate().invoke(jvmti, (PointerBase)propertyValuePtr.read()));
            }
            String string = propertyValue;
            return string;
        }
    }

    static String[] getSystemProperties(JvmtiEnv jvmti) {
        CIntPointer countPtr = (CIntPointer)StackValue.get(CIntPointer.class);
        WordPointer propertyPtr = (WordPointer)StackValue.get(WordPointer.class);
        Support.check(jvmti.getFunctions().GetSystemProperties().invoke(jvmti, countPtr, propertyPtr));
        int numEntries = countPtr.read();
        CCharPointerPointer properties = (CCharPointerPointer)propertyPtr.read();
        String[] result = new String[numEntries];
        for (int i = 0; i < numEntries; ++i) {
            CCharPointer rawEntry = properties.read(i);
            result[i] = Support.fromCString(rawEntry);
            Support.check(jvmti.getFunctions().Deallocate().invoke(jvmti, (PointerBase)rawEntry));
        }
        Support.check(jvmti.getFunctions().Deallocate().invoke(jvmti, (PointerBase)properties));
        return result;
    }

    public static JvmtiEnv jvmtiEnv() {
        return jvmtiEnv;
    }

    public static JvmtiInterface jvmtiFunctions() {
        return jvmtiEnv.getFunctions();
    }

    public static JNINativeInterface jniFunctions() {
        return jniFunctions;
    }

    public static JavaHandles handles() {
        return handles;
    }

    public static String fromCString(CCharPointer s) {
        return CTypeConversion.toJavaString((CCharPointer)s, (UnsignedWord)SubstrateUtil.strlen((CCharPointer)s), (Charset)StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String fromJniString(JNIEnvironment env, JNIObjectHandle handle) {
        CCharPointer cstr;
        if (handle.notEqual((ComparableWord)JNIObjectHandles.nullHandle()) && (cstr = Support.jniFunctions().getGetStringUTFChars().invoke(env, handle, (CIntPointer)WordFactory.nullPointer())).isNonNull()) {
            try {
                String string = Support.fromCString(cstr);
                return string;
            }
            finally {
                Support.jniFunctions().getReleaseStringUTFChars().invoke(env, handle, cstr);
            }
        }
        return null;
    }

    public static CTypeConversion.CCharPointerHolder toCString(String s) {
        return CTypeConversion.toCString((CharSequence)s);
    }

    public static JNIObjectHandle getCallerClass(int depth) {
        return Support.getMethodDeclaringClass(Support.getCallerMethod(depth));
    }

    static JNIObjectHandle getDirectCallerClass() {
        return Support.getCallerClass(1);
    }

    public static JNIMethodId getCallerMethod(int depth) {
        JvmtiFrameInfo frameInfo = (JvmtiFrameInfo)StackValue.get(JvmtiFrameInfo.class);
        CIntPointer countPtr = (CIntPointer)StackValue.get(CIntPointer.class);
        JvmtiError result = Support.jvmtiFunctions().GetStackTrace().invoke(Support.jvmtiEnv(), (JNIObjectHandle)JNIObjectHandles.nullHandle(), depth, 1, frameInfo, countPtr);
        if (result == JvmtiError.JVMTI_ERROR_NONE && countPtr.read() == 1) {
            return frameInfo.getMethod();
        }
        return (JNIMethodId)WordFactory.nullPointer();
    }

    public static JNIObjectHandle getObjectArgument(int slot) {
        WordPointer handlePtr = (WordPointer)StackValue.get(WordPointer.class);
        if (Support.jvmtiFunctions().GetLocalObject().invoke(Support.jvmtiEnv(), (JNIObjectHandle)JNIObjectHandles.nullHandle(), 0, slot, (PointerBase)handlePtr) != JvmtiError.JVMTI_ERROR_NONE) {
            return (JNIObjectHandle)JNIObjectHandles.nullHandle();
        }
        return (JNIObjectHandle)handlePtr.read();
    }

    public static String getClassNameOr(JNIEnvironment env, JNIObjectHandle clazz, String forNullHandle, String forNullNameOrException) {
        if (clazz.notEqual((ComparableWord)JNIObjectHandles.nullHandle())) {
            JNIObjectHandle clazzName = ((JNIFunctionPointerTypes.CallObjectMethod0FunctionPointer)Support.jniFunctions().getCallObjectMethod()).invoke(env, clazz, Support.handles().javaLangClassGetName);
            String result = Support.fromJniString(env, clazzName);
            if (result == null || Support.clearException(env)) {
                result = forNullNameOrException;
            }
            return result;
        }
        return forNullHandle;
    }

    public static String getClassNameOrNull(JNIEnvironment env, JNIObjectHandle clazz) {
        return Support.getClassNameOr(env, clazz, null, null);
    }

    public static JNIObjectHandle getMethodDeclaringClass(JNIMethodId method) {
        WordPointer declaringClass = (WordPointer)StackValue.get(WordPointer.class);
        if (method.isNull() || Support.jvmtiFunctions().GetMethodDeclaringClass().invoke(Support.jvmtiEnv(), method, declaringClass) != JvmtiError.JVMTI_ERROR_NONE) {
            declaringClass.write((WordBase)WordFactory.nullPointer());
        }
        return (JNIObjectHandle)declaringClass.read();
    }

    public static JNIObjectHandle getFieldDeclaringClass(JNIObjectHandle clazz, JNIFieldId method) {
        WordPointer declaringClass = (WordPointer)StackValue.get(WordPointer.class);
        if (method.isNull() || Support.jvmtiFunctions().GetFieldDeclaringClass().invoke(Support.jvmtiEnv(), clazz, method, declaringClass) != JvmtiError.JVMTI_ERROR_NONE) {
            declaringClass.write((WordBase)WordFactory.nullPointer());
        }
        return (JNIObjectHandle)declaringClass.read();
    }

    public static String getFieldName(JNIObjectHandle clazz, JNIFieldId field) {
        String name = null;
        CCharPointerPointer namePtr = (CCharPointerPointer)StackValue.get(CCharPointerPointer.class);
        if (Support.jvmtiFunctions().GetFieldName().invoke(Support.jvmtiEnv(), clazz, field, namePtr, (CCharPointerPointer)WordFactory.nullPointer(), (CCharPointerPointer)WordFactory.nullPointer()) == JvmtiError.JVMTI_ERROR_NONE) {
            name = Support.fromCString(namePtr.read());
            Support.jvmtiFunctions().Deallocate().invoke(Support.jvmtiEnv(), (PointerBase)namePtr.read());
        }
        return name;
    }

    public static boolean clearException(JNIEnvironment localEnv) {
        if (Support.jniFunctions().getExceptionCheck().invoke(localEnv)) {
            Support.jniFunctions().getExceptionClear().invoke(localEnv);
            return true;
        }
        return false;
    }

    public static boolean testException(JNIEnvironment localEnv) {
        if (Support.jniFunctions().getExceptionCheck().invoke(localEnv)) {
            Support.jniFunctions().getExceptionDescribe().invoke(localEnv);
            return true;
        }
        return false;
    }

    public static void checkNoException(JNIEnvironment localEnv) {
        VMError.guarantee((!Support.testException(localEnv) ? 1 : 0) != 0);
    }

    public static void check(JvmtiError resultCode) {
        VMError.guarantee((boolean)resultCode.equals((Object)JvmtiError.JVMTI_ERROR_NONE));
    }

    public static void checkJni(int resultCode) {
        VMError.guarantee((resultCode == JNIErrors.JNI_OK() ? 1 : 0) != 0);
    }

    private Support() {
    }

    public static interface WordSupplier<T extends WordBase> {
        public T get();
    }

    public static final class JavaHandles {
        private final ReentrantLock globalRefsLock = new ReentrantLock();
        private JNIObjectHandle[] globalRefs = new JNIObjectHandle[16];
        private int globalRefCount = 0;
        public final JNIMethodId javaLangClassGetName;
        public final JNIMethodId javaLangClassForName3;
        public final JNIMethodId javaLangReflectMemberGetName;
        public final JNIMethodId javaLangReflectMemberGetDeclaringClass;
        public final JNIMethodId javaUtilEnumerationHasMoreElements;
        public final JNIMethodId javaUtilMissingResourceExceptionCtor3;
        public final JNIObjectHandle javaLangClassLoader;
        public final JNIObjectHandle javaLangSecurityException;
        public final JNIObjectHandle javaLangNoClassDefFoundError;
        public final JNIObjectHandle javaLangNoSuchMethodError;
        public final JNIObjectHandle javaLangNoSuchMethodException;
        public final JNIObjectHandle javaLangNoSuchFieldError;
        public final JNIObjectHandle javaLangNoSuchFieldException;
        public final JNIObjectHandle javaLangClassNotFoundException;
        public final JNIObjectHandle javaLangRuntimeException;
        public final JNIObjectHandle javaUtilMissingResourceException;
        private JNIObjectHandle javaLangReflectField;
        private JNIObjectHandle javaLangReflectMethod;
        private JNIObjectHandle javaLangReflectConstructor;
        private JNIObjectHandle javaUtilCollections;
        private JNIMethodId javaUtilCollectionsEmptyEnumeration;
        private JNIMethodId javaUtilResourceBundleGetBundleImplSLCC;
        private boolean queriedJavaUtilResourceBundleGetBundleImplSLCC;

        private JavaHandles(JNIEnvironment env) {
            JNIObjectHandle javaLangClass = JavaHandles.findClass(env, "java/lang/Class");
            try (CTypeConversion.CCharPointerHolder name = Support.toCString("getName");
                 CTypeConversion.CCharPointerHolder signature = Support.toCString("()Ljava/lang/String;");){
                this.javaLangClassGetName = jniFunctions.getGetMethodID().invoke(env, javaLangClass, name.get(), signature.get());
                VMError.guarantee((boolean)this.javaLangClassGetName.isNonNull());
            }
            this.javaLangClassForName3 = JavaHandles.getMethodId(env, javaLangClass, "forName", "(Ljava/lang/String;ZLjava/lang/ClassLoader;)Ljava/lang/Class;", true);
            JNIObjectHandle javaLangReflectMember = JavaHandles.findClass(env, "java/lang/reflect/Member");
            this.javaLangReflectMemberGetName = JavaHandles.getMethodId(env, javaLangReflectMember, "getName", "()Ljava/lang/String;", false);
            this.javaLangReflectMemberGetDeclaringClass = JavaHandles.getMethodId(env, javaLangReflectMember, "getDeclaringClass", "()Ljava/lang/Class;", false);
            JNIObjectHandle javaUtilEnumeration = JavaHandles.findClass(env, "java/util/Enumeration");
            this.javaUtilEnumerationHasMoreElements = JavaHandles.getMethodId(env, javaUtilEnumeration, "hasMoreElements", "()Z", false);
            this.javaLangClassLoader = this.newClassGlobalRef(env, "java/lang/ClassLoader");
            this.javaLangSecurityException = this.newClassGlobalRef(env, "java/lang/SecurityException");
            this.javaLangNoClassDefFoundError = this.newClassGlobalRef(env, "java/lang/NoClassDefFoundError");
            this.javaLangNoSuchMethodError = this.newClassGlobalRef(env, "java/lang/NoSuchMethodError");
            this.javaLangNoSuchMethodException = this.newClassGlobalRef(env, "java/lang/NoSuchMethodException");
            this.javaLangNoSuchFieldError = this.newClassGlobalRef(env, "java/lang/NoSuchFieldError");
            this.javaLangNoSuchFieldException = this.newClassGlobalRef(env, "java/lang/NoSuchFieldException");
            this.javaLangClassNotFoundException = this.newClassGlobalRef(env, "java/lang/ClassNotFoundException");
            this.javaLangRuntimeException = this.newClassGlobalRef(env, "java/lang/RuntimeException");
            this.javaUtilMissingResourceException = this.newClassGlobalRef(env, "java/util/MissingResourceException");
            this.javaUtilMissingResourceExceptionCtor3 = JavaHandles.getMethodId(env, this.javaUtilMissingResourceException, "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", false);
        }

        private static JNIObjectHandle findClass(JNIEnvironment env, String className) {
            try (CTypeConversion.CCharPointerHolder name = Support.toCString(className);){
                JNIObjectHandle h = jniFunctions.getFindClass().invoke(env, name.get());
                VMError.guarantee((boolean)h.notEqual((ComparableWord)JNIObjectHandles.nullHandle()));
                JNIObjectHandle jNIObjectHandle = h;
                return jNIObjectHandle;
            }
        }

        private JNIObjectHandle newClassGlobalRef(JNIEnvironment env, String className) {
            return this.newTrackedGlobalRef(env, JavaHandles.findClass(env, className));
        }

        private static JNIMethodId getMethodId(JNIEnvironment env, JNIObjectHandle clazz, String name, String signature, boolean isStatic) {
            JNIMethodId id = JavaHandles.getMethodIdOptional(env, clazz, name, signature, isStatic);
            VMError.guarantee((boolean)id.isNonNull());
            return id;
        }

        /*
         * Exception decompiling
         */
        private static JNIMethodId getMethodIdOptional(JNIEnvironment env, JNIObjectHandle clazz, String name, String signature, boolean isStatic) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JNIObjectHandle newTrackedGlobalRef(JNIEnvironment env, JNIObjectHandle ref) {
            JNIObjectHandle global = jniFunctions.getNewGlobalRef().invoke(env, ref);
            VMError.guarantee((boolean)global.notEqual((ComparableWord)JNIObjectHandles.nullHandle()));
            this.globalRefsLock.lock();
            try {
                if (this.globalRefCount == this.globalRefs.length) {
                    this.globalRefs = Arrays.copyOf(this.globalRefs, this.globalRefs.length * 2);
                }
                this.globalRefs[this.globalRefCount] = global;
                ++this.globalRefCount;
            }
            finally {
                this.globalRefsLock.unlock();
            }
            return global;
        }

        public JNIObjectHandle getJavaLangReflectField(JNIEnvironment env) {
            if (this.javaLangReflectField.equal((ComparableWord)JNIObjectHandles.nullHandle())) {
                this.javaLangReflectField = this.newClassGlobalRef(env, "java/lang/reflect/Field");
            }
            return this.javaLangReflectField;
        }

        public JNIObjectHandle getJavaLangReflectMethod(JNIEnvironment env) {
            if (this.javaLangReflectMethod.equal((ComparableWord)JNIObjectHandles.nullHandle())) {
                this.javaLangReflectMethod = this.newClassGlobalRef(env, "java/lang/reflect/Method");
            }
            return this.javaLangReflectMethod;
        }

        public JNIObjectHandle getJavaLangReflectConstructor(JNIEnvironment env) {
            if (this.javaLangReflectConstructor.equal((ComparableWord)JNIObjectHandles.nullHandle())) {
                this.javaLangReflectConstructor = this.newClassGlobalRef(env, "java/lang/reflect/Constructor");
            }
            return this.javaLangReflectConstructor;
        }

        public JNIObjectHandle getJavaUtilCollections(JNIEnvironment env) {
            if (this.javaUtilCollections.equal((ComparableWord)JNIObjectHandles.nullHandle())) {
                this.javaUtilCollections = this.newClassGlobalRef(env, "java/util/Collections");
            }
            return this.javaUtilCollections;
        }

        public JNIMethodId getJavaUtilCollectionsEmptyEnumeration(JNIEnvironment env) {
            if (this.javaUtilCollectionsEmptyEnumeration.isNull()) {
                this.javaUtilCollectionsEmptyEnumeration = JavaHandles.getMethodId(env, this.getJavaUtilCollections(env), "emptyEnumeration", "()Ljava/util/Enumeration;", true);
            }
            return this.javaUtilCollectionsEmptyEnumeration;
        }

        public JNIMethodId tryGetJavaUtilResourceBundleGetBundleImplSLCC(JNIEnvironment env) {
            if (!this.queriedJavaUtilResourceBundleGetBundleImplSLCC) {
                JNIObjectHandle javaUtilResourceBundle = JavaHandles.findClass(env, "java/util/ResourceBundle");
                this.javaUtilResourceBundleGetBundleImplSLCC = JavaHandles.getMethodIdOptional(env, javaUtilResourceBundle, "getBundleImpl", "(Ljava/lang/String;Ljava/util/Locale;Ljava/lang/Class;Ljava/util/ResourceBundle$Control;)Ljava/util/ResourceBundle;", true);
                this.queriedJavaUtilResourceBundleGetBundleImplSLCC = true;
            }
            return this.javaUtilResourceBundleGetBundleImplSLCC;
        }

        public void destroy(JNIEnvironment env) {
            for (int i = 0; i < this.globalRefCount; ++i) {
                Support.jniFunctions().getDeleteGlobalRef().invoke(env, this.globalRefs[i]);
            }
        }
    }
}

