/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.trace;

import com.oracle.svm.configure.config.ConfigurationMemberKind;
import com.oracle.svm.configure.config.ProxyConfiguration;
import com.oracle.svm.configure.config.ResourceConfiguration;
import com.oracle.svm.configure.config.SignatureUtil;
import com.oracle.svm.configure.config.TypeConfiguration;
import com.oracle.svm.configure.trace.AbstractProcessor;
import com.oracle.svm.configure.trace.AccessAdvisor;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.graalvm.compiler.phases.common.LazyValue;

class ReflectionProcessor
extends AbstractProcessor {
    private final AccessAdvisor advisor;
    private final TypeConfiguration configuration;
    private final ProxyConfiguration proxyConfiguration;
    private final ResourceConfiguration resourceConfiguration;

    ReflectionProcessor(AccessAdvisor advisor, TypeConfiguration typeConfiguration, ProxyConfiguration proxyConfiguration, ResourceConfiguration resourceConfiguration) {
        this.advisor = advisor;
        this.configuration = typeConfiguration;
        this.proxyConfiguration = proxyConfiguration;
        this.resourceConfiguration = resourceConfiguration;
    }

    public TypeConfiguration getConfiguration() {
        return this.configuration;
    }

    public ProxyConfiguration getProxyConfiguration() {
        return this.proxyConfiguration;
    }

    public ResourceConfiguration getResourceConfiguration() {
        return this.resourceConfiguration;
    }

    @Override
    public void processEntry(Map<String, ?> entry) {
        boolean invalidResult = Boolean.FALSE.equals(entry.get("result"));
        if (invalidResult) {
            return;
        }
        String function = (String)entry.get("function");
        List args = (List)entry.get("args");
        switch (function) {
            case "getResource": 
            case "getResourceAsStream": 
            case "getSystemResource": 
            case "getSystemResourceAsStream": 
            case "getResources": 
            case "getSystemResources": {
                this.resourceConfiguration.add((String)ReflectionProcessor.singleElement(args));
                return;
            }
        }
        String clazz = (String)entry.get("class");
        String callerClass = (String)entry.get("caller_class");
        if (this.advisor.shouldIgnore((LazyValue<String>)new LazyValue(() -> callerClass))) {
            return;
        }
        ConfigurationMemberKind memberKind = ConfigurationMemberKind.PUBLIC;
        boolean unsafeAccess = false;
        String clazzOrDeclaringClass = entry.containsKey("declaring_class") ? (String)entry.get("declaring_class") : clazz;
        switch (function) {
            case "forName": {
                assert (clazz.equals("java.lang.Class"));
                ReflectionProcessor.expectSize(args, 1);
                String name = (String)args.get(0);
                this.configuration.getOrCreateType(name);
                break;
            }
            case "getDeclaredFields": {
                this.configuration.getOrCreateType(clazz).setAllDeclaredFields();
                break;
            }
            case "getFields": {
                this.configuration.getOrCreateType(clazz).setAllPublicFields();
                break;
            }
            case "getDeclaredMethods": {
                this.configuration.getOrCreateType(clazz).setAllDeclaredMethods();
                break;
            }
            case "getMethods": {
                this.configuration.getOrCreateType(clazz).setAllPublicMethods();
                break;
            }
            case "getDeclaredConstructors": {
                this.configuration.getOrCreateType(clazz).setAllDeclaredConstructors();
                break;
            }
            case "getConstructors": {
                this.configuration.getOrCreateType(clazz).setAllPublicConstructors();
                break;
            }
            case "objectFieldOffset": {
                unsafeAccess = true;
            }
            case "getDeclaredField": {
                memberKind = ConfigurationMemberKind.DECLARED;
            }
            case "getField": {
                this.configuration.getOrCreateType(clazzOrDeclaringClass).addField((String)ReflectionProcessor.singleElement(args), memberKind, false, unsafeAccess);
                break;
            }
            case "getDeclaredMethod": {
                memberKind = ConfigurationMemberKind.DECLARED;
            }
            case "getMethod": {
                ReflectionProcessor.expectSize(args, 2);
                String name = (String)args.get(0);
                List parameterTypes = (List)args.get(1);
                if (parameterTypes == null) {
                    parameterTypes = Collections.emptyList();
                }
                this.configuration.getOrCreateType(clazzOrDeclaringClass).addMethod(name, SignatureUtil.toInternalSignature(parameterTypes), memberKind);
                break;
            }
            case "getDeclaredConstructor": {
                memberKind = ConfigurationMemberKind.DECLARED;
            }
            case "getConstructor": {
                List parameterTypes = (List)ReflectionProcessor.singleElement(args);
                if (parameterTypes == null) {
                    parameterTypes = Collections.emptyList();
                }
                String signature = SignatureUtil.toInternalSignature(parameterTypes);
                this.configuration.getOrCreateType(clazzOrDeclaringClass).addMethod("<init>", signature, memberKind);
                break;
            }
            case "getProxyClass": {
                ReflectionProcessor.expectSize(args, 2);
                this.addDynamicProxy((List)args.get(1));
                break;
            }
            case "newProxyInstance": {
                ReflectionProcessor.expectSize(args, 3);
                this.addDynamicProxy((List)args.get(1));
                break;
            }
            case "getEnclosingConstructor": 
            case "getEnclosingMethod": {
                String result = (String)entry.get("result");
                this.addFullyQualifiedDeclaredMethod(result);
                break;
            }
            case "newInstance": {
                this.configuration.getOrCreateType(clazz).addMethod("<init>", "()V", ConfigurationMemberKind.DECLARED);
            }
        }
    }

    private void addFullyQualifiedDeclaredMethod(String descriptor) {
        int sigbegin = descriptor.indexOf(40);
        int classend = descriptor.lastIndexOf(46, sigbegin - 1);
        String qualifiedClass = descriptor.substring(0, classend);
        String methodName = descriptor.substring(classend + 1, sigbegin);
        String signature = descriptor.substring(sigbegin);
        this.configuration.getOrCreateType(qualifiedClass).addMethod(methodName, signature, ConfigurationMemberKind.DECLARED);
    }

    private void addDynamicProxy(List<?> interfaceList) {
        this.proxyConfiguration.add(interfaceList);
    }
}

