/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.agent.restrict;

import com.oracle.svm.agent.Support;
import com.oracle.svm.agent.jvmti.JvmtiError;
import com.oracle.svm.agent.restrict.AbstractAccessVerifier;
import com.oracle.svm.agent.restrict.TypeAccessChecker;
import com.oracle.svm.configure.trace.AccessAdvisor;
import com.oracle.svm.jni.nativeapi.JNIEnvironment;
import com.oracle.svm.jni.nativeapi.JNIFieldId;
import com.oracle.svm.jni.nativeapi.JNIMethodId;
import com.oracle.svm.jni.nativeapi.JNIObjectHandle;
import org.graalvm.compiler.phases.common.LazyValue;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.c.type.WordPointer;

public class JniAccessVerifier
extends AbstractAccessVerifier {
    private final TypeAccessChecker typeAccessChecker;
    private final TypeAccessChecker reflectTypeAccessChecker;

    public JniAccessVerifier(TypeAccessChecker typeAccessChecker, TypeAccessChecker reflectTypeAccessChecker, AccessAdvisor advisor) {
        super(advisor);
        this.typeAccessChecker = typeAccessChecker;
        this.reflectTypeAccessChecker = reflectTypeAccessChecker;
    }

    public boolean verifyDefineClass(JNIEnvironment env, CCharPointer name, JNIObjectHandle loader, CCharPointer buf, int bufLen, JNIObjectHandle callerClass) {
        if (this.shouldApproveWithoutChecks(env, callerClass)) {
            return true;
        }
        try (CTypeConversion.CCharPointerHolder message = Support.toCString("native-image-agent: defining classes is not permitted.");){
            Support.jniFunctions().getThrowNew().invoke(env, Support.handles().javaLangSecurityException, message.get());
        }
        return false;
    }

    public boolean verifyFindClass(JNIEnvironment env, CCharPointer cname, JNIObjectHandle callerClass) {
        if (this.shouldApproveWithoutChecks(env, callerClass)) {
            return true;
        }
        String name = Support.fromCString(cname);
        if (name != null) {
            if (!name.startsWith("[") && name.length() > 1) {
                name = "L" + name + ";";
            }
            if (this.typeAccessChecker.getConfiguration().getByInternalName(name) != null) {
                return true;
            }
        }
        try (CTypeConversion.CCharPointerHolder message = Support.toCString("native-image-agent: configuration does not permit access to class: " + name);){
            Support.jniFunctions().getThrowNew().invoke(env, Support.handles().javaLangNoClassDefFoundError, message.get());
        }
        return false;
    }

    public boolean verifyGetMethodID(JNIEnvironment env, JNIObjectHandle clazz, CCharPointer cname, CCharPointer csignature, JNIMethodId result, JNIObjectHandle callerClass) {
        JNIObjectHandle declaring;
        assert (result.isNonNull());
        String name = Support.fromCString(cname);
        if (this.accessAdvisor.shouldIgnoreJniMethodLookup((LazyValue<String>)new LazyValue(() -> Support.getClassNameOrNull(env, clazz)), (LazyValue<String>)new LazyValue(() -> name), (LazyValue<String>)new LazyValue(() -> Support.fromCString(csignature)), (LazyValue<String>)new LazyValue(() -> Support.getClassNameOrNull(env, callerClass)))) {
            return true;
        }
        WordPointer declaringPtr = (WordPointer)StackValue.get(WordPointer.class);
        if (Support.jvmtiFunctions().GetMethodDeclaringClass().invoke(Support.jvmtiEnv(), result, declaringPtr) == JvmtiError.JVMTI_ERROR_NONE && this.typeAccessChecker.isMethodAccessible(env, clazz, name, () -> Support.fromCString(csignature), result, declaring = (JNIObjectHandle)declaringPtr.read())) {
            return true;
        }
        try (CTypeConversion.CCharPointerHolder message = Support.toCString("native-image-agent: configuration does not permit access to method: " + Support.getClassNameOr(env, clazz, "(null)", "(?)") + "." + name + Support.fromCString(csignature));){
            Support.jniFunctions().getThrowNew().invoke(env, Support.handles().javaLangNoSuchMethodError, message.get());
        }
        return false;
    }

    public boolean verifyGetFieldID(JNIEnvironment env, JNIObjectHandle clazz, CCharPointer cname, CCharPointer csignature, JNIFieldId result, JNIObjectHandle callerClass) {
        JNIObjectHandle declaring;
        assert (result.isNonNull());
        if (this.shouldApproveWithoutChecks(env, callerClass)) {
            return true;
        }
        WordPointer declaringPtr = (WordPointer)StackValue.get(WordPointer.class);
        if (Support.jvmtiFunctions().GetFieldDeclaringClass().invoke(Support.jvmtiEnv(), clazz, result, declaringPtr) == JvmtiError.JVMTI_ERROR_NONE && this.typeAccessChecker.isFieldAccessible(env, clazz, () -> Support.fromCString(cname), result, declaring = (JNIObjectHandle)declaringPtr.read())) {
            return true;
        }
        try (CTypeConversion.CCharPointerHolder message = Support.toCString("native-image-agent: configuration does not permit access to field: " + Support.getClassNameOr(env, clazz, "(null)", "(?)") + "." + Support.fromCString(cname));){
            Support.jniFunctions().getThrowNew().invoke(env, Support.handles().javaLangNoSuchFieldError, message.get());
        }
        return false;
    }

    public boolean verifyThrowNew(JNIEnvironment env, JNIObjectHandle clazz, JNIObjectHandle callerClass) {
        JNIMethodId result;
        String name = "<init>";
        String signature = "(Ljava/lang/String;)V";
        if (this.accessAdvisor.shouldIgnoreJniMethodLookup((LazyValue<String>)new LazyValue(() -> Support.getClassNameOrNull(env, clazz)), (LazyValue<String>)new LazyValue(() -> name), (LazyValue<String>)new LazyValue(() -> signature), (LazyValue<String>)new LazyValue(() -> Support.getClassNameOrNull(env, callerClass)))) {
            return true;
        }
        try (CTypeConversion.CCharPointerHolder cname = Support.toCString(name);
             CTypeConversion.CCharPointerHolder csignature = Support.toCString(signature);){
            result = Support.jniFunctions().getGetMethodID().invoke(env, clazz, cname.get(), csignature.get());
        }
        return result.isNull() || this.typeAccessChecker.isMethodAccessible(env, clazz, name, () -> signature, result, clazz);
    }

    public boolean verifyFromReflectedMethod(JNIEnvironment env, JNIObjectHandle declaring, String name, String signature, JNIMethodId result, JNIObjectHandle callerClass) {
        assert (result.isNonNull());
        if (this.shouldApproveWithoutChecks(env, callerClass)) {
            return true;
        }
        return this.typeAccessChecker.isMethodAccessible(env, declaring, name, () -> signature, result, declaring);
    }

    public boolean verifyFromReflectedField(JNIEnvironment env, JNIObjectHandle declaring, String name, JNIFieldId result, JNIObjectHandle callerClass) {
        assert (result.isNonNull());
        if (this.shouldApproveWithoutChecks(env, callerClass)) {
            return true;
        }
        return this.typeAccessChecker.isFieldAccessible(env, declaring, () -> name, result, declaring);
    }

    public boolean verifyToReflectedMethod(JNIEnvironment env, JNIObjectHandle clazz, JNIObjectHandle declaring, JNIMethodId methodId, String name, String signature, JNIObjectHandle callerClass) {
        assert (methodId.isNonNull());
        if (this.reflectTypeAccessChecker == null) {
            return true;
        }
        if (this.shouldApproveWithoutChecks(env, callerClass)) {
            return true;
        }
        return this.reflectTypeAccessChecker.isMethodAccessible(env, clazz, name, () -> signature, methodId, declaring);
    }

    public boolean verifyToReflectedField(JNIEnvironment env, JNIObjectHandle clazz, JNIObjectHandle declaring, String name, JNIFieldId fieldId, JNIObjectHandle callerClass) {
        assert (fieldId.isNonNull());
        if (this.reflectTypeAccessChecker == null) {
            return true;
        }
        if (this.shouldApproveWithoutChecks(env, callerClass)) {
            return true;
        }
        return this.reflectTypeAccessChecker.isFieldAccessible(env, clazz, () -> name, fieldId, declaring);
    }
}

