/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.util;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public final class ConcurrentLightHashSet {
    private ConcurrentLightHashSet() {
    }

    public static int size(Object elements) {
        if (elements == null) {
            return 0;
        }
        if (elements instanceof ConcurrentHashMap) {
            ConcurrentHashMap elementsMap = (ConcurrentHashMap)elements;
            return elementsMap.size();
        }
        return 1;
    }

    public static <T, U> boolean addElement(U holder, AtomicReferenceFieldUpdater<U, Object> updater, T newElement) {
        Object oldElements;
        block5: {
            assert (newElement != null);
            while (true) {
                if ((oldElements = updater.get(holder)) == null) {
                    if (!updater.compareAndSet(holder, oldElements, newElement)) continue;
                    return true;
                }
                if (oldElements instanceof ConcurrentHashMap) {
                    ConcurrentHashMap elementsMap = (ConcurrentHashMap)oldElements;
                    return elementsMap.putIfAbsent(newElement, Boolean.TRUE) == null;
                }
                if (oldElements == newElement) break block5;
                ConcurrentHashMap<Object, Boolean> newElements = new ConcurrentHashMap<Object, Boolean>();
                newElements.put(oldElements, Boolean.TRUE);
                newElements.put(newElement, Boolean.TRUE);
                if (updater.compareAndSet(holder, oldElements, newElements)) break;
            }
            return true;
        }
        assert (oldElements == newElement);
        return false;
    }

    public static <T, U> Collection<T> getElements(U holder, AtomicReferenceFieldUpdater<U, Object> updater) {
        Object u = updater.get(holder);
        if (u == null) {
            return Collections.emptySet();
        }
        if (u instanceof ConcurrentHashMap) {
            ConcurrentHashMap elementsMap = (ConcurrentHashMap)u;
            return elementsMap.keySet();
        }
        return Collections.singleton(u);
    }

    public static <T, U> boolean removeElement(U holder, AtomicReferenceFieldUpdater<U, Object> updater, T element) {
        block2: {
            Object e;
            do {
                if ((e = updater.get(holder)) instanceof ConcurrentHashMap) {
                    ConcurrentHashMap elementsMap = (ConcurrentHashMap)e;
                    return elementsMap.remove(element) != null;
                }
                if (!element.equals(e)) break block2;
            } while (!updater.compareAndSet(holder, e, null));
            return true;
        }
        return false;
    }

    public static <U> void clear(U holder, AtomicReferenceFieldUpdater<U, Object> updater) {
        updater.set(holder, null);
    }
}

