/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.results;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.flow.FormalParamTypeFlow;
import com.oracle.graal.pointsto.flow.InstanceOfTypeFlow;
import com.oracle.graal.pointsto.flow.InvokeTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.MethodTypeFlow;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.BytecodeLocation;
import com.oracle.graal.pointsto.infrastructure.Universe;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.results.StaticAnalysisResults;
import com.oracle.graal.pointsto.typestate.TypeState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaMethodProfile;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.JavaTypeProfile;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.TriState;

public class StaticAnalysisResultsBuilder {
    private final BigBang bb;
    protected final Universe converter;
    private final JavaTypeProfile[] types0;
    private final JavaTypeProfile[] types1Null;
    private final JavaTypeProfile[] types1NonNull;
    private final Map<JavaTypeProfile, JavaTypeProfile> types;
    private final JavaMethodProfile[] methods0;
    private final JavaMethodProfile[] methods1;
    private final Map<JavaMethodProfile, JavaMethodProfile> methods;

    public StaticAnalysisResultsBuilder(BigBang bb, Universe converter) {
        this.bb = bb;
        this.converter = converter;
        this.types0 = new JavaTypeProfile[2];
        this.types1Null = new JavaTypeProfile[bb.getUniverse().getNextTypeId()];
        this.types1NonNull = new JavaTypeProfile[bb.getUniverse().getNextTypeId()];
        this.types = new HashMap<JavaTypeProfile, JavaTypeProfile>();
        this.methods0 = new JavaMethodProfile[1];
        this.methods1 = new JavaMethodProfile[bb.getUniverse().getNextMethodId()];
        this.methods = new HashMap<JavaMethodProfile, JavaMethodProfile>();
    }

    /*
     * WARNING - void declaration
     */
    public StaticAnalysisResults makeResults(AnalysisMethod method) {
        void var9_14;
        int bci;
        MethodTypeFlow methodFlow = method.getTypeFlow();
        MethodFlowsGraph originalFlows = methodFlow.getOriginalMethodFlows();
        ArrayList<Object> paramProfiles = new ArrayList<Object>(originalFlows.getParameters().length);
        for (int i = 0; i < originalFlows.getParameters().length; ++i) {
            TypeState paramTypeState;
            Object paramProfile;
            FormalParamTypeFlow parameter = originalFlows.getParameter(i);
            if (parameter == null || methodFlow.isSaturated(this.bb, parameter) || (paramProfile = this.makeTypeProfile(paramTypeState = methodFlow.foldTypeFlow(this.bb, parameter))) == null) continue;
            StaticAnalysisResultsBuilder.ensureSize(paramProfiles, i);
            paramProfiles.set(i, paramProfile);
        }
        JavaTypeProfile[] parameterTypeProfiles = null;
        if (paramProfiles.size() > 0) {
            parameterTypeProfiles = paramProfiles.toArray(new JavaTypeProfile[paramProfiles.size()]);
        }
        JavaTypeProfile resultTypeProfile = this.makeTypeProfile(methodFlow.foldTypeFlow(this.bb, originalFlows.getResult()));
        ArrayList<StaticAnalysisResults.BytecodeEntry> entries = new ArrayList<StaticAnalysisResults.BytecodeEntry>(method.getCodeSize());
        for (Map.Entry entry : originalFlows.getInstanceOfFlows()) {
            if (!BytecodeLocation.isValidBci(entry.getKey())) continue;
            bci = (Integer)entry.getKey();
            InstanceOfTypeFlow originalInstanceOf = (InstanceOfTypeFlow)entry.getValue();
            if (methodFlow.isSaturated(this.bb, originalInstanceOf)) continue;
            TypeState instanceOfTypeState = methodFlow.foldTypeFlow(this.bb, originalInstanceOf);
            originalInstanceOf.setState(this.bb, instanceOfTypeState);
            JavaTypeProfile typeProfile = this.makeTypeProfile(instanceOfTypeState);
            if (typeProfile == null) continue;
            StaticAnalysisResultsBuilder.ensureSize(entries, bci);
            assert (entries.get(bci) == null) : "In " + method.format("%h.%n(%p)") + " a profile with bci=" + bci + " already exists: " + entries.get(bci);
            entries.set(bci, this.createBytecodeEntry(method, bci, typeProfile, null, null));
        }
        for (Map.Entry entry : originalFlows.getInvokes()) {
            JavaTypeProfile invokeResultTypeProfile;
            if (!BytecodeLocation.isValidBci(entry.getKey())) continue;
            bci = (Integer)entry.getKey();
            InvokeTypeFlow originalInvoke = (InvokeTypeFlow)entry.getValue();
            TypeState invokeTypeState = null;
            if (originalInvoke.getTargetMethod().hasReceiver() && !methodFlow.isSaturated(this.bb, originalInvoke.getReceiver())) {
                invokeTypeState = methodFlow.foldTypeFlow(this.bb, originalInvoke.getReceiver());
                originalInvoke.setState(this.bb, invokeTypeState);
            }
            TypeFlow<?> originalReturn = originalInvoke.getActualReturn();
            TypeState returnTypeState = null;
            if (originalReturn != null && !methodFlow.isSaturated(this.bb, originalReturn)) {
                returnTypeState = methodFlow.foldTypeFlow(this.bb, originalReturn);
                originalReturn.setState(this.bb, returnTypeState);
            }
            JavaTypeProfile typeProfile = this.makeTypeProfile(invokeTypeState);
            JavaMethodProfile methodProfile = this.makeMethodProfile(originalInvoke.getCallees());
            JavaTypeProfile javaTypeProfile = invokeResultTypeProfile = originalReturn == null ? null : this.makeTypeProfile(returnTypeState);
            if (!StaticAnalysisResultsBuilder.hasStaticProfiles(typeProfile, methodProfile, invokeResultTypeProfile) && !this.hasRuntimeProfiles()) continue;
            StaticAnalysisResultsBuilder.ensureSize(entries, bci);
            assert (entries.get(bci) == null) : "In " + method.format("%h.%n(%p)") + " a profile with bci=" + bci + " already exists: " + entries.get(bci);
            entries.set(bci, this.createBytecodeEntry(method, bci, typeProfile, methodProfile, invokeResultTypeProfile));
        }
        if (((Boolean)PointstoOptions.PrintSynchronizedAnalysis.getValue(this.bb.getOptions())).booleanValue()) {
            originalFlows.getMonitorEntries().stream().filter(m -> m.getState().typesCount() > 20).sorted(Comparator.comparingInt(m2 -> m2.getState().typesCount())).forEach(monitorEnter -> {
                TypeState monitorEntryState = monitorEnter.getState();
                String typesString = monitorEntryState.closeToAllInstantiated(this.bb) ? "close to all instantiated" : StreamSupport.stream(monitorEntryState.types().spliterator(), false).map(AnalysisType::getName).collect(Collectors.joining(", "));
                StringBuilder strb = new StringBuilder();
                strb.append("Location: ");
                String methodName = method.format("%h.%n(%p)");
                int bci = monitorEnter.getLocation().getBci();
                if (bci != -2) {
                    StackTraceElement traceElement = method.asStackTraceElement(bci);
                    String sourceLocation = traceElement.getFileName() + ":" + traceElement.getLineNumber();
                    strb.append("@(").append(methodName).append(":").append(bci).append(")");
                    strb.append("=(").append(sourceLocation).append(")");
                } else {
                    strb.append("@(").append(methodName).append(")");
                }
                strb.append("\n");
                strb.append("Synchronized types #: ").append(monitorEntryState.typesCount()).append("\n");
                strb.append("Types: ").append(typesString).append("\n");
                System.out.println(strb);
            });
        }
        StaticAnalysisResults.BytecodeEntry first = null;
        int n = entries.size() - 1;
        while (var9_14 >= 0) {
            StaticAnalysisResults.BytecodeEntry cur = (StaticAnalysisResults.BytecodeEntry)entries.get((int)var9_14);
            if (cur != null) {
                cur.next = first;
                first = cur;
            }
            --var9_14;
        }
        return this.createStaticAnalysisResults(method, parameterTypeProfiles, resultTypeProfile, first);
    }

    protected StaticAnalysisResults.BytecodeEntry createBytecodeEntry(AnalysisMethod method, int bci, JavaTypeProfile typeProfile, JavaMethodProfile methodProfile, JavaTypeProfile invokeResultTypeProfile) {
        return new StaticAnalysisResults.BytecodeEntry(bci, typeProfile, methodProfile, invokeResultTypeProfile);
    }

    protected StaticAnalysisResults createStaticAnalysisResults(AnalysisMethod method, JavaTypeProfile[] parameterTypeProfiles, JavaTypeProfile resultTypeProfile, StaticAnalysisResults.BytecodeEntry first) {
        if (parameterTypeProfiles == null && resultTypeProfile == null && first == null) {
            return StaticAnalysisResults.NO_RESULTS;
        }
        return new StaticAnalysisResults(method.getCodeSize(), parameterTypeProfiles, resultTypeProfile, first);
    }

    protected boolean hasRuntimeProfiles() {
        return false;
    }

    private static boolean hasStaticProfiles(JavaTypeProfile typeProfile, JavaMethodProfile methodProfile, JavaTypeProfile invokeResultTypeProfile) {
        return typeProfile != null || methodProfile != null || invokeResultTypeProfile != null;
    }

    private static void ensureSize(ArrayList<?> list, int index) {
        list.ensureCapacity(index);
        while (list.size() <= index) {
            list.add(null);
        }
    }

    public JavaTypeProfile makeTypeProfile(AnalysisField field) {
        TypeState fieldState = field.getTypeState();
        return this.makeTypeProfile(fieldState);
    }

    public BigBang getBigBang() {
        return this.bb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JavaTypeProfile makeTypeProfile(TypeState typeState) {
        if (typeState == null || typeState.isUnknown() || (Integer)PointstoOptions.AnalysisSizeCutoff.getValue(this.bb.getOptions()) != -1 && typeState.typesCount() > (Integer)PointstoOptions.AnalysisSizeCutoff.getValue(this.bb.getOptions())) {
            return null;
        }
        if (typeState.isEmpty()) {
            JavaTypeProfile[] javaTypeProfileArray = this.types0;
            synchronized (this.types0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.cachedTypeProfile(this.types0, 0, typeState);
            }
        }
        if (typeState.isNull()) {
            JavaTypeProfile[] javaTypeProfileArray = this.types0;
            synchronized (this.types0) {
                // ** MonitorExit[var2_3] (shouldn't be in output)
                return this.cachedTypeProfile(this.types0, 1, typeState);
            }
        }
        if (typeState.exactType() != null) {
            if (typeState.canBeNull()) {
                JavaTypeProfile[] javaTypeProfileArray = this.types1Null;
                synchronized (this.types1Null) {
                    // ** MonitorExit[var2_4] (shouldn't be in output)
                    return this.cachedTypeProfile(this.types1Null, typeState.exactType().getId(), typeState);
                }
            }
            JavaTypeProfile[] javaTypeProfileArray = this.types1NonNull;
            synchronized (this.types1NonNull) {
                // ** MonitorExit[var2_5] (shouldn't be in output)
                return this.cachedTypeProfile(this.types1NonNull, typeState.exactType().getId(), typeState);
            }
        }
        Map<JavaTypeProfile, JavaTypeProfile> map = this.types;
        synchronized (map) {
            JavaTypeProfile created = this.createTypeProfile(typeState);
            this.types.putIfAbsent(created, created);
            return created;
        }
    }

    private JavaTypeProfile cachedTypeProfile(JavaTypeProfile[] cache, int cacheIdx, TypeState typeState) {
        JavaTypeProfile result = cache[cacheIdx];
        if (result == null) {
            cache[cacheIdx] = result = this.createTypeProfile(typeState);
        }
        return result;
    }

    private JavaTypeProfile createTypeProfile(TypeState typeState) {
        double probability = 1.0 / (double)typeState.typesCount();
        JavaTypeProfile.ProfiledType[] pitems = (JavaTypeProfile.ProfiledType[])typeState.typesStream().map(analysisType -> this.converter == null ? analysisType : this.converter.lookup((JavaType)analysisType)).sorted().map(type -> new JavaTypeProfile.ProfiledType(type, probability)).toArray(JavaTypeProfile.ProfiledType[]::new);
        return new JavaTypeProfile(TriState.get((boolean)typeState.canBeNull()), 0.0, pitems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JavaMethodProfile makeMethodProfile(Collection<AnalysisMethod> callees) {
        if ((Integer)PointstoOptions.AnalysisSizeCutoff.getValue(this.bb.getOptions()) != -1 && callees.size() > (Integer)PointstoOptions.AnalysisSizeCutoff.getValue(this.bb.getOptions())) {
            return null;
        }
        if (callees.isEmpty()) {
            JavaMethodProfile[] javaMethodProfileArray = this.methods0;
            synchronized (this.methods0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.cachedMethodProfile(this.methods0, 0, callees);
            }
        }
        if (callees.size() == 1) {
            JavaMethodProfile[] javaMethodProfileArray = this.methods1;
            synchronized (this.methods1) {
                // ** MonitorExit[var2_3] (shouldn't be in output)
                return this.cachedMethodProfile(this.methods1, callees.iterator().next().getId(), callees);
            }
        }
        Map<JavaMethodProfile, JavaMethodProfile> map = this.methods;
        synchronized (map) {
            JavaMethodProfile created = this.createMethodProfile(callees);
            this.methods.putIfAbsent(created, created);
            return created;
        }
    }

    private JavaMethodProfile cachedMethodProfile(JavaMethodProfile[] cache, int cacheIdx, Collection<AnalysisMethod> callees) {
        JavaMethodProfile result = cache[cacheIdx];
        if (result == null) {
            cache[cacheIdx] = result = this.createMethodProfile(callees);
        }
        return result;
    }

    private JavaMethodProfile createMethodProfile(Collection<AnalysisMethod> callees) {
        JavaMethodProfile.ProfiledMethod[] pitems = new JavaMethodProfile.ProfiledMethod[callees.size()];
        double probability = 1.0 / (double)pitems.length;
        int idx = 0;
        for (AnalysisMethod aMethod : callees) {
            AnalysisMethod convertedMethod = this.converter == null ? aMethod : this.converter.lookup((JavaMethod)aMethod);
            pitems[idx++] = new JavaMethodProfile.ProfiledMethod((ResolvedJavaMethod)convertedMethod, probability);
        }
        return new JavaMethodProfile(0.0, pitems);
    }
}

