/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.elf.dwarf;

import com.oracle.objectfile.LayoutDecision;
import com.oracle.objectfile.LayoutDecisionMap;
import com.oracle.objectfile.ObjectFile;
import com.oracle.objectfile.debugentry.ClassEntry;
import com.oracle.objectfile.debugentry.DirEntry;
import com.oracle.objectfile.debugentry.FileEntry;
import com.oracle.objectfile.debugentry.PrimaryEntry;
import com.oracle.objectfile.debugentry.Range;
import com.oracle.objectfile.debuginfo.DebugInfoProvider;
import com.oracle.objectfile.elf.dwarf.DwarfDebugInfo;
import com.oracle.objectfile.elf.dwarf.DwarfSectionImpl;
import java.util.Iterator;
import java.util.Map;
import org.graalvm.compiler.debug.DebugContext;

public class DwarfLineSectionImpl
extends DwarfSectionImpl {
    private static final int DW_LN_HEADER_SIZE = 27;
    private static final int DW_LN_LINE_BASE = -5;
    private static final int DW_LN_LINE_RANGE = 14;
    private static final int DW_LN_OPCODE_BASE = 13;
    private static final byte DW_LNS_undefined = 0;
    private static final byte DW_LNS_extended_prefix = 0;
    private static final byte DW_LNS_copy = 1;
    private static final byte DW_LNS_advance_pc = 2;
    private static final byte DW_LNS_advance_line = 3;
    private static final byte DW_LNS_set_file = 4;
    private static final byte DW_LNS_set_column = 5;
    private static final byte DW_LNS_negate_stmt = 6;
    private static final byte DW_LNS_set_basic_block = 7;
    private static final byte DW_LNS_const_add_pc = 8;
    private static final byte DW_LNS_fixed_advance_pc = 9;
    private static final byte DW_LNE_undefined = 0;
    private static final byte DW_LNE_end_sequence = 1;
    private static final byte DW_LNE_set_address = 2;
    private static final byte DW_LNE_define_file = 3;
    private int debugLine = 1;
    private int debugCopyCount = 0;
    private static final int MAX_ADDRESS_ONLY_DELTA = 17;
    private static final int MAX_ADDPC_DELTA = 33;
    private static final String TARGET_SECTION_NAME = ".debug_str";
    private final LayoutDecision.Kind[] targetSectionKinds = new LayoutDecision.Kind[]{LayoutDecision.Kind.CONTENT, LayoutDecision.Kind.SIZE};

    DwarfLineSectionImpl(DwarfDebugInfo dwarfSections) {
        super(dwarfSections);
    }

    @Override
    public String getSectionName() {
        return ".debug_line";
    }

    @Override
    public void createContent() {
        assert (!this.contentByteArrayCreated());
        int pos = 0;
        for (ClassEntry classEntry : this.getPrimaryClasses()) {
            if (classEntry.getFileName().length() == 0) continue;
            int startPos = pos;
            this.setLineIndex(classEntry, startPos);
            int headerSize = DwarfLineSectionImpl.headerSize();
            int dirTableSize = DwarfLineSectionImpl.computeDirTableSize(classEntry);
            int fileTableSize = this.computeFileTableSize(classEntry);
            int prologueSize = headerSize + dirTableSize + fileTableSize;
            this.setLinePrologueSize(classEntry, prologueSize);
            int lineNumberTableSize = this.computeLineNUmberTableSize(classEntry);
            int totalSize = prologueSize + lineNumberTableSize;
            this.setLineSectionSize(classEntry, totalSize);
            pos += totalSize;
        }
        byte[] buffer = new byte[pos];
        super.setContent(buffer);
    }

    private static int headerSize() {
        return 27;
    }

    private static int computeDirTableSize(ClassEntry classEntry) {
        int dirSize = 0;
        for (DirEntry dir : classEntry.getLocalDirs()) {
            dirSize += DwarfLineSectionImpl.countUTF8Bytes(dir.getPathString()) + 1;
        }
        return ++dirSize;
    }

    private int computeFileTableSize(ClassEntry classEntry) {
        int fileSize = 0;
        for (FileEntry localEntry : classEntry.getLocalFiles()) {
            String baseName = localEntry.getFileName();
            int length = DwarfLineSectionImpl.countUTF8Bytes(baseName);
            assert (length > 0);
            fileSize += length + 1;
            DirEntry dirEntry = localEntry.getDirEntry();
            int idx = classEntry.localDirsIdx(dirEntry);
            fileSize += this.putULEB(idx, scratch, 0);
            fileSize += 2;
        }
        return ++fileSize;
    }

    private int computeLineNUmberTableSize(ClassEntry classEntry) {
        return this.writeLineNumberTable(null, classEntry, null, 0);
    }

    @Override
    public byte[] getOrDecideContent(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, byte[] contentHint) {
        Object valueObj;
        ObjectFile.Element textElement = this.getElement().getOwner().elementForName(".text");
        LayoutDecisionMap decisionMap = alreadyDecided.get(textElement);
        if (decisionMap != null && (valueObj = decisionMap.getDecidedValue(LayoutDecision.Kind.VADDR)) != null && valueObj instanceof Number) {
            this.debugTextBase = ((Number)valueObj).longValue();
        }
        return super.getOrDecideContent(alreadyDecided, contentHint);
    }

    @Override
    public void writeContent(DebugContext context) {
        assert (this.contentByteArrayCreated());
        byte[] buffer = this.getContent();
        int pos = 0;
        this.enableLog(context, pos);
        this.log(context, "  [0x%08x] DEBUG_LINE", pos);
        for (ClassEntry classEntry : this.getPrimaryClasses()) {
            if (classEntry.getFileName().length() == 0) continue;
            int startPos = pos;
            assert (this.getLineIndex(classEntry) == startPos);
            this.log(context, "  [0x%08x] Compile Unit for %s", pos, classEntry.getFileName());
            pos = this.writeHeader(classEntry, buffer, pos);
            this.log(context, "  [0x%08x] headerSize = 0x%08x", pos, pos - startPos);
            int dirTablePos = pos;
            pos = this.writeDirTable(context, classEntry, buffer, pos);
            this.log(context, "  [0x%08x] dirTableSize = 0x%08x", pos, pos - dirTablePos);
            int fileTablePos = pos;
            pos = this.writeFileTable(context, classEntry, buffer, pos);
            this.log(context, "  [0x%08x] fileTableSize = 0x%08x", pos, pos - fileTablePos);
            int lineNumberTablePos = pos;
            pos = this.writeLineNumberTable(context, classEntry, buffer, pos);
            this.log(context, "  [0x%08x] lineNumberTableSize = 0x%x", pos, pos - lineNumberTablePos);
            this.log(context, "  [0x%08x] size = 0x%x", pos, pos - startPos);
        }
        assert (pos == buffer.length);
    }

    private int writeHeader(ClassEntry classEntry, byte[] buffer, int p) {
        int pos = p;
        pos = this.putInt(this.getLineSectionSize(classEntry) - 4, buffer, pos);
        pos = this.putShort((short)2, buffer, pos);
        int prologueSize = this.getLinePrologueSize(classEntry) - 10;
        pos = this.putInt(prologueSize, buffer, pos);
        pos = this.putByte((byte)1, buffer, pos);
        pos = this.putByte((byte)1, buffer, pos);
        pos = this.putByte((byte)-5, buffer, pos);
        pos = this.putByte((byte)14, buffer, pos);
        pos = this.putByte((byte)13, buffer, pos);
        this.putByte((byte)0, buffer, pos);
        this.putByte((byte)1, buffer, pos + 1);
        this.putByte((byte)1, buffer, pos + 2);
        this.putByte((byte)1, buffer, pos + 3);
        this.putByte((byte)1, buffer, pos + 4);
        this.putByte((byte)0, buffer, pos + 5);
        this.putByte((byte)0, buffer, pos + 6);
        this.putByte((byte)0, buffer, pos + 7);
        this.putByte((byte)1, buffer, pos + 8);
        this.putByte((byte)0, buffer, pos + 9);
        this.putByte((byte)0, buffer, pos + 10);
        pos = this.putByte((byte)1, buffer, pos + 11);
        return pos;
    }

    private int writeDirTable(DebugContext context, ClassEntry classEntry, byte[] buffer, int p) {
        int pos = p;
        this.verboseLog(context, "  [0x%08x] Dir  Name", pos);
        int dirIdx = 1;
        for (DirEntry dir : classEntry.getLocalDirs()) {
            this.verboseLog(context, "  [0x%08x] %-4d %s", pos, dirIdx, dir.getPath());
            pos = this.putUTF8StringBytes(dir.getPathString(), buffer, pos);
            ++dirIdx;
        }
        pos = this.putByte((byte)0, buffer, pos);
        return pos;
    }

    private int writeFileTable(DebugContext context, ClassEntry classEntry, byte[] buffer, int p) {
        int pos = p;
        int fileIdx = 1;
        this.verboseLog(context, "  [0x%08x] Entry Dir  Name", pos);
        for (FileEntry localEntry : classEntry.getLocalFiles()) {
            String baseName = localEntry.getFileName();
            DirEntry dirEntry = localEntry.getDirEntry();
            int dirIdx = classEntry.localDirsIdx(dirEntry);
            this.verboseLog(context, "  [0x%08x] %-5d %-5d %s", pos, fileIdx, dirIdx, baseName);
            pos = this.putUTF8StringBytes(baseName, buffer, pos);
            pos = this.putULEB(dirIdx, buffer, pos);
            pos = this.putULEB(0L, buffer, pos);
            pos = this.putULEB(0L, buffer, pos);
            ++fileIdx;
        }
        pos = this.putByte((byte)0, buffer, pos);
        return pos;
    }

    private int writeLineNumberTable(DebugContext context, ClassEntry classEntry, byte[] buffer, int p) {
        int pos = p;
        if (classEntry.getFileEntry() == null) {
            return pos;
        }
        assert (classEntry.localFilesIdx() == 1);
        String primaryClassName = classEntry.getTypeName();
        String primaryFileName = classEntry.getFileName();
        this.log(context, "  [0x%08x] primary class %s", pos, primaryClassName);
        this.log(context, "  [0x%08x] primary class file %s", pos, primaryFileName);
        for (PrimaryEntry primaryEntry : classEntry.getPrimaryEntries()) {
            long addressDelta;
            FileEntry subFileEntry;
            Range subRange;
            Iterator<Range> iterator;
            Range primaryRange = primaryEntry.getPrimary();
            FileEntry fileEntry = primaryRange.getFileEntry();
            if (fileEntry == null) {
                this.log(context, "  [0x%08x] primary range [0x%08x, 0x%08x] skipped (no file) %s", pos, this.debugTextBase + (long)primaryRange.getLo(), this.debugTextBase + (long)primaryRange.getHi(), primaryRange.getFullMethodNameWithParams());
                continue;
            }
            String file = fileEntry.getFileName();
            int fileIdx = classEntry.localFilesIdx(fileEntry);
            long line = primaryRange.getLine();
            if (line < 0L && (iterator = primaryEntry.leafRangeIterator()).hasNext() && (line = (long)(subRange = iterator.next()).getLine()) > 0L && (subFileEntry = subRange.getFileEntry()) != null) {
                fileIdx = classEntry.localFilesIdx(subFileEntry);
            }
            if (line < 0L) {
                line = 0L;
            }
            long address = primaryRange.getLo();
            this.log(context, "  [0x%08x] primary range [0x%08x, 0x%08x] %s %s:%d", pos, this.debugTextBase + (long)primaryRange.getLo(), this.debugTextBase + (long)primaryRange.getHi(), primaryRange.getFullMethodNameWithParams(), file, primaryRange.getLine());
            pos = this.writeSetFileOp(context, file, fileIdx, buffer, pos);
            pos = this.writeSetBasicBlockOp(context, buffer, pos);
            pos = this.writeSetAddressOp(context, address, buffer, pos);
            if (line != 1L) {
                pos = this.writeAdvanceLineOp(context, line - 1L, buffer, pos);
            }
            pos = this.writeCopyOp(context, buffer, pos);
            if (this.isAArch64() && !primaryEntry.getFrameSizeInfos().isEmpty()) {
                DebugInfoProvider.DebugFrameSizeChange frameSizeChange = primaryEntry.getFrameSizeInfos().get(0);
                assert (frameSizeChange.getType() == DebugInfoProvider.DebugFrameSizeChange.Type.EXTEND);
                addressDelta = frameSizeChange.getOffset();
                if (addressDelta < 16L && (long)primaryRange.getLo() + addressDelta < (long)primaryRange.getHi()) {
                    byte opcode = DwarfLineSectionImpl.isSpecialOpcode(addressDelta, 0L);
                    assert (opcode != 0);
                    pos = this.writeSpecialOpcode(context, opcode, buffer, pos);
                    pos = this.writeCopyOp(context, buffer, pos);
                    address += addressDelta;
                }
            }
            Iterator<Range> iterator2 = primaryEntry.leafRangeIterator();
            while (iterator2.hasNext()) {
                long lineDelta;
                long addressDelta2;
                byte opcode;
                Range subrange = iterator2.next();
                assert (subrange.getLo() >= primaryRange.getLo());
                assert (subrange.getHi() <= primaryRange.getHi());
                FileEntry subFileEntry2 = subrange.getFileEntry();
                if (subFileEntry2 == null) continue;
                String subfile = subFileEntry2.getFileName();
                int subFileIdx = classEntry.localFilesIdx(subFileEntry2);
                assert (subFileIdx > 0);
                long subLine = subrange.getLine();
                long subAddressLo = subrange.getLo();
                long subAddressHi = subrange.getHi();
                this.log(context, "  [0x%08x] sub range [0x%08x, 0x%08x] %s %s:%d", pos, this.debugTextBase + subAddressLo, this.debugTextBase + subAddressHi, subrange.getFullMethodNameWithParams(), subfile, subLine);
                if (subLine < 0L) {
                    subLine = line;
                    subfile = file;
                    subFileIdx = fileIdx;
                    this.verboseLog(context, "  [0x%08x] missing line info - staying put at %s:%d", pos, file, line);
                }
                if (subFileIdx != fileIdx) {
                    pos = this.writeSetFileOp(context, subfile, subFileIdx, buffer, pos);
                    file = subfile;
                    fileIdx = subFileIdx;
                }
                if ((opcode = DwarfLineSectionImpl.isSpecialOpcode(addressDelta2 = subAddressLo - address, lineDelta = subLine - line)) != 0) {
                    if (addressDelta2 != 0L || lineDelta != 0L) {
                        pos = this.writeSpecialOpcode(context, opcode, buffer, pos);
                    }
                } else {
                    int remainder = DwarfLineSectionImpl.isConstAddPC(addressDelta2);
                    if (remainder > 0) {
                        pos = this.writeConstAddPCOp(context, buffer, pos);
                        opcode = DwarfLineSectionImpl.isSpecialOpcode(remainder, lineDelta);
                        if (opcode != 0) {
                            pos = this.writeSpecialOpcode(context, opcode, buffer, pos);
                        } else {
                            opcode = DwarfLineSectionImpl.isSpecialOpcode(remainder, 0L);
                            assert (opcode != 0);
                            pos = this.writeAdvanceLineOp(context, lineDelta, buffer, pos);
                            pos = this.writeSpecialOpcode(context, opcode, buffer, pos);
                        }
                    } else {
                        if (lineDelta != 0L) {
                            pos = this.writeAdvanceLineOp(context, lineDelta, buffer, pos);
                        }
                        if (addressDelta2 > 0L) {
                            pos = DwarfLineSectionImpl.isFixedAdvancePC(addressDelta2) ? this.writeFixedAdvancePCOp(context, (short)addressDelta2, buffer, pos) : this.writeAdvancePCOp(context, addressDelta2, buffer, pos);
                        }
                        pos = this.writeCopyOp(context, buffer, pos);
                    }
                }
                line += lineDelta;
                address += addressDelta2;
            }
            if (address < (long)primaryRange.getHi()) {
                addressDelta = (long)primaryRange.getHi() - address;
                pos = this.writeAdvancePCOp(context, addressDelta, buffer, pos);
            }
            pos = this.writeEndSequenceOp(context, buffer, pos);
        }
        this.log(context, "  [0x%08x] primary class processed %s", pos, primaryClassName);
        return pos;
    }

    private int writeCopyOp(DebugContext context, byte[] buffer, int p) {
        byte opcode = 1;
        int pos = p;
        if (buffer == null) {
            return pos + this.putByte(opcode, scratch, 0);
        }
        ++this.debugCopyCount;
        this.verboseLog(context, "  [0x%08x] Copy %d", pos, this.debugCopyCount);
        return this.putByte(opcode, buffer, pos);
    }

    private int writeAdvancePCOp(DebugContext context, long uleb, byte[] buffer, int p) {
        byte opcode = 2;
        int pos = p;
        if (buffer == null) {
            return (pos += this.putByte(opcode, scratch, 0)) + this.putULEB(uleb, scratch, 0);
        }
        this.debugAddress += uleb;
        this.verboseLog(context, "  [0x%08x] Advance PC by %d to 0x%08x", pos, uleb, this.debugAddress);
        pos = this.putByte(opcode, buffer, pos);
        return this.putULEB(uleb, buffer, pos);
    }

    private int writeAdvanceLineOp(DebugContext context, long sleb, byte[] buffer, int p) {
        byte opcode = 3;
        int pos = p;
        if (buffer == null) {
            return (pos += this.putByte(opcode, scratch, 0)) + this.putSLEB(sleb, scratch, 0);
        }
        this.debugLine = (int)((long)this.debugLine + sleb);
        this.verboseLog(context, "  [0x%08x] Advance Line by %d to %d", pos, sleb, this.debugLine);
        pos = this.putByte(opcode, buffer, pos);
        return this.putSLEB(sleb, buffer, pos);
    }

    private int writeSetFileOp(DebugContext context, String file, long uleb, byte[] buffer, int p) {
        byte opcode = 4;
        int pos = p;
        if (buffer == null) {
            return (pos += this.putByte(opcode, scratch, 0)) + this.putULEB(uleb, scratch, 0);
        }
        this.verboseLog(context, "  [0x%08x] Set File Name to entry %d in the File Name Table (%s)", pos, uleb, file);
        pos = this.putByte(opcode, buffer, pos);
        return this.putULEB(uleb, buffer, pos);
    }

    private int writeSetColumnOp(DebugContext context, long uleb, byte[] buffer, int p) {
        byte opcode = 5;
        int pos = p;
        if (buffer == null) {
            return (pos += this.putByte(opcode, scratch, 0)) + this.putULEB(uleb, scratch, 0);
        }
        pos = this.putByte(opcode, buffer, pos);
        return this.putULEB(uleb, buffer, pos);
    }

    private int writeNegateStmtOp(DebugContext context, byte[] buffer, int p) {
        byte opcode = 6;
        int pos = p;
        if (buffer == null) {
            return pos + this.putByte(opcode, scratch, 0);
        }
        return this.putByte(opcode, buffer, pos);
    }

    private int writeSetBasicBlockOp(DebugContext context, byte[] buffer, int p) {
        byte opcode = 7;
        int pos = p;
        if (buffer == null) {
            return pos + this.putByte(opcode, scratch, 0);
        }
        this.verboseLog(context, "  [0x%08x] Set basic block", pos);
        return this.putByte(opcode, buffer, pos);
    }

    private int writeConstAddPCOp(DebugContext context, byte[] buffer, int p) {
        byte opcode = 8;
        int pos = p;
        if (buffer == null) {
            return pos + this.putByte(opcode, scratch, 0);
        }
        int advance = DwarfLineSectionImpl.opcodeAddress((byte)-1);
        this.debugAddress += (long)advance;
        this.verboseLog(context, "  [0x%08x] Advance PC by constant %d to 0x%08x", pos, advance, this.debugAddress);
        return this.putByte(opcode, buffer, pos);
    }

    private int writeFixedAdvancePCOp(DebugContext context, short arg, byte[] buffer, int p) {
        byte opcode = 9;
        int pos = p;
        if (buffer == null) {
            return (pos += this.putByte(opcode, scratch, 0)) + this.putShort(arg, scratch, 0);
        }
        this.debugAddress += (long)arg;
        this.verboseLog(context, "  [0x%08x] Fixed advance Address by %d to 0x%08x", pos, arg, this.debugAddress);
        pos = this.putByte(opcode, buffer, pos);
        return this.putShort(arg, buffer, pos);
    }

    private int writeEndSequenceOp(DebugContext context, byte[] buffer, int p) {
        byte opcode = 1;
        int pos = p;
        if (buffer == null) {
            pos += this.putByte((byte)0, scratch, 0);
            return (pos += this.putULEB(1L, scratch, 0)) + this.putByte(opcode, scratch, 0);
        }
        this.verboseLog(context, "  [0x%08x] Extended opcode 1: End sequence", pos);
        this.debugAddress = this.debugTextBase;
        this.debugLine = 1;
        this.debugCopyCount = 0;
        pos = this.putByte((byte)0, buffer, pos);
        pos = this.putULEB(1L, buffer, pos);
        return this.putByte(opcode, buffer, pos);
    }

    private int writeSetAddressOp(DebugContext context, long arg, byte[] buffer, int p) {
        byte opcode = 2;
        int pos = p;
        if (buffer == null) {
            pos += this.putByte((byte)0, scratch, 0);
            pos += this.putULEB(9L, scratch, 0);
            return (pos += this.putByte(opcode, scratch, 0)) + this.putLong(arg, scratch, 0);
        }
        this.debugAddress = this.debugTextBase + (long)((int)arg);
        this.verboseLog(context, "  [0x%08x] Extended opcode 2: Set Address to 0x%08x", pos, this.debugAddress);
        pos = this.putByte((byte)0, buffer, pos);
        pos = this.putULEB(9L, buffer, pos);
        pos = this.putByte(opcode, buffer, pos);
        return this.putRelocatableCodeOffset(arg, buffer, pos);
    }

    private int writeDefineFileOp(DebugContext context, String file, long uleb1, long uleb2, long uleb3, byte[] buffer, int p) {
        byte opcode = 3;
        int pos = p;
        int fileBytes = DwarfLineSectionImpl.countUTF8Bytes(file) + 1;
        long insnBytes = 1L;
        insnBytes += (long)fileBytes;
        insnBytes += (long)this.putULEB(uleb1, scratch, 0);
        insnBytes += (long)this.putULEB(uleb2, scratch, 0);
        insnBytes += (long)this.putULEB(uleb3, scratch, 0);
        if (buffer == null) {
            pos += this.putByte((byte)0, scratch, 0);
            return (pos += this.putULEB(insnBytes, scratch, 0)) + (int)insnBytes;
        }
        this.verboseLog(context, "  [0x%08x] Extended opcode 3: Define File %s idx %d ts1 %d ts2 %d", pos, file, uleb1, uleb2, uleb3);
        pos = this.putByte((byte)0, buffer, pos);
        pos = this.putULEB(insnBytes, buffer, pos);
        pos = this.putByte(opcode, buffer, pos);
        pos = this.putUTF8StringBytes(file, buffer, pos);
        pos = this.putULEB(uleb1, buffer, pos);
        pos = this.putULEB(uleb2, buffer, pos);
        return this.putULEB(uleb3, buffer, pos);
    }

    private static int opcodeId(byte opcode) {
        int iopcode = opcode & 0xFF;
        return iopcode - 13;
    }

    private static int opcodeAddress(byte opcode) {
        int iopcode = opcode & 0xFF;
        return (iopcode - 13) / 14;
    }

    private static int opcodeLine(byte opcode) {
        int iopcode = opcode & 0xFF;
        return (iopcode - 13) % 14 + -5;
    }

    private int writeSpecialOpcode(DebugContext context, byte opcode, byte[] buffer, int p) {
        int pos = p;
        if (buffer == null) {
            return pos + this.putByte(opcode, scratch, 0);
        }
        if (this.debug && opcode == 0) {
            this.verboseLog(context, "  [0x%08x] ERROR Special Opcode %d: Address 0x%08x Line %d", this.debugAddress, this.debugLine);
        }
        this.debugAddress += (long)DwarfLineSectionImpl.opcodeAddress(opcode);
        this.debugLine += DwarfLineSectionImpl.opcodeLine(opcode);
        this.verboseLog(context, "  [0x%08x] Special Opcode %d: advance Address by %d to 0x%08x and Line by %d to %d", pos, DwarfLineSectionImpl.opcodeId(opcode), DwarfLineSectionImpl.opcodeAddress(opcode), this.debugAddress, DwarfLineSectionImpl.opcodeLine(opcode), this.debugLine);
        return this.putByte(opcode, buffer, pos);
    }

    private static byte isSpecialOpcode(long addressDelta, long lineDelta) {
        long opcode;
        long offsetLineDelta;
        if (addressDelta < 0L) {
            return 0;
        }
        if (lineDelta >= -5L && (offsetLineDelta = lineDelta - -5L) < 14L && addressDelta <= 17L && (opcode = 13L + addressDelta * 14L + offsetLineDelta) <= 255L) {
            return (byte)opcode;
        }
        return 0;
    }

    private static int isConstAddPC(long addressDelta) {
        if (addressDelta < 17L) {
            return 0;
        }
        if (addressDelta <= 33L) {
            return (int)(addressDelta - 17L);
        }
        return 0;
    }

    private static boolean isFixedAdvancePC(long addressDiff) {
        return addressDiff >= 0L && addressDiff < 65535L;
    }

    @Override
    public String targetSectionName() {
        return TARGET_SECTION_NAME;
    }

    @Override
    public LayoutDecision.Kind[] targetSectionKinds() {
        return this.targetSectionKinds;
    }
}

