/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.elf.dwarf;

import com.oracle.objectfile.debuginfo.DebugInfoProvider;
import com.oracle.objectfile.elf.dwarf.DwarfDebugInfo;
import com.oracle.objectfile.elf.dwarf.DwarfFrameSectionImpl;
import java.util.List;

public class DwarfFrameSectionImplAArch64
extends DwarfFrameSectionImpl {
    public static final int DW_CFA_FP_IDX = 29;
    private static final int DW_CFA_LR_IDX = 30;
    private static final int DW_CFA_SP_IDX = 31;
    private static final int DW_CFA_PC_IDX = 32;

    public DwarfFrameSectionImplAArch64(DwarfDebugInfo dwarfSections) {
        super(dwarfSections);
    }

    @Override
    public int getReturnPCIdx() {
        return 30;
    }

    @Override
    public int getSPIdx() {
        return 31;
    }

    @Override
    public int writeInitialInstructions(byte[] buffer, int p) {
        int pos = p;
        pos = this.writeDefCFA(31, 0, buffer, pos);
        return pos;
    }

    @Override
    protected int writeFDEs(int frameSize, List<DebugInfoProvider.DebugFrameSizeChange> frameSizeInfos, byte[] buffer, int p) {
        int pos = p;
        int currentOffset = 0;
        for (DebugInfoProvider.DebugFrameSizeChange debugFrameSizeInfo : frameSizeInfos) {
            int advance = debugFrameSizeInfo.getOffset() - currentOffset;
            currentOffset += advance;
            pos = this.writeAdvanceLoc(advance, buffer, pos);
            if (debugFrameSizeInfo.getType() == DebugInfoProvider.DebugFrameSizeChange.Type.EXTEND) {
                pos = this.writeDefCFAOffset(frameSize, buffer, pos);
                pos = this.writeOffset(30, 1, buffer, pos);
                pos = this.writeOffset(29, 2, buffer, pos);
                continue;
            }
            pos = this.writeDefCFAOffset(0, buffer, pos);
            pos = this.writeRestore(29, buffer, pos);
            pos = this.writeRestore(30, buffer, pos);
        }
        return pos;
    }
}

