/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.debugentry;

import com.oracle.objectfile.debugentry.DebugInfoBase;
import com.oracle.objectfile.debugentry.FieldEntry;
import com.oracle.objectfile.debugentry.FileEntry;
import com.oracle.objectfile.debugentry.TypeEntry;
import com.oracle.objectfile.debuginfo.DebugInfoProvider;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.graalvm.compiler.debug.DebugContext;

public abstract class StructureTypeEntry
extends TypeEntry {
    protected List<FieldEntry> fields = new ArrayList<FieldEntry>();

    public StructureTypeEntry(String typeName, int size) {
        super(typeName, size);
    }

    public Stream<FieldEntry> fields() {
        return this.fields.stream();
    }

    protected void processField(DebugInfoProvider.DebugFieldInfo debugFieldInfo, DebugInfoBase debugInfoBase, DebugContext debugContext) {
        this.addField(debugFieldInfo, debugInfoBase, debugContext);
    }

    protected FieldEntry addField(DebugInfoProvider.DebugFieldInfo debugFieldInfo, DebugInfoBase debugInfoBase, DebugContext debugContext) {
        String fieldName = debugInfoBase.uniqueDebugString(debugFieldInfo.name());
        String valueTypeName = TypeEntry.canonicalize(debugFieldInfo.valueType());
        int fieldSize = debugFieldInfo.size();
        int fieldoffset = debugFieldInfo.offset();
        int fieldModifiers = debugFieldInfo.modifiers();
        debugContext.log("typename %s adding %s field %s type %s size %s at offset %d\n", (Object)this.typeName, (Object)this.memberModifiers(fieldModifiers), (Object)fieldName, (Object)valueTypeName, (Object)fieldSize, (Object)fieldoffset);
        TypeEntry valueType = debugInfoBase.lookupTypeEntry(valueTypeName);
        FileEntry fileEntry = debugInfoBase.ensureFileEntry(debugFieldInfo);
        FieldEntry fieldEntry = new FieldEntry(fileEntry, fieldName, this, valueType, fieldSize, fieldoffset, fieldModifiers);
        this.fields.add(fieldEntry);
        return fieldEntry;
    }

    String memberModifiers(int modifiers) {
        StringBuilder builder = new StringBuilder();
        if (Modifier.isPublic(modifiers)) {
            builder.append("public ");
        } else if (Modifier.isProtected(modifiers)) {
            builder.append("protected ");
        } else if (Modifier.isPrivate(modifiers)) {
            builder.append("private ");
        }
        if (Modifier.isFinal(modifiers)) {
            builder.append("final ");
        }
        if (Modifier.isAbstract(modifiers)) {
            builder.append("abstract ");
        } else if (Modifier.isVolatile(modifiers)) {
            builder.append("volatile ");
        } else if (Modifier.isTransient(modifiers)) {
            builder.append("transient ");
        } else if (Modifier.isSynchronized(modifiers)) {
            builder.append("synchronized ");
        }
        if (Modifier.isNative(modifiers)) {
            builder.append("native ");
        }
        if (Modifier.isStatic(modifiers)) {
            builder.append("static");
        } else {
            builder.append("instance");
        }
        return builder.toString();
    }
}

