/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile;

import com.oracle.objectfile.io.OutputAssembler;
import com.oracle.objectfile.io.Utf8;
import java.io.CharConversionException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public class StringTable {
    protected NavigableMap<Integer, String> stringMap = new TreeMap<Integer, String>();
    private Map<String, Integer> stringToIndexMap = new HashMap<String, Integer>();
    private int totalSize;

    public StringTable() {
    }

    public StringTable(byte[] bytes) {
        this(ByteBuffer.wrap(bytes));
    }

    public StringTable(ByteBuffer buffer) {
        this.read(buffer);
    }

    public void read(ByteBuffer buffer) {
        try {
            while (buffer.position() < buffer.limit()) {
                int index = buffer.position();
                String s = Utf8.utf8ToString(true, buffer);
                if (this.stringMap.containsKey(index)) {
                    throw new IllegalStateException("offset cannot be re-used");
                }
                this.stringMap.put(index, s);
                this.stringToIndexMap.put(s, index);
            }
            this.totalSize = buffer.position();
        }
        catch (CharConversionException e) {
            throw new RuntimeException(e);
        }
    }

    public long add(String s) {
        Integer index = this.stringToIndexMap.get(s);
        if (index != null) {
            return index.intValue();
        }
        int newIndex = this.totalSize;
        this.stringMap.put(newIndex, s);
        this.totalSize += Utf8.utf8Length(s) + 1;
        return newIndex;
    }

    public int indexFor(String s) {
        Integer index = this.stringToIndexMap.get(s);
        if (index == null) {
            return -1;
        }
        return index;
    }

    public String get(String s) {
        return (String)this.stringMap.get(this.indexFor(s));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("str\nindex   string\n==========================================================================\n");
        for (Integer idx : this.stringMap.keySet()) {
            sb.append(String.format("%5d   %s\n", idx, this.stringMap.get(idx)));
        }
        return sb.toString();
    }

    public void write(OutputAssembler out) {
        ByteBuffer blob = ByteBuffer.allocate(this.totalSize);
        for (Integer index : this.stringMap.keySet()) {
            assert (blob.position() == index.intValue());
            String s = (String)this.stringMap.get(index);
            Utf8.substringToUtf8(blob, s, 0, s.length(), true);
        }
        out.writeBlob(blob.array());
    }
}

