/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.elf;

import com.oracle.objectfile.ObjectFile;
import com.oracle.objectfile.elf.ELFAArch64Relocation;
import com.oracle.objectfile.elf.ELFCavaRelocation;
import com.oracle.objectfile.elf.ELFDummyRelocation;
import com.oracle.objectfile.elf.ELFRelocationSection;
import com.oracle.objectfile.elf.ELFX86_64Relocation;

public enum ELFMachine {
    NONE{

        @Override
        Class<? extends Enum<? extends ObjectFile.RelocationMethod>> relocationTypes() {
            return ELFDummyRelocation.class;
        }
    }
    ,
    X86_64{

        @Override
        Class<? extends Enum<? extends ObjectFile.RelocationMethod>> relocationTypes() {
            return ELFX86_64Relocation.class;
        }
    }
    ,
    AArch64{

        @Override
        Class<? extends Enum<? extends ObjectFile.RelocationMethod>> relocationTypes() {
            return ELFAArch64Relocation.class;
        }
    }
    ,
    CAVA{

        @Override
        Class<? extends Enum<? extends ObjectFile.RelocationMethod>> relocationTypes() {
            return ELFCavaRelocation.class;
        }
    };


    abstract Class<? extends Enum<? extends ObjectFile.RelocationMethod>> relocationTypes();

    public static ELFMachine from(String s) {
        switch (s.toLowerCase()) {
            case "amd64": 
            case "x86_64": {
                return X86_64;
            }
            case "arm64": 
            case "aarch64": {
                return AArch64;
            }
        }
        throw new IllegalStateException("unknown CPU type: " + s);
    }

    public static ELFRelocationSection.ELFRelocationMethod getRelocation(ELFMachine m, ObjectFile.RelocationKind k, int sizeInBytes) {
        switch (m) {
            case X86_64: {
                switch (k) {
                    case DIRECT: {
                        switch (sizeInBytes) {
                            case 8: {
                                return ELFX86_64Relocation.R_64;
                            }
                            case 4: {
                                return ELFX86_64Relocation.R_32;
                            }
                            case 2: {
                                return ELFX86_64Relocation.R_16;
                            }
                            case 1: {
                                return ELFX86_64Relocation.R_8;
                            }
                        }
                        return ELFX86_64Relocation.R_NONE;
                    }
                    case PC_RELATIVE: {
                        switch (sizeInBytes) {
                            case 8: {
                                return ELFX86_64Relocation.R_PC64;
                            }
                            case 4: {
                                return ELFX86_64Relocation.R_PC32;
                            }
                            case 2: {
                                return ELFX86_64Relocation.R_PC16;
                            }
                            case 1: {
                                return ELFX86_64Relocation.R_PC8;
                            }
                        }
                        return ELFX86_64Relocation.R_NONE;
                    }
                    case PROGRAM_BASE: {
                        switch (sizeInBytes) {
                            case 8: {
                                return ELFX86_64Relocation.R_RELATIVE64;
                            }
                            case 4: {
                                return ELFX86_64Relocation.R_RELATIVE;
                            }
                        }
                        return ELFX86_64Relocation.R_NONE;
                    }
                }
                throw new IllegalArgumentException("cannot map unknown relocation kind to an ELF x86-64 relocation type");
            }
            case AArch64: {
                switch (k) {
                    case DIRECT: {
                        switch (sizeInBytes) {
                            case 8: {
                                return ELFAArch64Relocation.R_AARCH64_ABS64;
                            }
                            case 4: {
                                return ELFAArch64Relocation.R_AARCH64_ABS32;
                            }
                            case 2: {
                                return ELFAArch64Relocation.R_AARCH64_ABS16;
                            }
                        }
                        return ELFAArch64Relocation.R_AARCH64_NONE;
                    }
                    case AARCH64_R_MOVW_UABS_G0: {
                        return ELFAArch64Relocation.R_AARCH64_MOVW_UABS_G0;
                    }
                    case AARCH64_R_MOVW_UABS_G0_NC: {
                        return ELFAArch64Relocation.R_AARCH64_MOVW_UABS_G0_NC;
                    }
                    case AARCH64_R_MOVW_UABS_G1: {
                        return ELFAArch64Relocation.R_AARCH64_MOVW_UABS_G1;
                    }
                    case AARCH64_R_MOVW_UABS_G1_NC: {
                        return ELFAArch64Relocation.R_AARCH64_MOVW_UABS_G1_NC;
                    }
                    case AARCH64_R_MOVW_UABS_G2: {
                        return ELFAArch64Relocation.R_AARCH64_MOVW_UABS_G2;
                    }
                    case AARCH64_R_MOVW_UABS_G2_NC: {
                        return ELFAArch64Relocation.R_AARCH64_MOVW_UABS_G2_NC;
                    }
                    case AARCH64_R_MOVW_UABS_G3: {
                        return ELFAArch64Relocation.R_AARCH64_MOVW_UABS_G3;
                    }
                    case AARCH64_R_AARCH64_ADR_PREL_PG_HI21: {
                        return ELFAArch64Relocation.R_AARCH64_ADR_PREL_PG_HI21;
                    }
                    case AARCH64_R_AARCH64_LDST128_ABS_LO12_NC: {
                        return ELFAArch64Relocation.R_AARCH64_LDST128_ABS_LO12_NC;
                    }
                    case AARCH64_R_AARCH64_ADD_ABS_LO12_NC: {
                        return ELFAArch64Relocation.R_AARCH64_ADD_ABS_LO12_NC;
                    }
                    case AARCH64_R_GOT_LD_PREL19: {
                        return ELFAArch64Relocation.R_AARCH64_GOT_LD_PREL19;
                    }
                    case AARCH64_R_LD_PREL_LO19: {
                        return ELFAArch64Relocation.R_AARCH64_LD_PREL_LO19;
                    }
                    case AARCH64_R_AARCH64_LDST64_ABS_LO12_NC: {
                        return ELFAArch64Relocation.R_AARCH64_LDST64_ABS_LO12_NC;
                    }
                    case AARCH64_R_AARCH64_LDST32_ABS_LO12_NC: {
                        return ELFAArch64Relocation.R_AARCH64_LDST32_ABS_LO12_NC;
                    }
                    case AARCH64_R_AARCH64_LDST16_ABS_LO12_NC: {
                        return ELFAArch64Relocation.R_AARCH64_LDST16_ABS_LO12_NC;
                    }
                    case AARCH64_R_AARCH64_LDST8_ABS_LO12_NC: {
                        return ELFAArch64Relocation.R_AARCH64_LDST8_ABS_LO12_NC;
                    }
                }
                throw new IllegalArgumentException("cannot map unknown relocation kind to an ELF aarch64 relocation type: " + (Object)((Object)k));
            }
            case CAVA: {
                switch (k) {
                    case DIRECT_LO: {
                        switch (sizeInBytes) {
                            case 2: {
                                return ELFCavaRelocation.R_CAVA_OFFSET;
                            }
                        }
                        throw new RuntimeException(Integer.toString(sizeInBytes));
                    }
                    case DIRECT_HI: {
                        switch (sizeInBytes) {
                            case 2: {
                                return ELFCavaRelocation.R_CAVA_HIGH;
                            }
                        }
                        throw new RuntimeException(Integer.toString(sizeInBytes));
                    }
                }
                throw new RuntimeException(k.toString());
            }
        }
        return ELFDummyRelocation.R_NONE;
    }

    public static ELFMachine from(int m) {
        switch (m) {
            case 0: {
                return NONE;
            }
            case 62: {
                return X86_64;
            }
            case 183: {
                return AArch64;
            }
        }
        throw new IllegalStateException("unknown ELF machine type");
    }

    public short toShort() {
        if (this == NONE) {
            return 0;
        }
        if (this == AArch64) {
            return 183;
        }
        if (this == X86_64) {
            return 62;
        }
        if (this == AArch64) {
            return 183;
        }
        if (this == CAVA) {
            return -13570;
        }
        throw new IllegalStateException("should not reach here");
    }

    public static ELFMachine getSystemNativeValue() {
        if (System.getProperty("os.arch").equals("aarch64")) {
            return AArch64;
        }
        return X86_64;
    }
}

