/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.debugentry;

import com.oracle.objectfile.debugentry.StringEntry;
import java.util.HashMap;
import java.util.Iterator;

public class StringTable
implements Iterable<StringEntry> {
    private final HashMap<String, StringEntry> table = new HashMap();

    public String uniqueString(String string) {
        return this.ensureString(string, false);
    }

    public String uniqueDebugString(String string) {
        return this.ensureString(string, true);
    }

    private String ensureString(String string, boolean addToStrSection) {
        StringEntry stringEntry = this.table.get(string);
        if (stringEntry == null) {
            stringEntry = new StringEntry(string);
            this.table.put(string, stringEntry);
        }
        if (addToStrSection && !stringEntry.isAddToStrSection()) {
            stringEntry.setAddToStrSection();
        }
        return stringEntry.getString();
    }

    public int debugStringIndex(String string) {
        StringEntry stringEntry = this.table.get(string);
        assert (stringEntry != null);
        if (stringEntry == null) {
            return -1;
        }
        return stringEntry.getOffset();
    }

    @Override
    public Iterator<StringEntry> iterator() {
        return this.table.values().iterator();
    }
}

