/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile;

import com.oracle.objectfile.ObjectFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.TreeSet;

public class ElementList
implements List<ObjectFile.Element> {
    private List<ObjectFile.Element> entries = new ArrayList<ObjectFile.Element>();
    protected final Map<String, ObjectFile.Element> elementForName = new HashMap<String, ObjectFile.Element>();
    private NavigableSet<Integer> nonSectionElementIndices = new TreeSet<Integer>();
    private NavigableSet<Integer> sectionElementIndices = new TreeSet<Integer>();

    public ObjectFile.Element forName(String name) {
        return this.elementForName.get(name);
    }

    public int elementIndexToSectionIndex(int i) {
        SortedSet<Integer> lowerNonSectionElements = this.nonSectionElementIndices.headSet(i);
        return i - lowerNonSectionElements.size();
    }

    public int sectionIndexToElementIndex(int sectionIndex) {
        int toReturn;
        int pivot = ((Integer)this.sectionElementIndices.first() + (Integer)this.sectionElementIndices.last()) / 2;
        int leftOffset = 0;
        SortedSet<Integer> leftSet = this.sectionElementIndices.headSet(pivot);
        SortedSet<Integer> rightSet = this.sectionElementIndices.tailSet(pivot);
        int rightHeadIndex = leftOffset + leftSet.size();
        while (leftSet.size() + rightSet.size() > 1) {
            SortedSet<Integer> newRightSet;
            SortedSet<Integer> newLeftSet;
            if (rightHeadIndex > sectionIndex) {
                if (leftSet.size() == 0) {
                    throw new IndexOutOfBoundsException();
                }
                pivot = (int)Math.floor((double)(leftSet.first() + leftSet.last()) / 2.0);
                newLeftSet = leftSet.headSet(pivot);
                newRightSet = leftSet.tailSet(pivot);
                assert (!leftSet.equals(newLeftSet) || !rightSet.equals(newRightSet));
                leftSet = newLeftSet;
                rightSet = newRightSet;
            } else {
                if (rightSet.size() == 0) {
                    throw new IndexOutOfBoundsException();
                }
                pivot = (int)Math.ceil((double)(rightSet.first() + rightSet.last()) / 2.0);
                leftOffset += leftSet.size();
                newLeftSet = rightSet.headSet(pivot);
                newRightSet = rightSet.tailSet(pivot);
                assert (!leftSet.equals(newLeftSet) || !rightSet.equals(newRightSet));
                leftSet = newLeftSet;
                rightSet = newRightSet;
            }
            rightHeadIndex = leftOffset + leftSet.size();
        }
        if (rightHeadIndex > sectionIndex && leftSet.size() == 0 || rightHeadIndex <= sectionIndex && rightSet.size() == 0) {
            throw new IndexOutOfBoundsException();
        }
        int n = toReturn = rightHeadIndex > sectionIndex ? leftSet.last().intValue() : rightSet.first().intValue();
        assert (toReturn == this.sectionIndexToElementIndexNaive(sectionIndex));
        return toReturn;
    }

    ObjectFile.Section getSection(int sectionIndex) {
        int elementIndex = this.sectionIndexToElementIndex(sectionIndex);
        if (elementIndex == -1) {
            return null;
        }
        ObjectFile.Element found = this.get(elementIndex);
        assert (found instanceof ObjectFile.Section);
        return (ObjectFile.Section)found;
    }

    public int sectionIndexToElementIndexNaive(int i) {
        ObjectFile.Section s = null;
        int si = -1;
        Iterator<ObjectFile.Section> iter = this.sectionsIterator();
        while (iter.hasNext()) {
            ObjectFile.Section cur = iter.next();
            if (i != ++si) continue;
            s = cur;
            break;
        }
        if (s == null) {
            assert (i == this.sectionsCount());
            return this.size();
        }
        assert (s != null);
        int ei = si;
        while (this.get(ei) != s) {
            ++ei;
        }
        return ei;
    }

    public Iterator<ObjectFile.Section> sectionsIterator() {
        return this.entries.stream().filter(element -> element instanceof ObjectFile.Section).map(element -> (ObjectFile.Section)element).iterator();
    }

    public int sectionsCount() {
        return this.sectionElementIndices.size();
    }

    public int nonSectionsCount() {
        return this.nonSectionElementIndices.size();
    }

    private void decrementSectionCounters(ObjectFile.Element removed, int pos) {
        if (removed instanceof ObjectFile.Section) {
            this.sectionElementIndices.remove(pos);
        } else {
            this.nonSectionElementIndices.remove(pos);
        }
    }

    private void incrementSectionCounters(ObjectFile.Element added, int pos) {
        if (added instanceof ObjectFile.Section) {
            this.sectionElementIndices.add(pos);
        } else {
            this.nonSectionElementIndices.add(pos);
        }
    }

    @Override
    public boolean add(ObjectFile.Element arg) {
        this.elementForName.put(arg.getName(), arg);
        boolean changed = this.entries.add(arg);
        if (changed) {
            int pos = this.size() - 1;
            this.incrementSectionCounters(arg, pos);
        }
        return changed;
    }

    @Override
    public boolean addAll(Collection<? extends ObjectFile.Element> arg) {
        boolean changed = false;
        for (ObjectFile.Element element : arg) {
            changed |= this.add(element);
        }
        return changed;
    }

    @Override
    public void clear() {
        this.entries.clear();
        this.elementForName.clear();
        this.sectionElementIndices.clear();
        this.nonSectionElementIndices.clear();
    }

    @Override
    public boolean contains(Object arg) {
        return this.entries.contains(arg);
    }

    @Override
    public boolean containsAll(Collection<?> arg) {
        return this.entries.containsAll(arg);
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public Iterator<ObjectFile.Element> iterator() {
        return this.entries.iterator();
    }

    @Override
    public boolean remove(Object arg) {
        boolean ret = this.entries.remove(arg);
        int pos = this.entries.indexOf(arg);
        if (ret) {
            this.decrementSectionCounters((ObjectFile.Element)arg, pos);
            ElementList.adjustAllGE(this.nonSectionElementIndices, pos, -1);
            ElementList.adjustAllGE(this.sectionElementIndices, pos, -1);
            this.elementForName.remove(((ObjectFile.Element)arg).getName());
        }
        return ret;
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        boolean removed = false;
        for (Object o : arg0) {
            removed |= this.remove(o);
        }
        return removed;
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        boolean changed = false;
        for (ObjectFile.Element e : this) {
            if (arg0.contains(e)) continue;
            changed |= this.remove(e);
        }
        return changed;
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public Object[] toArray() {
        return this.entries.toArray();
    }

    @Override
    public <T> T[] toArray(T[] arg) {
        return this.entries.toArray(arg);
    }

    static void adjustAllGE(SortedSet<Integer> t, int pos, int diff) {
        TreeSet<Integer> tmp = new TreeSet<Integer>();
        SortedSet<Integer> tailSet = t.tailSet(pos);
        for (Integer i : tailSet) {
            tmp.add(i + diff);
        }
        t.removeAll(tailSet);
        t.addAll(tmp);
    }

    @Override
    public void add(int pos, ObjectFile.Element arg1) {
        ElementList.adjustAllGE(this.sectionElementIndices, pos, 1);
        ElementList.adjustAllGE(this.nonSectionElementIndices, pos, 1);
        this.entries.add(pos, arg1);
        (arg1 instanceof ObjectFile.Section ? this.sectionElementIndices : this.nonSectionElementIndices).add(pos);
        this.elementForName.put(arg1.getName(), arg1);
    }

    @Override
    public boolean addAll(int arg0, Collection<? extends ObjectFile.Element> arg1) {
        int pos = arg0;
        boolean changed = false;
        for (ObjectFile.Element element : arg1) {
            this.add(pos++, element);
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean equals(Object arg0) {
        return this.entries.equals(arg0);
    }

    @Override
    public ObjectFile.Element get(int arg0) {
        return this.entries.get(arg0);
    }

    @Override
    public int hashCode() {
        return this.entries.hashCode();
    }

    @Override
    public int indexOf(Object arg0) {
        return this.entries.indexOf(arg0);
    }

    @Override
    public int lastIndexOf(Object arg0) {
        return this.entries.lastIndexOf(arg0);
    }

    @Override
    public ListIterator<ObjectFile.Element> listIterator() {
        return this.entries.listIterator();
    }

    @Override
    public ListIterator<ObjectFile.Element> listIterator(int arg0) {
        return this.entries.listIterator(arg0);
    }

    @Override
    public ObjectFile.Element remove(int arg0) {
        ElementList.adjustAllGE(this.sectionElementIndices, arg0, -1);
        ElementList.adjustAllGE(this.nonSectionElementIndices, arg0, -1);
        ObjectFile.Element e = this.entries.remove(arg0);
        this.elementForName.remove(e.getName());
        return e;
    }

    @Override
    public ObjectFile.Element set(int arg0, ObjectFile.Element arg1) {
        ObjectFile.Element replaced = this.entries.set(arg0, arg1);
        this.elementForName.remove(replaced.getName());
        this.elementForName.put(arg1.getName(), arg1);
        if (replaced instanceof ObjectFile.Section) {
            this.sectionElementIndices.remove(arg0);
        } else {
            this.nonSectionElementIndices.remove(arg0);
        }
        if (arg1 instanceof ObjectFile.Section) {
            this.sectionElementIndices.add(arg0);
        } else {
            this.nonSectionElementIndices.add(arg0);
        }
        return replaced;
    }

    @Override
    public List<ObjectFile.Element> subList(int arg0, int arg1) {
        return this.entries.subList(arg0, arg1);
    }
}

