/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.vector;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.llvm.runtime.types.Type;

@CompilerDirectives.ValueType
public abstract class LLVMVector {
    public abstract int getLength();

    public abstract Type getElementType();

    public abstract Object getElement(int var1);

    @CompilerDirectives.TruffleBoundary
    private String getTypedElementString(int index) {
        return String.format("%s %s", this.getElementType(), this.getElement(index));
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("< ").append(this.getLength()).append(" x ").append(this.getElementType()).append(" > < ");
        if (this.getLength() > 0) {
            builder.append(this.getTypedElementString(0));
        }
        for (int i = 1; i < this.getLength(); ++i) {
            builder.append(", ").append(this.getTypedElementString(i));
        }
        builder.append(" >");
        return builder.toString();
    }
}

