/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMWithElementPtrStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMOffsetStoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=LLVMWithElementPtrStoreNode.class)
public final class LLVMWithElementPtrStoreNodeGen
extends LLVMWithElementPtrStoreNode
implements GenerateAOT.Provider {
    @Node.Child
    private LLVMExpressionNode base_;
    @Node.Child
    private LLVMExpressionNode offset_;
    @CompilerDirectives.CompilationFinal
    private int state_0_;

    private LLVMWithElementPtrStoreNodeGen(LLVMOffsetStoreNode store, long typeWidth, LLVMExpressionNode base, LLVMExpressionNode offset) {
        super(store, typeWidth);
        this.base_ = base;
        this.offset_ = offset;
    }

    @Override
    public void execute(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0x36) == 0 && (state_0 & 0x3E) != 0) {
            this.execute_int0(state_0, frameValue);
            return;
        }
        if ((state_0 & 0x2E) == 0 && (state_0 & 0x3E) != 0) {
            this.execute_long1(state_0, frameValue);
            return;
        }
        this.execute_generic2(state_0, frameValue);
    }

    private void execute_int0(int state_0__, VirtualFrame frameValue) {
        int offsetValue_;
        int state_0 = state_0__;
        Object baseValue_ = this.base_.executeGeneric(frameValue);
        try {
            offsetValue_ = this.offset_.executeI32(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, baseValue_, ex.getResult());
            return;
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
            this.executeAndSpecialize(frameValue, baseValue_, offsetValue_);
            return;
        }
        assert ((state_0 & 8) != 0);
        if (LLVMTypes.isPointer(baseValue_)) {
            LLVMPointer baseValue__ = LLVMTypes.asPointer(baseValue_);
            this.doInt(frameValue, baseValue__, offsetValue_);
            return;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.executeAndSpecialize(frameValue, baseValue_, offsetValue_);
    }

    private void execute_long1(int state_0__, VirtualFrame frameValue) {
        long offsetValue_;
        int state_0 = state_0__;
        Object baseValue_ = this.base_.executeGeneric(frameValue);
        try {
            offsetValue_ = this.offset_.executeI64(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, baseValue_, ex.getResult());
            return;
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
            this.executeAndSpecialize(frameValue, baseValue_, offsetValue_);
            return;
        }
        assert ((state_0 & 0x10) != 0);
        if (LLVMTypes.isPointer(baseValue_)) {
            LLVMPointer baseValue__ = LLVMTypes.asPointer(baseValue_);
            this.doLong(frameValue, baseValue__, offsetValue_);
            return;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.executeAndSpecialize(frameValue, baseValue_, offsetValue_);
    }

    private void execute_generic2(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        Object baseValue_ = this.base_.executeGeneric(frameValue);
        Object offsetValue_ = this.offset_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
            this.executeAndSpecialize(frameValue, baseValue_, offsetValue_);
            return;
        }
        if ((state_0 & 0x3E) != 0) {
            LLVMPointer offsetValue__;
            LLVMPointer baseValue__;
            if ((state_0 & 6) != 0 && LLVMTypes.isManagedPointer(baseValue_)) {
                baseValue__ = LLVMTypes.asManagedPointer(baseValue_);
                if (LLVMTypes.isManagedPointer(offsetValue_)) {
                    offsetValue__ = LLVMTypes.asManagedPointer(offsetValue_);
                    if ((state_0 & 2) != 0 && LLVMWithElementPtrStoreNode.isNegated(baseValue__.getObject(), offsetValue__.getObject())) {
                        this.doPointerDiff(frameValue, (LLVMManagedPointer)baseValue__, (LLVMManagedPointer)offsetValue__);
                        return;
                    }
                    if ((state_0 & 4) != 0 && LLVMWithElementPtrStoreNode.isNegated(offsetValue__.getObject(), baseValue__.getObject())) {
                        this.doPointerDiffRev(frameValue, (LLVMManagedPointer)baseValue__, (LLVMManagedPointer)offsetValue__);
                        return;
                    }
                }
            }
            if ((state_0 & 0x38) != 0 && LLVMTypes.isPointer(baseValue_)) {
                baseValue__ = LLVMTypes.asPointer(baseValue_);
                if ((state_0 & 8) != 0 && offsetValue_ instanceof Integer) {
                    int offsetValue__2 = (Integer)offsetValue_;
                    this.doInt(frameValue, baseValue__, offsetValue__2);
                    return;
                }
                if ((state_0 & 0x10) != 0 && offsetValue_ instanceof Long) {
                    long offsetValue__3 = (Long)offsetValue_;
                    this.doLong(frameValue, baseValue__, offsetValue__3);
                    return;
                }
                if ((state_0 & 0x20) != 0 && LLVMTypes.isNativePointer(offsetValue_)) {
                    offsetValue__ = LLVMTypes.asNativePointer(offsetValue_);
                    this.doNativePointer(frameValue, baseValue__, (LLVMNativePointer)offsetValue__);
                    return;
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.executeAndSpecialize(frameValue, baseValue_, offsetValue_);
    }

    private void executeAndSpecialize(VirtualFrame frameValue, Object baseValue, Object offsetValue) {
        LLVMPointer offsetValue_;
        LLVMPointer baseValue_;
        int state_0 = this.state_0_;
        if ((state_0 & 1) != 0) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (LLVMTypes.isManagedPointer(baseValue)) {
            baseValue_ = LLVMTypes.asManagedPointer(baseValue);
            if (LLVMTypes.isManagedPointer(offsetValue)) {
                offsetValue_ = LLVMTypes.asManagedPointer(offsetValue);
                if (LLVMWithElementPtrStoreNode.isNegated(baseValue_.getObject(), offsetValue_.getObject())) {
                    this.state_0_ = state_0 |= 2;
                    this.doPointerDiff(frameValue, (LLVMManagedPointer)baseValue_, (LLVMManagedPointer)offsetValue_);
                    return;
                }
                if (LLVMWithElementPtrStoreNode.isNegated(offsetValue_.getObject(), baseValue_.getObject())) {
                    this.state_0_ = state_0 |= 4;
                    this.doPointerDiffRev(frameValue, (LLVMManagedPointer)baseValue_, (LLVMManagedPointer)offsetValue_);
                    return;
                }
            }
        }
        if (LLVMTypes.isPointer(baseValue)) {
            baseValue_ = LLVMTypes.asPointer(baseValue);
            if (offsetValue instanceof Integer) {
                int offsetValue_2 = (Integer)offsetValue;
                this.state_0_ = state_0 |= 8;
                this.doInt(frameValue, baseValue_, offsetValue_2);
                return;
            }
            if (offsetValue instanceof Long) {
                long offsetValue_3 = (Long)offsetValue;
                this.state_0_ = state_0 |= 0x10;
                this.doLong(frameValue, baseValue_, offsetValue_3);
                return;
            }
            if (LLVMTypes.isNativePointer(offsetValue)) {
                offsetValue_ = LLVMTypes.asNativePointer(offsetValue);
                this.state_0_ = state_0 |= 0x20;
                this.doNativePointer(frameValue, baseValue_, (LLVMNativePointer)offsetValue_);
                return;
            }
        }
        throw new UnsupportedSpecializationException((Node)this, new Node[]{this.base_, this.offset_}, new Object[]{baseValue, offsetValue});
    }

    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
        if ((this.state_0_ & 1) != 0) {
            return;
        }
        this.state_0_ |= 2;
        this.state_0_ |= 4;
        this.state_0_ |= 8;
        this.state_0_ |= 0x10;
        this.state_0_ |= 0x20;
        int state_0 = this.state_0_;
        this.state_0_ = state_0 |= 1;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if ((state_0 & 1) == 0) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMWithElementPtrStoreNode create(LLVMOffsetStoreNode store, long typeWidth, LLVMExpressionNode base, LLVMExpressionNode offset) {
        return new LLVMWithElementPtrStoreNodeGen(store, typeWidth, base, offset);
    }
}

