/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMBuiltin;

public abstract class LLVMExpect {
    private LLVMExpect() {
    }

    static ConditionProfile getExpectConditionProfile() {
        return ConditionProfile.create();
    }

    @NodeChild(type=LLVMExpressionNode.class, value="val")
    public static abstract class LLVMExpectI64
    extends LLVMBuiltin {
        private final ConditionProfile expectProfile = LLVMExpect.getExpectConditionProfile();
        private final long expected;

        public LLVMExpectI64(long expected) {
            this.expected = expected;
        }

        @Specialization
        protected long doI64(long val) {
            if (this.expectProfile.profile(val == this.expected)) {
                return this.expected;
            }
            return val;
        }
    }

    @NodeChild(type=LLVMExpressionNode.class, value="val")
    public static abstract class LLVMExpectI32
    extends LLVMBuiltin {
        private final ConditionProfile expectProfile = LLVMExpect.getExpectConditionProfile();
        private final int expected;

        public LLVMExpectI32(int expected) {
            this.expected = expected;
        }

        @Specialization
        protected int doI32(int val) {
            if (this.expectProfile.profile(val == this.expected)) {
                return this.expected;
            }
            return val;
        }
    }

    @NodeChild(type=LLVMExpressionNode.class, value="val")
    public static abstract class LLVMExpectI1
    extends LLVMBuiltin {
        private final ConditionProfile expectProfile = LLVMExpect.getExpectConditionProfile();
        private final boolean expected;

        public LLVMExpectI1(boolean expected) {
            this.expected = expected;
        }

        @Specialization
        protected boolean doI1(boolean val) {
            if (this.expectProfile.profile(val == this.expected)) {
                return this.expected;
            }
            return val;
        }
    }
}

