/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InvalidBufferOffsetException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI16LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI32LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI64LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI8LoadNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.nio.ByteOrder;

public abstract class LLVMPolyglotReadBuffer
extends LLVMNode {
    protected boolean isBufferPointer(LLVMPointer receiver) {
        return receiver.getExportType() instanceof LLVMInteropType.Buffer;
    }

    protected boolean inBounds(LLVMPointer receiver, long byteOffset, int length) {
        return length >= 0 && byteOffset >= 0L && byteOffset + (long)length <= receiver.getExportType().getSize();
    }

    protected boolean isNativeOrder(ByteOrder order) {
        return order == ByteOrder.nativeOrder();
    }

    protected void throwUnsupported(LLVMPointer receiver, long byteOffset) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    protected void throwUnsupported(LLVMPointer receiver, long byteOffset, byte[] destination, int destinationOffset, int length) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @GenerateUncached
    public static abstract class LLVMPolyglotReadBufferDoubleNode
    extends LLVMPolyglotReadBuffer {
        public abstract double execute(LLVMPointer var1, ByteOrder var2, long var3) throws UnsupportedMessageException, InvalidBufferOffsetException;

        @Specialization(guards={"isBufferPointer(receiver)"})
        public double doNative(LLVMNativePointer receiver, ByteOrder order, long byteOffset, @Cached BranchProfile exception, @Cached LLVMI64LoadNode.LLVMI64OffsetLoadNode loadOffset) throws InvalidBufferOffsetException, UnsupportedMessageException {
            if (this.inBounds(receiver, byteOffset, 8)) {
                try {
                    long bits = loadOffset.executeWithTarget(receiver, byteOffset);
                    return Double.longBitsToDouble(this.isNativeOrder(order) ? bits : Long.reverseBytes(bits));
                }
                catch (UnexpectedResultException ex) {
                    this.throwUnsupported(receiver, byteOffset);
                    return 0.0;
                }
            }
            exception.enter();
            throw InvalidBufferOffsetException.create((long)byteOffset, (long)8L);
        }

        @Specialization(guards={"isBufferPointer(pointer)", "!foreignsLib.isForeign(pointer)"}, limit="3")
        @GenerateAOT.Exclude
        public double nonForeignRead(LLVMManagedPointer pointer, ByteOrder order, long byteOffset, @Cached LLVMI64LoadNode.LLVMI64OffsetLoadNode loadOffset, @Cached BranchProfile exception, @CachedLibrary(value="pointer") LLVMAsForeignLibrary foreignsLib) throws InvalidBufferOffsetException, UnsupportedMessageException {
            if (this.inBounds(pointer, byteOffset, 8)) {
                try {
                    long bits = loadOffset.executeWithTarget(pointer, byteOffset);
                    return Double.longBitsToDouble(this.isNativeOrder(order) ? bits : Long.reverseBytes(bits));
                }
                catch (UnexpectedResultException ex) {
                    this.throwUnsupported(pointer, byteOffset);
                    return 0.0;
                }
            }
            exception.enter();
            throw InvalidBufferOffsetException.create((long)byteOffset, (long)8L);
        }

        @Fallback
        public double unsupported(LLVMPointer receiver, ByteOrder order, long byteOffset) throws UnsupportedMessageException {
            this.throwUnsupported(receiver, byteOffset);
            return 0.0;
        }
    }

    @GenerateUncached
    public static abstract class LLVMPolyglotReadBufferFloatNode
    extends LLVMPolyglotReadBuffer {
        public abstract float execute(LLVMPointer var1, ByteOrder var2, long var3) throws UnsupportedMessageException, InvalidBufferOffsetException;

        @Specialization(guards={"isBufferPointer(receiver)"})
        public float doNative(LLVMNativePointer receiver, ByteOrder order, long byteOffset, @Cached BranchProfile exception, @Cached LLVMI32LoadNode.LLVMI32OffsetLoadNode loadOffset) throws InvalidBufferOffsetException {
            if (this.inBounds(receiver, byteOffset, 4)) {
                int bits = loadOffset.executeWithTarget(receiver, byteOffset);
                return Float.intBitsToFloat(this.isNativeOrder(order) ? bits : Integer.reverseBytes(bits));
            }
            exception.enter();
            throw InvalidBufferOffsetException.create((long)byteOffset, (long)4L);
        }

        @Specialization(guards={"isBufferPointer(pointer)", "!foreignsLib.isForeign(pointer)"}, limit="3")
        @GenerateAOT.Exclude
        public float nonForeignRead(LLVMManagedPointer pointer, ByteOrder order, long byteOffset, @Cached LLVMI32LoadNode.LLVMI32OffsetLoadNode loadOffset, @Cached BranchProfile exception, @CachedLibrary(value="pointer") LLVMAsForeignLibrary foreignsLib) throws InvalidBufferOffsetException {
            if (this.inBounds(pointer, byteOffset, 4)) {
                int bits = loadOffset.executeWithTarget(pointer, byteOffset);
                return Float.intBitsToFloat(this.isNativeOrder(order) ? bits : Integer.reverseBytes(bits));
            }
            exception.enter();
            throw InvalidBufferOffsetException.create((long)byteOffset, (long)4L);
        }

        @Fallback
        public float unsupported(LLVMPointer receiver, ByteOrder order, long byteOffset) throws UnsupportedMessageException {
            this.throwUnsupported(receiver, byteOffset);
            return 0.0f;
        }
    }

    @GenerateUncached
    public static abstract class LLVMPolyglotReadBufferLongNode
    extends LLVMPolyglotReadBuffer {
        public abstract long execute(LLVMPointer var1, ByteOrder var2, long var3) throws UnsupportedMessageException, InvalidBufferOffsetException;

        @Specialization(guards={"isBufferPointer(receiver)"})
        public long doNative(LLVMNativePointer receiver, ByteOrder order, long byteOffset, @Cached BranchProfile exception, @Cached LLVMI64LoadNode.LLVMI64OffsetLoadNode loadOffset) throws InvalidBufferOffsetException, UnsupportedMessageException {
            if (this.inBounds(receiver, byteOffset, 8)) {
                try {
                    long v = loadOffset.executeWithTarget(receiver, byteOffset);
                    return this.isNativeOrder(order) ? v : Long.reverseBytes(v);
                }
                catch (UnexpectedResultException ex) {
                    this.throwUnsupported(receiver, byteOffset);
                    return 0L;
                }
            }
            exception.enter();
            throw InvalidBufferOffsetException.create((long)byteOffset, (long)8L);
        }

        @Specialization(guards={"isBufferPointer(pointer)", "!foreignsLib.isForeign(pointer)"}, limit="3")
        @GenerateAOT.Exclude
        public long nonForeignRead(LLVMManagedPointer pointer, ByteOrder order, long byteOffset, @Cached LLVMI64LoadNode.LLVMI64OffsetLoadNode loadOffset, @Cached BranchProfile exception, @CachedLibrary(value="pointer") LLVMAsForeignLibrary foreignsLib) throws InvalidBufferOffsetException, UnsupportedMessageException {
            if (this.inBounds(pointer, byteOffset, 8)) {
                try {
                    long v = loadOffset.executeWithTarget(pointer, byteOffset);
                    return this.isNativeOrder(order) ? v : Long.reverseBytes(v);
                }
                catch (UnexpectedResultException ex) {
                    this.throwUnsupported(pointer, byteOffset);
                    return 0L;
                }
            }
            exception.enter();
            throw InvalidBufferOffsetException.create((long)byteOffset, (long)8L);
        }

        @Fallback
        public long unsupported(LLVMPointer receiver, ByteOrder order, long byteOffset) throws UnsupportedMessageException {
            this.throwUnsupported(receiver, byteOffset);
            return 0L;
        }
    }

    @GenerateUncached
    public static abstract class LLVMPolyglotReadBufferIntNode
    extends LLVMPolyglotReadBuffer {
        public abstract int execute(LLVMPointer var1, ByteOrder var2, long var3) throws UnsupportedMessageException, InvalidBufferOffsetException;

        @Specialization(guards={"isBufferPointer(receiver)"})
        public int doNative(LLVMNativePointer receiver, ByteOrder order, long byteOffset, @Cached BranchProfile exception, @Cached LLVMI32LoadNode.LLVMI32OffsetLoadNode loadOffset) throws InvalidBufferOffsetException {
            if (this.inBounds(receiver, byteOffset, 4)) {
                int v = loadOffset.executeWithTarget(receiver, byteOffset);
                return this.isNativeOrder(order) ? v : Integer.reverseBytes(v);
            }
            exception.enter();
            throw InvalidBufferOffsetException.create((long)byteOffset, (long)4L);
        }

        @Specialization(guards={"isBufferPointer(pointer)", "!foreignsLib.isForeign(pointer)"}, limit="3")
        @GenerateAOT.Exclude
        public int nonForeignRead(LLVMManagedPointer pointer, ByteOrder order, long byteOffset, @Cached LLVMI32LoadNode.LLVMI32OffsetLoadNode loadOffset, @Cached BranchProfile exception, @CachedLibrary(value="pointer") LLVMAsForeignLibrary foreignsLib) throws InvalidBufferOffsetException {
            if (this.inBounds(pointer, byteOffset, 4)) {
                int v = loadOffset.executeWithTarget(pointer, byteOffset);
                return this.isNativeOrder(order) ? v : Integer.reverseBytes(v);
            }
            exception.enter();
            throw InvalidBufferOffsetException.create((long)byteOffset, (long)4L);
        }

        @Fallback
        public int unsupported(LLVMPointer receiver, ByteOrder order, long byteOffset) throws UnsupportedMessageException {
            this.throwUnsupported(receiver, byteOffset);
            return 0;
        }
    }

    @GenerateUncached
    public static abstract class LLVMPolyglotReadBufferShortNode
    extends LLVMPolyglotReadBuffer {
        public abstract short execute(LLVMPointer var1, ByteOrder var2, long var3) throws UnsupportedMessageException, InvalidBufferOffsetException;

        @Specialization(guards={"isBufferPointer(receiver)"})
        public short doNative(LLVMNativePointer receiver, ByteOrder order, long byteOffset, @Cached BranchProfile exception, @Cached LLVMI16LoadNode.LLVMI16OffsetLoadNode loadOffset) throws InvalidBufferOffsetException {
            if (this.inBounds(receiver, byteOffset, 2)) {
                short v = loadOffset.executeWithTarget(receiver, byteOffset);
                return this.isNativeOrder(order) ? v : Short.reverseBytes(v);
            }
            exception.enter();
            throw InvalidBufferOffsetException.create((long)byteOffset, (long)2L);
        }

        @Specialization(guards={"isBufferPointer(pointer)", "!foreignsLib.isForeign(pointer)"}, limit="3")
        @GenerateAOT.Exclude
        public short nonForeignRead(LLVMManagedPointer pointer, ByteOrder order, long byteOffset, @Cached LLVMI16LoadNode.LLVMI16OffsetLoadNode loadOffset, @Cached BranchProfile exception, @CachedLibrary(value="pointer") LLVMAsForeignLibrary foreignsLib) throws InvalidBufferOffsetException {
            if (this.inBounds(pointer, byteOffset, 2)) {
                short v = loadOffset.executeWithTarget(pointer, byteOffset);
                return this.isNativeOrder(order) ? v : Short.reverseBytes(v);
            }
            exception.enter();
            throw InvalidBufferOffsetException.create((long)byteOffset, (long)2L);
        }

        @Fallback
        public short unsupported(LLVMPointer receiver, ByteOrder order, long byteOffset) throws UnsupportedMessageException {
            this.throwUnsupported(receiver, byteOffset);
            return 0;
        }
    }

    @GenerateUncached
    public static abstract class LLVMPolyglotReadBufferNode
    extends LLVMPolyglotReadBuffer {
        public abstract void execute(LLVMPointer var1, long var2, byte[] var4, int var5, int var6) throws UnsupportedMessageException, InvalidBufferOffsetException;

        @Specialization(guards={"isBufferPointer(receiver)"})
        public void doNative(LLVMNativePointer receiver, long byteOffset, byte[] destination, int destinationOffset, int length, @Cached BranchProfile exception, @Cached LLVMI8LoadNode.LLVMI8OffsetLoadNode loadOffset) throws InvalidBufferOffsetException {
            if (this.inBounds(receiver, byteOffset, length)) {
                for (long offset = byteOffset; offset < byteOffset + (long)length; ++offset) {
                    destination[destinationOffset + (int)(offset - byteOffset)] = loadOffset.executeWithTarget(receiver, offset);
                }
            } else {
                exception.enter();
                throw InvalidBufferOffsetException.create((long)byteOffset, (long)length);
            }
        }

        @Specialization(guards={"isBufferPointer(pointer)", "!foreignsLib.isForeign(pointer)"}, limit="3")
        @GenerateAOT.Exclude
        public void nonForeignRead(LLVMManagedPointer pointer, long byteOffset, byte[] destination, int destinationOffset, int length, @Cached LLVMI8LoadNode.LLVMI8OffsetLoadNode loadOffset, @Cached BranchProfile exception, @CachedLibrary(value="pointer") LLVMAsForeignLibrary foreignsLib) throws InvalidBufferOffsetException {
            if (this.inBounds(pointer, byteOffset, length)) {
                for (long offset = byteOffset; offset < byteOffset + (long)length; ++offset) {
                    destination[destinationOffset + (int)(offset - byteOffset)] = loadOffset.executeWithTarget(pointer, offset);
                }
            } else {
                exception.enter();
                throw InvalidBufferOffsetException.create((long)byteOffset, (long)length);
            }
        }

        @Fallback
        public void unsupported(LLVMPointer receiver, long byteOffset, byte[] destination, int destinationOffset, int length) throws UnsupportedMessageException {
            this.throwUnsupported(receiver, byteOffset, destination, destinationOffset, length);
        }
    }

    @GenerateUncached
    public static abstract class LLVMPolyglotReadBufferByteNode
    extends LLVMPolyglotReadBuffer {
        public abstract byte execute(LLVMPointer var1, long var2) throws UnsupportedMessageException, InvalidBufferOffsetException;

        @Specialization(guards={"isBufferPointer(receiver)"})
        public byte doNative(LLVMNativePointer receiver, long byteOffset, @Cached BranchProfile exception, @Cached LLVMI8LoadNode.LLVMI8OffsetLoadNode loadOffset) throws InvalidBufferOffsetException {
            if (this.inBounds(receiver, byteOffset, 1)) {
                return loadOffset.executeWithTarget(receiver, byteOffset);
            }
            exception.enter();
            throw InvalidBufferOffsetException.create((long)byteOffset, (long)1L);
        }

        @Specialization(guards={"isBufferPointer(pointer)", "!foreignsLib.isForeign(pointer)"}, limit="3")
        @GenerateAOT.Exclude
        public byte nonForeignRead(LLVMManagedPointer pointer, long byteOffset, @Cached LLVMI8LoadNode.LLVMI8OffsetLoadNode loadOffset, @Cached BranchProfile exception, @CachedLibrary(value="pointer") LLVMAsForeignLibrary foreignsLib) throws InvalidBufferOffsetException {
            if (this.inBounds(pointer, byteOffset, 1)) {
                return loadOffset.executeWithTarget(pointer, byteOffset);
            }
            exception.enter();
            throw InvalidBufferOffsetException.create((long)byteOffset, (long)1L);
        }

        @Fallback
        public byte unsupported(LLVMPointer receiver, long byteOffset) throws UnsupportedMessageException {
            this.throwUnsupported(receiver, byteOffset);
            return 0;
        }
    }
}

