/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.c;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.c.LLVMSyscall;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=LLVMSyscall.class)
public final class LLVMSyscallFactory {

    @GeneratedBy(value=LLVMSyscall.SyscallArgConverter.class)
    static final class SyscallArgConverterNodeGen
    extends LLVMSyscall.SyscallArgConverter
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode value_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private SyscallArgConverterNodeGen(LLVMExpressionNode value) {
            this.value_ = value;
        }

        private boolean fallbackGuard_(int state_0, Object valueValue) {
            if ((state_0 & 2) == 0 && valueValue instanceof Long) {
                return false;
            }
            if ((state_0 & 4) == 0 && valueValue instanceof Integer) {
                return false;
            }
            if ((state_0 & 8) == 0 && valueValue instanceof Short) {
                return false;
            }
            if ((state_0 & 0x10) == 0 && valueValue instanceof Byte) {
                return false;
            }
            return (state_0 & 0x20) != 0 || !LLVMTypes.isPointer(valueValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0x7C) == 0 && (state_0 & 0x7E) != 0) {
                return this.executeGeneric_long0(state_0, frameValue);
            }
            if ((state_0 & 0x7A) == 0 && (state_0 & 0x7E) != 0) {
                return this.executeGeneric_int1(state_0, frameValue);
            }
            if ((state_0 & 0x76) == 0 && (state_0 & 0x7E) != 0) {
                return this.executeGeneric_short2(state_0, frameValue);
            }
            if ((state_0 & 0x6E) == 0 && (state_0 & 0x7E) != 0) {
                return this.executeGeneric_byte3(state_0, frameValue);
            }
            return this.executeGeneric_generic4(state_0, frameValue);
        }

        private Object executeGeneric_long0(int state_0__, VirtualFrame frameValue) {
            long valueValue_;
            int state_0 = state_0__;
            try {
                valueValue_ = this.value_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(valueValue_);
            }
            assert ((state_0 & 2) != 0);
            return LLVMSyscall.SyscallArgConverter.convert(valueValue_);
        }

        private Object executeGeneric_int1(int state_0__, VirtualFrame frameValue) {
            int valueValue_;
            int state_0 = state_0__;
            try {
                valueValue_ = this.value_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(valueValue_);
            }
            assert ((state_0 & 4) != 0);
            return LLVMSyscall.SyscallArgConverter.convert(valueValue_);
        }

        private Object executeGeneric_short2(int state_0__, VirtualFrame frameValue) {
            short valueValue_;
            int state_0 = state_0__;
            try {
                valueValue_ = this.value_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(valueValue_);
            }
            assert ((state_0 & 8) != 0);
            return LLVMSyscall.SyscallArgConverter.convert(valueValue_);
        }

        private Object executeGeneric_byte3(int state_0__, VirtualFrame frameValue) {
            byte valueValue_;
            int state_0 = state_0__;
            try {
                valueValue_ = this.value_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(valueValue_);
            }
            assert ((state_0 & 0x10) != 0);
            return LLVMSyscall.SyscallArgConverter.convert(valueValue_);
        }

        private Object executeGeneric_generic4(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object valueValue_ = this.value_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(valueValue_);
            }
            if ((state_0 & 0x7E) != 0) {
                if ((state_0 & 2) != 0 && valueValue_ instanceof Long) {
                    long valueValue__ = (Long)valueValue_;
                    return LLVMSyscall.SyscallArgConverter.convert(valueValue__);
                }
                if ((state_0 & 4) != 0 && valueValue_ instanceof Integer) {
                    int valueValue__ = (Integer)valueValue_;
                    return LLVMSyscall.SyscallArgConverter.convert(valueValue__);
                }
                if ((state_0 & 8) != 0 && valueValue_ instanceof Short) {
                    short valueValue__ = (Short)valueValue_;
                    return LLVMSyscall.SyscallArgConverter.convert(valueValue__);
                }
                if ((state_0 & 0x10) != 0 && valueValue_ instanceof Byte) {
                    byte valueValue__ = (Byte)valueValue_;
                    return LLVMSyscall.SyscallArgConverter.convert(valueValue__);
                }
                if ((state_0 & 0x20) != 0 && LLVMTypes.isPointer(valueValue_)) {
                    LLVMPointer valueValue__ = LLVMTypes.asPointer(valueValue_);
                    return LLVMSyscall.SyscallArgConverter.convert(valueValue__);
                }
                if ((state_0 & 0x40) != 0 && this.fallbackGuard_(state_0, valueValue_)) {
                    return LLVMSyscall.SyscallArgConverter.convert(valueValue_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(valueValue_);
        }

        @Override
        public long executeI64(VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = this.state_0_;
            if ((state_0 & 0x40) != 0) {
                return LLVMTypesGen.expectLong(this.executeGeneric(frameValue));
            }
            if ((state_0 & 0x1C) == 0 && (state_0 & 0x1E) != 0) {
                return this.executeI64_long5(state_0, frameValue);
            }
            if ((state_0 & 0x1A) == 0 && (state_0 & 0x1E) != 0) {
                return this.executeI64_int6(state_0, frameValue);
            }
            if ((state_0 & 0x16) == 0 && (state_0 & 0x1E) != 0) {
                return this.executeI64_short7(state_0, frameValue);
            }
            if ((state_0 & 0xE) == 0 && (state_0 & 0x1E) != 0) {
                return this.executeI64_byte8(state_0, frameValue);
            }
            return this.executeI64_generic9(state_0, frameValue);
        }

        private long executeI64_long5(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            long valueValue_;
            int state_0 = state_0__;
            try {
                valueValue_ = this.value_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(valueValue_));
            }
            assert ((state_0 & 2) != 0);
            return LLVMSyscall.SyscallArgConverter.convert(valueValue_);
        }

        private long executeI64_int6(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            int valueValue_;
            int state_0 = state_0__;
            try {
                valueValue_ = this.value_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(valueValue_));
            }
            assert ((state_0 & 4) != 0);
            return LLVMSyscall.SyscallArgConverter.convert(valueValue_);
        }

        private long executeI64_short7(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            short valueValue_;
            int state_0 = state_0__;
            try {
                valueValue_ = this.value_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(valueValue_));
            }
            assert ((state_0 & 8) != 0);
            return LLVMSyscall.SyscallArgConverter.convert(valueValue_);
        }

        private long executeI64_byte8(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            byte valueValue_;
            int state_0 = state_0__;
            try {
                valueValue_ = this.value_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(valueValue_));
            }
            assert ((state_0 & 0x10) != 0);
            return LLVMSyscall.SyscallArgConverter.convert(valueValue_);
        }

        private long executeI64_generic9(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = state_0__;
            Object valueValue_ = this.value_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(valueValue_));
            }
            if ((state_0 & 0x1E) != 0) {
                if ((state_0 & 2) != 0 && valueValue_ instanceof Long) {
                    long valueValue__ = (Long)valueValue_;
                    return LLVMSyscall.SyscallArgConverter.convert(valueValue__);
                }
                if ((state_0 & 4) != 0 && valueValue_ instanceof Integer) {
                    int valueValue__ = (Integer)valueValue_;
                    return LLVMSyscall.SyscallArgConverter.convert(valueValue__);
                }
                if ((state_0 & 8) != 0 && valueValue_ instanceof Short) {
                    short valueValue__ = (Short)valueValue_;
                    return LLVMSyscall.SyscallArgConverter.convert(valueValue__);
                }
                if ((state_0 & 0x10) != 0 && valueValue_ instanceof Byte) {
                    byte valueValue__ = (Byte)valueValue_;
                    return LLVMSyscall.SyscallArgConverter.convert(valueValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(this.executeAndSpecialize(valueValue_));
        }

        private Object executeAndSpecialize(Object valueValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (valueValue instanceof Long) {
                long valueValue_ = (Long)valueValue;
                this.state_0_ = state_0 |= 2;
                return LLVMSyscall.SyscallArgConverter.convert(valueValue_);
            }
            if (valueValue instanceof Integer) {
                int valueValue_ = (Integer)valueValue;
                this.state_0_ = state_0 |= 4;
                return LLVMSyscall.SyscallArgConverter.convert(valueValue_);
            }
            if (valueValue instanceof Short) {
                short valueValue_ = (Short)valueValue;
                this.state_0_ = state_0 |= 8;
                return LLVMSyscall.SyscallArgConverter.convert(valueValue_);
            }
            if (valueValue instanceof Byte) {
                byte valueValue_ = (Byte)valueValue;
                this.state_0_ = state_0 |= 0x10;
                return LLVMSyscall.SyscallArgConverter.convert(valueValue_);
            }
            if (LLVMTypes.isPointer(valueValue)) {
                LLVMPointer valueValue_ = LLVMTypes.asPointer(valueValue);
                this.state_0_ = state_0 |= 0x20;
                return LLVMSyscall.SyscallArgConverter.convert(valueValue_);
            }
            this.state_0_ = state_0 |= 0x40;
            return LLVMSyscall.SyscallArgConverter.convert(valueValue);
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            this.state_0_ |= 4;
            this.state_0_ |= 8;
            this.state_0_ |= 0x10;
            this.state_0_ |= 0x20;
            this.state_0_ |= 0x40;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMSyscall.SyscallArgConverter create(LLVMExpressionNode value) {
            return new SyscallArgConverterNodeGen(value);
        }
    }
}

