/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.floating;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.llvm.runtime.ContextExtension;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.NativeContextExtension;
import com.oracle.truffle.llvm.runtime.floating.LLVM128BitFloat;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.floating.LLVMLongDoubleFloatingPoint;
import com.oracle.truffle.llvm.runtime.floating.LLVMLongDoubleNodeFactory;
import com.oracle.truffle.llvm.runtime.interop.nfi.LLVMNativeConvertNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.nfi.api.SignatureLibrary;

public abstract class LLVMLongDoubleNode
extends LLVMExpressionNode {
    final String name;
    private final String functionName;
    private final String signature;
    final ContextExtension.Key<NativeContextExtension> nativeCtxExtKey;
    public final LongDoubleKinds kind;

    public abstract LLVMLongDoubleFloatingPoint execute(Object ... var1);

    LLVMLongDoubleNode(String name, String signature, LongDoubleKinds kind) {
        this.name = name;
        this.functionName = "__sulong_longdouble_" + name;
        this.signature = signature;
        this.kind = kind;
        this.nativeCtxExtKey = LLVMLanguage.get(this).lookupContextExtension(NativeContextExtension.class);
    }

    protected NativeContextExtension.WellKnownNativeFunctionNode createFunction() {
        LLVMContext context = LLVMContext.get(this);
        NativeContextExtension nativeContextExtension = context.getContextExtensionOrNull(NativeContextExtension.class);
        if (nativeContextExtension == null) {
            return null;
        }
        return nativeContextExtension.getWellKnownNativeFunction(this.functionName, this.signature);
    }

    protected NativeContextExtension.WellKnownNativeFunctionAndSignature getFunction() {
        NativeContextExtension nativeContextExtension = this.nativeCtxExtKey.get(LLVMContext.get(this));
        return nativeContextExtension.getWellKnownNativeFunctionAndSignature(this.functionName, this.signature);
    }

    protected LLVMNativeConvertNode createToLongDouble() {
        return switch (this.kind.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> LLVMNativeConvertNode.createFromNative(PrimitiveType.X86_FP80);
            case 1 -> LLVMNativeConvertNode.createFromNative(PrimitiveType.F128);
        };
    }

    public static LLVMLongDoubleNode createAddNode(LongDoubleKinds kind) {
        return LLVMLongDoubleNode.createNativeCallNode("add", kind);
    }

    public static LLVMLongDoubleNode createSubNode(LongDoubleKinds kind) {
        return LLVMLongDoubleNode.createNativeCallNode("sub", kind);
    }

    public static LLVMLongDoubleNode createMulNode(LongDoubleKinds kind) {
        return LLVMLongDoubleNode.createNativeCallNode("mul", kind);
    }

    public static LLVMLongDoubleNode createDivNode(LongDoubleKinds kind) {
        return LLVMLongDoubleNode.createNativeCallNode("div", kind);
    }

    public static LLVMLongDoubleNode createRemNode(LongDoubleKinds kind) {
        return LLVMLongDoubleNode.createNativeCallNode("mod", kind);
    }

    public static LLVMLongDoubleNode createPowNode(LLVMExpressionNode x, LLVMExpressionNode y, LongDoubleKinds kind) {
        return LLVMLongDoubleNode.createNativeCallNode("pow", kind, x, y);
    }

    private static LLVMLongDoubleNode createNativeCallNode(String name, LongDoubleKinds kind, LLVMExpressionNode x, LLVMExpressionNode y) {
        return switch (kind.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> LLVMLongDoubleNodeFactory.LLVMLongDoubleNativeCallNodeGen.create(name, "(FP80,FP80):FP80", kind, x, y);
            case 1 -> LLVMLongDoubleNodeFactory.LLVMLongDoubleNativeCallNodeGen.create(name, "(FP128,FP128):FP128", kind, x, y);
        };
    }

    private static LLVMLongDoubleNode createNativeCallNode(String name, LongDoubleKinds kind) {
        return switch (kind.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> LLVMLongDoubleNodeFactory.LLVMLongDoubleNativeCallNodeGen.create(name, "(FP80,FP80):FP80", kind, null, null);
            case 1 -> LLVMLongDoubleNodeFactory.LLVMLongDoubleNativeCallNodeGen.create(name, "(FP128,FP128):FP128", kind, null, null);
        };
    }

    public static LLVMLongDoubleNode createUnary(String name, LLVMExpressionNode x, LongDoubleKinds kind) {
        return switch (kind.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> LLVMLongDoubleNodeFactory.LLVMLongDoubleUnaryNativeCallNodeGen.create(name, "(FP80):FP80", kind, x);
            case 1 -> LLVMLongDoubleNodeFactory.LLVMLongDoubleUnaryNativeCallNodeGen.create(name, "(FP128):FP128", kind, x);
        };
    }

    public static enum LongDoubleKinds {
        FP80,
        FP128;

    }

    @NodeChildren(value={@NodeChild(value="x", type=LLVMExpressionNode.class), @NodeChild(value="y", type=LLVMExpressionNode.class)})
    static abstract class LLVMLongDoubleNativeCallNode
    extends LLVMLongDoubleNode {
        LLVMLongDoubleNativeCallNode(String name, String signature, LongDoubleKinds kind) {
            super(name, signature, kind);
        }

        @Specialization(guards={"function != null"})
        protected LLVMLongDoubleFloatingPoint doCall(Object x, Object y, @Cached(value="createFunction()") NativeContextExtension.WellKnownNativeFunctionNode function, @Cached(value="createToLongDouble()") LLVMNativeConvertNode nativeConvert) {
            try {
                Object ret = function.execute(x, y);
                return (LLVMLongDoubleFloatingPoint)nativeConvert.executeConvert(ret);
            }
            catch (InteropException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
        }

        @Specialization(guards={"nativeCtxExtKey != null"}, replaces={"doCall"})
        protected LLVMLongDoubleFloatingPoint doCallAOT(Object x, Object y, @CachedLibrary(limit="1") SignatureLibrary signatureLibrary, @Cached(value="createToLongDouble()") LLVMNativeConvertNode nativeConvert) {
            NativeContextExtension.WellKnownNativeFunctionAndSignature wkFunSig = this.getFunction();
            try {
                Object ret = signatureLibrary.call(wkFunSig.getSignature(), wkFunSig.getFunction(), new Object[]{x, y});
                return (LLVMLongDoubleFloatingPoint)nativeConvert.executeConvert(ret);
            }
            catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"nativeCtxExtKey == null"})
        protected LLVMLongDoubleFloatingPoint doCallNoNative(LLVMLongDoubleFloatingPoint x, LLVMLongDoubleFloatingPoint y) {
            double xDouble = x.toDoubleValue();
            double yDouble = y.toDoubleValue();
            return switch (this.kind.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> LLVM80BitFloat.fromDouble(switch (this.name) {
                    case "add" -> xDouble + yDouble;
                    case "sub" -> xDouble - yDouble;
                    case "mul" -> xDouble * yDouble;
                    case "div" -> xDouble / yDouble;
                    case "mod" -> xDouble % yDouble;
                    default -> throw new AssertionError((Object)("unexpected long double bit float operation: " + this.name + ", for the type: " + String.valueOf((Object)this.kind)));
                });
                case 1 -> LLVM128BitFloat.fromDouble(switch (this.name) {
                    case "add" -> xDouble + yDouble;
                    case "sub" -> xDouble - yDouble;
                    case "mul" -> xDouble * yDouble;
                    case "div" -> xDouble / yDouble;
                    case "mod" -> xDouble % yDouble;
                    default -> throw new AssertionError((Object)("unexpected long double bit float operation: " + this.name + ", for the type: " + String.valueOf((Object)this.kind)));
                });
            };
        }

        @Override
        public String toString() {
            return String.valueOf((Object)this.kind) + " " + this.name;
        }
    }

    @NodeChild(value="x", type=LLVMExpressionNode.class)
    static abstract class LLVMLongDoubleUnaryNativeCallNode
    extends LLVMLongDoubleNode {
        LLVMLongDoubleUnaryNativeCallNode(String name, String signature, LongDoubleKinds kind) {
            super(name, signature, kind);
        }

        @Specialization(guards={"function != null"})
        protected LLVMLongDoubleFloatingPoint doCall(Object x, @Cached(value="createFunction()") NativeContextExtension.WellKnownNativeFunctionNode function, @Cached(value="createToLongDouble()") LLVMNativeConvertNode nativeConvert) {
            try {
                Object ret = function.execute(x);
                return (LLVMLongDoubleFloatingPoint)nativeConvert.executeConvert(ret);
            }
            catch (InteropException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
        }

        @Specialization(guards={"nativeCtxExtKey != null"}, replaces={"doCall"})
        protected LLVMLongDoubleFloatingPoint doCallAOT(Object x, @CachedLibrary(limit="1") SignatureLibrary signatureLibrary, @Cached(value="createToLongDouble()") LLVMNativeConvertNode nativeConvert) {
            NativeContextExtension.WellKnownNativeFunctionAndSignature wkFunSig = this.getFunction();
            try {
                Object ret = signatureLibrary.call(wkFunSig.getSignature(), wkFunSig.getFunction(), new Object[]{x});
                return (LLVMLongDoubleFloatingPoint)nativeConvert.executeConvert(ret);
            }
            catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
        }
    }
}

