/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.instructions;

import com.oracle.truffle.llvm.parser.metadata.MDBaseNode;
import com.oracle.truffle.llvm.parser.metadata.MDExpression;
import com.oracle.truffle.llvm.parser.metadata.MDLocalVariable;
import com.oracle.truffle.llvm.parser.metadata.MDLocation;
import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.VoidInstruction;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;

public class DebugInstruction
extends VoidInstruction {
    private final DebugInstructionKind kind;
    private final MDLocalVariable variable;
    private final MDExpression expression;
    private final MDBaseNode value;

    public DebugInstruction(DebugInstructionKind kind, MDLocation location, MDLocalVariable variable, MDExpression expression, MDBaseNode value) {
        super(location);
        this.kind = kind;
        this.variable = variable;
        this.expression = expression;
        this.value = value;
    }

    public DebugInstructionKind getKind() {
        return this.kind;
    }

    public MDLocalVariable getVariable() {
        return this.variable;
    }

    public MDExpression getExpression() {
        return this.expression;
    }

    public MDBaseNode getValue() {
        return this.value;
    }

    @Override
    public void replace(SymbolImpl oldValue, SymbolImpl newValue) {
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DebugInstruction that = (DebugInstruction)o;
        if (!this.getKind().equals((Object)that.getKind())) {
            return false;
        }
        if (!this.getVariable().equals(that.getVariable())) {
            return false;
        }
        if (!this.getExpression().equals(that.getExpression())) {
            return false;
        }
        return this.getValue().equals(that.getValue());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.kind == null ? 0 : this.kind.hashCode());
        result = 31 * result + (this.variable == null ? 0 : this.variable.hashCode());
        result = 31 * result + (this.expression == null ? 0 : this.expression.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public static enum DebugInstructionKind {
        VALUE,
        DECLARE;

    }
}

