/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.metadata.debuginfo;

import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.llvm.parser.metadata.MDBaseNode;
import com.oracle.truffle.llvm.parser.metadata.MDExpression;
import com.oracle.truffle.llvm.parser.metadata.MDLocalVariable;
import com.oracle.truffle.llvm.parser.metadata.MDLocation;
import com.oracle.truffle.llvm.parser.metadata.MDNode;
import com.oracle.truffle.llvm.parser.metadata.MDValue;
import com.oracle.truffle.llvm.parser.metadata.MetadataSymbol;
import com.oracle.truffle.llvm.parser.metadata.MetadataVisitor;
import com.oracle.truffle.llvm.parser.metadata.debuginfo.DIScopeBuilder;
import com.oracle.truffle.llvm.parser.metadata.debuginfo.DebugInfoCache;
import com.oracle.truffle.llvm.parser.metadata.debuginfo.ImportsProcessor;
import com.oracle.truffle.llvm.parser.metadata.debuginfo.MDSymbolExtractor;
import com.oracle.truffle.llvm.parser.metadata.debuginfo.SourceFunction;
import com.oracle.truffle.llvm.parser.metadata.debuginfo.SourceVariable;
import com.oracle.truffle.llvm.parser.metadata.debuginfo.ValueFragment;
import com.oracle.truffle.llvm.parser.model.IRScope;
import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.blocks.InstructionBlock;
import com.oracle.truffle.llvm.parser.model.functions.FunctionDeclaration;
import com.oracle.truffle.llvm.parser.model.functions.FunctionDefinition;
import com.oracle.truffle.llvm.parser.model.functions.FunctionParameter;
import com.oracle.truffle.llvm.parser.model.symbols.constants.NullConstant;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.DbgDeclareInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.DbgNoaliasScopeDeclInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.DbgValueInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.DebugInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.DebugTrapInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.Instruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.VoidCallInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.VoidInstruction;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceSymbol;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceFunctionType;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceType;
import com.oracle.truffle.llvm.runtime.types.MetaType;
import java.util.List;

public final class DebugInfoFunctionProcessor {
    private static final int LLVM_DBG_INTRINSICS_VALUE_ARGINDEX = 0;
    private static final String LLVM_DBG_DECLARE_NAME = "llvm.dbg.declare";
    private static final int LLVM_DBG_DECLARE_LOCALREF_ARGINDEX = 1;
    private static final int LLVM_DBG_DECLARE_EXPR_ARGINDEX = 2;
    private static final String LLVM_DBG_ADDR_NAME = "llvm.dbg.addr";
    private static final String LLVM_DBG_VALUE_NAME = "llvm.dbg.value";
    private static final int LLVM_DBG_VALUE_LOCALREF_ARGINDEX_OLD = 2;
    private static final int LLVM_DBG_VALUE_EXPR_ARGINDEX_OLD = 3;
    private static final int LLVM_DBG_VALUE_LOCALREF_ARGSIZE_OLD = 4;
    private static final int LLVM_DBG_VALUE_LOCALREF_ARGINDEX_NEW = 1;
    private static final int LLVM_DBG_VALUE_EXPR_ARGINDEX_NEW = 2;
    private static final int LLVM_DBG_VALUE_LOCALREF_ARGSIZE_NEW = 3;
    private static final String LLVM_DEBUGTRAP_NAME = "llvm.debugtrap";
    private final DebugInfoCache cache;

    DebugInfoFunctionProcessor(DebugInfoCache cache) {
        this.cache = cache;
    }

    public void process(FunctionDefinition function, IRScope scope, Source bitcodeSource) {
        ImportsProcessor.process(scope.getMetadata(), this.cache);
        this.initSourceFunction(function, bitcodeSource);
        for (InstructionBlock block : function.getBlocks()) {
            List<Instruction> instructions = block.getInstructions();
            for (int i = 0; i < instructions.size(); ++i) {
                Instruction replacement;
                Instruction instruction = instructions.get(i);
                if (instruction instanceof DebugInstruction) {
                    replacement = this.visit(function, (DebugInstruction)instruction);
                    if (replacement == instruction) continue;
                    instructions.set(i, replacement);
                    continue;
                }
                if (instruction instanceof VoidCallInstruction) {
                    replacement = this.visit(function, (VoidCallInstruction)instruction);
                    if (replacement == instruction) continue;
                    instructions.set(i, replacement);
                    continue;
                }
                this.visitInstruction(instruction);
            }
        }
        scope.getMetadata().consumeLocals(new MetadataProcessor());
        for (SourceVariable local : function.getSourceFunction().getVariables()) {
            local.processFragments();
        }
        this.cache.endLocalScope();
    }

    private void initSourceFunction(FunctionDefinition function, Source bitcodeSource) {
        MDBaseNode debugInfo = DebugInfoCache.getDebugInfo(function);
        LLVMSourceLocation scope = null;
        LLVMSourceFunctionType type = null;
        if (debugInfo != null) {
            scope = this.cache.buildLocation(debugInfo);
            LLVMSourceType actualType = this.cache.parseType(debugInfo);
            if (actualType instanceof LLVMSourceFunctionType) {
                type = (LLVMSourceFunctionType)actualType;
            }
        }
        if (scope == null) {
            String sourceText = String.format("%s:%s", bitcodeSource.getName(), function.getName());
            Source irSource = Source.newBuilder((String)"llvm", (CharSequence)sourceText, (String)sourceText).mimeType(DIScopeBuilder.getMimeType(null)).build();
            SourceSection simpleSection = irSource.createSection(1);
            scope = LLVMSourceLocation.createBitcodeFunction(function.getName(), simpleSection);
        }
        SourceFunction sourceFunction = new SourceFunction(scope, type);
        function.setSourceFunction(sourceFunction);
    }

    private static SymbolImpl getArg(VoidCallInstruction call, int index) {
        return index < call.getArgumentCount() ? call.getArgument(index) : null;
    }

    private static MDExpression getExpression(VoidCallInstruction call, int index) {
        MDBaseNode mdNode;
        SymbolImpl argSymbol = DebugInfoFunctionProcessor.getArg(call, index);
        if (argSymbol instanceof MetadataSymbol && (mdNode = ((MetadataSymbol)argSymbol).getNode()) instanceof MDExpression) {
            return (MDExpression)mdNode;
        }
        return MDExpression.EMPTY;
    }

    private static SymbolImpl getValue(DebugInstruction debug) {
        MDBaseNode valueNode = debug.getValue();
        SymbolImpl value = null;
        value = valueNode instanceof MDValue ? ((MDValue)valueNode).getValue() : null;
        if (value instanceof MetadataSymbol) {
            value = MDSymbolExtractor.getSymbol(((MetadataSymbol)value).getNode());
        }
        if (value == null) {
            value = new NullConstant(MetaType.DEBUG);
        }
        return value;
    }

    private void visitInstruction(Instruction instruction) {
        LLVMSourceLocation scope;
        MDLocation loc = instruction.getDebugLocation();
        if (loc != null && (scope = this.cache.buildLocation(loc)) != null) {
            instruction.setSourceLocation(scope);
        }
    }

    private Instruction visit(FunctionDefinition function, DebugInstruction debug) {
        VoidInstruction ret;
        SymbolImpl value = DebugInfoFunctionProcessor.getValue(debug);
        SourceVariable variable = this.getVariable(function, debug);
        if (variable == null) {
            return null;
        }
        MDExpression expression = debug.getExpression();
        if (ValueFragment.describesFragment(expression)) {
            variable.addFragment(ValueFragment.parse(expression));
        } else {
            variable.addFullDefinition();
        }
        switch (debug.getKind()) {
            case DECLARE: {
                ret = new DbgDeclareInstruction(value, variable, expression);
                break;
            }
            case VALUE: {
                ret = new DbgValueInstruction(value, variable, expression);
                break;
            }
            default: {
                return debug;
            }
        }
        ret.setDebugLocation(debug.getDebugLocation());
        this.visitInstruction(ret);
        return ret;
    }

    private Instruction visit(FunctionDefinition function, VoidCallInstruction call) {
        SymbolImpl callTarget = call.getCallTarget();
        if (callTarget instanceof FunctionDeclaration) {
            DebugInstruction debug = null;
            switch (((FunctionDeclaration)callTarget).getName()) {
                case "llvm.dbg.declare": {
                    debug = DebugInfoFunctionProcessor.handleDebugIntrinsic(call, DebugInstruction.DebugInstructionKind.DECLARE);
                    break;
                }
                case "llvm.dbg.addr": {
                    debug = DebugInfoFunctionProcessor.handleDebugIntrinsic(call, DebugInstruction.DebugInstructionKind.DECLARE);
                    break;
                }
                case "llvm.dbg.value": {
                    debug = DebugInfoFunctionProcessor.handleDebugIntrinsic(call, DebugInstruction.DebugInstructionKind.VALUE);
                    break;
                }
                case "llvm.debugtrap": {
                    return this.visitDebugTrap(call);
                }
                case "llvm.experimental.noalias.scope.decl": {
                    return DebugInfoFunctionProcessor.handleNoaliasScopeDecl(call);
                }
            }
            if (debug != null) {
                return this.visit(function, debug);
            }
        }
        this.visitInstruction(call);
        return call;
    }

    private Instruction visitDebugTrap(VoidCallInstruction call) {
        DebugTrapInstruction trap = DebugTrapInstruction.create(call);
        this.visitInstruction(trap);
        return trap;
    }

    private static void attachSourceArgumentInformation(FunctionDefinition function, DebugInstruction debug) {
        if (debug.getKind() == DebugInstruction.DebugInstructionKind.VALUE) {
            SymbolImpl intrinsicValue = DebugInfoFunctionProcessor.getValue(debug);
            MDLocalVariable local = debug.getVariable();
            MDExpression expr = debug.getExpression();
            if (!(intrinsicValue instanceof FunctionParameter)) {
                return;
            }
            FunctionParameter parameter = (FunctionParameter)intrinsicValue;
            ValueFragment fragment = ValueFragment.parse(expr);
            if (!fragment.isComplete()) {
                long sourceArgIndex = local.getArg();
                if (Long.compareUnsigned(sourceArgIndex, Integer.MAX_VALUE) > 0) {
                    throw new IndexOutOfBoundsException(String.format("Source argument index (%s) is out of integer range", Long.toUnsignedString(sourceArgIndex)));
                }
                function.getSourceFunction().getSourceType().attachSourceArgumentInformation(parameter.getArgIndex(), (int)sourceArgIndex - 1, fragment.getOffset(), fragment.getLength());
            }
        }
    }

    private SourceVariable getVariable(FunctionDefinition function, DebugInstruction debug) {
        MDLocalVariable mdLocal = debug.getVariable();
        LLVMSourceSymbol symbol = this.cache.getSourceSymbol(mdLocal, false);
        DebugInfoFunctionProcessor.attachSourceArgumentInformation(function, debug);
        return function.getSourceFunction().getLocal(symbol);
    }

    private static Instruction handleNoaliasScopeDecl(VoidCallInstruction call) {
        SymbolImpl value = DebugInfoFunctionProcessor.getArg(call, 0);
        MDNode node = (MDNode)((MetadataSymbol)value).getNode();
        return new DbgNoaliasScopeDeclInstruction(node);
    }

    private static DebugInstruction handleDebugIntrinsic(VoidCallInstruction call, DebugInstruction.DebugInstructionKind kind) {
        int mdExprArgIndex;
        int mdLocalArgIndex;
        if (kind == DebugInstruction.DebugInstructionKind.DECLARE) {
            mdLocalArgIndex = 1;
            mdExprArgIndex = 2;
        } else if (call.getArgumentCount() == 3) {
            mdLocalArgIndex = 1;
            mdExprArgIndex = 2;
        } else if (call.getArgumentCount() == 4) {
            mdLocalArgIndex = 2;
            mdExprArgIndex = 3;
        } else {
            return null;
        }
        SymbolImpl value = DebugInfoFunctionProcessor.getArg(call, 0);
        SymbolImpl localSymbol = DebugInfoFunctionProcessor.getArg(call, mdLocalArgIndex);
        if (!(value instanceof MetadataSymbol) || !(localSymbol instanceof MetadataSymbol)) {
            return null;
        }
        MDBaseNode valueNode = ((MetadataSymbol)value).getNode();
        MDBaseNode localNode = ((MetadataSymbol)localSymbol).getNode();
        if (!(localNode instanceof MDLocalVariable)) {
            return null;
        }
        MDExpression expr = DebugInfoFunctionProcessor.getExpression(call, mdExprArgIndex);
        return new DebugInstruction(kind, call.getDebugLocation(), (MDLocalVariable)localNode, expr, valueNode);
    }

    private final class MetadataProcessor
    implements MetadataVisitor {
        private MetadataProcessor() {
        }

        @Override
        public void visit(MDLocalVariable md) {
            DebugInfoFunctionProcessor.this.cache.getSourceSymbol(md, false);
        }
    }
}

