/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.metadata;

import com.oracle.truffle.llvm.parser.metadata.MDAggregateNode;
import com.oracle.truffle.llvm.parser.metadata.MDBaseNode;
import com.oracle.truffle.llvm.parser.metadata.MDVoidNode;
import com.oracle.truffle.llvm.parser.metadata.MetadataValueList;
import com.oracle.truffle.llvm.parser.metadata.MetadataVisitor;
import com.oracle.truffle.llvm.parser.scanner.RecordBuffer;

public final class MDGenericDebug
extends MDAggregateNode {
    private final long tag;
    private final long version;
    private MDBaseNode header;

    private MDGenericDebug(long tag, long version, int size) {
        super(size);
        this.tag = tag;
        this.version = version;
        this.header = MDVoidNode.INSTANCE;
    }

    public long getTag() {
        return this.tag;
    }

    public long getVersion() {
        return this.version;
    }

    public MDBaseNode getHeader() {
        return this.header;
    }

    @Override
    public void replace(MDBaseNode oldValue, MDBaseNode newValue) {
        super.replace(oldValue, newValue);
        if (this.header == oldValue) {
            this.header = newValue;
        }
    }

    @Override
    public void accept(MetadataVisitor visitor) {
        visitor.visit(this);
    }

    public static MDGenericDebug create38(RecordBuffer buffer, MetadataValueList md) {
        buffer.skip();
        long tag = buffer.read();
        long version = buffer.read();
        long header = buffer.read();
        int size = buffer.remaining();
        MDGenericDebug debug = new MDGenericDebug(tag, version, size);
        debug.header = md.getNullable(header, debug);
        for (int i = 0; i < size; ++i) {
            debug.set(i, md.getNullable(buffer.read(), debug));
        }
        return debug;
    }
}

