/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.vector;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.vector.LLVMVector;

@CompilerDirectives.ValueType
public final class LLVMPointerVector
extends LLVMVector {
    private final LLVMPointer[] vector;

    public static LLVMPointerVector create(LLVMPointer[] vector) {
        return new LLVMPointerVector(vector);
    }

    private LLVMPointerVector(LLVMPointer[] vector) {
        this.vector = vector;
    }

    public LLVMPointer getValue(int index) {
        return this.vector[index];
    }

    @Override
    public int getLength() {
        return this.vector.length;
    }

    @Override
    public Type getElementType() {
        return PointerType.VOID;
    }

    @Override
    public LLVMPointer getElement(int index) {
        return index >= 0 && index < this.vector.length ? this.vector[index] : null;
    }
}

