/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.types;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.GetStackSpaceFactory;
import com.oracle.truffle.llvm.runtime.NodeFactory;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.types.AggregateType;
import com.oracle.truffle.llvm.runtime.types.MetaType;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.types.VoidType;
import com.oracle.truffle.llvm.runtime.types.visitors.TypeVisitor;

public final class PointerType
extends AggregateType {
    public static final PointerType I8 = new PointerType(PrimitiveType.I8);
    public static final PointerType VOID = new PointerType(VoidType.INSTANCE);
    public static final PointerType PTR = new PointerType(MetaType.UNKNOWN);
    private Type pointeeType;

    public PointerType(Type pointeeType) {
        this.pointeeType = pointeeType;
    }

    public boolean isOpaque() {
        return this.pointeeType == MetaType.UNKNOWN;
    }

    public Type getPointeeType() {
        CompilerAsserts.neverPartOfCompilation();
        assert (!this.isOpaque()) : "unexpected getPointeeType() on opaque pointer";
        return this.pointeeType;
    }

    public void setPointeeType(Type type) {
        CompilerAsserts.neverPartOfCompilation();
        this.verifyCycleFree(type);
        this.pointeeType = type;
    }

    @Override
    public int getAlignment(DataLayout targetDataLayout) {
        if (targetDataLayout != null) {
            return targetDataLayout.getBitAlignment(this) / 8;
        }
        return 8;
    }

    @Override
    public long getSize(DataLayout targetDataLayout) {
        return 8L;
    }

    @Override
    public long getOffsetOf(long index, DataLayout targetDataLayout) throws Type.TypeOverflowException {
        return PointerType.multiplySignedExact(this.getPointeeType().getSize(targetDataLayout), index);
    }

    @Override
    public Type getElementType(long index) {
        return this.getPointeeType();
    }

    @Override
    public long getNumberOfElements() {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    public long getBitSize() {
        return 64L;
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        if (this.isOpaque()) {
            return "ptr";
        }
        return String.format("%s*", this.getPointeeType());
    }

    @Override
    public int hashCode() {
        return PointerType.class.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof PointerType;
    }

    @Override
    public LLVMExpressionNode createNullConstant(NodeFactory nodeFactory, DataLayout dataLayout, GetStackSpaceFactory stackFactory) {
        return CommonNodeFactory.createSimpleConstantNoArray(null, this);
    }
}

