/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.pointer;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMNativeLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.pointer.CommonPointerLibraries;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointerImpl;

@ExportLibrary.Repeat(value={@ExportLibrary(value=InteropLibrary.class, receiverType=LLVMPointerImpl.class), @ExportLibrary(value=LLVMAsForeignLibrary.class, receiverType=LLVMPointerImpl.class, useForAOT=false)})
abstract class ManagedPointerLibraries
extends CommonPointerLibraries {
    ManagedPointerLibraries() {
    }

    @ExportMessage
    static boolean isNull(LLVMPointerImpl receiver, @CachedLibrary(value="receiver.object") InteropLibrary interop) {
        if (receiver.getOffset() == 0L) {
            return interop.isNull(receiver.object);
        }
        return false;
    }

    @ExportMessage
    static boolean isExecutable(LLVMPointerImpl receiver, @CachedLibrary(value="receiver.object") InteropLibrary interop) {
        if (receiver.getOffset() == 0L) {
            return interop.isExecutable(receiver.object);
        }
        return false;
    }

    @ExportMessage
    static Object execute(LLVMPointerImpl receiver, Object[] args, @CachedLibrary(value="receiver.object") InteropLibrary interop) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
        if (receiver.getOffset() == 0L) {
            return interop.execute(receiver.object, args);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage(library=InteropLibrary.class)
    static boolean isPointer(LLVMPointerImpl receiver, @CachedLibrary(value="receiver.object") LLVMNativeLibrary natives) {
        return natives.isPointer(receiver.object);
    }

    @ExportMessage(library=InteropLibrary.class)
    static long asPointer(LLVMPointerImpl receiver, @CachedLibrary(value="receiver.object") LLVMNativeLibrary natives) throws UnsupportedMessageException {
        return natives.asPointer(receiver.object) + receiver.getOffset();
    }

    @ExportMessage
    static void toNative(LLVMPointerImpl receiver, @CachedLibrary(value="receiver.object") InteropLibrary interop) {
        interop.toNative(receiver.object);
    }

    @ExportMessage
    static boolean isForeign(LLVMPointerImpl receiver, @CachedLibrary(value="receiver.object") LLVMAsForeignLibrary foreigns) {
        return ManagedPointerLibraries.isForeignTest(receiver, foreigns);
    }

    @ExportMessage
    static Object asForeign(LLVMPointerImpl receiver, @CachedLibrary(value="receiver.object") LLVMAsForeignLibrary foreigns) {
        return foreigns.asForeign(receiver.object);
    }

    static boolean isForeignTest(LLVMPointerImpl receiver, LLVMAsForeignLibrary foreigns) {
        return receiver.getOffset() == 0L && foreigns.isForeign(receiver.object);
    }

    @ExportMessage
    static String toDisplayString(LLVMPointerImpl receiver, boolean allowSideEffects, @CachedLibrary(value="receiver.object") InteropLibrary objInterop, @CachedLibrary(limit="3") InteropLibrary strInterop) {
        Object managed = objInterop.toDisplayString(receiver.object, allowSideEffects);
        try {
            return ManagedPointerLibraries.formatManagedPointer(strInterop.asString(managed), receiver.getOffset());
        }
        catch (UnsupportedMessageException ex) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)ex);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static String formatManagedPointer(String managed, long offset) {
        StringBuilder ret = new StringBuilder(managed.length() + 24);
        ret.append("ptr(");
        ret.append(managed);
        ret.append(")+0x");
        ret.append(Long.toHexString(offset));
        return ret.toString();
    }

    @GenerateUncached
    static abstract class ForeignIdentityHashNode
    extends LLVMNode {
        ForeignIdentityHashNode() {
        }

        abstract int execute(Object var1);

        @Specialization(limit="3", rewriteOn={UnsupportedMessageException.class})
        @GenerateAOT.Exclude
        int doUnchecked(Object obj, @CachedLibrary(value="obj") InteropLibrary interop) throws UnsupportedMessageException {
            return interop.identityHashCode(obj);
        }

        @Specialization(limit="3", guards={"!interop.hasIdentity(obj)"}, replaces={"doUnchecked"})
        @CompilerDirectives.TruffleBoundary
        @GenerateAOT.Exclude
        int doNoIdentity(Object obj, @CachedLibrary(value="obj") InteropLibrary interop) {
            return System.identityHashCode(obj);
        }

        @Specialization(limit="3", replaces={"doNoIdentity"})
        @GenerateAOT.Exclude
        int doChecked(Object obj, @CachedLibrary(value="obj") InteropLibrary interop) {
            try {
                return interop.identityHashCode(obj);
            }
            catch (UnsupportedMessageException ex) {
                return this.doNoIdentity(obj, interop);
            }
        }
    }

    @ExportMessage
    static class IdentityHashCode {
        IdentityHashCode() {
        }

        @Specialization(guards={"!foreigns.isForeign(receiver.object)"})
        @CompilerDirectives.TruffleBoundary
        static int doInternal(LLVMPointerImpl receiver, @CachedLibrary(value="receiver.object") LLVMAsForeignLibrary foreigns) {
            return IdentityHashCode.hash(System.identityHashCode(receiver.getObject()), receiver.getOffset());
        }

        @Specialization(guards={"foreigns.isForeign(receiver.object)"})
        static int doForeign(LLVMPointerImpl receiver, @CachedLibrary(value="receiver.object") LLVMAsForeignLibrary foreigns, @Cached ForeignIdentityHashNode hashForeign) {
            Object foreign = foreigns.asForeign(receiver.getObject());
            return IdentityHashCode.hash(hashForeign.execute(foreign), receiver.getOffset());
        }

        private static int hash(int objHash, long offset) {
            int ret = 0;
            ret = ret * 31 + objHash;
            ret = ret * 31 + Long.hashCode(offset);
            return ret;
        }
    }
}

