/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.vector;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.CountingConditionProfile;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.vector.LLVMShuffleVectorNode;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMPointerVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMVector;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=LLVMShuffleVectorNode.class)
public final class LLVMShuffleVectorNodeFactory {

    @GeneratedBy(value=LLVMShuffleVectorNode.LLVMShuffleDoubleVectorNode.class)
    public static final class LLVMShuffleDoubleVectorNodeGen
    extends LLVMShuffleVectorNode.LLVMShuffleDoubleVectorNode
    implements GenerateAOT.Provider {
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @Node.Child
        private LLVMExpressionNode mask_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @CompilerDirectives.CompilationFinal
        private CountingConditionProfile conditionProfile_;

        private LLVMShuffleDoubleVectorNodeGen(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode mask, int vectorLength) {
            this.vectorLength = vectorLength;
            this.left_ = left;
            this.right_ = right;
            this.mask_ = mask;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object leftValue_ = this.left_.executeGeneric(frameValue);
            Object rightValue_ = this.right_.executeGeneric(frameValue);
            Object maskValue_ = this.mask_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftValue_, rightValue_, maskValue_);
            }
            if ((state_0 & 2) != 0 && leftValue_ instanceof LLVMDoubleVector) {
                LLVMDoubleVector leftValue__ = (LLVMDoubleVector)leftValue_;
                if (rightValue_ instanceof LLVMDoubleVector) {
                    LLVMDoubleVector rightValue__ = (LLVMDoubleVector)rightValue_;
                    if (maskValue_ instanceof LLVMI32Vector) {
                        LLVMI32Vector maskValue__ = (LLVMI32Vector)maskValue_;
                        CountingConditionProfile conditionProfile__ = this.conditionProfile_;
                        if (conditionProfile__ != null) {
                            return this.doOp(leftValue__, rightValue__, maskValue__, conditionProfile__);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, maskValue_);
        }

        private LLVMDoubleVector executeAndSpecialize(Object leftValue, Object rightValue, Object maskValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftValue instanceof LLVMDoubleVector) {
                LLVMDoubleVector leftValue_ = (LLVMDoubleVector)leftValue;
                if (rightValue instanceof LLVMDoubleVector) {
                    LLVMDoubleVector rightValue_ = (LLVMDoubleVector)rightValue;
                    if (maskValue instanceof LLVMI32Vector) {
                        LLVMI32Vector maskValue_ = (LLVMI32Vector)maskValue;
                        CountingConditionProfile conditionProfile__ = CountingConditionProfile.create();
                        Objects.requireNonNull(conditionProfile__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        VarHandle.storeStoreFence();
                        this.conditionProfile_ = conditionProfile__;
                        this.state_0_ = state_0 |= 2;
                        return this.doOp(leftValue_, rightValue_, maskValue_, conditionProfile__);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_, this.mask_}, new Object[]{leftValue, rightValue, maskValue});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            CountingConditionProfile conditionProfile__ = CountingConditionProfile.create();
            Objects.requireNonNull(conditionProfile__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.conditionProfile_ = conditionProfile__;
            this.conditionProfile_.disable();
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
            this.conditionProfile_.reset();
        }

        @NeverDefault
        public static LLVMShuffleVectorNode.LLVMShuffleDoubleVectorNode create(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode mask, int vectorLength) {
            return new LLVMShuffleDoubleVectorNodeGen(left, right, mask, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMShuffleVectorNode.LLVMShuffleFloatVectorNode.class)
    public static final class LLVMShuffleFloatVectorNodeGen
    extends LLVMShuffleVectorNode.LLVMShuffleFloatVectorNode
    implements GenerateAOT.Provider {
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @Node.Child
        private LLVMExpressionNode mask_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @CompilerDirectives.CompilationFinal
        private CountingConditionProfile conditionProfile_;

        private LLVMShuffleFloatVectorNodeGen(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode mask, int vectorLength) {
            this.vectorLength = vectorLength;
            this.left_ = left;
            this.right_ = right;
            this.mask_ = mask;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object leftValue_ = this.left_.executeGeneric(frameValue);
            Object rightValue_ = this.right_.executeGeneric(frameValue);
            Object maskValue_ = this.mask_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftValue_, rightValue_, maskValue_);
            }
            if ((state_0 & 2) != 0 && leftValue_ instanceof LLVMFloatVector) {
                LLVMFloatVector leftValue__ = (LLVMFloatVector)leftValue_;
                if (rightValue_ instanceof LLVMFloatVector) {
                    LLVMFloatVector rightValue__ = (LLVMFloatVector)rightValue_;
                    if (maskValue_ instanceof LLVMI32Vector) {
                        LLVMI32Vector maskValue__ = (LLVMI32Vector)maskValue_;
                        CountingConditionProfile conditionProfile__ = this.conditionProfile_;
                        if (conditionProfile__ != null) {
                            return this.doOp(leftValue__, rightValue__, maskValue__, conditionProfile__);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, maskValue_);
        }

        private LLVMFloatVector executeAndSpecialize(Object leftValue, Object rightValue, Object maskValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftValue instanceof LLVMFloatVector) {
                LLVMFloatVector leftValue_ = (LLVMFloatVector)leftValue;
                if (rightValue instanceof LLVMFloatVector) {
                    LLVMFloatVector rightValue_ = (LLVMFloatVector)rightValue;
                    if (maskValue instanceof LLVMI32Vector) {
                        LLVMI32Vector maskValue_ = (LLVMI32Vector)maskValue;
                        CountingConditionProfile conditionProfile__ = CountingConditionProfile.create();
                        Objects.requireNonNull(conditionProfile__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        VarHandle.storeStoreFence();
                        this.conditionProfile_ = conditionProfile__;
                        this.state_0_ = state_0 |= 2;
                        return this.doOp(leftValue_, rightValue_, maskValue_, conditionProfile__);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_, this.mask_}, new Object[]{leftValue, rightValue, maskValue});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            CountingConditionProfile conditionProfile__ = CountingConditionProfile.create();
            Objects.requireNonNull(conditionProfile__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.conditionProfile_ = conditionProfile__;
            this.conditionProfile_.disable();
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
            this.conditionProfile_.reset();
        }

        @NeverDefault
        public static LLVMShuffleVectorNode.LLVMShuffleFloatVectorNode create(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode mask, int vectorLength) {
            return new LLVMShuffleFloatVectorNodeGen(left, right, mask, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMShuffleVectorNode.LLVMShuffleI64VectorNode.class)
    public static final class LLVMShuffleI64VectorNodeGen
    extends LLVMShuffleVectorNode.LLVMShuffleI64VectorNode
    implements GenerateAOT.Provider {
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @Node.Child
        private LLVMExpressionNode mask_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @CompilerDirectives.CompilationFinal
        private CountingConditionProfile i64Vector_conditionProfile_;
        @CompilerDirectives.CompilationFinal
        private CountingConditionProfile pointerVector0_conditionProfile_;
        @CompilerDirectives.CompilationFinal
        private CountingConditionProfile pointerVector1_conditionProfile_;
        @CompilerDirectives.CompilationFinal
        private CountingConditionProfile pointerVector2_conditionProfile_;

        private LLVMShuffleI64VectorNodeGen(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode mask, int vectorLength) {
            this.vectorLength = vectorLength;
            this.left_ = left;
            this.right_ = right;
            this.mask_ = mask;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object leftValue_ = this.left_.executeGeneric(frameValue);
            Object rightValue_ = this.right_.executeGeneric(frameValue);
            Object maskValue_ = this.mask_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftValue_, rightValue_, maskValue_);
            }
            if ((state_0 & 0x1E) != 0 && maskValue_ instanceof LLVMI32Vector) {
                LLVMVector leftValue__;
                LLVMVector rightValue__;
                LLVMI32Vector maskValue__ = (LLVMI32Vector)maskValue_;
                if ((state_0 & 6) != 0 && rightValue_ instanceof LLVMI64Vector) {
                    rightValue__ = (LLVMI64Vector)rightValue_;
                    if ((state_0 & 2) != 0 && leftValue_ instanceof LLVMI64Vector) {
                        leftValue__ = (LLVMI64Vector)leftValue_;
                        CountingConditionProfile conditionProfile__ = this.i64Vector_conditionProfile_;
                        if (conditionProfile__ != null) {
                            return this.doI64Vector((LLVMI64Vector)leftValue__, (LLVMI64Vector)rightValue__, maskValue__, conditionProfile__);
                        }
                    }
                    if ((state_0 & 4) != 0 && leftValue_ instanceof LLVMPointerVector) {
                        leftValue__ = (LLVMPointerVector)leftValue_;
                        CountingConditionProfile conditionProfile__1 = this.pointerVector0_conditionProfile_;
                        if (conditionProfile__1 != null) {
                            return this.doPointerVector((LLVMPointerVector)leftValue__, (LLVMI64Vector)rightValue__, maskValue__, conditionProfile__1);
                        }
                    }
                }
                if ((state_0 & 0x18) != 0 && rightValue_ instanceof LLVMPointerVector) {
                    rightValue__ = (LLVMPointerVector)rightValue_;
                    if ((state_0 & 8) != 0 && leftValue_ instanceof LLVMI64Vector) {
                        leftValue__ = (LLVMI64Vector)leftValue_;
                        CountingConditionProfile conditionProfile__2 = this.pointerVector1_conditionProfile_;
                        if (conditionProfile__2 != null) {
                            return this.doPointerVector((LLVMI64Vector)leftValue__, (LLVMPointerVector)rightValue__, maskValue__, conditionProfile__2);
                        }
                    }
                    if ((state_0 & 0x10) != 0 && leftValue_ instanceof LLVMPointerVector) {
                        leftValue__ = (LLVMPointerVector)leftValue_;
                        CountingConditionProfile conditionProfile__3 = this.pointerVector2_conditionProfile_;
                        if (conditionProfile__3 != null) {
                            return this.doPointerVector((LLVMPointerVector)leftValue__, (LLVMPointerVector)rightValue__, maskValue__, conditionProfile__3);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, maskValue_);
        }

        private LLVMVector executeAndSpecialize(Object leftValue, Object rightValue, Object maskValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (maskValue instanceof LLVMI32Vector) {
                LLVMVector rightValue_;
                LLVMI32Vector maskValue_ = (LLVMI32Vector)maskValue;
                if (rightValue instanceof LLVMI64Vector) {
                    rightValue_ = (LLVMI64Vector)rightValue;
                    if (leftValue instanceof LLVMI64Vector) {
                        LLVMI64Vector leftValue_ = (LLVMI64Vector)leftValue;
                        CountingConditionProfile conditionProfile__ = CountingConditionProfile.create();
                        Objects.requireNonNull(conditionProfile__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        VarHandle.storeStoreFence();
                        this.i64Vector_conditionProfile_ = conditionProfile__;
                        this.state_0_ = state_0 |= 2;
                        return this.doI64Vector(leftValue_, (LLVMI64Vector)rightValue_, maskValue_, conditionProfile__);
                    }
                    if (leftValue instanceof LLVMPointerVector) {
                        LLVMPointerVector leftValue_ = (LLVMPointerVector)leftValue;
                        CountingConditionProfile conditionProfile__1 = CountingConditionProfile.create();
                        Objects.requireNonNull(conditionProfile__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        VarHandle.storeStoreFence();
                        this.pointerVector0_conditionProfile_ = conditionProfile__1;
                        this.state_0_ = state_0 |= 4;
                        return this.doPointerVector(leftValue_, (LLVMI64Vector)rightValue_, maskValue_, conditionProfile__1);
                    }
                }
                if (rightValue instanceof LLVMPointerVector) {
                    rightValue_ = (LLVMPointerVector)rightValue;
                    if (leftValue instanceof LLVMI64Vector) {
                        LLVMI64Vector leftValue_ = (LLVMI64Vector)leftValue;
                        CountingConditionProfile conditionProfile__2 = CountingConditionProfile.create();
                        Objects.requireNonNull(conditionProfile__2, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        VarHandle.storeStoreFence();
                        this.pointerVector1_conditionProfile_ = conditionProfile__2;
                        this.state_0_ = state_0 |= 8;
                        return this.doPointerVector(leftValue_, (LLVMPointerVector)rightValue_, maskValue_, conditionProfile__2);
                    }
                    if (leftValue instanceof LLVMPointerVector) {
                        LLVMPointerVector leftValue_ = (LLVMPointerVector)leftValue;
                        CountingConditionProfile conditionProfile__3 = CountingConditionProfile.create();
                        Objects.requireNonNull(conditionProfile__3, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        VarHandle.storeStoreFence();
                        this.pointerVector2_conditionProfile_ = conditionProfile__3;
                        this.state_0_ = state_0 |= 0x10;
                        return this.doPointerVector(leftValue_, (LLVMPointerVector)rightValue_, maskValue_, conditionProfile__3);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_, this.mask_}, new Object[]{leftValue, rightValue, maskValue});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            CountingConditionProfile conditionProfile__ = CountingConditionProfile.create();
            Objects.requireNonNull(conditionProfile__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.i64Vector_conditionProfile_ = conditionProfile__;
            this.i64Vector_conditionProfile_.disable();
            this.state_0_ |= 2;
            CountingConditionProfile conditionProfile__1 = CountingConditionProfile.create();
            Objects.requireNonNull(conditionProfile__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.pointerVector0_conditionProfile_ = conditionProfile__1;
            this.pointerVector0_conditionProfile_.disable();
            this.state_0_ |= 4;
            CountingConditionProfile conditionProfile__2 = CountingConditionProfile.create();
            Objects.requireNonNull(conditionProfile__2, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.pointerVector1_conditionProfile_ = conditionProfile__2;
            this.pointerVector1_conditionProfile_.disable();
            this.state_0_ |= 8;
            CountingConditionProfile conditionProfile__3 = CountingConditionProfile.create();
            Objects.requireNonNull(conditionProfile__3, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.pointerVector2_conditionProfile_ = conditionProfile__3;
            this.pointerVector2_conditionProfile_.disable();
            this.state_0_ |= 0x10;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
            this.i64Vector_conditionProfile_.reset();
            this.pointerVector0_conditionProfile_.reset();
            this.pointerVector1_conditionProfile_.reset();
            this.pointerVector2_conditionProfile_.reset();
        }

        @NeverDefault
        public static LLVMShuffleVectorNode.LLVMShuffleI64VectorNode create(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode mask, int vectorLength) {
            return new LLVMShuffleI64VectorNodeGen(left, right, mask, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMShuffleVectorNode.LLVMShuffleI32VectorNode.class)
    public static final class LLVMShuffleI32VectorNodeGen
    extends LLVMShuffleVectorNode.LLVMShuffleI32VectorNode
    implements GenerateAOT.Provider {
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @Node.Child
        private LLVMExpressionNode mask_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @CompilerDirectives.CompilationFinal
        private CountingConditionProfile conditionProfile_;

        private LLVMShuffleI32VectorNodeGen(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode mask, int vectorLength) {
            this.vectorLength = vectorLength;
            this.left_ = left;
            this.right_ = right;
            this.mask_ = mask;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object leftValue_ = this.left_.executeGeneric(frameValue);
            Object rightValue_ = this.right_.executeGeneric(frameValue);
            Object maskValue_ = this.mask_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftValue_, rightValue_, maskValue_);
            }
            if ((state_0 & 2) != 0 && leftValue_ instanceof LLVMI32Vector) {
                LLVMI32Vector leftValue__ = (LLVMI32Vector)leftValue_;
                if (rightValue_ instanceof LLVMI32Vector) {
                    LLVMI32Vector rightValue__ = (LLVMI32Vector)rightValue_;
                    if (maskValue_ instanceof LLVMI32Vector) {
                        LLVMI32Vector maskValue__ = (LLVMI32Vector)maskValue_;
                        CountingConditionProfile conditionProfile__ = this.conditionProfile_;
                        if (conditionProfile__ != null) {
                            return this.doI32Vector(leftValue__, rightValue__, maskValue__, conditionProfile__);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, maskValue_);
        }

        private LLVMI32Vector executeAndSpecialize(Object leftValue, Object rightValue, Object maskValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftValue instanceof LLVMI32Vector) {
                LLVMI32Vector leftValue_ = (LLVMI32Vector)leftValue;
                if (rightValue instanceof LLVMI32Vector) {
                    LLVMI32Vector rightValue_ = (LLVMI32Vector)rightValue;
                    if (maskValue instanceof LLVMI32Vector) {
                        LLVMI32Vector maskValue_ = (LLVMI32Vector)maskValue;
                        CountingConditionProfile conditionProfile__ = CountingConditionProfile.create();
                        Objects.requireNonNull(conditionProfile__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        VarHandle.storeStoreFence();
                        this.conditionProfile_ = conditionProfile__;
                        this.state_0_ = state_0 |= 2;
                        return this.doI32Vector(leftValue_, rightValue_, maskValue_, conditionProfile__);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_, this.mask_}, new Object[]{leftValue, rightValue, maskValue});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            CountingConditionProfile conditionProfile__ = CountingConditionProfile.create();
            Objects.requireNonNull(conditionProfile__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.conditionProfile_ = conditionProfile__;
            this.conditionProfile_.disable();
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
            this.conditionProfile_.reset();
        }

        @NeverDefault
        public static LLVMShuffleVectorNode.LLVMShuffleI32VectorNode create(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode mask, int vectorLength) {
            return new LLVMShuffleI32VectorNodeGen(left, right, mask, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMShuffleVectorNode.LLVMShuffleI16VectorNode.class)
    public static final class LLVMShuffleI16VectorNodeGen
    extends LLVMShuffleVectorNode.LLVMShuffleI16VectorNode
    implements GenerateAOT.Provider {
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @Node.Child
        private LLVMExpressionNode mask_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @CompilerDirectives.CompilationFinal
        private CountingConditionProfile conditionProfile_;

        private LLVMShuffleI16VectorNodeGen(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode mask, int vectorLength) {
            this.vectorLength = vectorLength;
            this.left_ = left;
            this.right_ = right;
            this.mask_ = mask;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object leftValue_ = this.left_.executeGeneric(frameValue);
            Object rightValue_ = this.right_.executeGeneric(frameValue);
            Object maskValue_ = this.mask_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftValue_, rightValue_, maskValue_);
            }
            if ((state_0 & 2) != 0 && leftValue_ instanceof LLVMI16Vector) {
                LLVMI16Vector leftValue__ = (LLVMI16Vector)leftValue_;
                if (rightValue_ instanceof LLVMI16Vector) {
                    LLVMI16Vector rightValue__ = (LLVMI16Vector)rightValue_;
                    if (maskValue_ instanceof LLVMI32Vector) {
                        LLVMI32Vector maskValue__ = (LLVMI32Vector)maskValue_;
                        CountingConditionProfile conditionProfile__ = this.conditionProfile_;
                        if (conditionProfile__ != null) {
                            return this.doI8Vector(leftValue__, rightValue__, maskValue__, conditionProfile__);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, maskValue_);
        }

        private LLVMI16Vector executeAndSpecialize(Object leftValue, Object rightValue, Object maskValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftValue instanceof LLVMI16Vector) {
                LLVMI16Vector leftValue_ = (LLVMI16Vector)leftValue;
                if (rightValue instanceof LLVMI16Vector) {
                    LLVMI16Vector rightValue_ = (LLVMI16Vector)rightValue;
                    if (maskValue instanceof LLVMI32Vector) {
                        LLVMI32Vector maskValue_ = (LLVMI32Vector)maskValue;
                        CountingConditionProfile conditionProfile__ = CountingConditionProfile.create();
                        Objects.requireNonNull(conditionProfile__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        VarHandle.storeStoreFence();
                        this.conditionProfile_ = conditionProfile__;
                        this.state_0_ = state_0 |= 2;
                        return this.doI8Vector(leftValue_, rightValue_, maskValue_, conditionProfile__);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_, this.mask_}, new Object[]{leftValue, rightValue, maskValue});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            CountingConditionProfile conditionProfile__ = CountingConditionProfile.create();
            Objects.requireNonNull(conditionProfile__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.conditionProfile_ = conditionProfile__;
            this.conditionProfile_.disable();
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
            this.conditionProfile_.reset();
        }

        @NeverDefault
        public static LLVMShuffleVectorNode.LLVMShuffleI16VectorNode create(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode mask, int vectorLength) {
            return new LLVMShuffleI16VectorNodeGen(left, right, mask, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMShuffleVectorNode.LLVMShuffleI8VectorNode.class)
    public static final class LLVMShuffleI8VectorNodeGen
    extends LLVMShuffleVectorNode.LLVMShuffleI8VectorNode
    implements GenerateAOT.Provider {
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @Node.Child
        private LLVMExpressionNode mask_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @CompilerDirectives.CompilationFinal
        private CountingConditionProfile conditionProfile_;

        private LLVMShuffleI8VectorNodeGen(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode mask, int vectorLength) {
            this.vectorLength = vectorLength;
            this.left_ = left;
            this.right_ = right;
            this.mask_ = mask;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object leftValue_ = this.left_.executeGeneric(frameValue);
            Object rightValue_ = this.right_.executeGeneric(frameValue);
            Object maskValue_ = this.mask_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftValue_, rightValue_, maskValue_);
            }
            if ((state_0 & 2) != 0 && leftValue_ instanceof LLVMI8Vector) {
                LLVMI8Vector leftValue__ = (LLVMI8Vector)leftValue_;
                if (rightValue_ instanceof LLVMI8Vector) {
                    LLVMI8Vector rightValue__ = (LLVMI8Vector)rightValue_;
                    if (maskValue_ instanceof LLVMI32Vector) {
                        LLVMI32Vector maskValue__ = (LLVMI32Vector)maskValue_;
                        CountingConditionProfile conditionProfile__ = this.conditionProfile_;
                        if (conditionProfile__ != null) {
                            return this.doI8Vector(leftValue__, rightValue__, maskValue__, conditionProfile__);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, maskValue_);
        }

        private LLVMI8Vector executeAndSpecialize(Object leftValue, Object rightValue, Object maskValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftValue instanceof LLVMI8Vector) {
                LLVMI8Vector leftValue_ = (LLVMI8Vector)leftValue;
                if (rightValue instanceof LLVMI8Vector) {
                    LLVMI8Vector rightValue_ = (LLVMI8Vector)rightValue;
                    if (maskValue instanceof LLVMI32Vector) {
                        LLVMI32Vector maskValue_ = (LLVMI32Vector)maskValue;
                        CountingConditionProfile conditionProfile__ = CountingConditionProfile.create();
                        Objects.requireNonNull(conditionProfile__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        VarHandle.storeStoreFence();
                        this.conditionProfile_ = conditionProfile__;
                        this.state_0_ = state_0 |= 2;
                        return this.doI8Vector(leftValue_, rightValue_, maskValue_, conditionProfile__);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_, this.mask_}, new Object[]{leftValue, rightValue, maskValue});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            CountingConditionProfile conditionProfile__ = CountingConditionProfile.create();
            Objects.requireNonNull(conditionProfile__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.conditionProfile_ = conditionProfile__;
            this.conditionProfile_.disable();
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
            this.conditionProfile_.reset();
        }

        @NeverDefault
        public static LLVMShuffleVectorNode.LLVMShuffleI8VectorNode create(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode mask, int vectorLength) {
            return new LLVMShuffleI8VectorNodeGen(left, right, mask, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMShuffleVectorNode.LLVMShuffleI1VectorNode.class)
    public static final class LLVMShuffleI1VectorNodeGen
    extends LLVMShuffleVectorNode.LLVMShuffleI1VectorNode
    implements GenerateAOT.Provider {
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @Node.Child
        private LLVMExpressionNode mask_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @CompilerDirectives.CompilationFinal
        private CountingConditionProfile conditionProfile_;

        private LLVMShuffleI1VectorNodeGen(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode mask, int vectorLength) {
            this.vectorLength = vectorLength;
            this.left_ = left;
            this.right_ = right;
            this.mask_ = mask;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object leftValue_ = this.left_.executeGeneric(frameValue);
            Object rightValue_ = this.right_.executeGeneric(frameValue);
            Object maskValue_ = this.mask_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftValue_, rightValue_, maskValue_);
            }
            if ((state_0 & 2) != 0 && leftValue_ instanceof LLVMI1Vector) {
                LLVMI1Vector leftValue__ = (LLVMI1Vector)leftValue_;
                if (rightValue_ instanceof LLVMI1Vector) {
                    LLVMI1Vector rightValue__ = (LLVMI1Vector)rightValue_;
                    if (maskValue_ instanceof LLVMI32Vector) {
                        LLVMI32Vector maskValue__ = (LLVMI32Vector)maskValue_;
                        CountingConditionProfile conditionProfile__ = this.conditionProfile_;
                        if (conditionProfile__ != null) {
                            return this.doI1Vector(leftValue__, rightValue__, maskValue__, conditionProfile__);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, maskValue_);
        }

        private LLVMI1Vector executeAndSpecialize(Object leftValue, Object rightValue, Object maskValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftValue instanceof LLVMI1Vector) {
                LLVMI1Vector leftValue_ = (LLVMI1Vector)leftValue;
                if (rightValue instanceof LLVMI1Vector) {
                    LLVMI1Vector rightValue_ = (LLVMI1Vector)rightValue;
                    if (maskValue instanceof LLVMI32Vector) {
                        LLVMI32Vector maskValue_ = (LLVMI32Vector)maskValue;
                        CountingConditionProfile conditionProfile__ = CountingConditionProfile.create();
                        Objects.requireNonNull(conditionProfile__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        VarHandle.storeStoreFence();
                        this.conditionProfile_ = conditionProfile__;
                        this.state_0_ = state_0 |= 2;
                        return this.doI1Vector(leftValue_, rightValue_, maskValue_, conditionProfile__);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_, this.mask_}, new Object[]{leftValue, rightValue, maskValue});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            CountingConditionProfile conditionProfile__ = CountingConditionProfile.create();
            Objects.requireNonNull(conditionProfile__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.conditionProfile_ = conditionProfile__;
            this.conditionProfile_.disable();
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
            this.conditionProfile_.reset();
        }

        @NeverDefault
        public static LLVMShuffleVectorNode.LLVMShuffleI1VectorNode create(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode mask, int vectorLength) {
            return new LLVMShuffleI1VectorNodeGen(left, right, mask, vectorLength);
        }
    }
}

